//----------------------------------------------------------------
// ---- classes de threads pour lecture fichiers minifits
// LAL -      R. Ansari - Mai 2009 
//----------------------------------------------------------------


#include "brfitsrd.h"

#include <stdlib.h>
#include <unistd.h>
#include <fstream>
#include <signal.h>
#include "pexceptions.h"
#include "timestamp.h"
#include "ctimer.h"

#include "brpaqu.h"
#include "minifits.h"

#include "resusage.h" // Pour mesure temps elapsed/CPU ...
#include "datatable.h" // Pour sauver les entetes de paquet 
#include <sys/time.h>  // pour gettimeofday

//-------------------------------------------------------
// Classe thread de sauvegarde sur fichiers
//-------------------------------------------------------

BRFitsReader::BRFitsReader(RAcqMemZoneMgr& mem, vector<string>& infiles, bool fgnotrl)
  :  memgr(mem), infiles_(infiles), fgnotrl_(fgnotrl)
{
}
void BRFitsReader::Stop()
{
  // cout<< " BRFitsReader:Stop ........ " << endl;
  stop_=true;
}
void BRFitsReader::run()
{
  setRC(1);	

  try {
    TimeStamp ts; 
    Timer tm("BRFitsReader", false);
    BRPaqChecker pcheck(~fgnotrl_);  // Verification/comptage des paquets 
    
    size_t totnbytesrd = 0;
    cout << " BRFitsReader::run() - Starting " << ts << " NbFiles=" << infiles_.size() 
         << "  memgr.PaqSize() = " << memgr.PaqSize() << endl;

    uint_4  nfileok = 0; 
    uint_8 nbytesrd = 0;  
    /*  Variables pour la logique des zones memoire et numeros de paquets dans la zone memoire */
    int mid = -2;
    Byte* buff = NULL;  
    int kmp = 0;   
    int kmpmax=memgr.NbPaquets(); 

    int paqsz = 0;
    for(int ifile=0; ifile<infiles_.size(); ifile++) {
      string ffname = infiles_[ifile];
// -------------- Lecture de bytes      
      cout << "BRFitsReader::run() [" << ifile <<"]Ouverture/lecture fichier " << ffname << endl;
      MiniFITSFile mff(ffname, MF_Read);
      cout << "... Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
  	   << " NAxis2=" << mff.NAxis2() << endl;
      if (mff.DataType() != MF_Byte) {
        cout << "BRFitsReader::run() PB : DataType!=MF_Byte --> skipping " << endl;
        continue;
      }
// Les fichier FITS contiennent l'entet (24 bytes), mais pas le trailer (16 bytes) si fgnotrl=true
      int incpaqsz=0;
      if (fgnotrl_) {
        incpaqsz=16;
        cout << " Warning : FITS files without frame trailers ..." << endl;
      }
      if (paqsz == 0)  {  // premier passage, on fixe la taille de paquet et on verifie compatibilite avec memgr
        paqsz = mff.NAxis1()+incpaqsz;
        if (paqsz != memgr.PaqSize()) {
         cout << "BRFitsReader::run() mff.NAxis1() incompatible with memgr.PaqSize() -> exception " << endl;
         throw SzMismatchError(" fits file size incompatible with memgr.PaqSize()"); 
        }
      }
      else {
        if (paqsz != mff.NAxis1()+incpaqsz) {
        cout << " PB : paqsz=" << paqsz << " != mff.NAxis1()+" << incpaqsz << " --> skipping " << endl;
        continue;
        }
      }   
      if (mid < 0) {
        mid = memgr.FindMemZoneId(MemZA_Fill);  
        buff = memgr.GetMemZone(mid);
        if (buff == NULL) {
	      cout << " BRFitsReader::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
	      setRC(2);	
	       return;	
         }
         kmp=0;
      }
      size_t sx = mff.NAxis1(); 
      size_t sy = mff.NAxis2();      
      int nprt=0;
      for(int j=0; j<sy; j++) {
        mff.ReadB(buff+kmp*paqsz, sx, j*sx);
        BRPaquet paq(NULL, buff+kmp*paqsz, paqsz);
        bool pqok = pcheck.Check(paq);   // Verification du paquet / FrameCounter
        if (!pqok && (nprt < 10)) {
          cout << "--BUG-- i=" << ifile << " mid=" << mid << " j=" << j << " kmp=" << kmp 
               << " paqsz=" << paqsz << endl;
          nprt++; 
          paq.Print();	
        }
        kmp++;
        if (kmp >= kmpmax)  {   // Zone memoire rempli !
          memgr.FreeMemZone(mid, MemZS_Filled);
	      mid = -2;
          if (j<sy) { 
            mid = memgr.FindMemZoneId(MemZA_Fill);  
            buff = memgr.GetMemZone(mid);
            if (buff == NULL) {
	          cout << " BRFitsReader::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
	          setRC(2);	
	           return;	
             }
             kmp=0;
          }
        } 
      }
      nfileok++;   
      size_t nbytesrd = sx*sy;
      totnbytesrd += nbytesrd;
    }   // Fin de la boucle sur les fichiers
// Gestion d'une zone partiellement remplie
    if (mid>=0) {
      for(int k=kmp;k<kmpmax;k++) {
      	Byte* bp=buff+k*paqsz;
      	for(int l=0;l<paqsz;l++) bp[l]=0;
      }
      memgr.FreeMemZone(mid, MemZS_Filled);
    }

//    sprintf(fname,"%s/.log",path_.c_str());
//    ofstream filog(fname);
//    filog << " DataProc::run() - starting log file " << ts << endl;		       
//    filog << " NbFiles=" << nfiles_ << " NBloc/File="  << nblocperfile_ << " NMaxMemZones=" << nmax_ << endl;
    	


    cout << " ------------------  BRFitsReader::run() END ----------------- " << endl;
    ts.SetNow();
    tm.SplitQ();
    cout << "  END reading " << ts << " NFileOK=" << nfileok << endl; 
    cout << "  TotalDiskRead= " << totnbytesrd/(1024*1024) << " MBytes Disk-Read rate= " 
         << (double)(totnbytesrd)/1024./tm.PartialElapsedTimems() << " MB/s" << endl;    
    pcheck.Print(cout);
    cout << " BRFitsReader::run()/Timing: \n"; 
    tm.Print();
    cout << " ---------------------------------------------------------- " << endl;

  }  // Fin du bloc try 
  catch (MiniFITSException& exc) {
    cout << " BRFitsReader::run()/catched MiniFITSException " << exc.Msg() << endl;
    setRC(3);	
    return; 
  }
  catch(...) {
    cout << " BRFitsReader::run()/catched unknown ... exception " << endl;
    setRC(4);	
    return; 
  }
  setRC(0);
  return;
}   
