#include "racqumem.h"

//----------------------------------------------------------------
// ---- classes de gestion memoire pour acquisition BAORadio -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------

/* --Methode-- */
RAcqMemZoneMgr::RAcqMemZoneMgr(uint_4 nz, uint_4 np, uint_4 psz, uint_4 procpsz)
  : mex(true), nzones(nz), npaq(np), paqsz(psz), procpaqsz(procpsz),stop_(false)
{
  St_MemZ st;

  st.serial = 0;
  st.act = (uint_4)MemZA_None;
  st.stat = (uint_4)MemZS_Free;
  for(int k=0; k<6; k++) st.nbact[k] = 0;
  uint_8 mzsz = npaq*paqsz;
  uint_8 procmzsz = npaq*procpaqsz;

   for(int k=0; k<NbZones(); k++) {
     memzones.push_back(new Byte[mzsz] );
     states.push_back(st);
     if (procmzsz > 0)  procmemzones.push_back(new Byte[procmzsz] );
   }
  serial_ = 0;
  SetFinalizedMask();
}

/* --Methode-- */
RAcqMemZoneMgr::~RAcqMemZoneMgr()
{
  for(uint_4 k=0; k<NbZones(); k++) delete[] memzones[k]; 
}

/* --Methode-- */
int RAcqMemZoneMgr::FindMemZoneId(MemZaction act)
// Recherche et renvoie une zone memoire compatible pour effectuer l'operation act
// Pour act = MemZA_Fill : Zone vide ou satisfaisant la condition mask_finalized_
// On recherche a chaque fois la zone ayant le plus petit numero de serie 
// cad le numero d'ordre de remplissage
// Pour ProcA/B/C on attend que la zone avec le plus petit numero soit disponible

{
  int rid = -1;
  if (stop_) return rid;
  if ((act != MemZA_Fill) && (act != MemZA_Save) && (act != MemZA_Proc) &&
      (act != MemZA_ProcA) && (act != MemZA_ProcB) && (act != MemZA_ProcC)) return rid;
  mex.lock();
  uint_8 bestserial = serial_ + 5;
  while ((rid < 0)&&(!stop_)) {
    switch (act)  {
      case MemZA_Fill:
	if (rid < 0) for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
	      ((states[k].stat == MemZS_Free)||((states[k].stat&mask_finalized_)==mask_finalized_) )) {
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) { states[rid].act = MemZA_Fill; states[rid].stat = MemZS_Free; }
	break;
      case MemZA_Save:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
              (states[k].stat & MemZS_Filled) && !(states[k].stat & MemZS_Saved) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          } 
	}
	if (rid >= 0) states[rid].act = MemZA_Save; 
	break;
      case MemZA_Proc:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
              (states[k].stat & MemZS_Filled) && !(states[k].stat & MemZS_Proc) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_Proc;  
        break; 	      	  
      case MemZA_ProcA:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              !(states[k].stat & MemZS_ProcA) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcA;   	      	  
	break;
      case MemZA_ProcB:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcA) && !(states[k].stat & MemZS_ProcB) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcB;   	      	  
	break;
      case MemZA_ProcC:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcB) && !(states[k].stat & MemZS_ProcC) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcC;   	      	  
	break;
      case MemZA_None:   // MTQ pour supprimer un warning
	break;
      }  // Fin de switch 
    if (rid < 0)  mex.wait();
  }  // Fin de while 
  mex.unlock();
  return rid;
}

/* --Methode-- */
int RAcqMemZoneMgr::FreeMemZone(int id, MemZStatus st)
{
  if ((id < 0) || (id >= (int)states.size()))  return 1;
  int rc = 0;
  mex.lock();
  switch (st) {
    case MemZS_Free :
      states[id].serial = 0;
      states[id].stat = MemZS_Free; 
      states[id].act = MemZA_None;
      break;
    case MemZS_Filled :
      if (states[id].act != MemZA_Fill)  rc = 2;
      else states[id].nbact[0]++;
      serial_ ++;
      states[id].serial = serial_;
      states[id].stat |= MemZS_Filled; 
      states[id].act = MemZA_None;
      break;
    case MemZS_Saved :
      if (states[id].act != MemZA_Save)  rc = 4;
      else states[id].nbact[1]++;  	  
      states[id].stat |= MemZS_Saved; 
      states[id].act = MemZA_None;
      break;
    case MemZS_Proc :
      if (states[id].act != MemZA_Proc)  rc = 8;
      else states[id].nbact[2]++;  	  
      states[id].stat |= MemZS_Proc; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcA :
      if (states[id].act != MemZA_ProcA)  rc = 16;
      else states[id].nbact[3]++;  	  
      states[id].stat |= MemZS_ProcA; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcB :
      if (states[id].act != MemZA_ProcB)  rc = 32;
      else states[id].nbact[4]++;  	  
      states[id].stat |= MemZS_ProcB; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcC :
      if (states[id].act != MemZA_ProcC)  rc = 64;
      else states[id].nbact[4]++;  	  
      states[id].stat |= MemZS_ProcC; 
      states[id].act = MemZA_None;
      break;
    default :
      rc = 128;
      states[id].serial = 0;
      states[id].stat = MemZS_Free; 
      states[id].act = MemZA_None;
      break;
  }  // Fin de switch 
  mex.unlock();
  mex.broadcast();
  return rc;
}

/*  MIS en inline 
Byte* RAcqMemZoneMgr::GetMemZone(int id)
{
  if ((id < 0) || (id >= memzones.size()))  return NULL;
  return memzones[id];
}
*/
ostream& RAcqMemZoneMgr::Print(ostream& os)
{
  os << "RAcqMemZoneMgr::Print() NbZones=" << NbZones() << " PaqSize()=" << PaqSize()
     << " NbPaquets()=" << NbPaquets() << " ZoneSize()=" << ZoneSize() << endl;
  if (ProcPaqSize() > 0)  
    cout << " ... With Processed Data Zones ProcPaqSize()=" << ProcPaqSize() 
         << " ProcZoneSize()=" << ProcZoneSize() << endl;
  else cout << " ... NO Processed Data Zones" << endl;
  for(uint_4 k=0; k<states.size(); k++) 
    os << " [" << k << "] Act=" << states[k].act << " Stat=" << states[k].stat 
       << " NbAct[0..5]=" << states[k].nbact[0] << "," << states[k].nbact[1]
       << "," << states[k].nbact[2] << "," << states[k].nbact[3] 
       << "," << states[k].nbact[4] << "," << states[k].nbact[5] << endl; 	
  return os;   
}

void RAcqMemZoneMgr::Stop()
{
  //  cout << "RAcqMemZoneMgr::Stop() ........ STOP                          BROADCAST" <<endl; 
  stop_ = true;
  mex.broadcast();
}
