#include "racquproc.h"

#include <stdlib.h>
#include <unistd.h>
#include <fstream>
#include <signal.h>

#include "pexceptions.h"
#include "tvector.h"
#include "fioarr.h"
#include "timestamp.h"
#include "ctimer.h"
#include "fftpserver.h"
#include "fftwserver.h"

#include "FFTW/fftw3.h"


#include "pciewrap.h"
#include "brpaqu.h"
#include "brproc.h"


//---------------------------------------------------------------
// Classe thread de traitement donnees ADC avec 2 voies par frame
//---------------------------------------------------------------

BRProcARaw2C::BRProcARaw2C(RAcqMemZoneMgr& mem, string& path, uint_4 nmean, 
                           uint_4 step, uint_4 nmax, bool fgnotrl)
  :  memgr(mem) 
{
  nmax_ = nmax;	
  nmean_ = nmean;
  step_ = step;
  stop_ = false;	
  path_ = path;	
  fgnotrl_ = fgnotrl;
}

void BRProcARaw2C::Stop()
{
 stop_=true;
 // cout <<" BRProcARaw2C::Stop ... > STOP " << endl;
}


static inline r_4 Zmod2(complex<r_4> z) 
{ return (z.real()*z.real()+z.imag()*z.imag()); }

void BRProcARaw2C::run()
{
  setRC(1);	
  try {
    Timer tm("BRProcARaw2C", false);
    TimeStamp ts; 
    BRPaqChecker pcheck(~fgnotrl_);  // Verification/comptage des paquets 
    
    size_t totnbytesout = 0;
    size_t totnbytesproc = 0;

    cout << " BRProcARaw2C::run() - Starting " << ts << " NMaxMemZones=" << nmax_ 
	 << " NMean=" << nmean_ << " Step=" << step_ << endl;	
    cout << " BRProcARaw2C::run()... - Output Data Path: " << path_ << endl;
    char fname[512];
//    sprintf(fname,"%s/proc.log",path_.c_str());
//    ofstream filog(fname);
//    filog << " BRProcARaw2C::run() - starting log file " << ts << endl;		       
//    filog << " ... NMaxMemZones=" << nmax_ << " NMean=" << nmean_ << " Step=" << step_ << endl;	

// Initialisation pour calcul FFT 
    TVector< complex<r_4> > cfour1;  // composant TF
    uint_4 paqsz = memgr.PaqSize();
    uint_4 procpaqsz = memgr.ProcPaqSize();
    BRPaquet pq(NULL, NULL, paqsz); 
    TVector<r_4> vx(pq.DataSize()/2);
    vx = (r_4)(0.);
    FFTPackServer ffts;
    ffts.FFTForward(vx, cfour1);
    TVector< complex<r_4> > cfour2(cfour1.Size());
    
    TVector<r_4> spectreV1(cfour1.Size());
    TVector<r_4> spectreV2(cfour1.Size());
    TVector< complex<r_4> > visiV12( cfour1.Size() );


    fftwf_plan plan1 = fftwf_plan_dft_r2c_1d(vx.Size(), vx.Data(), 
                          (fftwf_complex*)cfour1.Data(), FFTW_ESTIMATE); 
    fftwf_plan plan2 = fftwf_plan_dft_r2c_1d(vx.Size(), vx.Data(), 
                          (fftwf_complex*)cfour2.Data(), FFTW_ESTIMATE); 

    uint_4 ifile = 0;  			        
    uint_4 nzm = 0;
    for (uint_4 kmz=0; kmz<nmax_; kmz++) {
      if (stop_) break;
      int mid = memgr.FindMemZoneId(MemZA_ProcA);
      Byte* buff = memgr.GetMemZone(mid);
      if (buff == NULL) {
         cout << " BRProcARaw2C::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
  	     break;		
      }
      Byte* procbuff = memgr.GetProcMemZone(mid);
      if (procbuff == NULL) {
  	    cout << " BRProcARaw2C::run()/ERROR memgr.GetProcMemZone(" << mid << ") -> NULL" << endl;
        break;	
      }

      for(uint_4 i=0; i<memgr.NbPaquets(); i+=step_) {
  	    BRPaquet paq(NULL, buff+i*paqsz, paqsz); 
        if (!pcheck.Check(paq)) continue;   // on ne traite que les paquets OK

// Traitement voie 1  	    
  	    for(sa_size_t j=0; j<vx.Size(); j++) 
  	      vx(j) = (r_4)(*(paq.Data1()+j))-127.5;
//        fftwf_complex* coeff1 = (fftwf_complex*)(procbuff+i*procpaqsz);
  	    fftwf_execute(plan1); 
//        complex<r_4>* zp1 = (complex<r_4>*)(coeff1);
//        ffts.FFTForward(vx, cfour1);
        for(sa_size_t j=0; j<spectreV1.Size(); j++) 
          spectreV1(j) += Zmod2(cfour1(j));
        memcpy(procbuff+i*procpaqsz, cfour1.Data(), sizeof(complex<r_4>)*cfour1.Size());
// Traitement voie 2  	    
   	    for(sa_size_t j=0; j<vx.Size(); j++) 
 	      vx(j) = (r_4)(*(paq.Data2()+j))-127.5;

  	    fftwf_execute(plan2); 

        for(sa_size_t j=0; j<spectreV2.Size(); j++) 
          spectreV2(j) += Zmod2(cfour2(j));  // Zmod2(zp2[j]); 
        memcpy(procbuff+i*procpaqsz+procpaqsz/2, cfour2.Data(), sizeof(complex<r_4>)*cfour2.Size());

// Calcul correlation (visibilite V1 * V2)
        for(sa_size_t j=0; j<visiV12.Size(); j++) 
          visiV12(j)+=cfour1(j)*conj(cfour2(j));
//        for(sa_size_t j=0; j<visiV12.Size(); j++) visiV12(j)+=zp1[j]*zp2[j];
        nzm++;   
        totnbytesproc += paq.DataSize();
        totnbytesout += (2*sizeof(complex<r_4>)*cfour1.Size());

      } // Fin de boucle sur les paquets d'une zone
      if ((nzm >= nmean_) || ((kmz==(nmax_-1))&&(nzm>1))) {
        spectreV1 /= (r_4)(nzm);
        spectreV2 /= (r_4)(nzm);

        visiV12 /= complex<r_4>((r_4)nzm, 0.);

        spectreV1.Info()["NPaqMoy"] = nzm;
        spectreV2.Info()["NPaqMoy"] = nzm;
        visiV12.Info()["NPaqMoy"] = nzm;
	    {
    	sprintf(fname,"%s_%d.ppf",path_.c_str(),(int)ifile);
        POutPersist po(fname);
        po << PPFNameTag("specV1") << spectreV1; 
        po << PPFNameTag("specV2") << spectreV2; 
        po << PPFNameTag("visiV12") << visiV12; 
	    }
        spectreV1 = (r_4)(0.);
        spectreV2 = (r_4)(0.);
        visiV12 = complex<r_4>(0., 0.);
        nzm = 0;  ifile++; 
//        ts.SetNow();
//        filog << ts << " :  proc file  " << fname << endl;		       
        cout << " BRProcARaw2C::run() created file  " << fname << endl;
      }   
      
      memgr.FreeMemZone(mid, MemZS_ProcA);
    }  // Fin de boucle sur les zones a traiter 
  cout << " ------------------  BRProcARaw2C::run() END ----------------- " << endl;
  ts.SetNow();
  tm.SplitQ();
  cout << "  TotalProc= " << totnbytesproc/(1024*1024) << " MBytes, rate= " 
       << (double)(totnbytesproc)/1024./tm.PartialElapsedTimems() << " MB/s" 
       << " ProcDataOut=" <<  totnbytesout/(1024*1024) << " MB" << endl;    
  cout << pcheck;
  cout << " BRProcARaw2C::run()/Timing: \n"; 
  tm.Print();
  cout << " ---------------------------------------------------------- " << endl;
    
  }
  catch (PException& exc) {
    cout << " BRProcARaw2C::run()/catched PException " << exc.Msg() << endl;
    setRC(3);	
    return; 
  }
  catch(...) {
    cout << " BRProcARaw2C::run()/catched unknown ... exception " << endl;
    setRC(4);	
    return; 
  }
  setRC(0);
  return;
}   




