// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

// include standard c/c++
#include <math.h>
#include <stdio.h>

#include <iostream>
#include <typeinfo>
#include <string>


#include "pexceptions.h"  // les exceptions SOPHYA
// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

// #include "array.h"
#ifndef NOPCIECARD
#include <dmamgrv3.h>
#endif
#include "pciewrap.h"
int main(int narg, char* arg[])
{

  if (narg < 2) {
    cout << "tpciew.cc/Usage: tpciew nread [prtlev=0] " << endl;
    return 1;
  }

  int NRead = atoi(arg[1]);
  int PrtLev = 0;
  if (narg > 2) PrtLev = atoi(arg[2]);
  // Sophya modules initialization
  //   TArrayInitiator  _inia;
  //------- AU LIEU DE ------>  SophyaInit();  

  InitTim();   // Initializing the CPU timer

  cout << " ---------- tpciew.cc Start --- NRead= " << NRead << " PrtLev=" << PrtLev << endl;
  int rc = 0;
  try {
#define SZ  4096  
    uint_1 data[SZ];
    Byte* pdata;
    int cardNum = 1;
    uint_4 frameSize = 4096;
    uint_4 paqSize = 4096; 
    uint_4 patternSZ=0x400; 
    uint_4 dmaSize  = 32*1024 ; 
#ifndef NOPCIECARD
    DMAMgr dmamgr(cardNum,patternSZ,dmaSize);
    //RzDEL    PCIEWrapper pciw(dmamgr,frameSize,paqSize);
    PCIEWrapper pciw(dmamgr);
#else
    TestPCIWrapperNODMA pciw(frameSize);
#endif
    for(int k=0; k<NRead; k++) {
      pdata = pciw.GetData();
      if (PrtLev > 0) {
	cout << "data[] : ";
	for(int j=0; j<PrtLev*5; j++) cout << " , " << (uint_4)pdata[j];
	cout << endl;
      }
    }
  }
  catch (PCIEWException& exc) {
    cerr << " tpciew.cc catched PCIEWException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (PThrowable& exc) {
    cerr << " tpciew.cc catched Exception " << exc.Msg() << endl;
    rc = 76;
  }  
  catch (std::exception& sex) {
    cerr << "\n tpciew.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " tpciew.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> tpciew.cc ------- FIN ----------- RC=" << rc << endl;
  PrtTim("FIN tpciew.cc");
  return rc;

}
