#ifndef  PCIEWRAP_H_SEEN
#define  PCIEWRAP_H_SEEN
#include "brtypes.h"
#include "machdefs.h"
#include "racqumem.h"
#include "brpaqu.h"
#include <string>
#include "randr48.h"  // Generateur aleatoire SOPHYA pour simulation perte de paquets

/* 
   Classe interface aux fonctions d'I/O PCIExpress 
   pour la carte de reception optique BAORadio
   R. Ansari                        Juin 2008
*/

using namespace std;

class PCIEWException {
  public:
  explicit PCIEWException(const char * m) { msg = m; }
  explicit PCIEWException(const string& m) { msg = m; }
  virtual ~PCIEWException() { }
  virtual string const& Msg() const  {return msg;}
  virtual const char* what() {return msg.c_str(); }
 private:
  string msg;
};


// Classe definissant l'interface des operations transfert DMA/PCIExpress 
class PCIEWrapperInterface {
 public:
  // Constructeur - fait l'initialisation
  PCIEWrapperInterface() { } 
  // destructeur - libere la memoire allouee
  virtual ~PCIEWrapperInterface() { } 

  virtual UInt32 TransferSize() = 0;
  virtual void   StartTransfers() { return; };
  virtual Byte*  GetData() = 0;
  virtual UInt64 TotTransferBytes() = 0;    
  virtual void PrintStatus(ostream& os) = 0;
};

// Classe de test Implementant l'interface PCIEWrapper sans DMA 
class TestPCIWrapperNODMA : public PCIEWrapperInterface {
public:	
  TestPCIWrapperNODMA(UInt32 sz, double lossrate=0.);
  virtual ~TestPCIWrapperNODMA();

  virtual UInt32 TransferSize() ;
  virtual Byte*  GetData() ;
  virtual UInt64 TotTransferBytes() ;    
  virtual void PrintStatus(ostream& os) ;
  
protected:
  Byte* data_;
  Byte* srcdata_;
  UInt32 size_;
  UInt32 frame_counter_;
  UInt64 timetag_; 	
  UInt64 tottransfer_;
  double lossrate_;
  BRPaqChecker pchk_;
//  FMTRandGen rg_;
  ThSDR48RandGen rg_;
};

#endif
