#ifndef  BRPROCA_H_SEEN
#define  BRPROCA_H_SEEN

//----------------------------------------------------------------
// ---- classe de thread de traitememt  acquisition BAORadio -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------


#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>
#include "sopnamsp.h"
#include "zthread.h"

#include "brtypes.h"

using namespace std;


//---------------------------------------------------------------------
// Classe thread de traitement avec 2 voies par frame (donnees brutes)
//---------------------------------------------------------------------
class BRProcARaw2C : public ZThread {
public:	
  BRProcARaw2C(RAcqMemZoneMgr& mem, string& path, uint_4 nmean=10, 
               uint_4 nmax=100, bool fgnotrl=false, int card=1);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  bool stop_;  
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
  bool fgnotrl_;   // if true, don't check packet trailer - when using pre-june fits files
  int card_;   // Numeros de voies 2*card_-1, 2*card_
};

//---------------------------------------------------------------------
// Classe thread de traitement 2 x 2 voies/frames (Apres BRProcARaw2C)
//---------------------------------------------------------------------
class BRProcBRaw4C : public ZThread {
public:	
  BRProcBRaw4C(RAcqMemZoneMgr& mem1, RAcqMemZoneMgr& mem2, string& path, 
               uint_4 nmean=10, uint_4 nmax=100, bool fgnotrl=false);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr1;
  RAcqMemZoneMgr& memgr2;
  bool stop_;  
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
  bool fgnotrl_;   // if true, don't check packet trailer - when using pre-june fits files
};



#endif
