/*  data tables for planetary solution VSOP87
 *
 *  created by automatic conversion from original distribution files at
 *  ftp://ftp.bdl.fr/pub/ephem/planets/vsop87/
 *
 *  Each coordinate is calculated as:
 *
 *	x = Sum{ T^alpha * A * cos( B + C*T ) }
 * 
 *  x is the coordinate in rad or a.u.
 *  T is the VSOP time in Julian Millenia(!) since J2000.0
 *  Note: the time argument in VSOP87 theory is equal to TAI + 32.184 s
 *
 *  A (scaled by VSOP_ASCALE), B, C given below for each x and alpha
 *  run-of-the mill for each planet in one array vx_planet[][3].
 *  The block-boundary indices for each spatial dimension are then listed
 *  in a separate array vn_planet[][3].
 *
 *  Truncation errors given in comments are from the authors' empirical
 *  formula:  2*sqrt(number of retained terms)*A[last retained]
 */

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_earth[][3] = {
	/* earth l, T^0 */
	{ 175347045.7, 0, 0 },
	{ 3341656.5, 4.66925680, 6283.07584999 },
	{ 34894.3, 4.626102, 12566.151700 },
	{ 3417.6, 2.82887, 3.52312 },
	{ 3497.1, 2.74412, 5753.38488 },
	{ 3135.9, 3.62767, 77713.77147 },
	{ 2676.2, 4.41808, 7860.41939 },
	{ 2342.7, 6.13516, 3930.20970 },
	{ 1273.2, 2.03710, 529.69097 },
	{ 1324.3, 0.74246, 11506.76977 },
	{ 901.9, 2.0451, 26.2983 },
	{ 1199.2, 1.10963, 1577.34354 },
	{ 857.2, 3.5085, 398.1490 },
	{ 779.8, 1.1788, 5223.6939 },
	{ 990.2, 5.2327, 5884.9268 },
	{ 753.1, 2.5334, 5507.5532 },
	{ 505.3, 4.5829, 18849.2275 },
	{ 492.4, 4.2051, 775.5226 },
	{ 356.7, 2.9195, 0.0673 },
	{ 284.1, 1.8987, 796.2980 },
	{ 242.8, 0.3448, 5486.7778 },
	{ 317.1, 5.8490, 11790.6291 },
	{ 271.0, 0.3149, 10977.0788 },
	{ 206.2, 4.8065, 2544.3144 },
	{ 205.4, 1.8695, 5573.1428 },
	{ 202.3, 2.4577, 6069.7768 },
	{ 126.2, 1.0830, 20.7754 },
	{ 155.5, 0.8331, 213.2991 },
	{ 115.1, 0.6454, 0.9803 },
	{ 102.9, 0.6360, 4694.0030 },
	{ 101.7, 4.2668, 7.1135 },
	{ 99.2, 6.210, 2146.165 },
	{ 132.2, 3.4112, 2942.4634 },
	{ 97.6, 0.681, 155.420 },
	{ 85.1, 1.299, 6275.962 },
	{ 74.7, 1.755, 5088.629 },
	{ 101.9, 0.9757, 15720.8388 },
	{ 84.7, 3.671, 71430.696 },
	{ 73.5, 4.679, 801.821 },
	{ 73.9, 3.503, 3154.687 },
	{ 78.8, 3.037, 12036.461 },
	{ 79.6, 1.808, 17260.155 },
	{ 85.8, 5.983, 161000.686 },
	{ 57.0, 2.784, 6286.599 },
	{ 61.1, 1.818, 7084.897 },
	{ 69.6, 0.833, 9437.763 },
	{ 56.1, 4.387, 14143.495 },
	{ 62.4, 3.978, 8827.390 },
	{ 51.1, 0.283, 5856.478 },
	{ 55.6, 3.470, 6279.553 },
	{ 41.0, 5.368, 8429.241 },
	{ 51.6, 1.333, 1748.016 },
	{ 52.0, 0.189, 12139.554 },
	{ 49.0, 0.487, 1194.447 },
	{ 39.2, 6.168, 10447.388 },
	{ 35.6, 1.776, 6812.767 },
	{ 36.8, 6.041, 10213.286 },
	{ 36.6, 2.570, 1059.382 },
	{ 33.3, 0.593, 17789.846 },
	{ 36.0, 1.709, 2352.866 },
	{ 40.9, 2.399, 19651.048 },
	{ 30.0, 2.740, 1349.867 },
	{ 30.4, 0.443, 83996.847 },
	{ 23.7, 0.485, 8031.092 },
	{ 23.6, 2.065, 3340.612 },
	{ 21.1, 4.148, 951.718 },
	{ 24.7, 0.215, 3.590 },
	{ 25.4, 3.165, 4690.480 },
	{ 22.8, 5.222, 4705.732 },
	{ 21.4, 1.426, 16730.464 },
	{ 21.9, 5.556, 553.569 },
	{ 17.5, 4.561, 135.065 },
	{ 19.9, 5.222, 12168.003 },
	{ 19.9, 5.775, 6309.374 },
	{ 20.3, 0.371, 283.859 },
	{ 14.4, 4.193, 242.729 },
	{ 16.2, 5.988, 11769.854 },
	{ 15.1, 4.196, 6256.778 },
	{ 19.1, 3.822, 23581.258 },
	{ 18.9, 5.386, 149854.400 },
	{ 14.3, 3.724, 38.028 },
	{ 17.9, 2.215, 13367.973 },
	{ 12.1, 2.622, 955.600 },
	{ 11.3, 0.177, 4164.312 },
	{ 14.0, 4.401, 6681.225 },
	{ 13.6, 1.889, 7632.943 },
	{ 12.5, 1.131, 5.523 },
	{ 10.5, 5.359, 1592.596 },
	{ 9.8, 1.00, 11371.70 },
	{ 9.2, 4.57, 4292.33 },
	{ 10.3, 6.200, 6438.496 },
	{ 12.0, 1.004, 632.784 },
	{ 10.8, 0.327, 103.093 },
	{ 8.4, 4.54, 25132.30 },
	{ 10.0, 6.029, 5746.271 },
	{ 8.4, 3.30, 7234.79 },
	{ 8.0, 5.82, 28.45 },
	{ 10.5, 0.939, 11926.254 },
	{ 7.7, 3.12, 7238.68 },
	{ 9.4, 2.62, 5760.50 },
	{ 8.1, 6.11, 4732.03 },
	{ 9.2, 0.48, 522.58 },
	{ 9.8, 5.24, 27511.47 },
	{ 7.9, 1.00, 5643.18 },
	{ 8.1, 6.27, 426.60 },
	{ 9.0, 5.34, 6386.17 },
	{ 8.6, 4.17, 7058.60 },
	{ 6.3, 4.72, 6836.65 },
	{ 7.6, 3.97, 11499.66 },
	{ 7.8, 2.96, 23013.54 },
	{ 7.3, 0.61, 11513.88 },
	{ 6.5, 5.79, 18073.70 },
	{ 7.2, 4.00, 74.78 },
	{ 7.3, 4.39, 316.39 },
	{ 7.1, 0.32, 263.08 },
	{ 6.6, 3.66, 17298.18 },
	{ 6.8, 5.91, 90955.55 },
	/* 117 terms retained, 442 terms dropped, error 0.3" */

	/* earth l, T^1 */
	{ 628331966747.5, 0, 0 },
	{ 206058.9, 2.6782346, 6283.0758500 },
	{ 4303.4, 2.63513, 12566.15170 },
	{ 425.3, 1.5905, 3.5231 },
	{ 109.0, 2.9662, 1577.3435 },
	{ 93.5, 2.592, 18849.228 },
	{ 119.3, 5.7956, 26.2983 },
	{ 72.1, 1.138, 529.691 },
	{ 67.8, 1.875, 398.149 },
	{ 67.3, 4.409, 5507.553 },
	{ 59.0, 2.888, 5223.694 },
	{ 56.0, 2.175, 155.420 },
	{ 45.4, 0.398, 796.298 },
	{ 36.4, 0.466, 775.523 },
	{ 29.0, 2.647, 7.114 },
	{ 19.1, 1.846, 5486.778 },
	{ 20.8, 5.341, 0.980 },
	{ 18.5, 4.969, 213.299 },
	{ 16.2, 0.032, 2544.314 },
	{ 17.3, 2.991, 6275.962 },
	{ 15.8, 1.430, 2146.165 },
	{ 14.6, 1.205, 10977.079 },
	{ 11.9, 3.258, 5088.629 },
	{ 11.5, 2.075, 4694.003 },
	{ 9.7, 4.24, 1349.87 },
	{ 10.0, 1.303, 6286.599 },
	{ 9.5, 2.70, 242.73 },
	{ 12.5, 2.834, 1748.016 },
	{ 11.8, 5.274, 1194.447 },
	{ 8.6, 5.64, 951.72 },
	{ 10.6, 0.766, 553.569 },
	{ 7.6, 5.30, 2352.87 },
	{ 5.8, 1.77, 1059.38 },
	{ 6.4, 2.65, 9437.76 },
	{ 5.2, 5.66, 71430.70 },
	{ 5.3, 0.91, 3154.69 },
	{ 6.1, 4.67, 4690.48 },
	{ 4.3, 0.24, 6812.77 },
	{ 5.0, 1.42, 6438.50 },
	{ 4.3, 0.77, 10447.39 },
	{ 5.2, 1.85, 801.82 },
	{ 3.7, 2.00, 8031.09 },
	{ 3.6, 2.43, 14143.50 },
	{ 3.4, 3.86, 1592.60 },
	{ 3.4, 0.89, 12036.46 },
	{ 3.2, 3.19, 4705.73 },
	{ 3.2, 0.62, 8429.24 },
	{ 4.1, 5.24, 7084.90 },
	{ 3.0, 6.07, 4292.33 },
	{ 2.9, 2.32, 20.36 },
	{ 3.5, 4.80, 6279.55 },
	{ 2.9, 1.43, 5746.27 },
	{ 2.7, 4.80, 7234.79 },
	{ 2.5, 6.22, 6836.65 },
	{ 2.7, 0.93, 5760.50 },
	{ 3.2, 3.40, 7632.94 },
	{ 2.3, 5.00, 17789.85 },
	{ 2.1, 3.96, 10213.29 },
	{ 2.1, 2.22, 5856.48 },
	{ 2.3, 5.67, 11499.66 },
	{ 2.1, 5.20, 11513.88 },
	{ 1.9, 0.53, 3340.61 },
	{ 1.9, 4.74, 83996.85 },
	{ 2.1, 2.55, 25132.30 },
	{ 1.8, 1.47, 4164.31 },
	{ 1.8, 3.02, 5.52 },
	{ 2.0, 0.91, 6256.78 },
	{ 2.1, 2.27, 522.58 },
	{ 1.8, 3.03, 5753.38 },
	{ 1.6, 6.12, 5216.58 },
	{ 1.6, 4.64, 3.29 },
	/* 71 terms retained, 270 terms dropped, error 0.056"*T */

	/* earth l, T^2 */
	{ 52918.9, 0, 0 },
	{ 8719.8, 1.07210, 6283.07585 },
	{ 309.1, 0.8673, 12566.1517 },
	{ 27.3, 0.053, 3.523 },
	{ 16.3, 5.188, 26.298 },
	{ 15.8, 3.685, 155.420 },
	{ 9.5, 0.76, 18849.23 },
	{ 8.9, 2.06, 77713.77 },
	{ 7.0, 0.83, 775.52 },
	{ 5.1, 4.66, 1577.34 },
	{ 4.1, 1.03, 7.11 },
	{ 3.5, 5.14, 796.30 },
	{ 3.2, 6.05, 5507.55 },
	{ 3.0, 1.19, 242.73 },
	{ 2.9, 6.12, 529.69 },
	{ 3.8, 3.44, 5573.14 },
	{ 2.7, 0.31, 398.15 },
	{ 2.4, 4.38, 5223.69 },
	{ 2.5, 2.28, 553.57 },
	{ 2.1, 3.75, 0.98 },
	{ 1.7, 0.90, 951.72 },
	{ 1.5, 5.76, 1349.87 },
	{ 1.2, 2.97, 2146.17 },
	{ 1.4, 4.36, 1748.02 },
	{ 1.3, 3.72, 1194.45 },
	{ 1.3, 2.95, 6438.50 },
	{ 1.0, 5.99, 6286.60 },
	{ 0.9, 4.80, 5088.63 },
	{ 0.8, 3.31, 213.30 },
	{ 1.1, 1.27, 161000.69 },
	{ 0.8, 3.42, 5486.78 },
	{ 1.0, 0.60, 3154.69 },
	{ 0.9, 5.23, 7084.90 },
	{ 0.6, 1.60, 2544.31 },
	{ 0.7, 3.43, 4694.00 },
	{ 0.6, 2.48, 10977.08 },
	{ 0.7, 6.19, 4690.48 },
	{ 0.6, 1.98, 801.82 },
	{ 0.5, 1.44, 6836.65 },
	{ 0.5, 2.34, 1592.60 },
	{ 0.5, 1.31, 4292.33 },
	{ 0.4, 0.04, 7234.79 },
	{ 0.5, 3.81, 149854.40 },
	{ 0.4, 4.94, 7632.94 },
	/* 44 terms retained, 98 terms dropped, error 0.011"*T^2 */

	/* earth l, T^3 */
	{ 289.2, 5.8438, 6283.0758 },
	{ 35.0, 0, 0 },
	{ 16.8, 5.488, 12566.152 },
	{ 3.0, 5.20, 155.42 },
	{ 1.3, 4.72, 3.52 },
	{ 0.6, 5.97, 242.73 },
	{ 0.7, 5.30, 18849.23 },
	{ 0.4, 3.79, 553.57 },
	/* 8 terms retained, 14 terms dropped, error 0.005"*T^3 */

	/* earth l, T^4 */
	{ 114.1, 3.1416, 0 },
	{ 7.7, 4.13, 6283.08 },
	{ 0.8, 3.84, 12566.15 },
	{ 0.4, 0.42, 155.42 },
	/* 4 terms retained, 7 terms dropped, error 0.00032"*T^4 */

	/* earth l, T^5 */
	{ 0.9, 3.14, 0 },
	{ 0.2, 2.77, 6283.08 },
	{ 0.1, 2.01, 155.42 },
	/* 3 terms retained, 2 terms dropped, error 0.00023"*T^5 */
	/* end earth l */

	/* earth b, T^0 */
	{ 279.6, 3.1987, 84334.6616 },
	{ 101.6, 5.4225, 5507.5532 },
	{ 80.4, 3.880, 5223.694 },
	{ 43.8, 3.704, 2352.866 },
	{ 31.9, 4.000, 1577.344 },
	{ 22.7, 3.985, 1047.747 },
	{ 16.4, 3.565, 5856.478 },
	{ 18.1, 4.984, 6283.076 },
	{ 14.4, 3.703, 9437.763 },
	{ 14.3, 3.411, 10213.286 },
	{ 11.2, 4.828, 14143.495 },
	{ 10.9, 2.086, 6812.767 },
	{ 9.7, 3.47, 4694.00 },
	{ 10.4, 4.057, 71092.881 },
	{ 8.8, 4.44, 5753.38 },
	{ 8.4, 4.99, 7084.90 },
	{ 6.9, 4.33, 6275.96 },
	{ 9.1, 1.14, 6620.89 },
	{ 7.2, 3.60, 529.69 },
	{ 7.7, 5.55, 167621.58 },
	/* 20 terms retained, 164 terms dropped, error 0.15" */

	/* earth b, T^1 */
	{ 9.0, 3.90, 5507.55 },
	{ 6.2, 1.73, 5223.69 },
	{ 3.8, 5.24, 2352.87 },
	{ 2.8, 2.47, 1577.34 },
	{ 1.8, 0.42, 6283.08 },
	/* 5 terms retained, 94 terms dropped, error 0.018"*T */

	/* earth b, T^2 */
	{ 1.7, 1.63, 84334.66 },
	{ 0.5, 2.41, 1047.75 },
	/* 2 terms retained, 47 terms dropped, error 0.0035"*T^2 */

	/* earth b, T^3 */
	/* 0 terms retained, 11 terms dropped, error 4.5e-05"*T^3 */

	/* earth b, T^4 */
	/* 0 terms retained, 5 terms dropped, error 1.7e-05"*T^4 */
	/* end earth b */

	/* earth r, T^0 */
	{ 100013988.8, 0, 0 },
	{ 1670699.6, 3.09846351, 6283.07584999 },
	{ 13956.0, 3.055246, 12566.151700 },
	{ 3083.7, 5.19847, 77713.77147 },
	{ 1628.5, 1.17388, 5753.38488 },
	{ 1575.6, 2.84685, 7860.41939 },
	{ 924.8, 5.4529, 11506.7698 },
	{ 542.4, 4.5641, 3930.2097 },
	{ 472.1, 3.6610, 5884.9268 },
	{ 328.8, 5.8998, 5223.6939 },
	{ 346.0, 0.9637, 5507.5532 },
	{ 306.8, 0.2987, 5573.1428 },
	{ 174.8, 3.0119, 18849.2275 },
	{ 243.2, 4.2735, 11790.6291 },
	{ 211.8, 5.8471, 1577.3435 },
	{ 185.8, 5.0219, 10977.0788 },
	{ 109.8, 5.0551, 5486.7778 },
	{ 98.3, 0.887, 6069.777 },
	{ 86.5, 5.690, 15720.839 },
	{ 85.8, 1.271, 161000.686 },
	{ 62.9, 0.922, 529.691 },
	{ 57.1, 2.014, 83996.847 },
	{ 64.9, 0.273, 17260.155 },
	{ 49.4, 3.245, 2544.314 },
	{ 55.7, 5.242, 71430.696 },
	{ 42.5, 6.011, 6275.962 },
	{ 47.0, 2.578, 775.523 },
	{ 39.0, 5.361, 4694.003 },
	{ 44.7, 5.537, 9437.763 },
	{ 35.7, 1.675, 12036.461 },
	{ 31.9, 0.184, 5088.629 },
	{ 31.8, 1.778, 398.149 },
	{ 33.2, 0.244, 7084.897 },
	{ 38.2, 2.393, 8827.390 },
	{ 28.5, 1.213, 6286.599 },
	{ 37.5, 0.830, 19651.048 },
	{ 37.0, 4.901, 12139.554 },
	{ 34.5, 1.843, 2942.463 },
	{ 26.3, 4.589, 10447.388 },
	{ 24.6, 3.787, 8429.241 },
	{ 23.6, 0.269, 796.298 },
	{ 27.8, 1.899, 6279.553 },
	{ 23.9, 4.996, 5856.478 },
	{ 20.3, 4.653, 2146.165 },
	{ 23.3, 2.808, 14143.495 },
	{ 22.1, 1.950, 3154.687 },
	{ 19.5, 5.382, 2352.866 },
	{ 18.0, 0.199, 6812.767 },
	{ 17.2, 4.433, 10213.286 },
	{ 16.2, 5.232, 17789.846 },
	{ 17.3, 6.152, 16730.464 },
	{ 13.8, 5.190, 8031.092 },
	{ 18.8, 0.673, 149854.400 },
	{ 18.3, 2.253, 23581.258 },
	{ 13.6, 3.685, 4705.732 },
	{ 13.1, 0.653, 13367.973 },
	{ 10.4, 4.333, 11769.854 },
	{ 10.0, 4.201, 6309.374 },
	{ 10.2, 1.594, 4690.480 },
	{ 7.6, 2.63, 6256.78 },
	{ 9.7, 3.68, 27511.47 },
	{ 6.7, 0.56, 3340.61 },
	{ 8.7, 6.06, 1748.02 },
	{ 7.8, 3.67, 12168.00 },
	{ 6.6, 5.66, 11371.70 },
	{ 7.7, 0.31, 7632.94 },
	{ 6.6, 3.14, 801.82 },
	{ 7.5, 5.65, 11926.25 },
	{ 6.9, 2.92, 6681.22 },
	{ 6.8, 1.42, 23013.54 },
	{ 6.5, 2.65, 19804.83 },
	/* 71 terms retained, 455 terms dropped, error 1.1e-06 a.u. */

	/* earth r, T^1 */
	{ 103018.6, 1.1074897, 6283.0758500 },
	{ 1721.2, 1.06442, 12566.15170 },
	{ 702.2, 3.1416, 0 },
	{ 32.3, 1.022, 18849.228 },
	{ 30.8, 2.844, 5507.553 },
	{ 25.0, 1.319, 5223.694 },
	{ 18.5, 1.424, 1577.344 },
	{ 10.1, 5.914, 10977.079 },
	{ 8.6, 0.27, 5486.78 },
	{ 8.7, 1.42, 6275.96 },
	{ 5.1, 1.69, 5088.63 },
	{ 5.0, 6.01, 6286.60 },
	{ 4.7, 5.99, 529.69 },
	{ 4.4, 0.52, 4694.00 },
	{ 3.9, 4.75, 2544.31 },
	{ 3.8, 5.07, 796.30 },
	{ 4.1, 1.08, 9437.76 },
	{ 3.5, 0.02, 83996.85 },
	{ 3.4, 0.95, 71430.70 },
	{ 3.2, 6.16, 2146.17 },
	{ 3.4, 5.41, 775.52 },
	{ 2.9, 5.48, 10447.39 },
	{ 2.5, 0.24, 398.15 },
	{ 2.2, 4.95, 6812.77 },
	{ 2.2, 0.42, 8031.09 },
	{ 2.8, 3.42, 2352.87 },
	{ 2.6, 6.13, 6438.50 },
	{ 1.9, 5.31, 8429.24 },
	{ 2.4, 3.09, 4690.48 },
	{ 1.7, 1.54, 4705.73 },
	{ 2.2, 3.69, 7084.90 },
	{ 2.1, 1.28, 1748.02 },
	{ 1.8, 3.23, 6279.55 },
	{ 1.6, 4.10, 11499.66 },
	{ 1.6, 5.54, 3154.69 },
	{ 1.8, 1.82, 7632.94 },
	/* 36 terms retained, 256 terms dropped, error 2.2e-07 a.u.*T */

	/* earth r, T^2 */
	{ 4359.4, 5.78455, 6283.07585 },
	{ 123.6, 5.5793, 12566.1517 },
	{ 12.3, 3.142, 0 },
	{ 8.8, 3.63, 77713.77 },
	{ 5.7, 1.87, 5573.14 },
	{ 3.3, 5.47, 18849.23 },
	{ 1.5, 4.48, 5507.55 },
	{ 1.0, 2.81, 5223.69 },
	{ 0.9, 3.11, 1577.34 },
	{ 1.1, 2.84, 161000.69 },
	{ 0.6, 5.47, 775.52 },
	{ 0.6, 1.38, 6438.50 },
	{ 0.5, 4.42, 6286.60 },
	{ 0.4, 0.90, 10977.08 },
	{ 0.4, 3.20, 5088.63 },
	{ 0.5, 3.66, 7084.90 },
	{ 0.5, 5.39, 149854.40 },
	/* 17 terms retained, 122 terms dropped, error 3.9e-08 a.u.*T^2 */

	/* earth r, T^3 */
	{ 144.6, 4.2732, 6283.0758 },
	{ 6.7, 3.92, 12566.15 },
	{ 0.8, 0, 0 },
	{ 0.2, 3.73, 18849.23 },
	/* 4 terms retained, 23 terms dropped, error 1.1e-08 a.u.*T^3 */

	/* earth r, T^4 */
	{ 3.9, 2.56, 6283.08 },
	{ 0.3, 2.27, 12566.15 },
	{ 0.1, 3.44, 5573.14 },
	/* 3 terms retained, 7 terms dropped, error 2.1e-09 a.u.*T^4 */

	/* earth r, T^5 */
	{ 0.1, 1.22, 6283.08 },
	/* 1 terms retained, 2 terms dropped, error 2.4e-09 a.u.*T^5 */
	/* end earth */
};

int vn_earth[][3] = {
	/* addresses for earth l, b, r  */
	/* T^0 */ { 0, 247, 274, },
	/* T^1 */ { 117, 267, 345, },
	/* T^2 */ { 188, 272, 381, },
	/* T^3 */ { 232, 274, 398, },
	/* T^4 */ { 240, 0, 402, },
	/* T^5 */ { 244, 0, 405, },
	/* end */ { 247, 0, 406, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_jupiter[][3] = {
	/* jupiter l, T^0 */
	{ 59954691.5, 0, 0 },
	{ 9695898.7, 5.06191793, 529.69096509 },
	{ 573610.1, 1.4440621, 7.1135470 },
	{ 306389.2, 5.4173473, 1059.3819302 },
	{ 97178.3, 4.142647, 632.783739 },
	{ 72903.1, 3.640429, 522.577418 },
	{ 64264.0, 3.411452, 103.092774 },
	{ 39806.1, 2.293767, 419.484644 },
	{ 38857.8, 1.272317, 316.391870 },
	{ 27964.6, 1.784546, 536.804512 },
	{ 13589.7, 5.774810, 1589.072895 },
	{ 8246.4, 3.58228, 206.18555 },
	{ 8768.7, 3.63000, 949.17561 },
	{ 7368.1, 5.08101, 735.87651 },
	{ 6263.2, 0.02498, 213.29910 },
	{ 6114.0, 4.51320, 1162.47470 },
	{ 4905.4, 1.32085, 110.20632 },
	{ 5305.3, 1.30671, 14.22709 },
	{ 5305.5, 4.18625, 1052.26838 },
	{ 4647.2, 4.69958, 3.93215 },
	{ 3045.0, 4.31676, 426.59819 },
	{ 2610.0, 1.56668, 846.08283 },
	{ 2028.2, 1.06377, 3.18139 },
	{ 1764.8, 2.14148, 1066.49548 },
	{ 1723.0, 3.88036, 1265.56748 },
	{ 1921.0, 0.97169, 639.89729 },
	{ 1633.2, 3.58201, 515.46387 },
	{ 1432.0, 4.29684, 625.67019 },
	{ 973.3, 4.0976, 95.9792 },
	{ 884.4, 2.4370, 412.3711 },
	{ 732.9, 6.0853, 838.9693 },
	{ 731.1, 3.8059, 1581.9593 },
	{ 691.9, 6.1337, 2118.7639 },
	{ 709.2, 1.2927, 742.9901 },
	{ 614.5, 4.1085, 1478.8666 },
	{ 495.2, 3.7557, 323.5054 },
	{ 581.9, 4.5397, 309.2783 },
	{ 375.7, 4.7030, 1368.6603 },
	{ 389.9, 4.8972, 1692.1657 },
	{ 341.0, 5.7145, 533.6231 },
	{ 330.5, 4.7405, 0.0482 },
	{ 440.9, 2.9582, 454.9094 },
	{ 417.3, 1.0355, 2.4477 },
	{ 244.2, 5.2202, 728.7630 },
	{ 261.5, 1.8765, 0.9632 },
	{ 256.6, 3.7241, 199.0720 },
	{ 261.0, 0.8205, 380.1278 },
	{ 220.4, 1.6512, 543.9181 },
	{ 202.0, 1.8068, 1375.7738 },
	{ 207.3, 1.8546, 525.7588 },
	{ 197.0, 5.2925, 1155.3612 },
	{ 235.1, 1.2269, 909.8187 },
	{ 174.8, 5.9097, 956.2892 },
	{ 149.4, 4.3775, 1685.0521 },
	{ 175.2, 3.2263, 1898.3512 },
	{ 175.2, 3.7297, 942.0621 },
	{ 157.9, 4.3648, 1795.2584 },
	{ 137.9, 1.3180, 1169.5883 },
	{ 117.5, 2.5002, 1596.1864 },
	{ 150.5, 3.9063, 74.7816 },
	{ 116.8, 3.3892, 0.5213 },
	{ 105.9, 4.5544, 526.5096 },
	{ 130.5, 4.1687, 1045.1548 },
	{ 141.4, 3.1357, 491.5579 },
	{ 99.5, 1.421, 532.872 },
	{ 96.1, 1.182, 117.320 },
	{ 91.8, 0.858, 1272.681 },
	{ 87.7, 1.217, 453.425 },
	{ 68.5, 2.352, 2.921 },
	{ 66.1, 5.344, 1471.753 },
	{ 77.4, 4.427, 39.357 },
	{ 72.0, 4.238, 2111.650 },
	{ 63.4, 4.977, 0.751 },
	{ 59.4, 4.111, 2001.444 },
	{ 62.5, 0.512, 220.413 },
	{ 66.5, 2.989, 2214.743 },
	{ 60.2, 4.126, 4.193 },
	{ 56.0, 1.155, 21.341 },
	{ 52.9, 0.912, 10.295 },
	{ 70.3, 5.142, 835.037 },
	{ 51.9, 4.100, 1258.454 },
	{ 46.4, 4.665, 5.629 },
	{ 58.2, 5.866, 5753.385 },
	{ 40.1, 4.688, 0.160 },
	{ 46.7, 4.794, 305.346 },
	{ 39.3, 4.254, 853.196 },
	{ 46.0, 5.110, 4.666 },
	{ 54.5, 1.571, 983.116 },
	{ 38.9, 6.076, 518.645 },
	{ 38.4, 2.438, 433.712 },
	{ 46.8, 3.546, 5.417 },
	{ 41.8, 4.680, 302.165 },
	{ 35.9, 2.451, 430.530 },
	{ 37.9, 0.211, 2648.455 },
	{ 39.2, 1.718, 11.046 },
	{ 37.6, 6.195, 831.856 },
	{ 35.8, 4.615, 2008.558 },
	{ 43.4, 0.150, 528.206 },
	{ 31.6, 5.141, 1788.145 },
	{ 29.8, 5.344, 2221.857 },
	{ 32.8, 5.289, 88.866 },
	{ 27.7, 1.852, 0.212 },
	{ 25.8, 3.859, 2317.836 },
	{ 33.8, 1.006, 9683.595 },
	{ 27.1, 2.808, 18.159 },
	{ 26.8, 1.776, 532.139 },
	{ 26.1, 2.744, 2531.135 },
	{ 30.8, 0.423, 1.484 },
	{ 30.5, 3.667, 508.350 },
	/* 109 terms retained, 651 terms dropped, error 1.3" */

	/* jupiter l, T^1 */
	{ 52993480757.5, 0, 0 },
	{ 489741.2, 4.2206669, 529.6909651 },
	{ 228918.5, 6.0264746, 7.1135470 },
	{ 27655.4, 4.572660, 1059.381930 },
	{ 20720.9, 5.459389, 522.577418 },
	{ 12105.7, 0.169858, 536.804512 },
	{ 6068.1, 4.42420, 103.09277 },
	{ 5433.9, 3.98478, 419.48464 },
	{ 4237.8, 5.89009, 14.22709 },
	{ 2211.9, 5.26771, 206.18555 },
	{ 1295.8, 5.55133, 3.18139 },
	{ 1745.9, 4.92669, 1589.07290 },
	{ 1163.4, 0.51451, 3.93215 },
	{ 1007.2, 0.46478, 735.87651 },
	{ 1173.1, 5.85647, 1052.26838 },
	{ 847.7, 5.7581, 110.2063 },
	{ 827.3, 4.8031, 213.2991 },
	{ 1003.6, 3.15040, 426.59819 },
	{ 1098.7, 5.30705, 515.46387 },
	{ 816.4, 0.5864, 1066.4955 },
	{ 725.4, 5.5183, 639.8973 },
	{ 567.8, 5.9887, 625.6702 },
	{ 474.2, 4.1325, 412.3711 },
	{ 412.9, 5.7365, 95.9792 },
	{ 335.8, 3.7325, 1162.4747 },
	{ 345.2, 4.2416, 632.7837 },
	{ 234.1, 6.2430, 309.2783 },
	{ 194.8, 2.2188, 323.5054 },
	{ 234.3, 4.0347, 949.1756 },
	{ 183.9, 6.2796, 543.9181 },
	{ 198.5, 1.5046, 838.9693 },
	{ 186.9, 6.0862, 742.9901 },
	{ 171.4, 5.4166, 199.0720 },
	{ 130.8, 0.6264, 728.7630 },
	{ 107.6, 4.4928, 956.2892 },
	{ 115.4, 0.6802, 846.0828 },
	{ 115.0, 5.2864, 2118.7639 },
	{ 66.8, 5.734, 21.341 },
	{ 69.6, 5.973, 532.872 },
	{ 64.9, 6.088, 1581.959 },
	{ 79.7, 5.824, 1045.155 },
	{ 57.9, 0.995, 1596.186 },
	{ 65.6, 0.129, 526.510 },
	{ 58.5, 0.586, 1155.361 },
	{ 56.6, 1.412, 533.623 },
	{ 71.6, 5.342, 942.062 },
	{ 57.4, 5.969, 1169.588 },
	{ 54.9, 5.428, 10.295 },
	{ 52.0, 0.230, 1368.660 },
	{ 52.3, 5.727, 117.320 },
	{ 50.4, 6.081, 525.759 },
	{ 47.4, 3.626, 1478.867 },
	{ 39.9, 4.162, 1692.166 },
	{ 46.7, 0.511, 1265.567 },
	{ 32.8, 5.036, 220.413 },
	{ 33.6, 0.099, 302.165 },
	{ 29.4, 3.359, 4.666 },
	{ 29.3, 0.759, 88.866 },
	{ 32.4, 5.375, 508.350 },
	{ 29.5, 5.422, 1272.681 },
	{ 21.8, 6.151, 1685.052 },
	{ 25.2, 1.607, 831.856 },
	{ 21.1, 5.863, 1258.454 },
	{ 19.7, 2.172, 316.392 },
	{ 17.9, 0.828, 433.712 },
	{ 17.7, 5.955, 5.417 },
	{ 17.2, 2.764, 853.196 },
	{ 17.5, 0.707, 1471.753 },
	{ 17.5, 0.498, 1375.774 },
	{ 14.4, 0.915, 18.159 },
	{ 14.1, 0.630, 2.921 },
	{ 11.6, 4.304, 405.258 },
	{ 11.7, 1.764, 380.128 },
	{ 11.1, 5.567, 1574.846 },
	{ 10.4, 0.314, 1361.547 },
	{ 9.8, 5.90, 519.40 },
	{ 9.8, 0.39, 1073.61 },
	{ 9.3, 3.22, 1795.26 },
	{ 8.9, 0.54, 1788.14 },
	{ 8.4, 5.88, 2001.44 },
	{ 8.1, 5.10, 1485.98 },
	{ 7.7, 5.65, 2648.45 },
	{ 6.7, 2.41, 4.19 },
	{ 7.3, 6.19, 11.05 },
	{ 6.3, 1.36, 1148.25 },
	/* 85 terms retained, 284 terms dropped, error 0.24"*T */

	/* jupiter l, T^2 */
	{ 47233.6, 4.321483, 7.113547 },
	{ 30629.1, 2.930214, 529.690965 },
	{ 38965.5, 0, 0 },
	{ 3189.3, 1.05505, 522.57742 },
	{ 2723.4, 3.41412, 1059.38193 },
	{ 2729.3, 4.84545, 536.80451 },
	{ 1721.1, 4.18734, 14.22709 },
	{ 383.3, 5.7679, 419.4846 },
	{ 367.5, 6.0551, 103.0928 },
	{ 377.5, 0.7605, 515.4639 },
	{ 337.4, 3.7864, 3.1814 },
	{ 308.2, 0.6936, 206.1855 },
	{ 218.4, 3.8139, 1589.0729 },
	{ 198.9, 5.3400, 1066.4955 },
	{ 197.4, 2.4836, 3.9322 },
	{ 146.2, 3.8137, 639.8973 },
	{ 155.9, 1.4064, 1052.2684 },
	{ 129.6, 5.8374, 412.3711 },
	{ 141.9, 1.6344, 426.5982 },
	{ 117.3, 1.4144, 625.6702 },
	{ 96.7, 4.034, 110.206 },
	{ 90.8, 1.106, 95.979 },
	{ 78.8, 4.637, 543.918 },
	{ 72.4, 2.217, 735.877 },
	{ 87.3, 2.522, 632.784 },
	{ 56.9, 3.123, 213.299 },
	{ 48.6, 1.673, 309.278 },
	{ 58.5, 0.832, 199.072 },
	{ 40.1, 4.025, 21.341 },
	{ 39.8, 0.624, 323.505 },
	{ 35.7, 2.326, 728.763 },
	{ 25.6, 2.512, 1162.475 },
	{ 29.3, 3.608, 10.295 },
	{ 23.6, 3.005, 956.289 },
	{ 27.8, 3.240, 838.969 },
	{ 26.0, 4.501, 742.990 },
	{ 25.2, 1.219, 1045.155 },
	{ 19.5, 4.290, 532.872 },
	{ 17.7, 0.810, 508.350 },
	{ 15.4, 5.810, 1596.186 },
	{ 17.1, 4.200, 2118.764 },
	{ 17.0, 1.834, 526.510 },
	{ 14.7, 4.000, 117.320 },
	{ 13.6, 1.803, 302.165 },
	{ 13.2, 2.519, 88.866 },
	{ 12.8, 4.369, 1169.588 },
	{ 15.3, 0.682, 942.062 },
	{ 11.0, 4.436, 525.759 },
	{ 13.9, 5.952, 316.392 },
	{ 9.4, 2.18, 1155.36 },
	{ 8.8, 3.29, 220.41 },
	{ 7.8, 5.76, 846.08 },
	{ 7.5, 2.71, 533.62 },
	{ 9.7, 1.72, 1581.96 },
	{ 8.7, 3.32, 831.86 },
	{ 6.3, 0.50, 949.18 },
	{ 6.7, 2.18, 1265.57 },
	{ 5.4, 6.01, 405.26 },
	{ 4.7, 1.41, 1258.45 },
	{ 4.4, 3.02, 1692.17 },
	{ 4.4, 5.48, 433.71 },
	{ 4.3, 5.07, 1073.61 },
	{ 4.2, 5.29, 18.16 },
	{ 3.9, 1.27, 853.20 },
	{ 5.4, 3.65, 1272.68 },
	{ 4.4, 2.27, 1368.66 },
	{ 3.5, 1.54, 519.40 },
	{ 2.7, 2.10, 1478.87 },
	{ 2.7, 1.06, 1574.85 },
	{ 2.9, 2.05, 1361.55 },
	{ 3.1, 0.99, 191.96 },
	{ 2.5, 2.37, 1471.75 },
	{ 2.2, 2.48, 721.65 },
	{ 2.1, 3.71, 1485.98 },
	{ 2.0, 1.88, 1685.05 },
	{ 2.3, 3.03, 1148.25 },
	{ 2.0, 6.17, 330.62 },
	/* 77 terms retained, 114 terms dropped, error 0.074"*T^2 */

	/* jupiter l, T^3 */
	{ 6501.7, 2.59863, 7.11355 },
	{ 1356.5, 1.34636, 529.69097 },
	{ 470.7, 2.4750, 14.2271 },
	{ 417.0, 3.2445, 536.8045 },
	{ 352.9, 2.9736, 522.5774 },
	{ 154.9, 2.0757, 1059.3819 },
	{ 86.8, 2.514, 515.464 },
	{ 33.5, 3.826, 1066.495 },
	{ 44.4, 0, 0 },
	{ 22.6, 2.982, 543.918 },
	{ 23.7, 1.277, 412.371 },
	{ 28.5, 2.448, 206.186 },
	{ 19.8, 2.101, 639.897 },
	{ 19.7, 1.403, 419.485 },
	{ 18.8, 1.594, 103.093 },
	{ 17.0, 2.302, 21.341 },
	{ 16.8, 2.598, 1589.073 },
	{ 16.2, 3.145, 625.670 },
	{ 16.1, 3.360, 1052.268 },
	{ 13.4, 2.760, 95.979 },
	{ 13.2, 2.539, 199.072 },
	{ 12.6, 6.266, 426.598 },
	{ 8.6, 2.27, 110.21 },
	{ 6.7, 3.43, 309.28 },
	{ 8.7, 1.76, 10.29 },
	{ 6.5, 4.04, 728.76 },
	{ 5.4, 5.25, 323.51 },
	{ 5.7, 2.52, 508.35 },
	{ 5.4, 2.91, 1045.15 },
	{ 4.0, 4.30, 88.87 },
	{ 3.9, 3.52, 302.16 },
	{ 3.8, 4.09, 735.88 },
	{ 3.3, 1.43, 956.29 },
	{ 2.8, 4.36, 1596.19 },
	{ 2.7, 1.25, 213.30 },
	{ 2.6, 2.24, 117.32 },
	{ 2.4, 2.90, 742.99 },
	{ 2.7, 5.02, 838.97 },
	{ 1.9, 2.77, 1169.59 },
	{ 2.3, 2.36, 942.06 },
	{ 1.5, 1.61, 220.41 },
	{ 1.5, 3.09, 2118.76 },
	{ 1.9, 5.01, 831.86 },
	{ 1.6, 1.40, 405.26 },
	{ 1.3, 3.98, 1155.36 },
	{ 1.2, 3.46, 1073.61 },
	{ 1.0, 3.39, 532.87 },
	{ 0.9, 2.70, 191.96 },
	{ 0.8, 1.48, 632.78 },
	{ 0.8, 1.11, 1162.47 },
	{ 0.8, 3.30, 1258.45 },
	{ 0.7, 5.90, 853.20 },
	{ 0.8, 3.66, 1581.96 },
	{ 0.7, 3.75, 433.71 },
	{ 0.7, 2.93, 1574.85 },
	{ 0.7, 3.53, 525.76 },
	{ 0.6, 4.15, 721.65 },
	{ 0.6, 4.69, 81.75 },
	{ 0.7, 1.96, 1272.68 },
	{ 0.5, 1.57, 949.18 },
	{ 0.7, 2.02, 526.51 },
	{ 0.5, 4.36, 1368.66 },
	{ 0.5, 4.96, 1148.25 },
	{ 0.5, 4.31, 330.62 },
	{ 0.6, 2.28, 551.03 },
	{ 0.5, 3.87, 1361.55 },
	{ 0.4, 2.95, 1038.04 },
	{ 0.4, 4.08, 1471.75 },
	{ 0.4, 2.22, 539.99 },
	{ 0.4, 4.53, 1464.64 },
	/* 70 terms retained, 39 terms dropped, error 0.014"*T^3 */

	/* jupiter l, T^4 */
	{ 669.5, 0.8528, 7.1135 },
	{ 100.0, 0.7426, 14.2271 },
	{ 114.0, 3.1416, 0 },
	{ 50.0, 1.653, 536.805 },
	{ 43.6, 5.820, 529.691 },
	{ 31.8, 4.858, 522.577 },
	{ 14.7, 4.291, 515.464 },
	{ 8.9, 0.71, 1059.38 },
	{ 5.0, 1.30, 543.92 },
	{ 4.5, 2.32, 1066.50 },
	{ 4.3, 0.48, 21.34 },
	{ 3.1, 3.00, 412.37 },
	{ 2.1, 0.40, 639.90 },
	{ 1.8, 4.91, 625.67 },
	{ 1.9, 4.26, 199.07 },
	{ 1.7, 4.26, 206.19 },
	{ 1.4, 5.26, 1052.27 },
	{ 1.2, 4.72, 95.98 },
	{ 1.1, 1.29, 1589.07 },
	{ 1.0, 4.78, 1045.15 },
	{ 0.9, 6.06, 88.87 },
	{ 0.9, 5.78, 728.76 },
	{ 0.9, 4.55, 426.60 },
	{ 0.8, 3.40, 419.48 },
	{ 0.8, 3.55, 103.09 },
	{ 0.7, 0.52, 110.21 },
	{ 0.4, 5.23, 302.16 },
	{ 0.4, 6.24, 956.29 },
	{ 0.4, 5.25, 309.28 },
	{ 0.4, 0.60, 117.32 },
	{ 0.3, 4.78, 508.35 },
	{ 0.3, 3.48, 323.51 },
	{ 0.3, 2.96, 1596.19 },
	{ 0.3, 4.33, 942.06 },
	{ 0.3, 0.48, 831.86 },
	{ 0.3, 1.80, 1073.61 },
	{ 0.2, 0.44, 220.41 },
	{ 0.2, 1.13, 1169.59 },
	{ 0.2, 2.16, 1361.55 },
	{ 0.2, 3.43, 1148.25 },
	{ 0.2, 1.93, 2118.76 },
	{ 0.2, 3.03, 1272.68 },
	/* 42 terms retained, 3 terms dropped, error 0.0042"*T^4 */

	/* jupiter l, T^5 */
	{ 49.6, 5.257, 7.114 },
	{ 15.8, 5.251, 14.227 },
	{ 4.3, 0.01, 536.80 },
	{ 1.5, 1.10, 522.58 },
	{ 0.7, 5.86, 543.92 },
	{ 0.7, 0.87, 515.46 },
	{ 0.8, 3.14, 0 },
	{ 0.5, 0.82, 1066.50 },
	{ 0.3, 5.63, 1059.38 },
	/* 9 terms retained, 1 terms dropped, error 0.0038"*T^5 */
	/* end jupiter l */

	/* jupiter b, T^0 */
	{ 2268615.7, 3.55852607, 529.69096509 },
	{ 109971.6, 3.9080935, 1059.3819302 },
	{ 110090.4, 0, 0 },
	{ 8101.4, 3.60510, 522.57742 },
	{ 6044.0, 4.25883, 1589.07290 },
	{ 6437.8, 0.30627, 536.80451 },
	{ 1106.9, 2.98534, 1162.47470 },
	{ 941.7, 2.9362, 1052.2684 },
	{ 894.1, 1.7545, 7.1135 },
	{ 767.3, 2.1547, 632.7837 },
	{ 944.3, 1.6752, 426.5982 },
	{ 684.2, 3.6781, 213.2991 },
	{ 629.2, 0.6434, 1066.4955 },
	{ 835.9, 5.1788, 103.0928 },
	{ 531.7, 2.7031, 110.2063 },
	{ 558.5, 0.0135, 846.0828 },
	{ 464.4, 1.1734, 949.1756 },
	{ 431.1, 2.6083, 419.4846 },
	{ 351.4, 4.6106, 2118.7639 },
	{ 123.1, 3.3497, 1692.1657 },
	{ 115.0, 5.0489, 316.3919 },
	{ 132.2, 4.7782, 742.9901 },
	{ 103.4, 2.3188, 1478.8666 },
	{ 116.4, 1.3869, 323.5054 },
	{ 102.4, 3.1529, 1581.9593 },
	{ 103.8, 3.7010, 515.4639 },
	{ 78.7, 3.983, 1265.567 },
	{ 69.9, 2.560, 956.289 },
	{ 55.6, 0.375, 1375.774 },
	{ 52.0, 0.990, 1596.186 },
	{ 55.2, 0.402, 525.759 },
	{ 63.5, 4.501, 735.877 },
	{ 49.7, 0.186, 543.918 },
	{ 48.8, 3.573, 533.623 },
	{ 28.4, 1.535, 625.670 },
	{ 29.2, 5.431, 206.186 },
	/* 36 terms retained, 213 terms dropped, error 0.73" */

	/* jupiter b, T^1 */
	{ 177351.8, 5.7016649, 529.6909651 },
	{ 3230.2, 5.77942, 1059.38193 },
	{ 3081.4, 5.47464, 522.57742 },
	{ 2211.9, 4.73477, 536.80451 },
	{ 1694.2, 3.14159, 0 },
	{ 346.4, 4.7460, 1052.2684 },
	{ 234.3, 5.1886, 1066.4955 },
	{ 196.2, 6.1855, 7.1135 },
	{ 150.5, 3.9272, 1589.0729 },
	{ 114.1, 3.4390, 632.7837 },
	{ 96.7, 2.914, 949.176 },
	{ 76.6, 2.505, 103.093 },
	{ 81.7, 5.077, 1162.475 },
	{ 76.6, 0.613, 419.485 },
	{ 73.9, 5.500, 515.464 },
	{ 49.9, 3.948, 735.877 },
	{ 60.5, 5.447, 213.299 },
	{ 36.6, 4.698, 543.918 },
	{ 46.0, 0.539, 110.206 },
	{ 45.1, 1.895, 846.083 },
	{ 36.0, 6.110, 316.392 },
	{ 32.0, 4.925, 1581.959 },
	{ 21.0, 5.630, 1596.186 },
	{ 23.2, 5.848, 323.505 },
	{ 24.7, 3.941, 2118.764 },
	{ 17.3, 5.653, 533.623 },
	{ 16.5, 5.898, 526.510 },
	{ 16.7, 5.667, 1265.567 },
	{ 15.8, 4.433, 1045.155 },
	{ 13.4, 4.302, 532.872 },
	{ 11.7, 1.810, 956.289 },
	{ 11.9, 4.301, 525.759 },
	{ 9.5, 2.03, 206.19 },
	{ 10.5, 6.155, 14.227 },
	{ 8.4, 3.93, 1478.87 },
	{ 8.1, 4.20, 1169.59 },
	{ 7.7, 2.99, 942.06 },
	{ 8.8, 1.56, 426.60 },
	{ 8.9, 4.87, 1155.36 },
	{ 7.8, 3.85, 625.67 },
	/* 40 terms retained, 101 terms dropped, error 0.21"*T */

	/* jupiter b, T^2 */
	{ 8094.1, 1.46323, 529.69097 },
	{ 742.4, 0.9569, 522.5774 },
	{ 813.2, 3.1416, 0 },
	{ 399.0, 2.8989, 536.8045 },
	{ 342.2, 1.4468, 1059.3819 },
	{ 73.9, 0.407, 1052.268 },
	{ 46.2, 3.480, 1066.495 },
	{ 29.3, 0.991, 515.464 },
	{ 29.7, 1.925, 1589.073 },
	{ 22.8, 4.271, 7.114 },
	{ 13.9, 2.922, 543.918 },
	{ 12.1, 5.222, 632.784 },
	{ 10.7, 4.880, 949.176 },
	{ 6.1, 6.21, 1045.15 },
	{ 5.9, 0.53, 1581.96 },
	{ 5.0, 1.43, 526.51 },
	{ 4.6, 0.92, 1162.47 },
	{ 4.5, 4.02, 1596.19 },
	{ 5.1, 6.03, 735.88 },
	{ 3.6, 4.54, 110.21 },
	{ 3.4, 1.39, 533.62 },
	{ 3.3, 4.40, 14.23 },
	{ 3.4, 0.42, 419.48 },
	{ 2.9, 2.06, 316.39 },
	{ 2.5, 3.98, 323.51 },
	{ 3.1, 2.48, 2118.76 },
	{ 3.1, 2.40, 532.87 },
	{ 2.2, 4.78, 942.06 },
	{ 2.1, 3.89, 426.60 },
	{ 2.3, 0.37, 1155.36 },
	{ 2.0, 3.90, 846.08 },
	{ 1.9, 1.20, 103.09 },
	{ 1.7, 1.42, 1265.57 },
	{ 2.3, 0.88, 213.30 },
	{ 1.8, 5.80, 625.67 },
	{ 1.7, 2.24, 525.76 },
	/* 36 terms retained, 45 terms dropped, error 0.043"*T^2 */

	/* jupiter b, T^3 */
	{ 251.6, 3.3809, 529.6910 },
	{ 121.7, 2.7331, 522.5774 },
	{ 48.7, 1.037, 536.805 },
	{ 11.0, 2.315, 1052.268 },
	{ 8.1, 2.77, 515.46 },
	{ 6.2, 1.78, 1066.50 },
	{ 7.3, 4.25, 1059.38 },
	{ 3.6, 1.13, 543.92 },
	{ 2.8, 3.14, 0 },
	{ 1.9, 2.29, 7.11 },
	{ 1.6, 1.78, 1045.15 },
	{ 0.9, 0.45, 632.78 },
	{ 0.8, 0.31, 949.18 },
	{ 0.7, 2.64, 14.23 },
	{ 0.9, 0.33, 1589.07 },
	{ 0.7, 2.37, 1581.96 },
	{ 0.6, 2.48, 1596.19 },
	{ 0.7, 1.53, 735.88 },
	{ 0.5, 3.68, 419.48 },
	{ 0.5, 0.27, 942.06 },
	{ 0.5, 3.18, 526.51 },
	{ 0.4, 2.88, 110.21 },
	/* 22 terms retained, 20 terms dropped, error 0.0081"*T^3 */

	/* jupiter b, T^4 */
	{ 15.1, 4.530, 522.577 },
	{ 5.4, 4.47, 529.69 },
	{ 4.5, 5.44, 536.80 },
	{ 3.4, 0, 0 },
	{ 1.8, 4.52, 515.46 },
	{ 1.3, 4.20, 1052.27 },
	{ 0.8, 5.59, 543.92 },
	{ 0.5, 0.06, 1066.50 },
	{ 0.3, 3.67, 1059.38 },
	{ 0.1, 3.56, 1045.15 },
	{ 0.1, 5.70, 7.11 },
	{ 0.1, 1.17, 14.23 },
	/* 12 terms retained, 0 terms dropped, error 0.0017"*T^4 */

	/* jupiter b, T^5 */
	{ 1.4, 0.09, 522.58 },
	{ 0.4, 0.01, 515.46 },
	{ 0.3, 3.28, 536.80 },
	{ 0.1, 0.34, 529.69 },
	/* 4 terms retained, 1 terms dropped, error 0.0012"*T^5 */
	/* end jupiter b */

	/* jupiter r, T^0 */
	{ 520887429.5, 0, 0 },
	{ 25209327.0, 3.491086400, 529.690965095 },
	{ 610599.9, 3.8411537, 1059.3819302 },
	{ 282029.5, 2.5741988, 632.7837393 },
	{ 187647.4, 2.0759038, 522.5774181 },
	{ 86792.9, 0.710011, 419.484644 },
	{ 72062.9, 0.214657, 536.804512 },
	{ 65517.2, 5.979959, 316.391870 },
	{ 29134.6, 1.677592, 103.092774 },
	{ 30135.3, 2.161321, 949.175609 },
	{ 23453.2, 3.540231, 735.876514 },
	{ 22283.7, 4.193628, 1589.072895 },
	{ 23947.3, 0.274579, 7.113547 },
	{ 13032.6, 2.960431, 1162.474704 },
	{ 9703.3, 1.90670, 206.18555 },
	{ 12749.0, 2.715501, 1052.268383 },
	{ 9161.4, 4.41353, 213.29910 },
	{ 7894.5, 2.47908, 426.59819 },
	{ 7058.0, 2.18185, 1265.56748 },
	{ 6137.8, 6.26418, 846.08283 },
	{ 5477.1, 5.65729, 639.89729 },
	{ 3502.5, 0.56531, 1066.49548 },
	{ 4136.9, 2.72220, 625.67019 },
	{ 4170.0, 2.01605, 515.46387 },
	{ 2500.0, 4.55182, 838.96929 },
	{ 2617.0, 2.00994, 1581.95935 },
	{ 1911.9, 0.85622, 412.37110 },
	{ 2127.6, 6.12751, 742.99006 },
	{ 1610.5, 3.08868, 1368.66025 },
	{ 1479.5, 2.68026, 1478.86657 },
	{ 1230.7, 1.89043, 323.50542 },
	{ 1216.8, 1.80172, 110.20632 },
	{ 961.1, 4.5488, 2118.7639 },
	{ 885.7, 4.1479, 533.6231 },
	{ 776.7, 3.6770, 728.7630 },
	{ 998.6, 2.8721, 309.2783 },
	{ 1015.0, 1.38673, 454.90937 },
	{ 727.2, 3.9882, 1155.3612 },
	{ 655.3, 2.7907, 1685.0521 },
	{ 821.5, 1.5934, 1898.3512 },
	{ 620.8, 4.8228, 956.2892 },
	{ 654.0, 3.3815, 1692.1657 },
	{ 812.0, 5.9409, 909.8187 },
	{ 562.1, 0.0810, 543.9181 },
	{ 542.2, 0.2836, 525.7588 },
	{ 457.9, 0.1272, 1375.7738 },
	{ 614.8, 2.2762, 942.0621 },
	{ 435.8, 2.6027, 95.9792 },
	{ 496.1, 5.5301, 380.1278 },
	{ 470.0, 2.8190, 1795.2584 },
	{ 445.0, 0.1462, 14.2271 },
	{ 290.9, 3.8934, 1471.7530 },
	{ 276.6, 2.5224, 2001.4440 },
	{ 275.1, 2.9886, 526.5096 },
	{ 293.9, 2.0494, 199.0720 },
	{ 291.0, 6.0313, 1169.5883 },
	{ 338.3, 2.7987, 1045.1548 },
	{ 257.5, 6.1340, 532.8724 },
	{ 319.0, 1.3480, 2214.7431 },
	{ 309.4, 5.3686, 1272.6810 },
	{ 345.8, 1.5640, 491.5579 },
	{ 303.4, 1.1541, 5753.3849 },
	{ 192.3, 0.9200, 1596.1864 },
	{ 215.4, 2.6357, 2111.6503 },
	{ 200.7, 2.3726, 1258.4539 },
	{ 239.0, 3.5740, 835.0371 },
	{ 197.1, 5.9286, 453.4249 },
	{ 139.4, 3.6396, 1788.1449 },
	{ 191.4, 6.2825, 983.1159 },
	{ 176.6, 2.5767, 9683.5946 },
	{ 123.6, 2.2616, 2317.8359 },
	{ 128.2, 4.6659, 831.8557 },
	{ 112.4, 0.8560, 433.7117 },
	{ 128.8, 1.1057, 2531.1350 },
	{ 99.4, 4.503, 518.645 },
	{ 93.9, 2.726, 853.196 },
	{ 106.5, 5.8146, 220.4126 },
	{ 120.2, 2.9516, 3.9322 },
	{ 104.0, 2.2222, 74.7816 },
	{ 81.7, 3.235, 1361.547 },
	{ 112.5, 4.8622, 528.2065 },
	{ 79.5, 0.885, 430.530 },
	{ 85.8, 2.115, 1574.846 },
	{ 85.7, 2.338, 2428.042 },
	{ 68.3, 3.357, 2104.537 },
	{ 69.6, 3.042, 302.165 },
	{ 69.8, 3.224, 305.346 },
	{ 69.6, 0.205, 532.139 },
	{ 57.0, 2.002, 2634.228 },
	{ 77.1, 2.098, 508.350 },
	{ 56.7, 3.917, 2221.857 },
	{ 58.3, 5.724, 628.852 },
	{ 52.5, 4.025, 527.243 },
	{ 63.6, 1.100, 1364.728 },
	{ 53.6, 0.874, 2847.527 },
	{ 59.6, 0.958, 494.266 },
	{ 58.0, 3.458, 2008.558 },
	{ 41.5, 3.520, 529.739 },
	{ 44.7, 1.623, 984.600 },
	{ 44.9, 4.901, 2648.455 },
	{ 53.2, 1.198, 760.256 },
	{ 44.4, 4.426, 1063.314 },
	{ 37.6, 2.930, 1677.939 },
	{ 41.5, 0.322, 529.643 },
	{ 42.9, 0.031, 1439.510 },
	{ 46.0, 2.543, 636.716 },
	{ 40.2, 4.394, 1148.248 },
	{ 38.8, 4.317, 149.563 },
	{ 40.3, 2.101, 2744.434 },
	{ 48.9, 5.603, 2810.921 },
	{ 37.1, 5.078, 1905.465 },
	{ 43.9, 1.245, 621.738 },
	{ 34.0, 3.094, 2420.929 },
	{ 36.8, 0.842, 530.654 },
	{ 31.1, 5.358, 1485.980 },
	{ 39.3, 4.708, 569.048 },
	{ 39.7, 2.462, 355.749 },
	{ 31.5, 6.193, 3.181 },
	{ 28.4, 2.485, 519.396 },
	{ 32.4, 2.733, 604.473 },
	{ 27.1, 3.923, 2324.949 },
	{ 26.8, 1.750, 2950.620 },
	{ 29.0, 1.835, 1891.238 },
	{ 26.5, 0.604, 1055.450 },
	{ 33.5, 0.761, 643.829 },
	{ 26.6, 1.036, 405.258 },
	{ 25.5, 3.463, 458.842 },
	{ 32.9, 3.186, 528.728 },
	{ 25.7, 0.524, 511.532 },
	{ 26.0, 1.336, 330.619 },
	/* 130 terms retained, 615 terms dropped, error 6e-06 a.u. */

	/* jupiter r, T^1 */
	{ 1271801.6, 2.64937511, 529.69096509 },
	{ 61661.8, 3.000763, 1059.381930 },
	{ 53443.6, 3.897176, 522.577418 },
	{ 31185.2, 4.882767, 536.804512 },
	{ 41390.3, 0, 0 },
	{ 11847.2, 2.413296, 419.484644 },
	{ 9166.4, 4.75979, 7.11355 },
	{ 3175.8, 2.79298, 103.09277 },
	{ 3203.4, 5.21083, 735.87651 },
	{ 3403.6, 3.34689, 1589.07290 },
	{ 2600.0, 3.63435, 206.18555 },
	{ 2412.2, 1.46947, 426.59819 },
	{ 2806.1, 3.74224, 515.46387 },
	{ 2676.6, 4.33053, 1052.26838 },
	{ 2100.5, 3.92763, 639.89729 },
	{ 1646.2, 5.30954, 1066.49548 },
	{ 1641.3, 4.41629, 625.67019 },
	{ 1049.9, 3.16114, 213.29910 },
	{ 1024.8, 2.55433, 412.37110 },
	{ 741.0, 2.1709, 1162.4747 },
	{ 806.4, 2.6775, 632.7837 },
	{ 676.9, 6.2495, 838.9693 },
	{ 468.9, 4.7097, 543.9181 },
	{ 444.7, 0.4028, 323.5054 },
	{ 567.1, 4.5766, 742.9901 },
	{ 415.9, 5.3684, 728.7630 },
	{ 484.7, 2.4688, 949.1756 },
	{ 337.6, 3.1678, 956.2892 },
	{ 401.7, 4.6053, 309.2783 },
	{ 347.4, 4.6815, 14.2271 },
	{ 260.8, 5.3429, 846.0828 },
	{ 220.1, 4.8421, 1368.6603 },
	{ 203.2, 5.6000, 1155.3612 },
	{ 246.6, 3.9231, 942.0621 },
	{ 183.5, 4.2653, 95.9792 },
	{ 180.1, 4.4017, 532.8724 },
	{ 197.1, 3.7055, 2118.7639 },
	{ 196.0, 3.7588, 199.0720 },
	{ 200.2, 4.4389, 1045.1548 },
	{ 170.2, 4.8465, 526.5096 },
	{ 146.3, 6.1296, 533.6231 },
	{ 133.5, 1.3225, 110.2063 },
	{ 132.1, 4.5119, 525.7588 },
	{ 123.9, 2.0429, 1478.8666 },
	{ 121.9, 4.4058, 1169.5883 },
	{ 115.3, 4.4674, 1581.9593 },
	{ 98.5, 5.728, 1596.186 },
	{ 91.6, 4.530, 1685.052 },
	{ 110.6, 3.6250, 1272.6810 },
	{ 80.5, 4.113, 1258.454 },
	{ 79.6, 2.719, 1692.166 },
	{ 100.2, 5.2469, 1265.5675 },
	{ 77.9, 5.567, 1471.753 },
	{ 85.8, 0.079, 831.856 },
	{ 82.1, 3.808, 508.350 },
	{ 55.3, 0.352, 316.392 },
	{ 52.3, 5.531, 433.712 },
	{ 55.8, 4.751, 302.165 },
	{ 50.6, 4.856, 1375.774 },
	{ 43.6, 4.944, 1361.547 },
	{ 42.2, 1.224, 853.196 },
	{ 37.7, 4.268, 2001.444 },
	{ 49.4, 4.014, 220.413 },
	{ 38.3, 5.330, 1788.145 },
	{ 35.6, 1.762, 1795.258 },
	{ 36.3, 3.850, 1574.846 },
	{ 29.3, 5.166, 3.932 },
	{ 25.2, 4.338, 519.396 },
	{ 24.8, 2.729, 405.258 },
	{ 27.0, 6.097, 1148.248 },
	{ 22.6, 0.192, 380.128 },
	{ 20.5, 4.329, 3.181 },
	{ 19.9, 4.630, 1677.939 },
	{ 19.5, 5.106, 1073.609 },
	{ 18.4, 3.765, 1485.980 },
	{ 18.9, 5.053, 2104.537 },
	{ 17.0, 4.018, 2317.836 },
	{ 16.7, 5.429, 88.866 },
	{ 15.3, 2.927, 2008.558 },
	{ 14.5, 3.633, 628.852 },
	{ 14.6, 5.508, 721.649 },
	{ 13.7, 4.876, 629.602 },
	{ 18.5, 6.030, 330.619 },
	{ 13.5, 1.385, 518.645 },
	{ 15.7, 2.930, 1905.465 },
	{ 12.5, 1.586, 2111.650 },
	{ 12.3, 3.377, 635.965 },
	{ 11.8, 4.085, 2648.455 },
	{ 11.2, 4.626, 636.716 },
	{ 14.3, 2.742, 2221.857 },
	{ 11.2, 3.553, 1891.238 },
	{ 13.1, 5.838, 1464.639 },
	{ 11.4, 2.576, 511.532 },
	{ 10.5, 0.499, 453.425 },
	{ 9.7, 4.39, 1994.33 },
	{ 10.1, 2.764, 423.417 },
	{ 8.6, 5.16, 1056.20 },
	{ 9.0, 4.79, 2420.93 },
	{ 8.1, 3.73, 2634.23 },
	{ 8.1, 1.29, 2428.04 },
	{ 8.9, 1.86, 750.10 },
	{ 8.9, 4.81, 1062.56 },
	{ 8.6, 4.54, 21.34 },
	{ 9.5, 4.33, 1802.37 },
	{ 6.9, 5.97, 540.74 },
	{ 7.3, 4.98, 1699.28 },
	{ 7.1, 4.99, 1055.45 },
	{ 7.2, 4.98, 1898.35 },
	{ 6.5, 1.39, 422.67 },
	{ 6.8, 2.91, 2324.95 },
	{ 6.5, 4.57, 1038.04 },
	{ 7.3, 3.02, 416.30 },
	{ 6.6, 5.55, 1781.03 },
	/* 113 terms retained, 268 terms dropped, error 1.4e-06 a.u.*T */

	/* jupiter r, T^2 */
	{ 79644.8, 1.358659, 529.690965 },
	{ 8251.6, 5.77774, 522.57742 },
	{ 7029.9, 3.27477, 536.80451 },
	{ 5314.0, 1.83835, 1059.38193 },
	{ 1860.8, 2.97682, 7.11355 },
	{ 836.3, 4.1989, 419.4846 },
	{ 964.5, 5.4803, 515.4639 },
	{ 406.5, 3.7825, 1066.4955 },
	{ 426.6, 2.2275, 639.8973 },
	{ 377.3, 2.2425, 1589.0729 },
	{ 497.9, 3.1416, 0 },
	{ 339.0, 6.1269, 625.6702 },
	{ 362.9, 5.3676, 206.1855 },
	{ 342.0, 6.0992, 1052.2684 },
	{ 279.9, 4.2616, 412.3711 },
	{ 332.6, 0.0033, 426.5982 },
	{ 229.8, 0.7053, 735.8765 },
	{ 200.8, 3.0685, 543.9181 },
	{ 199.8, 4.4288, 103.0928 },
	{ 257.3, 0.9630, 632.7837 },
	{ 138.6, 2.9324, 14.2271 },
	{ 113.5, 0.7871, 728.7630 },
	{ 86.0, 5.144, 323.505 },
	{ 94.6, 1.705, 838.969 },
	{ 83.5, 0.058, 309.278 },
	{ 75.2, 1.605, 956.289 },
	{ 70.5, 1.510, 213.299 },
	{ 80.3, 2.981, 742.990 },
	{ 56.2, 0.955, 1162.475 },
	{ 61.6, 6.101, 1045.155 },
	{ 66.6, 5.473, 199.072 },
	{ 50.1, 2.721, 532.872 },
	{ 51.9, 5.584, 942.062 },
	{ 39.8, 5.946, 95.979 },
	{ 44.5, 5.524, 508.350 },
	{ 44.3, 0.271, 526.510 },
	{ 29.9, 0.936, 1155.361 },
	{ 28.4, 2.878, 525.759 },
	{ 26.3, 4.269, 1596.186 },
	{ 27.0, 2.806, 1169.588 },
	{ 27.5, 2.648, 2118.764 },
	{ 22.7, 0.178, 302.165 },
	{ 29.3, 1.786, 831.856 },
	{ 20.0, 0.043, 949.176 },
	{ 19.9, 1.161, 533.623 },
	{ 21.7, 1.888, 1272.681 },
	{ 17.6, 4.150, 846.083 },
	{ 17.1, 5.892, 1258.454 },
	{ 21.4, 4.355, 316.392 },
	{ 21.3, 0.544, 1265.567 },
	{ 19.9, 0.065, 1581.959 },
	{ 17.0, 0.534, 1368.660 },
	{ 12.8, 3.900, 433.712 },
	{ 13.1, 0.795, 110.206 },
	{ 11.9, 0.407, 1361.547 },
	{ 11.7, 4.444, 405.258 },
	{ 12.0, 2.229, 220.413 },
	{ 9.6, 6.01, 853.20 },
	{ 10.2, 0.995, 1471.753 },
	{ 9.0, 1.60, 1692.17 },
	{ 8.7, 3.52, 1073.61 },
	{ 8.3, 5.60, 1574.85 },
	{ 9.0, 6.27, 519.40 },
	{ 7.8, 0.65, 1478.87 },
	{ 7.8, 0.18, 1685.05 },
	{ 7.5, 0.88, 88.87 },
	{ 7.3, 0.89, 721.65 },
	{ 9.1, 1.51, 1148.25 },
	{ 6.1, 2.50, 3.18 },
	{ 7.0, 4.44, 330.62 },
	{ 5.2, 2.79, 21.34 },
	{ 5.1, 2.98, 1375.77 },
	{ 4.9, 0.05, 1677.94 },
	{ 4.7, 2.28, 1485.98 },
	{ 4.7, 0.86, 3.93 },
	{ 5.3, 0.85, 1788.14 },
	{ 4.2, 0.41, 629.60 },
	{ 4.2, 1.61, 635.97 },
	{ 3.6, 2.71, 551.03 },
	{ 3.3, 0.55, 1795.26 },
	{ 4.4, 1.28, 1464.64 },
	{ 3.3, 1.19, 1905.46 },
	{ 3.2, 6.19, 1038.04 },
	{ 3.1, 6.23, 2001.44 },
	{ 3.4, 2.45, 539.99 },
	{ 3.2, 5.55, 191.96 },
	{ 2.6, 3.24, 1062.56 },
	{ 2.6, 0.55, 2104.54 },
	{ 2.2, 5.33, 1891.24 },
	{ 2.7, 4.82, 416.30 },
	{ 2.2, 1.72, 628.85 },
	{ 2.3, 6.19, 1994.33 },
	{ 2.3, 4.28, 963.40 },
	{ 2.6, 0.03, 1898.35 },
	{ 2.1, 3.33, 1699.28 },
	{ 2.5, 2.40, 227.53 },
	{ 2.5, 0.07, 750.10 },
	{ 2.0, 0.29, 636.72 },
	{ 1.9, 0.32, 295.05 },
	{ 1.9, 3.44, 647.01 },
	{ 1.9, 0.29, 2111.65 },
	{ 1.9, 3.14, 611.44 },
	{ 2.3, 1.95, 824.74 },
	{ 1.9, 4.72, 2125.88 },
	{ 2.5, 1.24, 2221.86 },
	{ 1.8, 1.60, 2008.56 },
	{ 1.6, 5.83, 422.67 },
	{ 1.7, 2.32, 440.83 },
	{ 1.6, 0.37, 1056.20 },
	{ 1.6, 2.42, 10.29 },
	{ 1.6, 3.52, 1055.45 },
	{ 1.6, 5.76, 117.32 },
	{ 1.6, 5.89, 2317.84 },
	{ 2.0, 4.62, 423.42 },
	{ 2.1, 1.05, 1781.03 },
	{ 1.9, 1.12, 618.56 },
	{ 1.9, 2.79, 1802.37 },
	{ 1.8, 3.01, 2648.45 },
	/* 118 terms retained, 72 terms dropped, error 3.9e-07 a.u.*T^2 */

	/* jupiter r, T^3 */
	{ 3519.3, 6.05801, 529.69097 },
	{ 1073.2, 1.67321, 536.80451 },
	{ 915.7, 1.4133, 522.5774 },
	{ 341.6, 0.5230, 1059.3819 },
	{ 254.9, 1.1963, 7.1135 },
	{ 221.5, 0.9523, 515.4639 },
	{ 69.1, 2.269, 1066.495 },
	{ 89.7, 3.142, 0 },
	{ 57.8, 1.414, 543.918 },
	{ 57.7, 0.526, 639.897 },
	{ 51.1, 5.980, 412.371 },
	{ 46.9, 1.579, 625.670 },
	{ 42.8, 6.117, 419.485 },
	{ 37.5, 1.183, 14.227 },
	{ 33.8, 1.667, 1052.268 },
	{ 31.2, 1.043, 1589.073 },
	{ 30.0, 4.632, 426.598 },
	{ 33.5, 0.848, 206.186 },
	{ 20.8, 2.501, 728.763 },
	{ 14.5, 0.960, 508.350 },
	{ 13.0, 1.502, 1045.155 },
	{ 11.7, 3.555, 323.505 },
	{ 12.3, 2.610, 735.877 },
	{ 15.0, 0.891, 199.072 },
	{ 11.2, 1.790, 309.278 },
	{ 10.6, 6.278, 956.289 },
	{ 9.8, 6.26, 103.09 },
	{ 9.3, 3.45, 838.97 },
	{ 6.7, 1.87, 302.16 },
	{ 7.4, 1.28, 742.99 },
	{ 7.2, 0.92, 942.06 },
	{ 5.6, 1.38, 95.98 },
	{ 6.8, 3.45, 831.86 },
	{ 4.6, 2.83, 1596.19 },
	{ 4.0, 1.21, 1169.59 },
	{ 3.9, 5.99, 213.30 },
	{ 3.6, 6.11, 405.26 },
	{ 2.9, 2.33, 1155.36 },
	{ 2.4, 1.87, 532.87 },
	{ 2.4, 0.43, 220.41 },
	{ 2.3, 1.95, 1073.61 },
	{ 2.3, 0.09, 632.78 },
	{ 2.2, 1.59, 2118.76 },
	{ 2.4, 5.97, 1162.47 },
	{ 2.1, 1.07, 21.34 },
	{ 2.1, 1.51, 1258.45 },
	{ 2.5, 0.35, 1272.68 },
	{ 2.0, 5.94, 110.21 },
	{ 2.0, 2.55, 88.87 },
	{ 2.0, 2.16, 433.71 },
	{ 2.0, 2.70, 721.65 },
	{ 1.7, 4.46, 853.20 },
	{ 1.9, 2.26, 1361.55 },
	{ 1.7, 1.98, 525.76 },
	{ 1.5, 0.12, 949.18 },
	{ 2.0, 3.17, 1148.25 },
	{ 1.7, 2.71, 330.62 },
	{ 1.6, 0.47, 526.51 },
	{ 1.2, 3.02, 963.40 },
	{ 1.7, 0.44, 533.62 },
	{ 1.2, 1.16, 1574.85 },
	{ 1.1, 2.55, 846.08 },
	{ 1.4, 1.17, 1038.04 },
	{ 1.0, 2.70, 519.40 },
	{ 1.4, 0.67, 551.03 },
	{ 1.0, 4.17, 2627.11 },
	{ 1.1, 1.07, 227.53 },
	{ 0.9, 2.93, 1368.66 },
	{ 0.8, 4.87, 611.44 },
	{ 1.1, 1.79, 1581.96 },
	{ 0.9, 4.91, 1670.83 },
	{ 0.9, 3.69, 824.74 },
	{ 0.8, 3.23, 2125.88 },
	{ 0.8, 2.39, 2317.84 },
	{ 0.9, 0.60, 539.99 },
	{ 0.9, 4.52, 750.10 },
	{ 0.8, 0.21, 1141.13 },
	{ 0.8, 0.94, 191.96 },
	{ 0.8, 2.25, 2538.25 },
	{ 0.7, 0.67, 440.83 },
	{ 0.7, 5.80, 1485.98 },
	{ 0.6, 2.48, 1265.57 },
	{ 0.6, 6.14, 1279.79 },
	{ 0.6, 5.51, 2413.82 },
	{ 0.6, 4.41, 1382.89 },
	{ 0.6, 2.18, 1062.56 },
	{ 0.6, 1.93, 2634.23 },
	{ 0.5, 2.05, 295.05 },
	{ 0.5, 2.32, 1471.75 },
	{ 0.7, 2.27, 1699.28 },
	{ 0.5, 1.96, 1677.94 },
	{ 0.5, 4.36, 1692.17 },
	{ 0.5, 2.50, 2207.63 },
	{ 0.5, 5.77, 1478.87 },
	{ 0.4, 5.99, 934.95 },
	{ 0.4, 2.80, 81.75 },
	{ 0.4, 3.94, 316.39 },
	{ 0.5, 0.19, 10.29 },
	/* 98 terms retained, 0 terms dropped, error 1e-07 a.u.*T^3 */

	/* jupiter r, T^4 */
	{ 128.6, 0.0842, 536.8045 },
	{ 113.5, 4.2486, 529.6910 },
	{ 82.7, 3.298, 522.577 },
	{ 37.9, 2.733, 515.464 },
	{ 26.7, 5.691, 7.114 },
	{ 17.6, 5.400, 1059.382 },
	{ 12.6, 6.016, 543.918 },
	{ 9.3, 0.77, 1066.50 },
	{ 8.1, 5.68, 14.23 },
	{ 6.3, 5.12, 639.90 },
	{ 7.0, 1.43, 412.37 },
	{ 5.4, 3.34, 625.67 },
	{ 2.9, 3.40, 1052.27 },
	{ 2.6, 4.16, 728.76 },
	{ 2.6, 2.90, 426.60 },
	{ 2.3, 6.22, 1589.07 },
	{ 2.1, 3.12, 1045.15 },
	{ 1.7, 2.81, 206.19 },
	{ 1.8, 2.60, 199.07 },
	{ 1.8, 1.89, 419.48 },
	{ 1.5, 1.33, 1596.19 },
	{ 1.7, 0, 0 },
	{ 1.0, 4.42, 956.29 },
	{ 1.2, 5.16, 831.86 },
	{ 0.9, 3.17, 508.35 },
	{ 0.9, 5.79, 1169.59 },
	{ 0.9, 1.87, 1148.25 },
	{ 1.0, 0.67, 1361.55 },
	{ 0.8, 1.48, 1272.68 },
	{ 1.0, 5.47, 220.41 },
	{ 0.8, 2.42, 117.32 },
	{ 0.7, 0.50, 1073.61 },
	{ 0.7, 3.53, 302.16 },
	{ 0.7, 2.85, 191.96 },
	{ 0.8, 2.20, 942.06 },
	{ 0.8, 5.31, 551.03 },
	{ 0.7, 3.72, 88.87 },
	{ 0.5, 1.83, 647.01 },
	{ 0.6, 0.86, 330.62 },
	{ 0.5, 5.26, 21.34 },
	{ 0.6, 3.82, 618.56 },
	{ 0.5, 4.44, 110.21 },
	{ 0.6, 1.59, 3.18 },
	{ 0.6, 1.84, 10.29 },
	{ 0.5, 1.53, 405.26 },
	{ 0.5, 0.24, 433.71 },
	/* 46 terms retained, 0 terms dropped, error 7.1e-08 a.u.*T^4 */

	/* jupiter r, T^5 */
	{ 11.2, 4.752, 536.805 },
	{ 4.3, 5.92, 522.58 },
	{ 2.1, 5.57, 515.46 },
	{ 1.9, 4.30, 543.92 },
	{ 1.9, 3.69, 7.11 },
	{ 1.6, 5.49, 1066.50 },
	{ 1.6, 4.13, 1059.38 },
	{ 1.2, 3.78, 14.23 },
	{ 1.0, 4.51, 529.69 },
	/* 9 terms retained, 0 terms dropped, error 6.5e-08 a.u.*T^5 */
	/* end jupiter */
};

int vn_jupiter[][3] = {
	/* addresses for jupiter l, b, r  */
	/* T^0 */ { 0, 392, 542, },
	/* T^1 */ { 109, 428, 672, },
	/* T^2 */ { 194, 468, 785, },
	/* T^3 */ { 271, 504, 903, },
	/* T^4 */ { 341, 526, 1001, },
	/* T^5 */ { 383, 538, 1047, },
	/* end */ { 392, 542, 1056, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_mars[][3] = {
	/* mars l, T^0 */
	{ 620347711.6, 0, 0 },
	{ 18656368.1, 5.050371003, 3340.612426700 },
	{ 1108216.8, 5.40099837, 6681.22485340 },
	{ 91798.4, 5.754787, 10021.837280 },
	{ 27745.0, 5.970495, 3.523118 },
	{ 10610.2, 2.939585, 2281.230497 },
	{ 12315.9, 0.849561, 2810.921462 },
	{ 8926.8, 4.15698, 0.01725 },
	{ 8715.7, 6.11005, 13362.44971 },
	{ 6797.6, 0.36462, 398.14900 },
	{ 7774.9, 3.33969, 5621.84292 },
	{ 3575.1, 1.66187, 2544.31442 },
	{ 4161.1, 0.22815, 2942.46342 },
	{ 3075.2, 0.85697, 191.44827 },
	{ 2628.1, 0.64806, 3337.08931 },
	{ 2937.5, 6.07894, 0.06731 },
	{ 2389.4, 5.03896, 796.29801 },
	{ 2579.8, 0.02997, 3344.13555 },
	{ 1528.1, 1.14979, 6151.53389 },
	{ 1798.8, 0.65634, 529.69097 },
	{ 1264.4, 3.62275, 5092.15196 },
	{ 1286.2, 3.06796, 2146.16542 },
	{ 1546.4, 2.91580, 1751.53953 },
	{ 1024.9, 3.69334, 8962.45535 },
	{ 891.6, 0.1829, 16703.0621 },
	{ 858.8, 2.4009, 2914.0142 },
	{ 832.7, 2.4642, 3340.5952 },
	{ 832.7, 4.4950, 3340.6297 },
	{ 712.9, 3.6634, 1059.3819 },
	{ 748.7, 3.8225, 155.4204 },
	{ 723.9, 0.6750, 3738.7614 },
	{ 635.6, 2.9218, 8432.7644 },
	{ 655.2, 0.4886, 3127.3133 },
	{ 550.5, 3.8100, 0.9803 },
	{ 552.7, 4.4748, 1748.0164 },
	{ 426.0, 0.5537, 6283.0758 },
	{ 415.1, 0.4966, 213.2991 },
	{ 472.2, 3.6255, 1194.4470 },
	{ 306.6, 0.3805, 6684.7480 },
	{ 312.1, 0.9985, 6677.7017 },
	{ 293.2, 4.2213, 20.7754 },
	{ 302.4, 4.4862, 3532.0607 },
	{ 274.0, 0.5422, 3340.5451 },
	{ 281.1, 5.8816, 1349.8674 },
	{ 231.2, 1.2824, 3870.3034 },
	{ 283.6, 5.7689, 3149.1642 },
	{ 236.1, 5.7550, 3333.4989 },
	{ 274.0, 0.1337, 3340.6797 },
	{ 299.4, 2.7832, 6254.6267 },
	{ 204.2, 2.8213, 1221.8486 },
	{ 238.9, 5.3716, 4136.9104 },
	{ 188.6, 1.4910, 9492.1463 },
	{ 221.2, 3.5047, 382.8965 },
	{ 179.2, 1.0056, 951.7184 },
	{ 172.1, 0.4394, 5486.7778 },
	{ 193.1, 3.3572, 3.5904 },
	{ 144.3, 1.4187, 135.0651 },
	{ 160.0, 3.9485, 4562.4610 },
	{ 174.1, 2.4136, 553.5694 },
	{ 131.0, 4.0449, 12303.0678 },
	{ 138.2, 4.3015, 7.1135 },
	{ 128.1, 1.8067, 5088.6288 },
	{ 139.9, 3.3259, 2700.7151 },
	{ 128.1, 2.2081, 1592.5960 },
	{ 116.9, 3.1281, 7903.0734 },
	{ 110.4, 1.0520, 242.7286 },
	{ 113.5, 3.7007, 1589.0729 },
	{ 100.1, 3.2434, 11773.3768 },
	{ 95.6, 0.540, 20043.675 },
	{ 98.9, 4.846, 6681.242 },
	{ 104.5, 0.7854, 8827.3903 },
	{ 84.2, 3.990, 4399.994 },
	{ 86.9, 2.202, 11243.686 },
	{ 71.4, 2.803, 3185.192 },
	{ 72.1, 5.847, 5884.927 },
	{ 73.5, 2.184, 8429.241 },
	{ 98.9, 2.815, 6681.208 },
	{ 68.4, 2.738, 2288.344 },
	{ 86.8, 1.021, 7079.374 },
	{ 65.3, 2.681, 28.449 },
	{ 83.7, 3.203, 4690.480 },
	{ 75.0, 0.766, 6467.926 },
	{ 69.0, 3.764, 6041.328 },
	{ 66.7, 0.736, 3723.509 },
	{ 63.3, 4.528, 426.598 },
	{ 61.7, 6.168, 2274.117 },
	{ 52.3, 0.899, 9623.688 },
	{ 55.5, 4.606, 4292.331 },
	{ 51.3, 4.148, 3341.593 },
	{ 56.6, 5.063, 15.252 },
	{ 63.4, 0.913, 3553.912 },
	{ 45.8, 0.788, 1990.745 },
	{ 48.5, 3.957, 4535.059 },
	{ 41.2, 6.020, 3894.182 },
	{ 41.9, 3.583, 8031.092 },
	{ 56.4, 1.687, 6872.673 },
	{ 55.9, 3.463, 263.084 },
	{ 51.7, 2.813, 3339.632 },
	{ 40.7, 3.138, 9595.239 },
	{ 38.1, 0.734, 10025.360 },
	{ 39.5, 5.632, 3097.884 },
	{ 44.2, 3.195, 5628.956 },
	{ 36.7, 2.637, 692.158 },
	{ 45.9, 0.287, 5614.729 },
	{ 38.4, 5.829, 3191.049 },
	{ 38.2, 2.348, 162.467 },
	{ 32.6, 0.484, 6681.292 },
	{ 37.1, 0.685, 2818.035 },
	{ 31.2, 3.982, 20.355 },
	{ 32.6, 0.893, 6681.158 },
	{ 37.8, 4.155, 2803.808 },
	{ 33.6, 6.120, 6489.777 },
	{ 29.0, 2.427, 3319.837 },
	{ 38.8, 1.352, 10018.314 },
	{ 33.1, 1.140, 5.523 },
	{ 27.6, 1.597, 7210.916 },
	{ 28.7, 5.721, 7477.523 },
	{ 34.0, 2.595, 11769.854 },
	{ 25.4, 0.521, 10.637 },
	{ 26.4, 1.345, 3496.033 },
	{ 25.6, 0.250, 522.577 },
	{ 27.3, 4.556, 3361.388 },
	{ 27.5, 6.084, 6674.111 },
	{ 25.5, 3.432, 3443.705 },
	/* 124 terms retained, 1093 terms dropped, error 1.2" */

	/* mars l, T^1 */
	{ 334085627474.3, 0, 0 },
	{ 1458227.1, 3.60426054, 3340.61242670 },
	{ 164901.3, 3.9263125, 6681.2248534 },
	{ 19963.3, 4.265941, 10021.837280 },
	{ 3452.4, 4.73210, 3.52312 },
	{ 2485.5, 4.61278, 13362.44971 },
	{ 841.6, 4.4586, 2281.2305 },
	{ 537.6, 5.0159, 398.1490 },
	{ 521.0, 4.9942, 3344.1355 },
	{ 432.6, 2.5607, 191.4483 },
	{ 429.7, 5.3165, 155.4204 },
	{ 381.7, 3.5388, 796.2980 },
	{ 314.1, 4.9634, 16703.0621 },
	{ 282.8, 3.1597, 2544.3144 },
	{ 205.7, 4.5689, 2146.1654 },
	{ 168.8, 1.3289, 3337.0893 },
	{ 157.6, 4.1850, 1751.5395 },
	{ 133.7, 2.2333, 0.9803 },
	{ 116.6, 2.2135, 1059.3819 },
	{ 117.6, 6.0241, 6151.5339 },
	{ 113.6, 5.4280, 3738.7614 },
	{ 133.6, 5.9742, 1748.0164 },
	{ 91.1, 1.096, 1349.867 },
	{ 83.3, 5.296, 6684.748 },
	{ 113.9, 2.1287, 1194.4470 },
	{ 80.8, 4.428, 529.691 },
	{ 79.5, 2.249, 8962.455 },
	{ 72.5, 5.842, 242.729 },
	{ 72.9, 2.502, 951.718 },
	{ 71.5, 3.856, 2914.014 },
	{ 85.3, 3.909, 553.569 },
	{ 67.6, 5.023, 382.897 },
	{ 65.1, 1.018, 3340.595 },
	{ 65.1, 3.049, 3340.630 },
	{ 61.5, 4.152, 3149.164 },
	{ 48.5, 4.874, 213.299 },
	{ 46.6, 1.315, 3185.192 },
	{ 56.5, 3.888, 4136.910 },
	{ 47.6, 1.182, 3333.499 },
	{ 41.3, 0.714, 1592.596 },
	{ 40.1, 5.316, 20043.675 },
	{ 40.3, 2.725, 7.114 },
	{ 32.9, 5.411, 6283.076 },
	{ 28.2, 0.045, 9492.146 },
	{ 22.3, 5.885, 3870.303 },
	{ 22.4, 5.466, 20.355 },
	{ 22.6, 0.838, 3097.884 },
	{ 21.4, 5.379, 3340.545 },
	{ 23.3, 6.168, 3532.061 },
	{ 26.6, 3.890, 1221.849 },
	{ 22.8, 1.545, 2274.117 },
	{ 20.4, 2.364, 1589.073 },
	{ 20.2, 3.364, 5088.629 },
	{ 26.6, 5.113, 2700.715 },
	{ 19.7, 2.578, 12303.068 },
	{ 19.5, 0.492, 6677.702 },
	{ 21.1, 3.525, 15.252 },
	{ 21.4, 4.971, 3340.680 },
	{ 18.5, 5.579, 1990.745 },
	{ 17.8, 6.125, 4292.331 },
	{ 16.5, 2.603, 3341.593 },
	{ 16.6, 1.255, 3894.182 },
	{ 19.5, 2.531, 4399.994 },
	{ 15.0, 1.035, 2288.344 },
	{ 20.0, 4.731, 4690.480 },
	{ 15.4, 2.470, 4535.059 },
	{ 20.0, 5.787, 7079.374 },
	{ 15.3, 2.265, 3723.509 },
	{ 14.7, 3.370, 6681.242 },
	{ 13.5, 2.123, 5486.778 },
	{ 12.9, 5.619, 10025.360 },
	{ 12.7, 2.950, 3496.033 },
	{ 13.6, 1.977, 5614.729 },
	{ 13.0, 1.514, 5628.956 },
	{ 14.7, 1.339, 6681.208 },
	{ 11.4, 6.234, 135.065 },
	{ 13.3, 3.422, 5621.843 },
	{ 10.9, 5.282, 2818.035 },
	{ 11.8, 3.127, 426.598 },
	{ 10.5, 2.736, 2787.043 },
	{ 11.1, 5.842, 2803.808 },
	{ 11.8, 2.586, 8432.764 },
	{ 11.9, 5.476, 3553.912 },
	{ 8.5, 1.91, 11773.38 },
	{ 9.7, 4.53, 6489.78 },
	{ 8.6, 3.16, 162.47 },
	{ 11.0, 4.158, 2388.894 },
	{ 8.1, 1.61, 2957.72 },
	{ 8.8, 4.23, 7477.52 },
	{ 8.0, 5.70, 6041.33 },
	{ 8.3, 2.18, 23.88 },
	{ 7.7, 5.72, 9623.69 },
	{ 8.7, 4.44, 5092.15 },
	{ 8.4, 3.16, 3347.73 },
	{ 6.7, 5.08, 8031.09 },
	{ 8.7, 4.33, 3339.63 },
	{ 7.4, 6.18, 3583.34 },
	{ 6.4, 2.12, 5884.93 },
	/* 98 terms retained, 588 terms dropped, error 0.26"*T */

	/* mars l, T^2 */
	{ 58015.8, 2.049795, 3340.612427 },
	{ 54187.6, 0, 0 },
	{ 13908.4, 2.457424, 6681.224853 },
	{ 2465.1, 2.80000, 10021.83728 },
	{ 398.4, 3.1412, 13362.4497 },
	{ 222.0, 3.1944, 3.5231 },
	{ 121.0, 0.5433, 155.4204 },
	{ 61.5, 3.485, 16703.062 },
	{ 53.6, 3.542, 3344.136 },
	{ 34.3, 6.002, 2281.230 },
	{ 31.7, 4.140, 191.448 },
	{ 29.8, 1.999, 796.298 },
	{ 23.2, 4.334, 242.729 },
	{ 21.7, 3.445, 398.149 },
	{ 16.0, 6.110, 2146.165 },
	{ 20.4, 5.422, 553.569 },
	{ 14.9, 6.095, 3185.192 },
	{ 16.2, 0.657, 0.980 },
	{ 14.3, 2.619, 1349.867 },
	{ 14.4, 4.019, 951.718 },
	{ 11.9, 3.861, 6684.748 },
	{ 15.6, 1.221, 1748.016 },
	{ 11.3, 4.718, 2544.314 },
	{ 13.4, 0.602, 1194.447 },
	{ 10.4, 0.250, 382.897 },
	{ 9.5, 0.68, 1059.38 },
	{ 9.2, 3.83, 20043.67 },
	{ 9.0, 3.88, 3738.76 },
	{ 7.5, 5.46, 1751.54 },
	{ 6.5, 5.48, 1592.60 },
	{ 6.3, 2.34, 3097.88 },
	{ 6.9, 2.58, 3149.16 },
	{ 5.9, 1.15, 7.11 },
	{ 6.7, 2.38, 4136.91 },
	{ 4.6, 4.43, 6151.53 },
	{ 4.2, 3.69, 5614.73 },
	{ 4.8, 2.90, 3333.50 },
	{ 4.0, 6.12, 5628.96 },
	{ 3.7, 4.07, 1990.75 },
	{ 3.6, 2.47, 529.69 },
	{ 3.3, 0.68, 8962.46 },
	{ 3.3, 2.80, 3894.18 },
	{ 3.1, 4.57, 3496.03 },
	{ 2.9, 5.41, 2914.01 },
	{ 2.9, 1.23, 2787.04 },
	{ 2.8, 1.39, 4292.33 },
	{ 2.6, 1.04, 3341.59 },
	{ 2.9, 3.41, 3337.09 },
	{ 2.4, 0.96, 4535.06 },
	{ 2.4, 4.85, 9492.15 },
	{ 2.6, 5.75, 3340.60 },
	{ 2.2, 3.26, 213.30 },
	{ 2.6, 1.50, 3340.63 },
	{ 2.3, 4.18, 10025.36 },
	{ 2.6, 4.68, 3583.34 },
	{ 2.6, 2.65, 2388.89 },
	{ 1.8, 0.97, 1589.07 },
	{ 2.4, 1.05, 4399.99 },
	{ 2.4, 4.27, 7079.37 },
	{ 2.2, 0.16, 6525.80 },
	{ 2.3, 0.01, 4690.48 },
	{ 1.6, 4.96, 5088.63 },
	{ 1.6, 1.11, 12303.07 },
	{ 2.1, 0.48, 2700.72 },
	{ 1.6, 4.94, 1221.85 },
	{ 1.8, 3.81, 3723.51 },
	{ 1.8, 2.52, 2810.92 },
	/* 67 terms retained, 243 terms dropped, error 0.06"*T^2 */

	/* mars l, T^3 */
	{ 1482.4, 0.44435, 3340.61243 },
	{ 662.1, 0.8847, 6681.2249 },
	{ 188.3, 1.2880, 10021.8373 },
	{ 41.5, 1.649, 13362.450 },
	{ 22.7, 2.053, 155.420 },
	{ 26.0, 0, 0 },
	{ 8.0, 2.00, 16703.06 },
	{ 10.5, 1.580, 3.523 },
	{ 4.9, 2.82, 242.73 },
	{ 3.8, 2.02, 3344.14 },
	{ 3.2, 4.59, 3185.19 },
	{ 3.1, 0.65, 553.57 },
	{ 1.7, 5.54, 951.72 },
	{ 1.5, 5.72, 191.45 },
	{ 1.4, 0.46, 796.30 },
	{ 1.4, 2.34, 20043.67 },
	{ 1.3, 5.36, 0.98 },
	{ 1.2, 4.15, 1349.87 },
	{ 1.1, 2.38, 6684.75 },
	{ 1.0, 1.77, 382.90 },
	{ 0.9, 5.34, 1194.45 },
	{ 0.8, 2.75, 1748.02 },
	{ 0.6, 6.11, 3496.03 },
	{ 0.6, 1.85, 398.15 },
	{ 0.6, 5.86, 7.11 },
	{ 0.6, 3.18, 3583.34 },
	{ 0.5, 5.98, 2787.04 },
	{ 0.5, 1.01, 3149.16 },
	{ 0.5, 4.93, 6525.80 },
	{ 0.4, 1.27, 2281.23 },
	{ 0.4, 2.33, 3738.76 },
	{ 0.5, 0.84, 4136.91 },
	/* 32 terms retained, 97 terms dropped, error 0.011"*T^3 */

	/* mars l, T^4 */
	{ 114.0, 3.1416, 0 },
	{ 28.7, 5.637, 6681.225 },
	{ 24.4, 5.139, 3340.612 },
	{ 11.2, 6.032, 10021.837 },
	{ 3.2, 3.56, 155.42 },
	{ 3.3, 0.13, 13362.45 },
	{ 0.8, 0.49, 16703.06 },
	{ 0.8, 1.32, 242.73 },
	{ 0.5, 3.06, 3185.19 },
	{ 0.4, 2.16, 553.57 },
	{ 0.3, 6.23, 3.52 },
	{ 0.2, 0.44, 3344.14 },
	{ 0.2, 0.82, 20043.67 },
	{ 0.2, 3.74, 3496.03 },
	{ 0.1, 1.67, 3583.34 },
	/* 15 terms retained, 21 terms dropped, error 0.0019"*T^4 */

	/* mars l, T^5 */
	{ 0.7, 4.04, 6681.22 },
	{ 0.9, 3.14, 0 },
	{ 0.5, 4.49, 10021.84 },
	{ 0.4, 5.07, 155.42 },
	{ 0.2, 3.51, 3340.61 },
	{ 0.2, 4.85, 13362.45 },
	{ 0.1, 6.09, 242.73 },
	/* 7 terms retained, 8 terms dropped, error 0.0012"*T^5 */
	/* end mars l */

	/* mars b, T^0 */
	{ 3197135.0, 3.76832042, 3340.61242670 },
	{ 298033.2, 4.1061700, 6681.2248534 },
	{ 289104.7, 0, 0 },
	{ 31365.5, 4.446511, 10021.837280 },
	{ 3484.1, 4.78813, 13362.44971 },
	{ 443.0, 5.6523, 3337.0893 },
	{ 443.4, 5.0264, 3344.1355 },
	{ 399.1, 5.1306, 16703.0621 },
	{ 292.5, 3.7929, 2281.2305 },
	{ 182.0, 6.1365, 6151.5339 },
	{ 163.2, 4.2640, 529.6910 },
	{ 159.7, 2.2319, 1059.3819 },
	{ 139.3, 2.4180, 8962.4553 },
	{ 149.3, 2.1650, 5621.8429 },
	{ 142.7, 1.1822, 3340.5952 },
	{ 142.7, 3.2129, 3340.6297 },
	{ 82.5, 5.367, 6684.748 },
	{ 73.6, 5.092, 398.149 },
	{ 72.7, 5.538, 6283.076 },
	{ 86.4, 5.744, 3738.761 },
	{ 83.3, 5.989, 6677.702 },
	{ 60.1, 3.680, 796.298 },
	{ 63.1, 0.730, 5884.927 },
	{ 62.3, 4.851, 2942.463 },
	{ 47.0, 5.543, 3340.545 },
	{ 47.0, 5.135, 3340.680 },
	{ 46.6, 5.474, 20043.675 },
	{ 45.6, 2.133, 2810.921 },
	{ 41.3, 0.200, 9492.146 },
	{ 47.2, 4.522, 3149.164 },
	{ 38.5, 4.080, 4136.910 },
	{ 33.1, 4.066, 1751.540 },
	{ 29.7, 5.922, 3532.061 },
	{ 32.7, 2.621, 2914.014 },
	{ 29.5, 2.753, 12303.068 },
	{ 28.2, 2.063, 5486.778 },
	{ 28.6, 4.947, 3870.303 },
	{ 26.6, 3.551, 6681.242 },
	{ 26.6, 1.520, 6681.208 },
	{ 26.1, 2.601, 4399.994 },
	/* 40 terms retained, 401 terms dropped, error 0.69" */

	/* mars b, T^1 */
	{ 350068.8, 5.3684784, 3340.6124267 },
	{ 14116.0, 3.141593, 0 },
	{ 9670.8, 5.47878, 6681.22485 },
	{ 1471.9, 3.20206, 10021.83728 },
	{ 425.9, 3.4084, 13362.4497 },
	{ 102.0, 0.7762, 3337.0893 },
	{ 78.8, 3.718, 16703.062 },
	{ 26.2, 2.483, 2281.230 },
	{ 32.7, 3.458, 5621.843 },
	{ 20.7, 1.441, 6151.534 },
	{ 18.3, 6.031, 529.691 },
	{ 15.7, 3.931, 8962.455 },
	{ 17.0, 4.811, 3344.136 },
	{ 13.1, 0.973, 6677.702 },
	{ 15.6, 2.782, 3340.595 },
	{ 15.6, 4.813, 3340.630 },
	{ 13.8, 1.680, 3532.061 },
	{ 12.7, 4.045, 20043.675 },
	{ 14.3, 0.246, 2942.463 },
	{ 12.5, 2.256, 5884.927 },
	{ 8.8, 0.34, 398.15 },
	{ 8.6, 1.75, 2544.31 },
	{ 8.9, 5.95, 2810.92 },
	{ 8.1, 0.84, 6283.08 },
	{ 9.2, 4.35, 3496.03 },
	{ 8.1, 4.30, 6684.75 },
	/* 26 terms retained, 261 terms dropped, error 0.17"*T */

	/* mars b, T^2 */
	{ 16726.7, 0.602214, 3340.612427 },
	{ 4986.8, 3.14159, 0 },
	{ 302.1, 5.5587, 6681.2249 },
	{ 25.8, 1.897, 13362.450 },
	{ 21.5, 0.917, 10021.837 },
	{ 11.8, 2.242, 3337.089 },
	{ 8.0, 2.25, 16703.06 },
	{ 3.0, 5.89, 3496.03 },
	{ 2.4, 5.19, 5621.84 },
	{ 1.8, 2.59, 20043.67 },
	/* 10 terms retained, 120 terms dropped, error 0.024"*T^2 */

	/* mars b, T^3 */
	{ 606.5, 1.9805, 3340.6124 },
	{ 42.6, 0, 0 },
	{ 13.7, 1.796, 6681.225 },
	{ 2.7, 3.45, 10021.84 },
	{ 0.9, 3.75, 3337.09 },
	{ 0.6, 0.11, 13362.45 },
	{ 0.6, 1.14, 3496.03 },
	{ 0.5, 0.71, 16703.06 },
	/* 8 terms retained, 33 terms dropped, error 0.0059"*T^3 */

	/* mars b, T^4 */
	{ 11.3, 3.457, 3340.612 },
	{ 13.4, 0, 0 },
	{ 0.7, 0.50, 6681.22 },
	{ 0.1, 1.05, 10021.84 },
	{ 0.1, 2.66, 3496.03 },
	/* 5 terms retained, 6 terms dropped, error 0.001"*T^4 */

	/* mars b, T^5 */
	{ 0.5, 4.87, 3340.61 },
	/* 1 terms retained, 4 terms dropped, error 0.0027"*T^5 */
	/* end mars b */

	/* mars r, T^0 */
	{ 153033488.3, 0, 0 },
	{ 14184953.2, 3.479712835, 3340.612426700 },
	{ 660776.4, 3.8178344, 6681.2248534 },
	{ 46179.1, 4.155953, 10021.837280 },
	{ 8109.7, 5.55958, 2810.92146 },
	{ 7485.3, 1.77239, 5621.84292 },
	{ 5523.2, 1.36436, 2281.23050 },
	{ 3825.2, 4.49407, 13362.44971 },
	{ 2306.5, 0.09082, 2544.31442 },
	{ 1999.4, 5.36060, 3337.08931 },
	{ 2484.4, 4.92546, 2942.46342 },
	{ 1960.2, 4.74249, 3344.13555 },
	{ 1167.1, 2.11262, 5092.15196 },
	{ 1102.8, 5.00908, 398.14900 },
	{ 899.1, 4.4079, 529.6910 },
	{ 992.3, 5.8386, 6151.5339 },
	{ 807.3, 2.1022, 1059.3819 },
	{ 797.9, 3.4484, 796.2980 },
	{ 741.0, 1.4991, 2146.1654 },
	{ 692.3, 2.1338, 8962.4553 },
	{ 633.1, 0.8935, 3340.5952 },
	{ 725.6, 1.2452, 8432.7644 },
	{ 633.1, 2.9243, 3340.6297 },
	{ 574.4, 0.8290, 2914.0142 },
	{ 526.2, 5.3829, 3738.7614 },
	{ 630.0, 1.2874, 1751.5395 },
	{ 472.8, 5.1985, 3127.3133 },
	{ 348.1, 4.8322, 16703.0621 },
	{ 283.7, 2.9069, 3532.0607 },
	{ 279.6, 5.2575, 6283.0758 },
	{ 233.8, 5.1055, 5486.7778 },
	{ 219.4, 5.5834, 191.4483 },
	{ 269.9, 3.7639, 5884.9268 },
	{ 208.3, 5.2548, 3340.5451 },
	{ 275.2, 2.9082, 1748.0164 },
	{ 275.5, 1.2177, 6254.6267 },
	{ 239.1, 2.0367, 1194.4470 },
	{ 223.2, 4.1986, 3149.1642 },
	{ 182.7, 5.0806, 6684.7480 },
	{ 186.2, 5.6987, 6677.7017 },
	{ 176.0, 5.9534, 3870.3034 },
	{ 178.6, 4.1842, 3333.4989 },
	{ 208.3, 4.8463, 3340.6797 },
	{ 228.1, 3.2553, 6872.6731 },
	{ 144.3, 0.2130, 5088.6288 },
	{ 163.5, 3.7989, 4136.9104 },
	{ 133.1, 1.5391, 7903.0734 },
	{ 141.8, 2.4779, 4562.4610 },
	{ 114.9, 4.3175, 1349.8674 },
	{ 118.8, 2.1218, 1589.0729 },
	{ 102.1, 6.1814, 9492.1463 },
	{ 128.6, 5.4988, 8827.3903 },
	{ 111.5, 0.5534, 11243.6858 },
	{ 82.5, 1.622, 11773.377 },
	{ 83.2, 0.616, 8429.241 },
	{ 84.5, 0.623, 1592.596 },
	{ 86.7, 1.750, 2700.715 },
	{ 71.8, 2.475, 12303.068 },
	{ 85.3, 1.616, 4690.480 },
	{ 63.6, 2.673, 426.598 },
	{ 68.6, 2.402, 4399.994 },
	{ 58.6, 4.721, 213.299 },
	{ 62.0, 1.101, 1221.849 },
	{ 66.5, 2.213, 6041.328 },
	{ 55.8, 1.233, 3185.192 },
	{ 55.0, 5.727, 951.718 },
	{ 52.4, 3.024, 4292.331 },
	{ 55.7, 5.447, 3723.509 },
	{ 59.0, 3.262, 6681.242 },
	{ 44.6, 2.015, 8031.092 },
	{ 59.0, 1.232, 6681.208 },
	{ 42.4, 2.266, 155.420 },
	{ 39.0, 2.578, 3341.593 },
	{ 51.6, 5.723, 7079.374 },
	{ 48.9, 5.616, 3553.912 },
	{ 45.4, 5.433, 6467.926 },
	{ 36.4, 4.439, 3894.182 },
	{ 36.0, 1.160, 2288.344 },
	{ 35.3, 5.490, 1990.745 },
	{ 42.2, 1.633, 5628.956 },
	{ 44.3, 5.003, 5614.729 },
	{ 33.6, 5.170, 20043.675 },
	{ 43.3, 1.037, 11769.854 },
	{ 39.2, 1.242, 3339.632 },
	{ 31.9, 4.593, 2274.117 },
	{ 30.3, 2.442, 11371.705 },
	{ 32.3, 2.382, 4535.059 },
	{ 31.9, 4.375, 3.523 },
	{ 29.3, 4.060, 3097.884 },
	{ 32.0, 1.940, 382.897 },
	{ 26.2, 5.585, 9623.688 },
	{ 27.9, 4.258, 3191.049 },
	{ 33.1, 0.855, 553.569 },
	{ 27.5, 1.577, 9595.239 },
	{ 25.2, 0.814, 10713.995 },
	/* 95 terms retained, 1023 terms dropped, error 4.9e-06 a.u. */

	/* mars r, T^1 */
	{ 1107433.3, 2.03250525, 3340.61242670 },
	{ 103175.9, 2.3707185, 6681.2248534 },
	{ 12877.2, 0, 0 },
	{ 10815.9, 2.708881, 10021.837280 },
	{ 1194.5, 3.04702, 13362.44971 },
	{ 438.6, 2.8884, 2281.2305 },
	{ 395.7, 3.4232, 3344.1355 },
	{ 182.6, 1.5843, 2544.3144 },
	{ 135.8, 3.3851, 16703.0621 },
	{ 128.2, 0.6299, 1059.3819 },
	{ 127.1, 1.9539, 796.2980 },
	{ 118.4, 2.9976, 2146.1654 },
	{ 128.4, 6.0434, 3337.0893 },
	{ 87.5, 3.421, 398.149 },
	{ 83.0, 3.856, 3738.761 },
	{ 75.6, 4.451, 6151.534 },
	{ 72.0, 2.764, 529.691 },
	{ 66.5, 2.549, 1751.540 },
	{ 54.3, 0.678, 8962.455 },
	{ 51.0, 3.726, 6684.748 },
	{ 66.4, 4.406, 1748.016 },
	{ 47.9, 2.285, 2914.014 },
	{ 49.4, 5.730, 3340.595 },
	{ 49.4, 1.477, 3340.630 },
	{ 57.5, 0.544, 1194.447 },
	{ 48.3, 2.581, 3149.164 },
	{ 36.4, 6.027, 3185.192 },
	{ 37.2, 5.814, 1349.867 },
	{ 36.0, 5.895, 3333.499 },
	{ 31.1, 0.978, 191.448 },
	{ 39.0, 2.319, 4136.910 },
	{ 27.2, 5.414, 1592.596 },
	{ 24.3, 3.758, 155.420 },
	{ 22.8, 1.748, 5088.629 },
	{ 22.3, 0.939, 951.718 },
	{ 21.7, 3.836, 6283.076 },
	{ 21.3, 0.780, 1589.073 },
	{ 21.6, 4.569, 3532.061 },
	{ 18.0, 4.219, 3870.303 },
	{ 18.2, 0.413, 5486.778 },
	{ 16.3, 3.808, 3340.545 },
	{ 16.8, 5.549, 3097.884 },
	{ 16.9, 4.537, 4292.331 },
	{ 15.8, 4.757, 9492.146 },
	{ 15.7, 3.724, 20043.675 },
	{ 20.4, 3.135, 4690.480 },
	{ 14.7, 5.953, 3894.182 },
	{ 16.3, 3.399, 3340.680 },
	{ 14.3, 3.999, 1990.745 },
	{ 16.5, 0.968, 4399.994 },
	{ 13.0, 5.142, 6677.702 },
	{ 12.5, 1.032, 3341.593 },
	{ 16.5, 3.539, 2700.715 },
	{ 16.2, 2.349, 553.569 },
	{ 13.2, 0.415, 5614.729 },
	{ 11.3, 1.024, 12303.068 },
	{ 12.4, 6.231, 5628.956 },
	{ 12.7, 0.690, 3723.509 },
	{ 11.8, 6.253, 2274.117 },
	{ 10.4, 1.233, 426.598 },
	{ 11.2, 1.318, 3496.033 },
	{ 10.3, 0.901, 4535.059 },
	{ 12.2, 4.223, 7079.374 },
	{ 9.8, 3.45, 382.90 },
	{ 8.6, 1.16, 2787.04 },
	{ 7.9, 5.74, 2288.34 },
	{ 9.2, 1.82, 6681.24 },
	{ 7.8, 4.15, 6041.33 },
	{ 9.2, 6.07, 6681.21 },
	{ 9.0, 2.58, 2388.89 },
	{ 6.8, 0.24, 11773.38 },
	{ 7.1, 3.51, 8031.09 },
	{ 9.2, 3.90, 3553.91 },
	{ 6.7, 4.26, 242.73 },
	{ 7.2, 3.70, 2818.04 },
	{ 6.5, 0.04, 2957.72 },
	{ 8.8, 2.20, 1221.85 },
	{ 6.5, 2.12, 8429.24 },
	{ 6.8, 4.05, 10025.36 },
	{ 7.3, 4.27, 2803.81 },
	{ 7.7, 1.01, 8432.76 },
	{ 6.3, 1.90, 5621.84 },
	{ 6.3, 1.60, 3347.73 },
	{ 6.5, 2.76, 3339.63 },
	/* 84 terms retained, 512 terms dropped, error 1.2e-06 a.u.*T */

	/* mars r, T^2 */
	{ 44242.2, 0.479306, 3340.612427 },
	{ 8138.0, 0.86998, 6681.22485 },
	{ 1274.9, 1.22594, 10021.83728 },
	{ 187.4, 1.5730, 13362.4497 },
	{ 40.7, 1.971, 3344.136 },
	{ 52.4, 3.142, 0 },
	{ 26.6, 1.917, 16703.062 },
	{ 17.8, 4.435, 2281.230 },
	{ 11.7, 4.525, 3185.192 },
	{ 10.2, 5.391, 1059.382 },
	{ 9.9, 0.42, 796.30 },
	{ 9.2, 4.54, 2146.17 },
	{ 7.3, 3.14, 2544.31 },
	{ 7.2, 2.29, 6684.75 },
	{ 6.8, 5.27, 155.42 },
	{ 6.5, 2.31, 3738.76 },
	{ 7.8, 5.93, 1748.02 },
	{ 5.8, 1.05, 1349.87 },
	{ 6.7, 5.30, 1194.45 },
	{ 4.7, 0.77, 3097.88 },
	{ 5.4, 1.00, 3149.16 },
	{ 4.4, 2.46, 951.72 },
	{ 4.3, 3.90, 1592.60 },
	{ 3.5, 1.85, 398.15 },
	{ 3.7, 2.26, 20043.67 },
	{ 3.4, 3.82, 1751.54 },
	{ 4.6, 0.81, 4136.91 },
	{ 3.2, 2.12, 5614.73 },
	{ 3.6, 1.32, 3333.50 },
	{ 2.9, 1.19, 529.69 },
	{ 3.0, 2.86, 6151.53 },
	{ 3.1, 4.55, 5628.96 },
	{ 2.9, 1.20, 3894.18 },
	{ 3.9, 3.86, 553.57 },
	{ 2.8, 2.49, 1990.75 },
	{ 2.7, 6.07, 4292.33 },
	{ 2.7, 2.92, 3496.03 },
	{ 2.4, 5.94, 2787.04 },
	{ 2.3, 2.56, 191.45 },
	{ 2.2, 5.37, 8962.46 },
	{ 2.1, 2.75, 242.73 },
	{ 2.2, 1.85, 3337.09 },
	{ 2.0, 5.76, 3341.59 },
	{ 2.0, 3.82, 2914.01 },
	{ 1.8, 5.69, 1589.07 },
	{ 1.8, 3.32, 5088.63 },
	{ 2.4, 4.68, 4690.48 },
	{ 2.0, 4.17, 3340.60 },
	{ 2.0, 6.21, 3340.63 },
	{ 1.6, 5.68, 4535.06 },
	{ 2.2, 1.07, 2388.89 },
	{ 2.0, 3.11, 3583.34 },
	{ 2.0, 5.76, 4399.99 },
	/* 53 terms retained, 260 terms dropped, error 2.9e-07 a.u.*T^2 */

	/* mars r, T^3 */
	{ 1113.1, 5.14987, 3340.61243 },
	{ 424.4, 5.6134, 6681.2249 },
	{ 100.0, 5.9973, 10021.8373 },
	{ 19.6, 0.076, 13362.450 },
	{ 3.5, 0.43, 16703.06 },
	{ 4.7, 3.14, 0 },
	{ 2.9, 0.45, 3344.14 },
	{ 2.4, 3.02, 3185.19 },
	{ 0.7, 0.81, 6684.75 },
	{ 0.5, 3.87, 1059.38 },
	{ 0.6, 0.78, 20043.67 },
	{ 0.5, 4.52, 3496.03 },
	{ 0.5, 1.61, 3583.34 },
	{ 0.4, 5.72, 3149.16 },
	/* 14 terms retained, 97 terms dropped, error 3.1e-08 a.u.*T^3 */

	/* mars r, T^4 */
	{ 19.6, 3.582, 3340.612 },
	{ 16.3, 4.051, 6681.225 },
	{ 5.8, 4.46, 10021.84 },
	{ 1.5, 4.84, 13362.45 },
	{ 0.4, 1.51, 3185.19 },
	{ 0.3, 5.21, 16703.06 },
	{ 0.2, 5.16, 3344.14 },
	{ 0.1, 2.19, 3496.03 },
	{ 0.1, 0, 0 },
	/* 9 terms retained, 19 terms dropped, error 9.4e-09 a.u.*T^4 */

	/* mars r, T^5 */
	{ 0.5, 2.48, 6681.22 },
	{ 0.3, 2.92, 10021.84 },
	{ 0.1, 1.77, 3340.61 },
	/* 3 terms retained, 6 terms dropped, error 4.6e-09 a.u.*T^5 */
	/* end mars */
};

int vn_mars[][3] = {
	/* addresses for mars l, b, r  */
	/* T^0 */ { 0, 343, 433, },
	/* T^1 */ { 124, 383, 528, },
	/* T^2 */ { 222, 409, 612, },
	/* T^3 */ { 289, 419, 665, },
	/* T^4 */ { 321, 427, 679, },
	/* T^5 */ { 336, 432, 688, },
	/* end */ { 343, 433, 691, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_mercury[][3] = {
	/* mercury l, T^0 */
	{ 440250710.1, 0, 0 },
	{ 40989415.0, 1.483020342, 26087.903141574 },
	{ 5046294.2, 4.47785490, 52175.80628315 },
	{ 855346.8, 1.1652032, 78263.7094247 },
	{ 165590.4, 4.1196916, 104351.6125663 },
	{ 34561.9, 0.779308, 130439.515708 },
	{ 7583.5, 3.71348, 156527.41885 },
	{ 3559.7, 1.51203, 1109.37855 },
	{ 1726.0, 0.35832, 182615.32199 },
	{ 1803.5, 4.10333, 5661.33205 },
	{ 1364.7, 4.59918, 27197.28169 },
	{ 1589.9, 2.99510, 25028.52121 },
	{ 1017.3, 0.88031, 31749.23519 },
	{ 714.2, 1.5414, 24978.5246 },
	{ 643.8, 5.3027, 21535.9496 },
	{ 404.2, 3.2823, 208703.2251 },
	{ 352.4, 5.2416, 20426.5711 },
	{ 343.3, 5.7653, 955.5997 },
	{ 339.2, 5.8633, 25558.2122 },
	{ 451.1, 6.0499, 51116.4244 },
	{ 325.3, 1.3367, 53285.1848 },
	{ 259.6, 0.9873, 4551.9535 },
	{ 345.2, 2.7921, 15874.6176 },
	{ 272.9, 2.4945, 529.6910 },
	{ 234.8, 0.2667, 11322.6641 },
	{ 238.8, 0.1134, 1059.3819 },
	{ 264.3, 3.9171, 57837.1383 },
	{ 216.6, 0.6599, 13521.7514 },
	{ 183.4, 2.6288, 27043.5029 },
	{ 176.0, 4.5364, 51066.4277 },
	{ 181.6, 2.4341, 25661.3050 },
	{ 209.0, 2.0918, 47623.8528 },
	{ 172.6, 2.4520, 24498.8302 },
	{ 142.3, 3.3600, 37410.5672 },
	{ 137.9, 0.2910, 10213.2855 },
	{ 118.2, 2.7815, 77204.3275 },
	{ 96.9, 6.204, 234791.128 },
	{ 125.2, 3.7208, 39609.6546 },
	{ 86.8, 2.642, 51646.115 },
	{ 86.7, 1.960, 46514.474 },
	{ 88.3, 5.413, 26617.594 },
	{ 106.4, 4.2057, 19804.8273 },
	{ 90.0, 5.852, 41962.521 },
	{ 85.0, 4.331, 79373.088 },
	{ 69.2, 4.194, 19.670 },
	{ 63.5, 3.147, 7238.676 },
	{ 68.5, 0.634, 83925.041 },
	{ 69.7, 3.572, 25132.303 },
	{ 59.5, 2.747, 16983.996 },
	{ 64.8, 0.048, 33326.579 },
	{ 55.4, 4.053, 30639.857 },
	{ 54.4, 3.143, 27147.285 },
	{ 47.6, 5.497, 3.881 },
	{ 49.6, 3.990, 6770.711 },
	{ 56.5, 5.119, 73711.756 },
	{ 41.8, 5.642, 53131.406 },
	{ 51.5, 5.478, 50586.733 },
	{ 44.7, 1.224, 77154.331 },
	{ 41.9, 5.193, 6283.076 },
	{ 38.0, 2.431, 12566.152 },
	{ 35.6, 0.814, 32858.614 },
	{ 48.0, 5.493, 51749.208 },
	{ 35.4, 3.370, 36301.189 },
	{ 34.0, 2.786, 14765.239 },
	{ 30.6, 5.840, 43071.899 },
	{ 36.0, 1.424, 2218.757 },
	{ 34.0, 0.475, 65697.558 },
	{ 30.8, 5.770, 103292.231 },
	{ 28.5, 0.650, 426.598 },
	{ 26.2, 5.242, 22645.328 },
	{ 26.3, 0.648, 1589.073 },
	{ 29.5, 0.698, 213.299 },
	{ 27.5, 0.980, 45892.730 },
	{ 26.8, 1.061, 3442.575 },
	{ 27.1, 0.085, 63498.470 },
	/* 75 terms retained, 1305 terms dropped, error 0.97" */

	/* mercury l, T^1 */
	{ 2608814706222.7, 0, 0 },
	{ 1126007.8, 6.21703971, 26087.90314157 },
	{ 303471.4, 3.0556547, 52175.8062831 },
	{ 80538.5, 6.104547, 78263.709425 },
	{ 21245.0, 2.835319, 104351.612566 },
	{ 5592.1, 5.82676, 130439.51571 },
	{ 1472.2, 2.51845, 156527.41885 },
	{ 352.2, 3.0524, 1109.3786 },
	{ 388.3, 5.4804, 182615.3220 },
	{ 93.5, 6.118, 27197.282 },
	{ 90.6, 0.000, 24978.525 },
	{ 102.7, 2.1488, 208703.2251 },
	{ 51.9, 5.621, 5661.332 },
	{ 44.4, 4.573, 25028.521 },
	{ 28.1, 3.042, 51066.428 },
	{ 22.0, 0.865, 955.600 },
	{ 27.3, 5.092, 234791.128 },
	{ 20.4, 3.715, 20426.571 },
	{ 20.2, 0.519, 21535.950 },
	{ 17.5, 5.727, 4551.953 },
	{ 16.7, 1.351, 529.691 },
	{ 15.3, 1.792, 11322.664 },
	{ 15.4, 5.743, 19.670 },
	{ 14.0, 3.594, 24498.830 },
	{ 12.8, 2.696, 53285.185 },
	{ 12.6, 3.895, 3.881 },
	{ 12.6, 4.705, 1059.382 },
	{ 8.0, 4.18, 26617.59 },
	{ 7.9, 0.50, 46514.47 },
	{ 8.0, 3.93, 27043.50 },
	{ 7.7, 2.48, 57837.14 },
	{ 8.6, 6.06, 77154.33 },
	{ 6.8, 2.77, 7.11 },
	{ 6.6, 5.53, 6770.71 },
	{ 7.3, 1.75, 260879.03 },
	{ 7.2, 2.98, 2218.76 },
	{ 6.4, 2.14, 25132.30 },
	/* 37 terms retained, 802 terms dropped, error 0.16"*T */

	/* mercury l, T^2 */
	{ 53049.8, 0, 0 },
	{ 16903.7, 4.690723, 26087.903142 },
	{ 7396.7, 1.34736, 52175.80628 },
	{ 3018.3, 4.45644, 78263.70942 },
	{ 1107.4, 1.26227, 104351.61257 },
	{ 378.2, 4.3200, 130439.5157 },
	{ 123.0, 1.0687, 156527.4188 },
	{ 38.7, 4.080, 182615.322 },
	{ 14.9, 4.633, 1109.379 },
	{ 11.9, 0.792, 208703.225 },
	{ 5.2, 4.72, 24978.52 },
	{ 3.6, 3.77, 234791.13 },
	{ 2.6, 1.44, 27197.28 },
	{ 2.0, 1.50, 51066.43 },
	/* 14 terms retained, 381 terms dropped, error 0.033"*T^2 */

	/* mercury l, T^3 */
	{ 188.1, 0.0347, 52175.8063 },
	{ 142.2, 3.1251, 26087.9031 },
	{ 96.9, 3.004, 78263.709 },
	{ 43.7, 6.019, 104351.613 },
	{ 35.4, 0, 0 },
	{ 18.0, 2.775, 130439.516 },
	{ 7.0, 5.82, 156527.42 },
	{ 2.6, 2.57, 182615.32 },
	{ 0.9, 5.59, 208703.23 },
	/* 9 terms retained, 144 terms dropped, error 0.012"*T^3 */

	/* mercury l, T^4 */
	{ 114.1, 3.1416, 0 },
	{ 3.2, 2.03, 26087.90 },
	{ 1.9, 1.42, 78263.71 },
	{ 1.7, 4.50, 52175.81 },
	{ 1.2, 4.50, 104351.61 },
	{ 0.6, 1.27, 130439.52 },
	{ 0.3, 4.31, 156527.42 },
	{ 0.1, 1.06, 182615.32 },
	/* 8 terms retained, 20 terms dropped, error 0.0016"*T^4 */

	/* mercury l, T^5 */
	{ 0.9, 3.14, 0 },
	/* 1 terms retained, 12 terms dropped, error 0.0051"*T^5 */
	/* end mercury l */

	/* mercury b, T^0 */
	{ 11737529.0, 1.983574988, 26087.903141574 },
	{ 2388077.0, 5.03738960, 52175.80628315 },
	{ 1222839.5, 3.14159265, 0 },
	{ 543251.8, 1.7964436, 78263.7094247 },
	{ 129778.8, 4.8323250, 104351.6125663 },
	{ 31866.9, 1.580885, 130439.515708 },
	{ 7963.3, 4.60972, 156527.41885 },
	{ 2014.2, 1.35324, 182615.32199 },
	{ 514.0, 4.3784, 208703.2251 },
	{ 207.7, 4.9177, 27197.2817 },
	{ 208.6, 2.0202, 24978.5246 },
	{ 132.0, 1.1191, 234791.1283 },
	{ 100.5, 5.6568, 20426.5711 },
	{ 121.4, 1.8127, 53285.1848 },
	{ 91.6, 2.282, 25028.521 },
	{ 99.2, 0.094, 51116.424 },
	{ 94.6, 1.242, 31749.235 },
	{ 78.8, 4.407, 57837.138 },
	{ 77.7, 0.526, 1059.382 },
	{ 84.3, 5.085, 51066.428 },
	{ 49.9, 3.498, 5661.332 },
	{ 46.5, 3.237, 77204.327 },
	{ 44.8, 4.878, 79373.088 },
	{ 40.8, 2.466, 46514.474 },
	{ 37.4, 4.458, 4551.953 },
	{ 34.1, 4.142, 260879.031 },
	{ 35.9, 1.091, 1109.379 },
	{ 32.0, 1.185, 83925.041 },
	{ 31.0, 3.503, 21535.950 },
	{ 31.8, 2.415, 47623.853 },
	{ 28.7, 1.848, 77154.331 },
	{ 25.8, 2.776, 27043.503 },
	{ 25.2, 3.591, 27147.285 },
	/* 33 terms retained, 785 terms dropped, error 0.61" */

	/* mercury b, T^1 */
	{ 429151.4, 3.5016978, 26087.9031416 },
	{ 146233.7, 3.1415927, 0 },
	{ 22675.3, 0.015154, 52175.806283 },
	{ 10895.0, 0.485402, 78263.709425 },
	{ 6353.5, 3.42944, 104351.61257 },
	{ 2495.7, 0.16051, 130439.51571 },
	{ 859.6, 3.1845, 156527.4188 },
	{ 277.5, 6.2102, 182615.3220 },
	{ 86.2, 2.952, 208703.225 },
	{ 26.1, 5.977, 234791.128 },
	{ 27.7, 0.291, 27197.282 },
	{ 12.8, 3.377, 53285.185 },
	{ 12.7, 0.538, 24978.525 },
	{ 7.8, 2.72, 260879.03 },
	{ 7.5, 3.58, 51066.43 },
	/* 15 terms retained, 479 terms dropped, error 0.12"*T */

	/* mercury b, T^2 */
	{ 11830.9, 4.790656, 26087.903142 },
	{ 1913.5, 0, 0 },
	{ 1044.8, 1.21217, 52175.80628 },
	{ 266.2, 4.4342, 78263.7094 },
	{ 170.3, 1.6226, 104351.6126 },
	{ 96.3, 4.800, 130439.516 },
	{ 44.7, 1.608, 156527.419 },
	{ 18.3, 4.669, 182615.322 },
	{ 6.9, 1.43, 208703.23 },
	{ 2.5, 4.47, 234791.13 },
	{ 1.7, 1.83, 27197.28 },
	/* 11 terms retained, 219 terms dropped, error 0.025"*T^2 */

	/* mercury b, T^3 */
	{ 235.4, 0.3539, 26087.9031 },
	{ 160.5, 0, 0 },
	{ 18.9, 4.363, 52175.806 },
	{ 6.4, 2.51, 78263.71 },
	{ 4.6, 6.14, 104351.61 },
	{ 3.1, 3.12, 130439.52 },
	{ 1.7, 6.27, 156527.42 },
	{ 0.9, 3.08, 182615.32 },
	/* 8 terms retained, 45 terms dropped, error 0.011"*T^3 */

	/* mercury b, T^4 */
	{ 4.3, 1.75, 26087.90 },
	{ 1.0, 3.14, 0 },
	{ 0.4, 4.03, 52175.81 },
	{ 0.3, 0.21, 78263.71 },
	{ 0.1, 3.75, 104351.61 },
	/* 5 terms retained, 10 terms dropped, error 0.0012"*T^4 */

	/* mercury b, T^5 */
	{ 0.1, 3.95, 26087.90 },
	/* 1 terms retained, 9 terms dropped, error 0.00062"*T^5 */
	/* end mercury b */

	/* mercury r, T^0 */
	{ 39528271.7, 0, 0 },
	{ 7834131.8, 6.19233723, 26087.90314157 },
	{ 795525.6, 2.9598969, 52175.8062831 },
	{ 121281.8, 6.0106415, 78263.7094247 },
	{ 21922.0, 2.778201, 104351.612566 },
	{ 4354.1, 5.82895, 130439.51571 },
	{ 918.2, 2.5965, 156527.4188 },
	{ 260.0, 3.0282, 27197.2817 },
	{ 290.0, 1.4244, 25028.5212 },
	{ 201.9, 5.6473, 182615.3220 },
	{ 201.5, 5.5923, 31749.2352 },
	{ 142.0, 6.2526, 24978.5246 },
	{ 100.1, 3.7344, 21535.9496 },
	{ 77.6, 3.670, 20426.571 },
	{ 63.3, 4.299, 25558.212 },
	{ 63.0, 4.766, 1059.382 },
	{ 66.8, 2.525, 5661.332 },
	{ 75.5, 4.474, 51116.424 },
	{ 48.3, 6.068, 53285.185 },
	{ 45.7, 2.415, 208703.225 },
	{ 35.2, 1.059, 27043.503 },
	{ 40.8, 2.359, 57837.138 },
	{ 44.2, 1.220, 15874.618 },
	{ 33.9, 0.864, 25661.305 },
	{ 37.2, 0.517, 47623.853 },
	{ 30.1, 1.795, 37410.567 },
	{ 28.4, 3.021, 51066.428 },
	{ 30.9, 0.884, 24498.830 },
	{ 26.1, 2.150, 39609.655 },
	/* 29 terms retained, 1186 terms dropped, error 2.9e-06 a.u. */

	/* mercury r, T^1 */
	{ 217347.7, 4.6561716, 26087.9031416 },
	{ 44141.8, 1.423855, 52175.806283 },
	{ 10094.5, 4.474663, 78263.709425 },
	{ 2432.8, 1.24226, 104351.61257 },
	{ 1624.4, 0, 0 },
	{ 604.0, 4.2930, 130439.5157 },
	{ 152.9, 1.0606, 156527.4188 },
	{ 39.2, 4.111, 182615.322 },
	{ 17.8, 4.544, 27197.282 },
	{ 18.0, 4.712, 24978.525 },
	{ 10.2, 0.879, 208703.225 },
	{ 8.1, 3.01, 25028.52 },
	/* 12 terms retained, 699 terms dropped, error 5.8e-07 a.u.*T */

	/* mercury r, T^2 */
	{ 3117.9, 3.08232, 26087.90314 },
	{ 1245.4, 6.15183, 52175.80628 },
	{ 424.8, 2.9258, 78263.7094 },
	{ 136.1, 5.9798, 104351.6126 },
	{ 42.2, 2.749, 130439.516 },
	{ 21.8, 3.142, 0 },
	{ 12.8, 5.801, 156527.419 },
	{ 3.8, 2.57, 182615.32 },
	/* 8 terms retained, 318 terms dropped, error 2.3e-07 a.u.*T^2 */

	/* mercury r, T^3 */
	{ 32.7, 1.680, 26087.903 },
	{ 24.2, 4.634, 52175.806 },
	{ 12.1, 1.390, 78263.709 },
	{ 5.1, 4.44, 104351.61 },
	{ 2.0, 1.21, 130439.52 },
	{ 1.5, 3.14, 0 },
	{ 0.7, 4.26, 156527.42 },
	/* 7 terms retained, 112 terms dropped, error 4.1e-08 a.u.*T^3 */

	/* mercury r, T^4 */
	{ 0.4, 0.37, 26087.90 },
	{ 0.4, 3.19, 52175.81 },
	{ 0.3, 6.17, 78263.71 },
	{ 0.1, 2.92, 104351.61 },
	/* 4 terms retained, 14 terms dropped, error 6.7e-09 a.u.*T^4 */

	/* mercury r, T^5 */
	/* 0 terms retained, 10 terms dropped, error 1.2e-10 a.u.*T^5 */
	/* end mercury */
};

int vn_mercury[][3] = {
	/* addresses for mercury l, b, r  */
	/* T^0 */ { 0, 144, 217, },
	/* T^1 */ { 75, 177, 246, },
	/* T^2 */ { 112, 192, 258, },
	/* T^3 */ { 126, 203, 266, },
	/* T^4 */ { 135, 211, 273, },
	/* T^5 */ { 143, 216, 277, },
	/* end */ { 144, 217, 0, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_neptune[][3] = {
	/* neptune l, T^0 */
	{ 531188633.0, 0, 0 },
	{ 1798475.5, 2.90101273, 38.13303564 },
	{ 1019727.7, 0.48580924, 1.48447271 },
	{ 124531.8, 4.8300809, 36.6485629 },
	{ 42064.4, 5.410550, 2.968945 },
	{ 37714.6, 6.092218, 35.164090 },
	{ 33784.7, 1.244889, 76.266071 },
	{ 16482.7, 0.000077, 491.557929 },
	{ 9198.6, 4.93747, 39.61751 },
	{ 8994.2, 0.27462, 175.16606 },
	{ 4216.2, 1.98712, 73.29713 },
	{ 3364.8, 1.03590, 33.67962 },
	{ 2284.8, 4.20607, 4.45342 },
	{ 1433.5, 2.78340, 74.78160 },
	{ 900.2, 2.0761, 109.9457 },
	{ 745.0, 3.1903, 71.8127 },
	{ 506.2, 5.7479, 114.3991 },
	{ 399.6, 0.3497, 1021.2489 },
	{ 345.2, 3.4619, 41.1020 },
	{ 306.3, 0.4968, 0.5213 },
	{ 287.3, 4.5052, 0.0482 },
	{ 323.0, 2.2482, 32.1951 },
	{ 340.3, 3.3037, 77.7505 },
	{ 266.6, 4.8893, 0.9632 },
	{ 227.1, 1.7971, 453.4249 },
	{ 244.7, 1.2469, 9.5612 },
	{ 232.9, 2.5046, 137.0330 },
	{ 282.2, 2.2457, 146.5943 },
	{ 251.9, 5.7817, 388.4652 },
	{ 150.2, 2.9971, 5.9379 },
	{ 170.4, 3.3239, 108.4612 },
	{ 151.4, 2.1915, 33.9402 },
	{ 148.3, 0.8595, 111.4302 },
	{ 118.7, 3.6771, 2.4477 },
	{ 101.8, 5.7054, 0.1119 },
	{ 97.9, 2.805, 8.077 },
	{ 103.1, 4.4044, 70.3282 },
	{ 103.3, 0.0408, 0.2606 },
	{ 109.3, 2.4160, 183.2428 },
	{ 73.9, 1.328, 529.691 },
	{ 77.7, 4.164, 4.193 },
	{ 86.4, 4.228, 490.073 },
	{ 81.5, 5.199, 493.042 },
	{ 71.5, 5.295, 350.332 },
	{ 64.4, 3.545, 168.053 },
	{ 62.6, 0.150, 182.280 },
	{ 58.5, 3.501, 145.110 },
	{ 48.3, 1.113, 112.915 },
	{ 47.2, 4.574, 46.210 },
	{ 39.1, 1.666, 213.299 },
	{ 47.7, 0.129, 484.444 },
	{ 46.9, 3.017, 498.671 },
	{ 38.7, 2.387, 2.921 },
	{ 47.0, 4.498, 173.682 },
	{ 47.6, 2.584, 219.891 },
	{ 44.7, 5.473, 176.651 },
	{ 32.3, 3.458, 30.711 },
	{ 28.2, 4.133, 6.592 },
	/* 58 terms retained, 365 terms dropped, error 0.9" */

	/* neptune l, T^1 */
	{ 3837687716.7, 0, 0 },
	{ 16604.2, 4.863191, 1.484473 },
	{ 15807.1, 2.279235, 38.133036 },
	{ 3334.7, 3.68200, 76.26607 },
	{ 1305.8, 3.67321, 2.96895 },
	{ 604.8, 1.5048, 35.1641 },
	{ 178.6, 3.4532, 39.6175 },
	{ 106.5, 2.4513, 4.4534 },
	{ 105.7, 2.7548, 33.6796 },
	{ 72.7, 5.487, 36.649 },
	{ 57.1, 5.216, 0.521 },
	{ 57.4, 1.858, 114.399 },
	{ 35.4, 4.517, 74.782 },
	{ 32.2, 5.904, 77.751 },
	{ 29.9, 3.670, 388.465 },
	{ 28.9, 5.169, 9.561 },
	{ 28.7, 5.167, 2.448 },
	{ 25.5, 5.245, 168.053 },
	{ 24.9, 4.732, 182.280 },
	{ 20.2, 5.789, 1021.249 },
	{ 19.0, 1.830, 484.444 },
	{ 18.7, 1.316, 498.671 },
	{ 15.1, 4.950, 137.033 },
	{ 15.1, 3.987, 32.195 },
	{ 10.7, 2.441, 4.193 },
	{ 11.7, 4.893, 71.813 },
	{ 9.6, 1.23, 5.94 },
	{ 9.6, 1.89, 41.10 },
	{ 9.0, 0.02, 8.08 },
	{ 9.9, 6.08, 7.11 },
	{ 7.6, 5.51, 73.30 },
	{ 7.0, 0.62, 2.92 },
	/* 32 terms retained, 151 terms dropped, error 0.17"*T */

	/* neptune l, T^2 */
	{ 53892.6, 0, 0 },
	{ 281.3, 1.1908, 38.1330 },
	{ 295.7, 1.8552, 1.4845 },
	{ 270.2, 5.7214, 76.2661 },
	{ 23.0, 1.210, 2.969 },
	{ 7.3, 0.54, 2.45 },
	{ 9.1, 4.43, 35.16 },
	{ 5.2, 0.67, 168.05 },
	{ 5.2, 3.02, 182.28 },
	{ 4.3, 3.84, 114.40 },
	{ 3.9, 3.53, 484.44 },
	{ 3.7, 5.90, 498.67 },
	{ 3.0, 0.31, 4.45 },
	{ 3.4, 0.56, 74.78 },
	{ 3.3, 1.85, 175.17 },
	{ 2.2, 1.89, 388.47 },
	{ 2.2, 4.38, 7.11 },
	{ 1.8, 3.49, 9.56 },
	{ 2.5, 4.69, 491.56 },
	{ 1.8, 5.12, 33.68 },
	{ 2.2, 1.69, 77.75 },
	{ 1.7, 2.56, 36.65 },
	/* 22 terms retained, 35 terms dropped, error 0.033"*T^2 */

	/* neptune l, T^3 */
	{ 31.3, 0, 0 },
	{ 12.5, 6.044, 1.484 },
	{ 14.5, 1.353, 76.266 },
	{ 11.5, 6.113, 38.133 },
	{ 1.4, 4.94, 2.97 },
	{ 0.7, 2.36, 168.05 },
	{ 0.7, 1.27, 182.28 },
	{ 0.5, 5.24, 484.44 },
	{ 0.5, 4.17, 498.67 },
	{ 0.7, 0.56, 31.02 },
	/* 10 terms retained, 5 terms dropped, error 0.0091"*T^3 */

	/* neptune l, T^4 */
	{ 114.0, 3.1416, 0 },
	{ 0.6, 3.18, 76.27 },
	/* 2 terms retained, 0 terms dropped, error 0.0043"*T^4 */

	/* neptune l, T^5 */
	{ 0.9, 3.14, 0 },
	/* 1 terms retained, 0 terms dropped, error 0.0051"*T^5 */
	/* end neptune l */

	/* neptune b, T^0 */
	{ 3088622.9, 1.44104373, 38.13303564 },
	{ 27780.1, 5.912719, 76.266071 },
	{ 27623.6, 0, 0 },
	{ 15355.5, 2.521238, 36.648563 },
	{ 15448.1, 3.508771, 39.617508 },
	{ 1999.9, 1.50999, 74.78160 },
	{ 1967.5, 4.37778, 1.48447 },
	{ 1015.1, 3.21561, 35.16409 },
	{ 605.8, 2.8025, 73.2971 },
	{ 594.9, 2.1289, 41.1020 },
	{ 588.8, 3.1866, 2.9689 },
	{ 401.8, 4.1688, 114.3991 },
	{ 254.3, 3.2712, 453.4249 },
	{ 261.6, 3.7672, 213.2991 },
	{ 280.0, 1.6817, 77.7505 },
	{ 205.6, 4.2565, 529.6910 },
	{ 140.5, 3.5297, 137.0330 },
	{ 98.5, 4.168, 33.680 },
	{ 51.3, 1.951, 4.453 },
	{ 68.0, 4.670, 71.813 },
	{ 41.9, 5.418, 111.430 },
	{ 41.8, 5.948, 112.915 },
	{ 30.6, 0.936, 42.586 },
	/* 23 terms retained, 149 terms dropped, error 0.62" */

	/* neptune b, T^1 */
	{ 227279.2, 3.8079309, 38.1330356 },
	{ 1803.1, 1.97576, 76.26607 },
	{ 1385.7, 4.82556, 36.64856 },
	{ 1433.3, 3.14159, 0 },
	{ 1073.3, 6.08054, 39.61751 },
	{ 147.9, 3.8577, 74.7816 },
	{ 136.4, 0.4776, 1.4845 },
	{ 70.3, 6.188, 35.164 },
	{ 51.9, 5.052, 73.297 },
	{ 37.3, 4.895, 41.102 },
	{ 42.6, 0.307, 114.399 },
	{ 37.1, 5.760, 2.969 },
	{ 26.4, 5.216, 213.299 },
	{ 16.9, 4.265, 77.751 },
	{ 18.7, 0.904, 453.425 },
	{ 13.0, 6.177, 529.691 },
	{ 10.5, 1.203, 137.033 },
	/* 17 terms retained, 65 terms dropped, error 0.18"*T */

	/* neptune b, T^2 */
	{ 9690.8, 5.57124, 38.13304 },
	{ 78.8, 3.627, 76.266 },
	{ 71.5, 0.455, 36.649 },
	{ 58.6, 3.142, 0 },
	{ 29.9, 1.607, 39.618 },
	{ 6.5, 5.61, 74.78 },
	{ 5.8, 2.25, 1.48 },
	{ 4.3, 1.68, 35.16 },
	{ 3.5, 2.39, 114.40 },
	{ 2.6, 0.65, 73.30 },
	/* 10 terms retained, 15 terms dropped, error 0.036"*T^2 */

	/* neptune b, T^3 */
	{ 273.4, 1.0169, 38.1330 },
	{ 2.3, 2.37, 36.65 },
	{ 2.0, 5.33, 76.27 },
	{ 2.4, 0, 0 },
	{ 0.5, 3.22, 39.62 },
	/* 5 terms retained, 4 terms dropped, error 0.0054"*T^3 */

	/* neptune b, T^4 */
	{ 5.7, 2.67, 38.13 },
	/* 1 terms retained, 0 terms dropped, error 0.033"*T^4 */

	/* neptune b, T^5 */
	{ 0.1, 4.71, 38.13 },
	/* 1 terms retained, 0 terms dropped, error 0.00066"*T^5 */
	/* end neptune b */

	/* neptune r, T^0 */
	{ 3007013206.1, 0, 0 },
	{ 27062259.5, 1.329994589, 38.133035638 },
	{ 1691764.3, 3.25186139, 36.64856293 },
	{ 807830.7, 5.1859284, 1.4844727 },
	{ 537760.6, 4.5211390, 35.1640902 },
	{ 495725.6, 1.5710565, 491.5579295 },
	{ 274572.0, 1.8455226, 175.1660598 },
	{ 135134.1, 3.3722061, 39.6175083 },
	{ 121801.8, 5.7975444, 76.2660713 },
	{ 100895.4, 0.3770275, 73.2971259 },
	{ 69791.7, 3.796172, 2.968945 },
	{ 46687.8, 5.749378, 33.679618 },
	{ 24593.8, 0.508017, 109.945689 },
	{ 16939.2, 1.594222, 71.812653 },
	{ 14229.7, 1.077861, 74.781599 },
	{ 12011.8, 1.920621, 1021.248895 },
	{ 8394.7, 0.67817, 146.59425 },
	{ 7571.8, 1.07149, 388.46516 },
	{ 5720.9, 2.59060, 4.45342 },
	{ 4839.7, 1.90686, 41.10198 },
	{ 4483.5, 2.90573, 529.69097 },
	{ 4270.2, 3.41344, 453.42489 },
	{ 4353.8, 0.67986, 32.19514 },
	{ 4420.8, 1.74994, 108.46122 },
	{ 2881.1, 1.98600, 137.03302 },
	{ 2635.5, 3.09756, 213.29910 },
	{ 3380.9, 0.84811, 183.24281 },
	{ 2878.9, 3.67416, 350.33212 },
	{ 2306.3, 2.80963, 70.32818 },
	{ 2530.1, 5.79840, 490.07346 },
	{ 2523.1, 0.48631, 493.04240 },
	{ 2087.3, 0.61858, 33.94025 },
	{ 1976.5, 5.11703, 168.05251 },
	{ 1905.3, 1.72186, 182.27961 },
	{ 1654.0, 1.92783, 145.10978 },
	{ 1435.1, 1.70005, 484.44438 },
	{ 1403.0, 4.58914, 498.67148 },
	{ 1499.2, 1.01623, 219.89138 },
	{ 1398.9, 0.76220, 176.65053 },
	{ 1403.4, 6.07659, 173.68159 },
	{ 1128.6, 5.96661, 9.56123 },
	{ 1228.3, 1.59881, 77.75054 },
	{ 835.4, 3.9707, 114.3991 },
	{ 811.2, 3.0026, 46.2098 },
	{ 731.9, 2.1045, 181.7583 },
	{ 615.8, 2.9787, 106.9767 },
	{ 704.8, 1.1874, 256.5399 },
	{ 502.0, 1.3866, 5.9379 },
	{ 530.4, 4.2406, 111.4302 },
	{ 437.1, 2.2703, 1550.9399 },
	{ 400.2, 1.2561, 8.0768 },
	{ 421.0, 1.8908, 30.7107 },
	{ 382.5, 3.2997, 983.1159 },
	{ 422.5, 5.5319, 525.4982 },
	{ 355.4, 2.2785, 218.4069 },
	{ 280.1, 1.5413, 98.9000 },
	{ 314.5, 3.9593, 381.3516 },
	{ 280.6, 4.5424, 44.7253 },
	{ 267.7, 5.1332, 112.9146 },
	{ 333.3, 5.7507, 39.0962 },
	{ 291.6, 4.0240, 68.8437 },
	{ 321.4, 1.5063, 454.9094 },
	{ 309.2, 2.8545, 72.0733 },
	{ 345.1, 1.3591, 293.1885 },
	{ 307.4, 0.3196, 601.7643 },
	{ 251.4, 3.5399, 312.1991 },
	{ 248.2, 3.4108, 37.6118 },
	{ 306.0, 2.7248, 6244.9428 },
	{ 293.5, 4.8908, 528.2065 },
	{ 234.5, 0.5923, 42.5865 },
	{ 239.6, 3.1644, 143.6253 },
	{ 214.5, 3.6248, 278.2588 },
	{ 246.2, 1.0151, 141.2258 },
	{ 174.1, 5.5501, 567.8240 },
	{ 163.9, 2.1017, 2.4477 },
	{ 162.9, 2.4895, 4.1928 },
	{ 193.5, 1.5843, 138.5175 },
	{ 155.3, 3.2843, 31.0195 },
	{ 182.5, 2.4524, 255.0555 },
	{ 177.8, 4.1477, 10175.1525 },
	{ 174.4, 1.5304, 329.8371 },
	{ 137.6, 3.3490, 0.9632 },
	{ 161.0, 5.1666, 211.8146 },
	{ 113.5, 4.9629, 148.0787 },
	{ 128.8, 3.2552, 24.1184 },
	{ 107.4, 3.2646, 1059.3819 },
	{ 122.7, 5.3940, 62.2514 },
	{ 120.5, 3.0805, 184.7273 },
	{ 99.4, 1.929, 28.572 },
	{ 97.7, 2.595, 6.592 },
	{ 124.1, 3.1152, 221.3759 },
	{ 124.7, 2.9704, 251.4321 },
	{ 114.3, 0.2504, 594.6507 },
	{ 111.0, 3.3428, 180.2739 },
	{ 120.9, 1.9291, 25.6029 },
	{ 104.7, 0.9488, 395.5787 },
	{ 109.8, 5.4315, 494.5269 },
	{ 96.9, 0.862, 1014.135 },
	{ 98.7, 0.896, 488.589 },
	{ 89.0, 4.781, 144.147 },
	{ 107.9, 0.9870, 1124.3417 },
	{ 97.1, 2.627, 291.704 },
	{ 75.1, 5.889, 43.241 },
	{ 93.7, 6.099, 526.722 },
	{ 94.8, 0.207, 456.394 },
	{ 70.0, 2.397, 426.598 },
	{ 77.2, 4.211, 105.492 },
	{ 89.9, 3.251, 258.024 },
	{ 69.1, 4.930, 1028.362 },
	{ 90.7, 1.695, 366.486 },
	{ 74.2, 3.145, 82.858 },
	{ 58.0, 0.862, 60.767 },
	{ 78.7, 1.093, 700.664 },
	{ 57.2, 0.813, 2.921 },
	{ 63.4, 4.396, 149.563 },
	{ 55.7, 3.890, 47.694 },
	{ 56.4, 5.150, 0.521 },
	{ 56.2, 5.430, 911.043 },
	{ 61.7, 6.165, 1019.764 },
	{ 70.5, 0.081, 40.581 },
	{ 74.7, 4.859, 186.212 },
	{ 61.9, 4.787, 11.046 },
	{ 61.1, 0.837, 1022.733 },
	{ 61.3, 5.702, 178.135 },
	{ 52.9, 0.375, 27.087 },
	{ 56.7, 3.523, 216.922 },
	{ 48.8, 5.108, 64.960 },
	{ 63.3, 4.394, 807.950 },
	{ 64.1, 6.283, 7.114 },
	{ 46.4, 1.347, 451.940 },
	{ 60.5, 3.403, 294.673 },
	{ 46.9, 0.170, 7.422 },
	{ 56.8, 0.450, 140.002 },
	{ 55.9, 1.068, 172.197 },
	{ 53.8, 2.796, 328.353 },
	{ 43.8, 6.047, 135.549 },
	{ 49.5, 0.641, 41.054 },
	{ 54.0, 2.918, 563.631 },
	{ 43.0, 5.402, 487.365 },
	{ 51.5, 0.091, 210.330 },
	{ 41.9, 3.123, 29.226 },
	{ 47.7, 3.907, 63.736 },
	{ 41.6, 6.268, 32.716 },
	{ 41.4, 4.455, 37.170 },
	{ 40.7, 0.160, 79.235 },
	{ 48.2, 1.842, 403.134 },
	{ 36.9, 0.448, 30.056 },
	{ 47.8, 0.881, 3302.479 },
	{ 39.5, 3.506, 357.446 },
	{ 42.1, 0.634, 343.219 },
	{ 41.3, 1.364, 31.232 },
	{ 42.6, 3.553, 38.654 },
	{ 38.9, 5.267, 415.292 },
	{ 39.0, 5.259, 386.981 },
	{ 33.7, 5.244, 67.359 },
	{ 40.9, 3.553, 331.322 },
	{ 38.8, 1.123, 38.181 },
	{ 37.5, 6.087, 35.425 },
	{ 38.8, 4.679, 38.085 },
	{ 38.2, 6.265, 389.950 },
	{ 30.0, 4.458, 22.634 },
	{ 31.4, 0.077, 12.530 },
	{ 26.3, 4.596, 106.014 },
	{ 27.5, 5.995, 206.186 },
	{ 25.2, 4.499, 34.201 },
	{ 29.0, 3.649, 253.571 },
	{ 27.2, 4.379, 142.141 },
	{ 30.6, 1.593, 348.848 },
	{ 31.5, 1.051, 100.384 },
	{ 26.3, 3.016, 365.001 },
	{ 26.5, 3.614, 367.970 },
	{ 25.5, 2.438, 351.817 },
	{ 25.7, 2.005, 439.783 },
	{ 25.4, 4.740, 1474.674 },
	/* 174 terms retained, 433 terms dropped, error 6.7e-06 a.u. */

	/* neptune r, T^1 */
	{ 236338.5, 0.7049801, 38.1330356 },
	{ 13220.3, 3.320155, 1.484473 },
	{ 8621.9, 6.21629, 35.16409 },
	{ 2701.7, 1.88141, 39.61751 },
	{ 2153.2, 5.16874, 76.26607 },
	{ 2154.7, 2.09431, 2.96895 },
	{ 1463.9, 1.18417, 33.67962 },
	{ 1603.2, 0, 0 },
	{ 1135.8, 3.91891, 36.64856 },
	{ 897.6, 5.2412, 388.4652 },
	{ 789.9, 0.5332, 168.0525 },
	{ 760.0, 0.0205, 182.2796 },
	{ 607.2, 1.0771, 1021.2489 },
	{ 571.6, 3.4006, 484.4444 },
	{ 560.8, 2.8869, 498.6715 },
	{ 490.2, 3.4683, 137.0330 },
	{ 264.1, 0.8622, 4.4534 },
	{ 270.5, 3.2736, 71.8127 },
	{ 203.5, 2.4182, 32.1951 },
	{ 155.4, 0.3654, 41.1020 },
	{ 132.8, 3.6016, 9.5612 },
	{ 93.6, 0.667, 46.210 },
	{ 83.3, 3.260, 98.900 },
	{ 72.2, 4.477, 601.764 },
	{ 69.0, 1.463, 74.782 },
	{ 87.0, 5.772, 381.352 },
	{ 68.7, 4.526, 70.328 },
	{ 64.7, 3.855, 73.297 },
	{ 68.4, 3.395, 108.461 },
	{ 53.4, 5.437, 395.579 },
	{ 44.5, 3.614, 2.448 },
	{ 41.2, 4.739, 8.077 },
	{ 48.3, 1.986, 175.166 },
	{ 41.7, 4.943, 31.019 },
	{ 44.1, 1.417, 1550.940 },
	{ 41.2, 1.420, 490.073 },
	{ 41.1, 4.863, 493.042 },
	{ 36.3, 5.308, 312.199 },
	{ 36.3, 0.382, 77.751 },
	{ 40.6, 2.272, 529.691 },
	{ 32.4, 5.911, 5.938 },
	{ 31.2, 2.705, 1014.135 },
	{ 32.7, 5.221, 41.054 },
	{ 36.1, 4.878, 491.558 },
	{ 30.2, 3.633, 30.711 },
	{ 30.0, 3.308, 1028.362 },
	{ 27.0, 1.776, 44.725 },
	{ 27.8, 4.556, 7.114 },
	{ 27.5, 0.972, 33.940 },
	{ 24.9, 3.101, 144.147 },
	{ 26.0, 2.997, 60.767 },
	{ 21.4, 4.713, 278.259 },
	{ 21.3, 0.690, 251.432 },
	{ 23.7, 5.120, 176.651 },
	{ 21.4, 0.863, 4.193 },
	{ 23.4, 1.650, 173.682 },
	{ 24.2, 3.566, 145.110 },
	{ 20.2, 5.615, 24.118 },
	{ 27.0, 4.143, 453.425 },
	{ 24.0, 1.007, 213.299 },
	{ 18.3, 1.980, 72.073 },
	{ 18.3, 6.173, 189.393 },
	{ 19.2, 4.652, 106.977 },
	{ 17.6, 1.603, 62.251 },
	{ 16.5, 1.699, 357.446 },
	{ 20.1, 3.295, 114.399 },
	{ 15.4, 4.388, 25.603 },
	{ 19.2, 2.200, 343.219 },
	{ 15.1, 3.668, 0.521 },
	{ 14.0, 0.553, 129.919 },
	{ 13.4, 5.858, 68.844 },
	{ 15.4, 4.207, 567.824 },
	{ 12.7, 3.528, 477.331 },
	{ 11.7, 5.576, 31.232 },
	{ 11.5, 0.891, 594.651 },
	{ 10.5, 4.356, 32.716 },
	{ 10.8, 5.218, 26.827 },
	{ 10.1, 1.981, 40.581 },
	{ 10.5, 5.273, 2.921 },
	{ 9.2, 0.50, 64.96 },
	{ 9.2, 0.68, 160.94 },
	{ 8.7, 5.81, 6.59 },
	{ 10.1, 4.512, 28.572 },
	{ 10.4, 5.189, 42.586 },
	{ 9.9, 3.77, 181.76 },
	{ 8.3, 2.82, 43.24 },
	{ 9.8, 1.49, 47.69 },
	{ 7.6, 4.08, 389.95 },
	{ 8.0, 2.78, 505.79 },
	{ 7.4, 2.36, 11.05 },
	{ 7.3, 1.62, 135.55 },
	{ 9.5, 0.27, 426.60 },
	{ 7.2, 0.83, 911.04 },
	{ 7.0, 1.87, 206.19 },
	{ 6.9, 0.84, 82.86 },
	{ 7.9, 1.87, 38.65 },
	{ 6.7, 3.98, 12.53 },
	{ 6.4, 0.90, 487.37 },
	{ 6.7, 1.34, 220.41 },
	{ 7.7, 5.13, 23.91 },
	{ 7.1, 6.00, 639.90 },
	{ 8.3, 3.86, 37.61 },
	{ 6.4, 2.42, 1059.38 },
	{ 6.8, 1.97, 45.25 },
	{ 6.4, 4.08, 35.69 },
	{ 6.4, 0.65, 350.33 },
	/* 106 terms retained, 144 terms dropped, error 1.3e-06 a.u.*T */

	/* neptune r, T^2 */
	{ 4247.4, 5.89911, 38.13304 },
	{ 217.6, 0.3458, 1.4845 },
	{ 163.0, 2.2387, 168.0525 },
	{ 156.3, 4.5941, 182.2796 },
	{ 117.9, 5.1030, 484.4444 },
	{ 112.4, 1.1900, 498.6715 },
	{ 127.1, 2.8479, 35.1641 },
	{ 99.5, 3.416, 175.166 },
	{ 64.8, 3.462, 388.465 },
	{ 77.3, 0.017, 491.558 },
	{ 49.5, 4.070, 76.266 },
	{ 39.3, 6.095, 1021.249 },
	{ 36.5, 5.171, 137.033 },
	{ 37.1, 5.973, 2.969 },
	{ 30.5, 3.583, 33.680 },
	{ 21.1, 0.768, 36.649 },
	{ 13.9, 3.592, 395.579 },
	{ 13.1, 5.093, 98.900 },
	{ 11.4, 1.181, 381.352 },
	{ 9.1, 2.35, 601.76 },
	{ 8.5, 5.25, 2.45 },
	{ 8.1, 4.96, 4.45 },
	{ 7.4, 4.47, 189.39 },
	{ 7.2, 1.92, 9.56 },
	{ 7.3, 1.66, 1028.36 },
	{ 8.1, 5.84, 220.41 },
	{ 9.7, 0, 0 },
	{ 6.6, 0.69, 144.15 },
	{ 7.8, 1.14, 1059.38 },
	{ 5.7, 6.25, 74.78 },
	{ 5.6, 5.23, 46.21 },
	{ 5.5, 4.59, 1014.14 },
	{ 5.2, 5.23, 477.33 },
	{ 5.5, 3.50, 183.76 },
	{ 4.9, 3.53, 39.62 },
	{ 4.8, 2.08, 41.10 },
	{ 5.1, 0.20, 166.57 },
	{ 4.8, 1.18, 169.54 },
	{ 4.7, 1.51, 73.30 },
	{ 6.1, 6.18, 71.81 },
	{ 4.6, 3.92, 587.54 },
	{ 5.8, 2.24, 176.65 },
	{ 4.5, 2.84, 7.11 },
	{ 4.3, 0.52, 446.31 },
	{ 3.9, 0.26, 1550.94 },
	{ 4.5, 3.01, 129.92 },
	{ 3.7, 2.38, 160.94 },
	{ 3.8, 3.79, 111.43 },
	{ 4.1, 1.70, 983.12 },
	{ 3.3, 1.08, 505.79 },
	{ 4.0, 0.31, 494.74 },
	{ 4.0, 5.97, 488.38 },
	{ 3.9, 4.86, 60.77 },
	{ 3.0, 2.02, 822.18 },
	{ 4.0, 1.08, 374.24 },
	{ 3.8, 5.23, 350.33 },
	{ 2.8, 6.18, 704.86 },
	{ 3.5, 0.79, 274.07 },
	{ 2.8, 1.32, 386.98 },
	{ 2.8, 5.37, 251.43 },
	{ 3.1, 5.13, 426.60 },
	{ 3.3, 5.61, 1124.34 },
	{ 2.6, 0.68, 312.20 },
	{ 2.6, 3.56, 567.82 },
	{ 2.6, 1.46, 1035.48 },
	{ 2.5, 5.19, 1227.43 },
	{ 2.5, 4.12, 171.23 },
	{ 2.5, 2.72, 179.10 },
	{ 2.3, 0.96, 1019.76 },
	{ 2.5, 0.70, 707.78 },
	{ 2.5, 4.60, 693.55 },
	{ 2.3, 0.74, 976.00 },
	/* 72 terms retained, 0 terms dropped, error 3.8e-07 a.u.*T^2 */

	/* neptune r, T^3 */
	{ 166.3, 4.5524, 38.1330 },
	{ 22.4, 3.948, 168.053 },
	{ 21.3, 2.863, 182.280 },
	{ 16.2, 0.542, 484.444 },
	{ 15.6, 5.757, 498.671 },
	{ 11.9, 4.403, 1.484 },
	{ 6.4, 5.19, 31.02 },
	{ 3.7, 5.91, 1007.02 },
	{ 3.7, 1.63, 388.47 },
	{ 3.2, 0.70, 1558.05 },
	{ 3.2, 1.88, 522.58 },
	{ 3.3, 2.94, 76.27 },
	{ 2.7, 1.87, 402.69 },
	{ 3.2, 0.79, 536.80 },
	{ 2.6, 5.77, 343.22 },
	{ 2.6, 4.65, 500.16 },
	{ 2.5, 4.79, 482.96 },
	{ 2.5, 1.73, 395.58 },
	{ 2.7, 2.21, 446.31 },
	{ 2.4, 5.77, 485.93 },
	{ 2.9, 6.20, 815.06 },
	{ 2.3, 3.67, 497.19 },
	/* 22 terms retained, 0 terms dropped, error 2.2e-07 a.u.*T^3 */

	/* neptune r, T^4 */
	{ 4.2, 2.40, 477.33 },
	{ 4.3, 0.10, 395.58 },
	{ 3.5, 4.78, 1028.36 },
	{ 3.2, 3.88, 505.79 },
	{ 3.0, 1.04, 189.39 },
	{ 2.3, 1.11, 182.28 },
	{ 2.3, 5.68, 168.05 },
	/* 7 terms retained, 0 terms dropped, error 1.3e-07 a.u.*T^4 */
	/* end neptune */
};

int vn_neptune[][3] = {
	/* addresses for neptune l, b, r  */
	/* T^0 */ { 0, 125, 182, },
	/* T^1 */ { 58, 148, 356, },
	/* T^2 */ { 90, 165, 462, },
	/* T^3 */ { 112, 175, 534, },
	/* T^4 */ { 122, 180, 556, },
	/* T^5 */ { 124, 181, 563, },
	/* end */ { 125, 182, 0, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_saturn[][3] = {
	/* saturn l, T^0 */
	{ 87401354.0, 0, 0 },
	{ 11107659.8, 3.962050902, 213.299095438 },
	{ 1414151.0, 4.58581516, 7.11354700 },
	{ 398379.4, 0.5211203, 206.1855484 },
	{ 350769.2, 3.3032990, 426.5981909 },
	{ 206816.3, 0.2465837, 103.0927742 },
	{ 79271.3, 3.840071, 220.412642 },
	{ 23990.3, 4.669769, 110.206321 },
	{ 16573.6, 0.437191, 419.484644 },
	{ 14907.0, 5.769033, 316.391870 },
	{ 15820.3, 0.938090, 632.783739 },
	{ 14609.6, 1.565186, 3.932153 },
	{ 13160.3, 4.448912, 14.227094 },
	{ 15053.5, 2.716700, 639.897286 },
	{ 13005.3, 5.981191, 11.045700 },
	{ 10725.1, 3.129396, 202.253395 },
	{ 5863.2, 0.23657, 529.69097 },
	{ 5227.8, 4.20783, 3.18139 },
	{ 6126.3, 1.76328, 277.03499 },
	{ 5019.7, 3.17788, 433.71174 },
	{ 4592.5, 0.61976, 199.07200 },
	{ 4005.9, 2.24480, 63.73590 },
	{ 2953.8, 0.98280, 95.97923 },
	{ 3873.7, 3.22283, 138.51750 },
	{ 2461.2, 2.03164, 735.87651 },
	{ 3269.5, 0.77492, 949.17561 },
	{ 1758.1, 3.26581, 522.57742 },
	{ 1640.2, 5.50505, 846.08283 },
	{ 1391.3, 4.02332, 323.50542 },
	{ 1580.6, 4.37266, 309.27832 },
	{ 1123.5, 2.83727, 415.55249 },
	{ 1017.3, 3.71698, 227.52619 },
	{ 848.6, 3.1915, 209.3669 },
	{ 1087.2, 4.18343, 2.44768 },
	{ 956.8, 0.5074, 1265.5675 },
	{ 789.2, 5.0075, 0.9632 },
	{ 687.0, 1.7471, 1052.2684 },
	{ 654.5, 1.5989, 0.0482 },
	{ 748.8, 2.1440, 853.1964 },
	{ 634.0, 2.2989, 412.3711 },
	{ 743.6, 5.2528, 224.3448 },
	{ 852.7, 3.4214, 175.1661 },
	{ 579.9, 3.0926, 74.7816 },
	{ 624.9, 0.9705, 210.1177 },
	{ 529.9, 4.4494, 117.3199 },
	{ 542.6, 1.5182, 9.5612 },
	{ 474.3, 5.4753, 742.9901 },
	{ 448.5, 1.2899, 127.4718 },
	{ 546.4, 2.1268, 350.3321 },
	{ 478.1, 2.9649, 137.0330 },
	{ 354.9, 3.0129, 838.9693 },
	{ 451.8, 1.0444, 490.3341 },
	{ 347.4, 1.5393, 340.7709 },
	{ 343.5, 0.2460, 0.5213 },
	{ 309.0, 3.4949, 216.4805 },
	{ 322.2, 0.9614, 203.7379 },
	{ 372.3, 2.2782, 217.2312 },
	{ 321.5, 2.5718, 647.0108 },
	{ 330.2, 0.2472, 1581.9593 },
	{ 249.1, 1.4701, 1368.6603 },
	{ 286.7, 2.3704, 351.8166 },
	{ 220.2, 4.2042, 200.7689 },
	{ 277.8, 0.4002, 211.8146 },
	{ 204.5, 6.0108, 265.9893 },
	{ 207.7, 0.4835, 1162.4747 },
	{ 208.7, 1.3452, 625.6702 },
	{ 182.5, 5.4912, 2.9208 },
	{ 226.6, 4.9100, 12.5302 },
	{ 207.7, 1.2830, 39.3569 },
	{ 173.9, 1.8631, 0.7508 },
	{ 184.7, 3.5034, 149.5632 },
	{ 183.5, 0.9725, 4.1928 },
	{ 146.1, 6.2310, 195.1398 },
	{ 164.5, 0.4401, 5.4166 },
	{ 147.5, 1.5353, 5.6291 },
	{ 139.7, 4.2945, 21.3406 },
	{ 131.3, 4.0683, 10.2949 },
	{ 117.3, 2.6792, 1155.3612 },
	{ 149.3, 5.7359, 52.6902 },
	{ 122.4, 1.9759, 4.6659 },
	{ 113.7, 5.5943, 1059.3819 },
	{ 102.7, 1.1975, 1685.0521 },
	{ 118.2, 5.3407, 554.0700 },
	{ 109.3, 3.4381, 536.8045 },
	{ 110.4, 0.1660, 1.4845 },
	{ 125.0, 6.2774, 1898.3512 },
	{ 89.9, 5.804, 114.138 },
	{ 104.0, 2.1921, 88.8657 },
	{ 112.4, 1.1050, 191.2077 },
	{ 106.6, 4.0116, 956.2892 },
	{ 91.4, 1.875, 38.133 },
	{ 83.8, 5.488, 0.112 },
	{ 83.5, 2.290, 628.852 },
	{ 97.0, 4.537, 302.165 },
	{ 100.6, 4.9651, 269.9214 },
	{ 75.5, 2.180, 728.763 },
	{ 96.3, 2.833, 275.551 },
	{ 82.4, 3.055, 440.825 },
	{ 73.9, 5.089, 1375.774 },
	{ 71.6, 5.109, 65.220 },
	{ 70.4, 4.868, 0.212 },
	{ 69.8, 3.710, 14.978 },
	{ 88.8, 3.863, 278.519 },
	{ 68.1, 0.734, 1478.867 },
	{ 66.5, 0.027, 70.849 },
	{ 65.7, 2.022, 142.450 },
	{ 75.8, 1.614, 284.149 },
	{ 63.2, 3.495, 479.288 },
	{ 62.5, 2.587, 422.666 },
	{ 69.3, 3.440, 515.464 },
	{ 79.0, 4.452, 35.425 },
	{ 63.7, 3.317, 62.251 },
	{ 52.9, 5.514, 0.261 },
	{ 53.0, 3.185, 8.077 },
	{ 54.5, 2.457, 22.091 },
	{ 50.5, 4.267, 99.161 },
	{ 55.2, 0.968, 942.062 },
	{ 49.3, 2.386, 1471.753 },
	{ 47.2, 2.025, 312.199 },
	{ 61.1, 1.503, 210.851 },
	{ 45.1, 0.931, 2001.444 },
	{ 60.6, 2.687, 388.465 },
	{ 43.5, 2.526, 288.081 },
	{ 42.5, 3.818, 330.619 },
	{ 39.9, 5.714, 408.439 },
	{ 50.1, 6.032, 2214.743 },
	{ 45.9, 0.542, 212.336 },
	{ 54.2, 0.782, 191.958 },
	{ 47.0, 4.599, 437.644 },
	{ 42.4, 1.901, 430.530 },
	{ 39.7, 1.633, 1066.495 },
	{ 36.3, 0.848, 213.347 },
	{ 35.5, 4.186, 215.747 },
	{ 36.3, 3.933, 213.251 },
	{ 38.0, 0.313, 423.417 },
	{ 44.7, 1.125, 6.150 },
	{ 37.9, 1.198, 2.708 },
	{ 43.4, 1.374, 563.631 },
	{ 43.8, 3.930, 525.498 },
	{ 34.8, 1.016, 203.004 },
	{ 31.8, 1.693, 0.160 },
	{ 30.9, 6.135, 417.037 },
	{ 36.4, 6.006, 18.159 },
	{ 29.0, 1.197, 404.507 },
	{ 32.8, 0.536, 107.025 },
	{ 30.4, 0.723, 222.860 },
	{ 32.6, 0.812, 1795.258 },
	{ 37.8, 3.697, 1272.681 },
	{ 27.7, 1.457, 7.162 },
	{ 27.2, 1.897, 1045.155 },
	{ 37.7, 4.520, 24.379 },
	{ 34.9, 4.461, 214.262 },
	{ 32.6, 0.664, 692.587 },
	{ 30.3, 5.304, 33.940 },
	{ 27.5, 6.227, 1.272 },
	{ 26.7, 4.567, 7.065 },
	{ 31.7, 5.498, 56.622 },
	{ 28.1, 5.644, 128.956 },
	{ 32.0, 5.223, 92.047 },
	{ 27.0, 0.067, 205.222 },
	{ 31.8, 5.592, 6069.777 },
	{ 31.0, 0.372, 703.633 },
	{ 29.4, 0.147, 131.404 },
	{ 26.2, 5.413, 140.002 },
	{ 25.7, 4.360, 32.243 },
	/* 165 terms retained, 987 terms dropped, error 1.4" */

	/* saturn l, T^1 */
	{ 21354295596.0, 0, 0 },
	{ 1296855.0, 1.82820545, 213.29909544 },
	{ 564347.6, 2.8850014, 7.1135470 },
	{ 98323.0, 1.080701, 426.598191 },
	{ 107678.8, 2.2776991, 206.1855484 },
	{ 40254.6, 2.041283, 220.412642 },
	{ 19941.7, 1.279547, 103.092774 },
	{ 10511.7, 2.748804, 14.227094 },
	{ 6939.2, 0.40493, 639.89729 },
	{ 4803.3, 2.44194, 419.48464 },
	{ 4056.3, 2.92167, 110.20632 },
	{ 3768.6, 3.64966, 3.93215 },
	{ 3384.7, 2.41694, 3.18139 },
	{ 3302.2, 1.26256, 433.71174 },
	{ 3071.4, 2.32739, 199.07200 },
	{ 1953.0, 3.56395, 11.04570 },
	{ 1249.3, 2.62804, 95.97923 },
	{ 921.7, 1.9609, 227.5262 },
	{ 705.6, 4.4169, 529.6910 },
	{ 649.7, 6.1742, 202.2534 },
	{ 627.6, 6.1109, 309.2783 },
	{ 486.8, 6.0400, 853.1964 },
	{ 468.4, 4.6171, 63.7359 },
	{ 478.5, 4.9878, 522.5774 },
	{ 417.0, 2.1171, 323.5054 },
	{ 407.6, 1.2995, 209.3669 },
	{ 343.8, 3.9585, 412.3711 },
	{ 339.7, 3.6340, 316.3919 },
	{ 335.9, 3.7717, 735.8765 },
	{ 331.9, 2.8608, 210.1177 },
	{ 352.5, 2.3171, 632.7837 },
	{ 289.4, 2.7326, 117.3199 },
	{ 265.8, 0.5434, 647.0108 },
	{ 230.5, 1.6443, 216.4805 },
	{ 280.9, 5.7440, 2.4477 },
	{ 191.7, 2.9651, 224.3448 },
	{ 172.9, 4.0770, 846.0828 },
	{ 167.1, 2.5975, 21.3406 },
	{ 136.3, 2.2858, 10.2949 },
	{ 131.4, 3.4411, 742.9901 },
	{ 127.8, 4.0953, 217.2312 },
	{ 108.9, 6.1614, 415.5525 },
	{ 93.9, 3.484, 1052.268 },
	{ 92.5, 3.948, 88.866 },
	{ 97.6, 4.728, 838.969 },
	{ 86.6, 1.220, 440.825 },
	{ 83.5, 3.113, 625.670 },
	{ 77.6, 6.244, 302.165 },
	{ 61.6, 1.828, 195.140 },
	{ 61.9, 4.293, 127.472 },
	{ 67.1, 0.290, 4.666 },
	{ 56.9, 5.019, 137.033 },
	{ 54.2, 5.126, 490.334 },
	{ 54.6, 0.284, 74.782 },
	{ 51.4, 1.458, 536.805 },
	{ 65.8, 5.648, 9.561 },
	{ 57.8, 2.476, 191.958 },
	{ 44.4, 2.709, 5.417 },
	{ 46.8, 1.177, 149.563 },
	{ 40.4, 3.889, 728.763 },
	{ 37.8, 2.534, 12.530 },
	{ 46.6, 5.148, 515.464 },
	{ 45.9, 2.232, 956.289 },
	{ 40.4, 0.413, 269.921 },
	{ 37.2, 3.782, 2.921 },
	{ 33.8, 3.211, 1368.660 },
	{ 38.0, 0.647, 422.666 },
	{ 32.9, 0.301, 351.817 },
	{ 33.0, 5.430, 1066.495 },
	{ 30.3, 2.841, 203.004 },
	{ 35.1, 6.084, 5.629 },
	{ 29.7, 3.391, 1059.382 },
	{ 33.2, 4.641, 277.035 },
	{ 31.9, 4.386, 1155.361 },
	{ 28.9, 2.026, 330.619 },
	{ 28.3, 2.742, 265.989 },
	{ 30.1, 6.187, 284.149 },
	{ 31.3, 2.435, 52.690 },
	{ 26.5, 4.512, 340.771 },
	{ 22.0, 5.144, 4.193 },
	{ 22.2, 1.965, 203.738 },
	{ 20.8, 6.160, 860.310 },
	{ 21.7, 2.676, 942.062 },
	{ 22.6, 5.886, 210.851 },
	{ 19.8, 2.313, 437.644 },
	{ 19.4, 4.766, 70.849 },
	{ 19.3, 4.102, 18.159 },
	{ 22.7, 4.137, 191.208 },
	{ 18.2, 0.903, 429.780 },
	{ 17.7, 1.850, 234.640 },
	{ 17.5, 2.447, 423.417 },
	{ 15.4, 4.238, 1162.475 },
	{ 14.6, 3.597, 1045.155 },
	{ 14.1, 2.943, 1685.052 },
	{ 16.3, 4.057, 949.176 },
	{ 13.3, 6.245, 38.133 },
	{ 15.9, 1.064, 56.622 },
	{ 14.1, 1.435, 408.439 },
	{ 13.1, 5.758, 138.517 },
	{ 15.8, 5.594, 6.150 },
	{ 15.0, 5.772, 22.091 },
	{ 16.0, 1.939, 1272.681 },
	{ 16.8, 5.967, 628.852 },
	{ 12.8, 4.247, 405.258 },
	{ 13.6, 4.099, 1471.753 },
	{ 15.1, 0.741, 200.769 },
	{ 11.0, 1.550, 223.594 },
	{ 11.7, 1.812, 124.433 },
	{ 10.3, 3.468, 1375.774 },
	{ 12.1, 1.857, 131.404 },
	{ 10.1, 2.382, 107.025 },
	{ 9.9, 3.95, 430.53 },
	{ 9.8, 2.55, 99.91 },
	{ 10.6, 5.367, 215.747 },
	{ 12.1, 4.845, 831.856 },
	{ 10.2, 6.077, 32.243 },
	{ 9.2, 3.65, 142.45 },
	{ 9.0, 1.24, 106.27 },
	{ 9.3, 5.81, 7.16 },
	{ 9.7, 1.39, 145.63 },
	{ 8.4, 4.42, 703.63 },
	{ 8.4, 5.64, 62.25 },
	{ 8.2, 2.42, 1258.45 },
	{ 7.8, 0.53, 654.12 },
	{ 7.6, 3.75, 312.20 },
	{ 7.2, 0.28, 0.75 },
	{ 8.2, 6.22, 14.98 },
	{ 7.1, 0.53, 388.47 },
	{ 6.6, 3.49, 35.42 },
	{ 9.0, 4.95, 208.63 },
	{ 9.0, 0.08, 288.08 },
	{ 6.4, 3.33, 1361.55 },
	{ 6.5, 2.89, 114.14 },
	{ 6.7, 0.24, 8.08 },
	{ 7.3, 4.85, 222.86 },
	{ 6.3, 3.81, 1788.14 },
	{ 6.9, 2.05, 99.16 },
	{ 6.6, 5.83, 483.22 },
	/* 138 terms retained, 504 terms dropped, error 0.32"*T */

	/* saturn l, T^2 */
	{ 116441.2, 1.1798785, 7.1135470 },
	{ 91920.8, 0.074253, 213.299095 },
	{ 90592.3, 0, 0 },
	{ 15276.9, 4.064920, 206.185548 },
	{ 10631.4, 0.257783, 220.412642 },
	{ 10605.0, 5.409636, 426.598191 },
	{ 4265.4, 1.04596, 14.22709 },
	{ 1215.5, 2.91860, 103.09277 },
	{ 1164.7, 4.60942, 639.89729 },
	{ 1082.0, 5.69130, 433.71174 },
	{ 1020.1, 0.63369, 3.18139 },
	{ 1044.8, 4.04206, 199.07200 },
	{ 633.6, 4.3883, 419.4846 },
	{ 549.3, 5.5730, 3.9322 },
	{ 456.9, 1.2684, 110.2063 },
	{ 425.1, 0.2094, 227.5262 },
	{ 273.7, 4.2884, 95.9792 },
	{ 161.6, 1.3814, 11.0457 },
	{ 129.5, 1.5659, 309.2783 },
	{ 117.0, 3.8812, 853.1964 },
	{ 105.4, 4.9000, 647.0108 },
	{ 101.0, 0.8927, 21.3406 },
	{ 95.2, 5.626, 412.371 },
	{ 81.9, 1.025, 117.320 },
	{ 74.9, 4.762, 210.118 },
	{ 82.7, 6.050, 216.480 },
	{ 95.7, 2.911, 316.392 },
	{ 63.7, 0.352, 323.505 },
	{ 84.9, 5.735, 209.367 },
	{ 60.6, 4.875, 632.784 },
	{ 66.5, 0.483, 10.295 },
	{ 67.2, 0.456, 522.577 },
	{ 53.3, 2.747, 529.691 },
	{ 45.8, 5.693, 440.825 },
	{ 45.3, 1.669, 202.253 },
	{ 42.3, 5.708, 88.866 },
	{ 32.1, 0.071, 63.736 },
	{ 31.6, 1.672, 302.165 },
	{ 31.1, 4.164, 191.958 },
	{ 24.6, 5.656, 735.877 },
	{ 26.6, 0.833, 224.345 },
	{ 20.1, 5.944, 217.231 },
	{ 17.5, 4.900, 625.670 },
	{ 17.1, 1.626, 742.990 },
	{ 13.7, 3.765, 195.140 },
	{ 12.2, 4.718, 203.004 },
	{ 11.9, 0.126, 234.640 },
	{ 16.0, 0.579, 515.464 },
	{ 11.2, 5.922, 536.805 },
	{ 14.1, 0.207, 838.969 },
	{ 11.0, 5.602, 728.763 },
	{ 11.7, 3.121, 846.083 },
	{ 10.0, 4.155, 860.310 },
	{ 10.6, 3.203, 1066.495 },
	{ 10.1, 0.257, 330.619 },
	{ 9.5, 0.46, 956.29 },
	{ 10.2, 4.987, 422.666 },
	{ 8.3, 2.14, 269.92 },
	{ 7.2, 5.40, 1052.27 },
	{ 7.7, 5.25, 429.78 },
	{ 6.4, 4.46, 284.15 },
	{ 5.9, 5.41, 149.56 },
	{ 7.5, 4.03, 9.56 },
	{ 5.8, 4.29, 415.55 },
	{ 6.1, 5.93, 405.26 },
	{ 5.7, 0.02, 124.43 },
	{ 5.7, 6.02, 223.59 },
	{ 4.8, 4.93, 654.12 },
	{ 4.7, 2.27, 18.16 },
	{ 4.5, 4.41, 942.06 },
	{ 5.6, 0.30, 127.47 },
	{ 5.5, 5.54, 949.18 },
	{ 4.1, 4.69, 74.78 },
	{ 4.1, 5.31, 1045.15 },
	{ 4.2, 2.89, 56.62 },
	{ 4.9, 3.20, 277.03 },
	{ 3.9, 3.30, 490.33 },
	{ 3.9, 6.10, 81.75 },
	{ 3.8, 4.93, 52.69 },
	{ 4.6, 6.14, 1155.36 },
	{ 3.7, 0.41, 137.03 },
	{ 3.4, 4.29, 99.91 },
	{ 3.6, 0.20, 1272.68 },
	{ 3.9, 0.37, 12.53 },
	{ 3.2, 1.57, 1059.38 },
	{ 4.1, 0.29, 831.86 },
	{ 3.7, 0.15, 437.64 },
	{ 2.9, 3.13, 70.85 },
	{ 2.8, 0.33, 191.21 },
	{ 2.7, 1.88, 295.05 },
	{ 3.5, 4.77, 423.42 },
	{ 2.6, 5.15, 1368.66 },
	{ 2.5, 3.90, 210.85 },
	{ 2.5, 1.59, 32.24 },
	{ 2.6, 3.59, 131.40 },
	{ 2.3, 4.77, 351.82 },
	{ 2.4, 5.83, 106.27 },
	{ 2.2, 5.98, 6062.66 },
	{ 2.2, 2.06, 6076.89 },
	{ 2.2, 5.95, 145.63 },
	{ 2.7, 3.38, 408.44 },
	{ 2.3, 3.14, 22.09 },
	{ 2.1, 1.12, 9992.87 },
	{ 2.1, 3.48, 10007.10 },
	{ 2.6, 5.12, 265.99 },
	{ 1.8, 4.15, 1258.45 },
	{ 1.8, 5.05, 1361.55 },
	{ 1.8, 4.14, 107.02 },
	{ 1.9, 4.52, 138.52 },
	{ 1.7, 1.36, 231.46 },
	{ 2.0, 5.87, 1471.75 },
	{ 2.1, 5.23, 1265.57 },
	{ 1.6, 5.62, 447.94 },
	{ 1.6, 3.75, 628.85 },
	{ 1.7, 6.24, 1148.25 },
	/* 115 terms retained, 206 terms dropped, error 0.074"*T^2 */

	/* saturn l, T^3 */
	{ 16038.7, 5.739454, 7.113547 },
	{ 4249.8, 4.58540, 213.29910 },
	{ 1906.5, 4.76082, 220.41264 },
	{ 1465.7, 5.91327, 206.18555 },
	{ 1162.0, 5.61973, 14.22709 },
	{ 1066.6, 3.60817, 426.59819 },
	{ 239.4, 3.8609, 433.7117 },
	{ 237.0, 5.7683, 199.0720 },
	{ 165.6, 5.1164, 3.1814 },
	{ 131.4, 4.7433, 227.5262 },
	{ 151.4, 2.7359, 639.8973 },
	{ 61.6, 4.743, 103.093 },
	{ 63.4, 0.229, 419.485 },
	{ 40.4, 5.473, 21.341 },
	{ 40.2, 5.964, 95.979 },
	{ 38.7, 5.834, 110.206 },
	{ 28.0, 3.012, 647.011 },
	{ 25.0, 0.988, 3.932 },
	{ 18.1, 1.025, 412.371 },
	{ 17.9, 3.319, 309.278 },
	{ 16.2, 3.898, 440.825 },
	{ 15.8, 5.617, 117.320 },
	{ 19.0, 1.916, 853.196 },
	{ 18.3, 4.967, 10.295 },
	{ 12.9, 1.181, 88.866 },
	{ 17.9, 4.204, 216.480 },
	{ 11.5, 5.575, 11.046 },
	{ 10.5, 5.929, 191.958 },
	{ 10.4, 3.948, 209.367 },
	{ 8.7, 3.39, 302.16 },
	{ 7.6, 4.88, 323.51 },
	{ 6.7, 0.38, 632.78 },
	{ 5.9, 1.06, 210.12 },
	{ 5.4, 4.64, 234.64 },
	{ 6.3, 2.25, 522.58 },
	{ 3.6, 2.31, 515.46 },
	{ 3.2, 2.20, 860.31 },
	{ 3.7, 3.14, 0 },
	{ 2.6, 4.93, 224.34 },
	{ 2.5, 0.42, 625.67 },
	{ 2.2, 3.20, 202.25 },
	{ 2.4, 4.77, 330.62 },
	{ 2.9, 0.59, 529.69 },
	{ 2.0, 4.40, 124.43 },
	{ 2.2, 1.35, 405.26 },
	{ 2.3, 3.35, 429.78 },
	{ 2.0, 3.07, 654.12 },
	{ 2.0, 1.03, 728.76 },
	{ 1.9, 3.09, 422.67 },
	{ 1.8, 4.15, 536.80 },
	{ 2.2, 1.19, 1066.50 },
	{ 2.1, 4.16, 223.59 },
	{ 1.5, 0.38, 316.39 },
	{ 1.7, 5.83, 195.14 },
	{ 1.5, 1.58, 81.75 },
	{ 1.6, 6.04, 742.99 },
	{ 1.3, 1.66, 63.74 },
	{ 1.3, 5.02, 956.29 },
	{ 1.4, 2.11, 838.97 },
	{ 1.2, 3.88, 269.92 },
	{ 1.0, 3.73, 295.05 },
	{ 1.3, 1.38, 735.88 },
	{ 1.3, 2.33, 217.23 },
	{ 0.9, 2.76, 284.15 },
	{ 0.9, 0.71, 846.08 },
	{ 0.9, 3.84, 447.94 },
	{ 0.9, 3.31, 18.16 },
	{ 0.8, 4.71, 56.62 },
	{ 0.9, 2.02, 831.86 },
	{ 0.8, 0.80, 1045.15 },
	{ 0.7, 4.27, 437.64 },
	{ 0.7, 6.18, 942.06 },
	{ 0.8, 2.41, 203.00 },
	{ 0.7, 1.65, 423.42 },
	{ 0.5, 2.86, 184.84 },
	{ 0.5, 6.26, 1059.38 },
	{ 0.5, 3.43, 149.56 },
	{ 0.5, 4.88, 1272.68 },
	{ 0.4, 5.40, 408.44 },
	{ 0.4, 4.06, 543.92 },
	{ 0.4, 1.69, 1155.36 },
	{ 0.4, 1.22, 1052.27 },
	/* 82 terms retained, 66 terms dropped, error 0.015"*T^3 */

	/* saturn l, T^4 */
	{ 1661.9, 3.99826, 7.11355 },
	{ 257.1, 2.9844, 220.4126 },
	{ 236.3, 3.9024, 14.2271 },
	{ 149.4, 2.7411, 213.2991 },
	{ 109.6, 1.5152, 206.1855 },
	{ 114.0, 3.1416, 0 },
	{ 68.4, 1.721, 426.598 },
	{ 37.7, 1.238, 199.072 },
	{ 40.1, 2.046, 433.712 },
	{ 31.2, 3.011, 227.526 },
	{ 15.1, 0.829, 639.897 },
	{ 9.4, 3.71, 21.34 },
	{ 5.7, 2.42, 419.48 },
	{ 4.5, 1.45, 95.98 },
	{ 5.6, 1.16, 647.01 },
	{ 4.5, 2.12, 440.83 },
	{ 3.2, 4.09, 110.21 },
	{ 2.9, 2.77, 412.37 },
	{ 2.8, 3.01, 88.87 },
	{ 2.6, 0.00, 853.20 },
	{ 2.6, 0.39, 103.09 },
	{ 1.9, 5.08, 309.28 },
	{ 2.2, 3.78, 117.32 },
	{ 1.8, 5.19, 302.16 },
	{ 1.9, 2.83, 234.64 },
	{ 1.8, 2.24, 216.48 },
	{ 1.2, 1.55, 191.96 },
	{ 0.8, 3.45, 323.51 },
	{ 0.8, 4.83, 210.12 },
	{ 0.6, 4.19, 515.46 },
	{ 0.6, 2.29, 209.37 },
	{ 0.6, 4.03, 522.58 },
	{ 0.6, 2.38, 632.78 },
	{ 0.6, 0.30, 860.31 },
	{ 0.6, 2.17, 124.43 },
	{ 0.4, 2.24, 447.94 },
	{ 0.4, 5.45, 1066.50 },
	{ 0.5, 1.27, 654.12 },
	{ 0.5, 3.20, 405.26 },
	{ 0.4, 3.12, 330.62 },
	{ 0.4, 3.39, 81.75 },
	{ 0.3, 4.12, 838.97 },
	{ 0.3, 3.18, 529.69 },
	{ 0.3, 1.41, 429.78 },
	{ 0.3, 3.19, 1464.64 },
	{ 0.3, 2.94, 728.76 },
	{ 0.2, 3.67, 1148.25 },
	{ 0.3, 2.58, 1045.15 },
	{ 0.2, 3.58, 1155.36 },
	{ 0.3, 2.05, 1677.94 },
	{ 0.2, 2.62, 536.80 },
	{ 0.3, 2.48, 625.67 },
	{ 0.2, 4.39, 1574.85 },
	{ 0.2, 1.26, 422.67 },
	{ 0.2, 2.33, 223.59 },
	{ 0.2, 1.09, 742.99 },
	{ 0.2, 0.70, 824.74 },
	{ 0.2, 5.03, 203.00 },
	{ 0.2, 0.40, 867.42 },
	{ 0.2, 3.68, 831.86 },
	{ 0.2, 5.75, 1073.61 },
	{ 0.2, 3.02, 1781.03 },
	{ 0.1, 2.28, 295.05 },
	{ 0.1, 3.48, 956.29 },
	{ 0.2, 1.91, 942.06 },
	{ 0.1, 6.17, 316.39 },
	/* 66 terms retained, 2 terms dropped, error 0.0049"*T^4 */

	/* saturn l, T^5 */
	{ 123.6, 2.2592, 7.1135 },
	{ 34.2, 2.163, 14.227 },
	{ 27.5, 1.199, 220.413 },
	{ 5.8, 1.22, 227.53 },
	{ 5.3, 0.24, 433.71 },
	{ 3.7, 6.23, 426.60 },
	{ 3.1, 2.97, 199.07 },
	{ 2.9, 4.29, 206.19 },
	{ 1.6, 6.25, 213.30 },
	{ 1.3, 5.28, 639.90 },
	{ 0.9, 5.57, 647.01 },
	{ 0.8, 6.18, 191.96 },
	{ 0.8, 0.69, 302.16 },
	{ 1.0, 0.24, 440.83 },
	{ 1.0, 3.14, 0 },
	{ 0.5, 4.88, 88.87 },
	{ 0.5, 4.78, 419.48 },
	{ 0.3, 4.32, 853.20 },
	{ 0.4, 5.70, 654.12 },
	{ 0.2, 2.05, 323.51 },
	{ 0.3, 1.11, 234.64 },
	{ 0.2, 0.89, 309.28 },
	{ 0.3, 5.10, 95.98 },
	{ 0.2, 2.40, 515.46 },
	{ 0.2, 4.70, 860.31 },
	{ 0.1, 0.49, 117.32 },
	/* 26 terms retained, 1 terms dropped, error 0.0022"*T^5 */
	/* end saturn l */

	/* saturn b, T^0 */
	{ 4330678.0, 3.60284428, 213.29909544 },
	{ 240348.3, 2.8523849, 426.5981909 },
	{ 84745.9, 0, 0 },
	{ 30863.4, 3.484415, 220.412642 },
	{ 34116.1, 0.572973, 206.185548 },
	{ 14734.1, 2.118466, 639.897286 },
	{ 9916.7, 5.79003, 419.48464 },
	{ 6993.6, 4.73605, 7.11355 },
	{ 4807.6, 5.43305, 316.39187 },
	{ 4788.4, 4.96513, 110.20632 },
	{ 3432.1, 2.73256, 433.71174 },
	{ 1506.1, 6.01305, 103.09277 },
	{ 1060.3, 5.63099, 529.69097 },
	{ 969.1, 5.2043, 632.7837 },
	{ 942.1, 1.3965, 853.1964 },
	{ 707.6, 3.8030, 323.5054 },
	{ 552.3, 5.1315, 202.2534 },
	{ 399.7, 3.3589, 227.5262 },
	{ 316.1, 1.9972, 647.0108 },
	{ 319.4, 3.6257, 209.3669 },
	{ 284.5, 4.8865, 224.3448 },
	{ 314.2, 0.4651, 217.2312 },
	{ 236.4, 2.1389, 11.0457 },
	{ 215.4, 5.9498, 846.0828 },
	{ 208.5, 2.1200, 415.5525 },
	{ 179.0, 2.9536, 63.7359 },
	{ 207.2, 0.7302, 199.0720 },
	{ 139.1, 1.9982, 735.8765 },
	{ 134.9, 5.2450, 742.9901 },
	{ 140.6, 0.6442, 490.3341 },
	{ 121.7, 3.1154, 522.5774 },
	{ 139.2, 4.5954, 14.2271 },
	{ 115.5, 3.1089, 216.4805 },
	{ 114.2, 0.9626, 210.1177 },
	{ 96.4, 4.482, 117.320 },
	{ 80.6, 1.317, 277.035 },
	{ 73.0, 3.060, 536.805 },
	{ 69.3, 4.924, 309.278 },
	{ 74.3, 2.894, 149.563 },
	{ 68.0, 2.180, 351.817 },
	{ 61.7, 0.677, 1066.495 },
	{ 56.6, 2.610, 440.825 },
	{ 48.9, 5.787, 95.979 },
	{ 48.2, 2.182, 74.782 },
	{ 38.3, 5.292, 1059.382 },
	{ 36.3, 1.633, 628.852 },
	{ 35.1, 1.713, 1052.268 },
	{ 34.3, 2.457, 422.666 },
	{ 34.3, 5.980, 412.371 },
	{ 33.8, 1.141, 949.176 },
	{ 31.6, 4.147, 437.644 },
	{ 36.8, 6.278, 1162.475 },
	{ 27.0, 1.272, 860.310 },
	/* 53 terms retained, 447 terms dropped, error 0.82" */

	/* saturn b, T^1 */
	{ 397555.0, 5.3328999, 213.2990954 },
	{ 49478.6, 3.141593, 0 },
	{ 18571.6, 6.099192, 426.598191 },
	{ 14800.6, 2.305861, 206.185548 },
	{ 9644.0, 1.69675, 220.41264 },
	{ 3757.2, 1.25430, 419.48464 },
	{ 2716.6, 5.91167, 639.89729 },
	{ 1455.3, 0.85162, 433.71174 },
	{ 1290.6, 2.91771, 7.11355 },
	{ 852.6, 0.4357, 316.3919 },
	{ 284.4, 1.6188, 227.5262 },
	{ 292.2, 5.3157, 853.1964 },
	{ 275.1, 3.8886, 103.0928 },
	{ 297.7, 0.9191, 632.7837 },
	{ 172.4, 0.0522, 647.0108 },
	{ 127.7, 1.2071, 529.6910 },
	{ 166.2, 2.4435, 199.0720 },
	{ 158.2, 5.2085, 110.2063 },
	{ 109.8, 2.4570, 217.2312 },
	{ 81.8, 2.758, 210.118 },
	{ 81.0, 2.860, 14.227 },
	{ 68.7, 1.655, 202.253 },
	{ 59.3, 1.824, 323.505 },
	{ 65.2, 1.255, 216.480 },
	{ 61.0, 1.253, 209.367 },
	{ 46.4, 0.815, 440.825 },
	{ 36.2, 1.819, 224.345 },
	{ 34.0, 2.840, 117.320 },
	{ 32.2, 1.187, 846.083 },
	{ 33.1, 1.306, 412.371 },
	{ 27.3, 4.647, 1066.495 },
	{ 22.8, 4.129, 415.552 },
	{ 27.1, 4.442, 11.046 },
	{ 18.1, 5.564, 860.310 },
	{ 20.9, 1.410, 309.278 },
	{ 14.9, 1.343, 95.979 },
	{ 15.3, 1.224, 63.736 },
	{ 14.6, 1.008, 536.805 },
	{ 12.8, 2.271, 742.990 },
	{ 12.8, 4.889, 522.577 },
	{ 13.1, 2.460, 490.334 },
	{ 11.9, 1.873, 423.417 },
	{ 13.0, 3.217, 277.035 },
	{ 9.9, 3.12, 625.67 },
	{ 12.7, 0.295, 422.666 },
	{ 9.6, 1.75, 330.62 },
	{ 8.1, 2.42, 430.53 },
	{ 8.2, 4.68, 215.75 },
	{ 9.0, 0.46, 429.78 },
	{ 6.5, 3.01, 949.18 },
	{ 7.3, 5.97, 149.56 },
	{ 6.6, 3.91, 351.82 },
	{ 6.8, 1.52, 437.64 },
	/* 53 terms retained, 207 terms dropped, error 0.21"*T */

	/* saturn b, T^2 */
	{ 20630.0, 0.504824, 213.299095 },
	{ 3719.6, 3.99833, 206.18555 },
	{ 1627.2, 6.18190, 220.41264 },
	{ 1346.1, 0, 0 },
	{ 705.8, 3.0391, 419.4846 },
	{ 365.0, 5.0993, 426.5982 },
	{ 329.6, 5.2790, 433.7117 },
	{ 219.3, 3.8284, 639.8973 },
	{ 139.4, 1.0427, 7.1135 },
	{ 104.0, 6.1573, 227.5262 },
	{ 93.0, 1.980, 316.392 },
	{ 71.2, 4.148, 199.072 },
	{ 51.9, 2.884, 632.784 },
	{ 49.0, 4.434, 647.011 },
	{ 41.4, 3.159, 853.196 },
	{ 28.6, 4.530, 210.118 },
	{ 24.0, 1.116, 14.227 },
	{ 20.5, 4.351, 217.231 },
	{ 19.5, 5.308, 440.825 },
	{ 18.3, 0.854, 110.206 },
	{ 15.7, 4.258, 103.093 },
	{ 16.8, 5.681, 216.480 },
	{ 13.6, 2.999, 412.371 },
	{ 11.6, 2.527, 529.691 },
	{ 8.0, 3.32, 202.25 },
	{ 6.6, 0.29, 323.51 },
	{ 6.3, 1.16, 117.32 },
	{ 5.9, 3.58, 309.28 },
	{ 6.6, 5.56, 209.37 },
	{ 5.6, 2.48, 1066.50 },
	{ 6.2, 3.61, 860.31 },
	{ 4.2, 3.02, 846.08 },
	{ 3.6, 4.80, 625.67 },
	{ 3.4, 3.77, 423.42 },
	{ 3.4, 6.04, 234.64 },
	{ 2.6, 5.64, 735.88 },
	{ 2.8, 4.82, 429.78 },
	{ 2.8, 4.48, 654.12 },
	{ 2.6, 0.22, 522.58 },
	{ 2.6, 3.29, 95.98 },
	{ 2.4, 0.03, 415.55 },
	{ 2.1, 4.56, 422.67 },
	{ 2.3, 6.25, 330.62 },
	{ 1.8, 5.53, 536.80 },
	{ 1.8, 5.06, 277.03 },
	{ 1.6, 5.54, 224.34 },
	/* 46 terms retained, 65 terms dropped, error 0.045"*T^2 */

	/* saturn b, T^3 */
	{ 666.3, 1.9901, 213.2991 },
	{ 632.4, 5.6978, 206.1855 },
	{ 398.1, 0, 0 },
	{ 187.8, 4.3378, 220.4126 },
	{ 91.9, 4.841, 419.485 },
	{ 42.4, 2.381, 426.598 },
	{ 51.5, 3.421, 433.712 },
	{ 25.7, 4.402, 227.526 },
	{ 20.6, 5.853, 199.072 },
	{ 18.1, 1.993, 639.897 },
	{ 10.9, 5.373, 7.114 },
	{ 9.6, 2.55, 647.01 },
	{ 7.1, 3.46, 316.39 },
	{ 6.0, 4.80, 632.78 },
	{ 5.8, 0.02, 210.12 },
	{ 4.9, 5.64, 14.23 },
	{ 4.5, 1.22, 853.20 },
	{ 5.5, 3.52, 440.83 },
	{ 3.5, 4.71, 412.37 },
	{ 2.9, 0.63, 103.09 },
	{ 2.2, 3.72, 216.48 },
	{ 2.0, 6.11, 217.23 },
	{ 1.4, 1.69, 860.31 },
	{ 1.2, 4.31, 234.64 },
	{ 1.2, 5.75, 309.28 },
	{ 0.8, 5.69, 117.32 },
	{ 0.7, 0.60, 1066.50 },
	{ 0.7, 0.22, 625.67 },
	{ 0.8, 5.48, 202.25 },
	{ 0.9, 2.66, 654.12 },
	{ 0.5, 2.86, 429.78 },
	{ 0.5, 4.18, 529.69 },
	{ 0.5, 4.52, 323.51 },
	/* 33 terms retained, 25 terms dropped, error 0.012"*T^3 */

	/* saturn b, T^4 */
	{ 80.4, 1.119, 206.186 },
	{ 31.7, 3.122, 213.299 },
	{ 17.1, 2.481, 220.413 },
	{ 11.8, 3.142, 0 },
	{ 9.0, 0.38, 419.48 },
	{ 6.2, 1.56, 433.71 },
	{ 4.7, 1.28, 199.07 },
	{ 4.8, 2.63, 227.53 },
	{ 1.5, 1.43, 426.60 },
	{ 1.4, 0.67, 647.01 },
	{ 1.1, 6.18, 639.90 },
	{ 1.1, 1.72, 440.83 },
	{ 0.7, 3.85, 14.23 },
	{ 0.7, 3.49, 7.11 },
	{ 0.5, 0.47, 632.78 },
	{ 0.5, 0.31, 412.37 },
	{ 0.3, 5.86, 853.20 },
	{ 0.3, 2.50, 234.64 },
	{ 0.2, 5.39, 316.39 },
	{ 0.2, 2.11, 210.12 },
	{ 0.2, 6.10, 860.31 },
	{ 0.2, 5.95, 216.48 },
	{ 0.1, 1.99, 625.67 },
	{ 0.1, 0.86, 654.12 },
	{ 0.1, 5.04, 117.32 },
	{ 0.1, 0.45, 110.21 },
	/* 26 terms retained, 0 terms dropped, error 0.0025"*T^4 */

	/* saturn b, T^5 */
	{ 7.9, 2.82, 206.19 },
	{ 1.0, 0.51, 220.41 },
	{ 0.8, 2.99, 199.07 },
	{ 1.0, 3.14, 0 },
	{ 0.6, 5.96, 433.71 },
	{ 0.6, 0.78, 227.53 },
	{ 0.4, 2.39, 419.48 },
	{ 0.1, 5.11, 647.01 },
	/* 8 terms retained, 3 terms dropped, error 0.0012"*T^5 */
	/* end saturn b */

	/* saturn r, T^0 */
	{ 955758135.8, 0, 0 },
	{ 52921382.5, 2.392262197, 213.299095438 },
	{ 1873679.9, 5.23549605, 206.18554844 },
	{ 1464664.0, 1.64763045, 426.59819088 },
	{ 821891.1, 5.9352003, 316.3918697 },
	{ 547506.9, 5.0153263, 103.0927742 },
	{ 371684.4, 2.2711483, 220.4126424 },
	{ 361778.4, 3.1390430, 7.1135470 },
	{ 140617.5, 5.7040665, 632.7837393 },
	{ 108974.7, 3.2931360, 110.2063212 },
	{ 69007.0, 5.940996, 419.484644 },
	{ 61053.3, 0.940378, 639.897286 },
	{ 48913.0, 1.557334, 202.253395 },
	{ 34143.8, 0.195186, 277.034994 },
	{ 32401.7, 5.470846, 949.175609 },
	{ 20936.6, 0.463492, 735.876514 },
	{ 20839.1, 1.521026, 433.711738 },
	{ 20746.7, 5.332557, 199.072001 },
	{ 15298.5, 3.059437, 529.690965 },
	{ 14296.5, 2.604335, 323.505417 },
	{ 11993.3, 5.980514, 846.082835 },
	{ 11380.3, 1.731057, 522.577418 },
	{ 12884.1, 1.648923, 138.517497 },
	{ 7752.8, 5.85191, 95.97923 },
	{ 9796.1, 5.20476, 1265.56748 },
	{ 6466.0, 0.17733, 1052.26838 },
	{ 6770.6, 3.00433, 14.22709 },
	{ 5850.4, 1.45520, 415.55249 },
	{ 5307.5, 0.59738, 63.73590 },
	{ 4695.7, 2.14919, 227.52619 },
	{ 4044.0, 1.64010, 209.36694 },
	{ 3688.1, 0.78016, 412.37110 },
	{ 3376.5, 3.69528, 224.34480 },
	{ 2885.3, 1.38764, 838.96929 },
	{ 2976.0, 5.68468, 210.11770 },
	{ 3419.6, 4.94549, 1581.95935 },
	{ 3460.9, 1.85089, 175.16606 },
	{ 3400.6, 0.55387, 350.33212 },
	{ 2507.6, 3.53852, 742.99006 },
	{ 2448.3, 6.18412, 1368.66025 },
	{ 2406.1, 2.96559, 117.31987 },
	{ 2881.2, 0.17961, 853.19638 },
	{ 2174.0, 0.01509, 340.77089 },
	{ 2024.5, 5.05411, 11.04570 },
	{ 1740.3, 2.34657, 309.27832 },
	{ 1861.4, 5.93362, 625.67019 },
	{ 1888.4, 0.02968, 3.93215 },
	{ 1610.9, 1.17302, 74.78160 },
	{ 1462.6, 1.92588, 216.48049 },
	{ 1474.5, 5.67670, 203.73787 },
	{ 1395.1, 5.93669, 127.47180 },
	{ 1781.2, 0.76314, 217.23125 },
	{ 1817.2, 5.77713, 490.33409 },
	{ 1472.4, 1.40065, 137.03302 },
	{ 1304.1, 0.77236, 647.01083 },
	{ 1149.8, 5.74021, 1162.47470 },
	{ 1126.7, 4.46708, 265.98929 },
	{ 1277.5, 2.98413, 1059.38193 },
	{ 1207.1, 0.75286, 351.81659 },
	{ 1071.4, 1.13567, 1155.36116 },
	{ 1020.9, 5.91234, 1685.05212 },
	{ 1315.0, 5.11203, 211.81462 },
	{ 1295.6, 4.69184, 1898.35122 },
	{ 1099.0, 1.81765, 149.56320 },
	{ 998.5, 2.6313, 200.7689 },
	{ 985.9, 2.2599, 956.2892 },
	{ 932.4, 3.6698, 554.0700 },
	{ 664.5, 0.6030, 728.7630 },
	{ 659.8, 4.6664, 195.1398 },
	{ 617.7, 5.6209, 942.0621 },
	{ 626.4, 5.9421, 1478.8666 },
	{ 482.2, 1.8407, 479.2884 },
	{ 487.7, 2.7937, 3.1814 },
	{ 470.1, 0.8385, 1471.7530 },
	{ 451.8, 5.6447, 2001.4440 },
	{ 553.1, 3.4109, 269.9214 },
	{ 534.4, 1.2644, 275.5505 },
	{ 472.6, 1.8820, 515.4639 },
	{ 405.4, 1.6400, 536.8045 },
	{ 517.2, 4.4431, 2214.7431 },
	{ 452.8, 3.0035, 302.1648 },
	{ 494.3, 2.2863, 278.5195 },
	{ 489.8, 5.8063, 191.2077 },
	{ 427.5, 0.0574, 284.1485 },
	{ 339.8, 1.4020, 440.8253 },
	{ 340.6, 0.8909, 628.8516 },
	{ 386.0, 1.9970, 1272.6810 },
	{ 288.3, 1.1216, 422.6660 },
	{ 294.4, 0.4258, 312.1991 },
	{ 262.5, 0.3175, 1045.1548 },
	{ 295.3, 0.6714, 88.8657 },
	{ 343.0, 5.8560, 1795.2584 },
	{ 341.1, 2.3759, 525.4982 },
	{ 234.0, 4.2276, 114.1385 },
	{ 223.7, 2.2813, 330.6190 },
	{ 275.8, 0.4783, 38.1330 },
	{ 224.6, 0.5475, 1788.1449 },
	{ 303.3, 0.8795, 6069.7768 },
	{ 292.1, 6.2142, 210.8514 },
	{ 226.1, 0.3750, 142.4497 },
	{ 277.3, 5.3192, 692.5875 },
	{ 242.9, 5.3719, 1258.4539 },
	{ 205.6, 0.9576, 288.0807 },
	{ 207.6, 5.3813, 2317.8359 },
	{ 186.8, 6.0359, 404.5068 },
	{ 218.5, 5.2561, 212.3359 },
	{ 222.2, 5.9459, 39.3569 },
	{ 179.7, 4.4105, 408.4389 },
	{ 241.4, 1.1253, 388.4652 },
	{ 197.1, 3.9014, 52.6902 },
	{ 236.6, 0.9080, 1375.7738 },
	{ 171.9, 5.5632, 213.3473 },
	{ 169.9, 2.8567, 99.1606 },
	{ 214.4, 4.2025, 2531.1350 },
	{ 172.0, 2.3654, 213.2509 },
	{ 165.7, 2.6368, 215.7468 },
	{ 230.9, 5.4946, 191.9585 },
	{ 177.6, 0.3816, 430.5303 },
	{ 191.5, 2.9591, 437.6439 },
	{ 163.2, 3.4583, 617.8059 },
	{ 162.3, 5.7305, 203.0042 },
	{ 175.1, 5.7140, 1066.4955 },
	{ 183.0, 5.6685, 2111.6503 },
	{ 150.1, 4.4066, 417.0370 },
	{ 187.9, 6.0792, 563.6312 },
	{ 145.1, 5.0818, 423.4168 },
	{ 137.5, 5.4391, 222.8603 },
	{ 172.8, 1.8492, 1589.0729 },
	{ 165.5, 2.8913, 214.2623 },
	{ 145.7, 1.5657, 831.8557 },
	{ 176.9, 2.3032, 9999.9865 },
	{ 128.9, 2.5534, 414.0680 },
	{ 120.1, 0.0433, 1361.5467 },
	{ 143.4, 0.9982, 76.2661 },
	{ 108.7, 2.0928, 207.6700 },
	{ 132.1, 2.8590, 312.4597 },
	{ 112.2, 0.2622, 2104.5368 },
	{ 125.2, 4.7835, 205.2223 },
	{ 104.4, 3.6367, 65.2204 },
	{ 107.4, 3.6706, 212.7778 },
	{ 108.6, 2.8549, 21.3406 },
	{ 97.7, 5.122, 2634.228 },
	{ 109.1, 1.6323, 208.6332 },
	{ 96.9, 4.199, 305.346 },
	{ 96.5, 2.560, 1692.166 },
	{ 85.8, 4.545, 210.378 },
	{ 99.2, 5.138, 1574.846 },
	{ 112.5, 5.0311, 703.6332 },
	{ 84.0, 1.183, 429.780 },
	{ 89.0, 5.388, 107.025 },
	{ 110.2, 2.4366, 355.7487 },
	{ 90.7, 4.209, 213.820 },
	{ 95.9, 5.446, 2428.042 },
	{ 94.1, 2.398, 483.221 },
	{ 85.6, 0.034, 860.310 },
	{ 88.8, 4.058, 128.956 },
	{ 82.0, 1.665, 62.251 },
	{ 91.2, 3.969, 2847.527 },
	{ 84.0, 4.608, 177.874 },
	{ 88.4, 3.868, 140.002 },
	{ 93.3, 0.738, 831.105 },
	{ 91.9, 2.950, 35.425 },
	{ 87.1, 1.334, 1905.465 },
	{ 96.6, 4.844, 131.404 },
	{ 71.0, 0.993, 405.258 },
	{ 95.3, 2.515, 2.448 },
	{ 72.5, 4.632, 245.542 },
	{ 82.6, 1.528, 145.631 },
	{ 76.7, 3.152, 767.369 },
	{ 70.3, 4.043, 173.942 },
	{ 86.0, 2.301, 85.827 },
	{ 66.5, 4.751, 70.849 },
	{ 65.8, 2.469, 280.967 },
	{ 64.8, 0.093, 9.561 },
	{ 71.6, 0.012, 565.116 },
	{ 66.5, 1.080, 339.286 },
	{ 63.5, 2.017, 234.640 },
	{ 60.8, 5.120, 756.323 },
	{ 58.1, 6.057, 1677.939 },
	{ 64.2, 1.286, 1148.248 },
	{ 73.1, 4.378, 425.114 },
	{ 55.0, 3.859, 342.255 },
	{ 57.1, 6.267, 2420.929 },
	{ 64.1, 4.099, 327.438 },
	{ 55.3, 1.605, 543.024 },
	{ 58.0, 5.473, 347.884 },
	{ 73.6, 3.723, 92.047 },
	{ 73.8, 3.570, 1.484 },
	{ 64.9, 2.447, 267.474 },
	{ 54.4, 3.715, 344.703 },
	{ 49.8, 3.935, 192.692 },
	{ 49.5, 3.228, 333.657 },
	{ 47.5, 3.929, 199.284 },
	{ 49.4, 4.903, 217.492 },
	{ 62.7, 4.401, 214.784 },
	{ 46.4, 2.094, 212.548 },
	{ 46.3, 2.640, 10.295 },
	{ 54.3, 1.072, 362.862 },
	{ 58.7, 2.623, 225.829 },
	{ 48.5, 3.152, 216.220 },
	{ 46.3, 4.862, 2950.620 },
	{ 46.0, 4.973, 198.321 },
	{ 46.7, 2.450, 207.149 },
	{ 44.9, 1.776, 223.594 },
	{ 44.5, 5.560, 264.505 },
	{ 55.9, 4.295, 329.725 },
	{ 49.6, 5.208, 2744.434 },
	{ 58.8, 4.231, 700.664 },
	{ 52.6, 3.792, 343.219 },
	{ 41.5, 0.745, 125.987 },
	{ 47.8, 2.393, 207.882 },
	{ 56.2, 2.072, 124.433 },
	{ 43.3, 1.837, 106.274 },
	{ 39.8, 4.009, 12.530 },
	{ 53.9, 4.979, 134.585 },
	{ 50.1, 5.759, 320.324 },
	{ 45.0, 5.357, 218.928 },
	{ 41.1, 4.923, 1891.238 },
	{ 46.5, 2.066, 2008.558 },
	{ 42.9, 0.399, 357.446 },
	{ 38.0, 2.065, 247.239 },
	{ 48.7, 5.328, 3127.313 },
	{ 34.6, 5.626, 99.911 },
	{ 41.1, 2.473, 237.678 },
	{ 40.8, 4.084, 621.738 },
	{ 34.2, 0.731, 750.104 },
	{ 34.0, 5.313, 206.234 },
	{ 36.5, 1.688, 22.091 },
	{ 39.4, 3.457, 241.610 },
	{ 34.8, 2.248, 487.365 },
	{ 33.0, 4.866, 209.106 },
	{ 32.6, 2.227, 319.573 },
	{ 39.0, 3.739, 3163.919 },
	{ 32.7, 1.066, 252.656 },
	{ 38.7, 4.396, 18.159 },
	{ 34.5, 1.826, 380.128 },
	{ 41.5, 0.081, 210.330 },
	{ 33.5, 5.805, 251.432 },
	{ 31.2, 1.965, 244.319 },
	{ 30.5, 2.269, 1169.588 },
	{ 34.8, 5.963, 217.965 },
	{ 38.5, 4.437, 160.609 },
	{ 36.0, 3.833, 56.622 },
	{ 31.0, 4.899, 144.147 },
	{ 32.3, 3.582, 231.458 },
	{ 28.8, 5.801, 1994.330 },
	{ 32.2, 2.132, 206.137 },
	{ 32.6, 1.931, 98.900 },
	{ 34.9, 5.653, 497.448 },
	{ 28.9, 2.217, 14.978 },
	{ 31.6, 3.818, 73.297 },
	{ 32.2, 0.998, 1464.639 },
	{ 29.2, 5.984, 2737.321 },
	{ 36.7, 4.755, 348.848 },
	{ 28.7, 1.687, 78.714 },
	{ 27.5, 6.121, 214.050 },
	{ 28.8, 0.044, 5.629 },
	{ 27.2, 0.246, 313.210 },
	{ 32.4, 3.779, 33.940 },
	{ 27.1, 5.203, 148.079 },
	{ 35.0, 3.439, 273.103 },
	{ 33.1, 2.447, 969.622 },
	{ 27.7, 1.446, 258.876 },
	{ 27.2, 4.259, 179.359 },
	{ 27.9, 0.788, 546.956 },
	{ 29.1, 4.839, 905.887 },
	{ 27.4, 2.449, 254.944 },
	{ 34.3, 6.009, 166.829 },
	{ 28.9, 6.029, 188.920 },
	{ 26.0, 0.650, 654.124 },
	{ 33.6, 1.237, 2221.857 },
	{ 27.8, 5.178, 5.417 },
	{ 25.6, 3.359, 0.963 },
	{ 28.8, 0.755, 488.850 },
	{ 31.2, 2.053, 282.452 },
	{ 25.4, 5.290, 636.716 },
	{ 25.3, 4.970, 3060.826 },
	{ 29.6, 3.927, 206.707 },
	{ 28.3, 2.721, 32.243 },
	{ 26.9, 2.863, 24.379 },
	{ 28.3, 4.731, 552.586 },
	{ 25.3, 5.120, 168.053 },
	{ 26.4, 1.593, 491.819 },
	{ 27.1, 5.537, 555.554 },
	{ 27.3, 3.579, 561.184 },
	{ 25.2, 1.781, 182.280 },
	{ 25.6, 1.621, 2324.949 },
	{ 25.6, 2.099, 248.724 },
	/* 288 terms retained, 917 terms dropped, error 8.7e-06 a.u. */

	/* saturn r, T^1 */
	{ 6182981.3, 0.25843515, 213.29909544 },
	{ 506577.6, 0.7111465, 206.1855484 },
	{ 341394.1, 5.7963577, 426.5981909 },
	{ 188491.4, 0.4721572, 220.4126424 },
	{ 186261.5, 3.1415927, 0 },
	{ 143891.2, 1.4074486, 7.1135470 },
	{ 49621.1, 6.017445, 103.092774 },
	{ 20928.2, 5.092457, 639.897286 },
	{ 19952.6, 1.175601, 419.484644 },
	{ 18839.6, 1.608196, 110.206321 },
	{ 12892.8, 5.943303, 433.711738 },
	{ 13876.6, 0.758862, 199.072001 },
	{ 5396.7, 1.28852, 14.22709 },
	{ 4869.3, 0.86794, 323.50542 },
	{ 4247.5, 0.39299, 227.52619 },
	{ 3252.1, 1.25853, 95.97923 },
	{ 2856.0, 2.16731, 735.87651 },
	{ 2909.4, 4.60679, 202.25340 },
	{ 3081.4, 3.43663, 522.57742 },
	{ 1987.7, 2.45054, 412.37110 },
	{ 1941.3, 6.02393, 209.36694 },
	{ 1581.4, 1.29192, 210.11770 },
	{ 1339.5, 4.30802, 853.19638 },
	{ 1315.6, 1.25296, 117.31987 },
	{ 1203.1, 1.86655, 316.39187 },
	{ 1091.1, 0.07527, 216.48049 },
	{ 954.4, 5.1517, 647.0108 },
	{ 966.0, 0.4799, 632.7837 },
	{ 881.8, 1.8847, 1052.2684 },
	{ 874.2, 1.4022, 224.3448 },
	{ 897.5, 0.9834, 529.6910 },
	{ 784.9, 3.0638, 838.9693 },
	{ 739.9, 1.3823, 625.6702 },
	{ 613.0, 3.0331, 63.7359 },
	{ 658.2, 4.1436, 309.2783 },
	{ 649.6, 1.7249, 742.9901 },
	{ 599.2, 2.5492, 217.2312 },
	{ 502.9, 2.1296, 3.9322 },
	{ 413.0, 4.5933, 415.5525 },
	{ 356.1, 2.3031, 728.7630 },
	{ 344.8, 5.8879, 440.8253 },
	{ 395.0, 0.5335, 956.2892 },
	{ 335.5, 1.6161, 1368.6603 },
	{ 362.8, 4.7069, 302.1648 },
	{ 321.6, 0.9793, 3.1814 },
	{ 277.8, 0.2601, 195.1398 },
	{ 291.2, 2.8313, 1155.3612 },
	{ 265.0, 2.4267, 88.8657 },
	{ 264.9, 5.8286, 149.5632 },
	{ 316.8, 3.5840, 515.4639 },
	{ 294.3, 2.8163, 11.0457 },
	{ 244.9, 1.0449, 942.0621 },
	{ 215.4, 3.5654, 490.3341 },
	{ 264.0, 1.2855, 1059.3819 },
	{ 246.2, 0.9073, 191.9585 },
	{ 222.1, 5.1319, 269.9214 },
	{ 195.0, 4.5667, 846.0828 },
	{ 182.8, 2.6791, 127.4718 },
	{ 181.6, 4.9343, 74.7816 },
	{ 174.7, 3.4456, 137.0330 },
	{ 165.5, 5.9978, 536.8045 },
	{ 154.8, 1.1972, 265.9893 },
	{ 169.7, 4.6346, 284.1485 },
	{ 151.5, 0.5293, 330.6190 },
	{ 152.5, 5.4389, 422.6660 },
	{ 157.7, 2.9956, 340.7709 },
	{ 140.6, 2.0207, 1045.1548 },
	{ 139.8, 1.3528, 1685.0521 },
	{ 141.0, 1.2710, 203.0042 },
	{ 136.0, 5.0168, 351.8166 },
	{ 153.4, 0.2697, 1272.6810 },
	{ 129.5, 1.1434, 21.3406 },
	{ 127.8, 2.5388, 1471.7530 },
	{ 126.5, 3.0031, 277.0350 },
	{ 100.3, 3.6136, 1066.4955 },
	{ 103.2, 0.3818, 203.7379 },
	{ 107.5, 4.3187, 210.8514 },
	{ 95.9, 0.795, 1258.454 },
	{ 82.7, 0.282, 234.640 },
	{ 98.0, 2.561, 191.208 },
	{ 97.4, 3.262, 831.856 },
	{ 72.2, 4.380, 860.310 },
	{ 70.6, 0.732, 437.644 },
	{ 70.4, 0.877, 423.417 },
	{ 72.1, 5.580, 429.780 },
	{ 73.3, 0.625, 1375.774 },
	{ 66.4, 2.684, 405.258 },
	{ 63.8, 1.751, 1361.547 },
	{ 61.6, 1.093, 2001.444 },
	{ 67.0, 0.069, 408.439 },
	{ 68.9, 2.471, 949.176 },
	{ 60.5, 2.251, 1788.145 },
	{ 67.1, 5.454, 200.769 },
	{ 65.6, 0.055, 1589.073 },
	{ 49.3, 4.172, 138.517 },
	{ 50.6, 6.269, 223.594 },
	{ 55.2, 4.595, 628.852 },
	{ 47.9, 0.839, 10.295 },
	{ 46.7, 2.173, 312.199 },
	{ 54.2, 0.284, 124.433 },
	{ 49.5, 3.800, 215.747 },
	{ 40.1, 5.182, 1478.867 },
	{ 39.3, 0.563, 1574.846 },
	{ 35.0, 4.685, 38.133 },
	{ 42.8, 2.986, 1148.248 },
	{ 36.5, 0.635, 52.690 },
	{ 39.8, 0.284, 131.404 },
	{ 31.8, 5.190, 76.266 },
	{ 33.0, 1.980, 142.450 },
	{ 42.1, 4.830, 288.081 },
	{ 30.8, 1.479, 1677.939 },
	{ 42.8, 3.382, 208.633 },
	{ 29.2, 5.099, 654.124 },
	{ 29.2, 4.957, 1795.258 },
	{ 29.1, 2.747, 404.507 },
	{ 32.7, 6.121, 145.631 },
	{ 28.0, 0.832, 2317.836 },
	{ 27.7, 2.244, 430.530 },
	{ 29.9, 1.964, 2104.537 },
	{ 33.0, 3.282, 222.860 },
	{ 31.8, 6.025, 1905.465 },
	{ 27.0, 5.243, 388.465 },
	{ 26.5, 0.996, 107.025 },
	{ 25.4, 2.873, 703.633 },
	{ 24.9, 1.077, 99.911 },
	{ 25.0, 6.240, 106.274 },
	{ 24.9, 0.810, 312.460 },
	{ 24.3, 0.549, 214.262 },
	{ 28.4, 0.826, 1692.166 },
	{ 23.2, 5.080, 479.288 },
	{ 24.4, 3.106, 212.336 },
	{ 22.0, 6.067, 85.827 },
	{ 22.0, 3.899, 563.631 },
	{ 22.6, 4.867, 295.051 },
	{ 21.3, 5.108, 333.657 },
	{ 26.0, 2.208, 1265.567 },
	{ 20.9, 3.289, 70.849 },
	{ 21.5, 3.795, 347.884 },
	{ 22.1, 4.227, 217.965 },
	{ 20.6, 1.687, 231.458 },
	{ 21.4, 3.089, 554.070 },
	{ 21.3, 0.389, 319.573 },
	{ 20.5, 2.457, 18.159 },
	{ 26.1, 4.276, 483.221 },
	{ 20.7, 5.121, 362.862 },
	{ 22.0, 5.512, 343.219 },
	{ 19.4, 2.024, 313.210 },
	{ 20.2, 5.085, 750.104 },
	{ 20.1, 3.430, 213.347 },
	{ 24.2, 0.648, 207.882 },
	{ 22.0, 0.729, 99.161 },
	{ 21.1, 2.693, 1464.639 },
	{ 17.2, 4.715, 2111.650 },
	{ 18.5, 0.048, 245.542 },
	{ 17.5, 3.837, 497.448 },
	{ 16.1, 4.224, 565.116 },
	{ 21.6, 4.166, 2.448 },
	{ 16.0, 0.274, 225.829 },
	{ 16.8, 1.411, 114.138 },
	{ 15.6, 2.828, 81.752 },
	{ 15.5, 1.206, 1994.330 },
	{ 15.2, 3.846, 1162.475 },
	{ 16.4, 3.048, 134.585 },
	{ 15.9, 0.330, 1891.238 },
	{ 20.4, 0.232, 213.251 },
	{ 16.3, 1.706, 2420.929 },
	{ 16.3, 4.942, 357.446 },
	{ 18.1, 5.695, 56.622 },
	{ 13.7, 0.572, 2634.228 },
	{ 17.4, 3.553, 218.928 },
	{ 13.7, 5.705, 92.047 },
	{ 15.3, 1.313, 216.220 },
	{ 12.5, 5.192, 635.965 },
	{ 12.8, 1.602, 320.324 },
	{ 13.0, 0.451, 1169.588 },
	{ 12.0, 5.949, 543.918 },
	{ 11.8, 2.803, 217.492 },
	{ 14.7, 5.565, 344.703 },
	{ 12.8, 1.636, 273.103 },
	{ 11.9, 2.462, 721.649 },
	{ 13.3, 5.756, 2221.857 },
	{ 14.5, 0.453, 2008.558 },
	{ 11.8, 1.757, 160.609 },
	{ 12.4, 1.015, 329.725 },
	{ 10.7, 1.581, 212.778 },
	{ 12.8, 1.920, 1581.959 },
	{ 11.9, 4.447, 32.243 },
	{ 11.9, 5.107, 4.666 },
	{ 11.9, 4.308, 618.557 },
	{ 10.0, 0.487, 305.346 },
	{ 12.8, 3.744, 508.350 },
	{ 10.7, 0.766, 218.716 },
	{ 11.4, 3.000, 198.321 },
	{ 10.2, 2.409, 546.956 },
	{ 10.0, 2.639, 416.303 },
	{ 9.3, 5.46, 414.07 },
	{ 9.3, 4.46, 2428.04 },
	{ 9.9, 4.05, 62.25 },
	{ 12.8, 3.433, 258.876 },
	{ 9.7, 1.61, 327.44 },
	{ 11.2, 2.407, 1781.031 },
	{ 10.6, 2.075, 213.820 },
	{ 9.1, 2.92, 1279.79 },
	{ 9.5, 1.10, 113.39 },
	{ 9.8, 3.28, 275.55 },
	{ 11.3, 1.894, 561.184 },
	{ 8.6, 2.18, 425.11 },
	{ 8.6, 1.95, 35.42 },
	{ 10.2, 0.090, 182.280 },
	{ 11.8, 3.713, 350.332 },
	{ 8.6, 1.83, 629.60 },
	{ 8.4, 3.77, 251.43 },
	{ 8.5, 0.36, 617.81 },
	{ 8.2, 5.31, 65.22 },
	{ 8.3, 1.38, 1.48 },
	{ 8.0, 5.14, 22.09 },
	{ 8.4, 0.92, 1485.98 },
	{ 8.0, 0.94, 2310.72 },
	{ 8.9, 0.54, 168.05 },
	{ 8.2, 3.46, 424.15 },
	{ 8.0, 3.38, 144.15 },
	{ 7.9, 5.14, 358.93 },
	{ 8.9, 6.14, 621.74 },
	{ 7.5, 5.75, 447.94 },
	{ 7.5, 2.19, 264.50 },
	{ 8.1, 1.43, 2737.32 },
	{ 8.2, 0.96, 767.37 },
	{ 8.2, 0.35, 278.52 },
	{ 8.2, 5.44, 254.94 },
	{ 6.8, 1.20, 5.42 },
	{ 8.9, 4.88, 120.36 },
	{ 7.8, 4.56, 280.97 },
	{ 6.6, 3.50, 9.56 },
	{ 6.4, 0.33, 2950.62 },
	{ 6.9, 3.39, 98.90 },
	{ 7.4, 4.52, 5.63 },
	{ 8.0, 0.94, 636.72 },
	{ 7.2, 3.85, 214.05 },
	{ 6.4, 2.12, 274.07 },
	{ 6.5, 5.31, 6076.89 },
	{ 6.4, 0.45, 10007.10 },
	{ 6.3, 3.21, 219.45 },
	{ 6.7, 1.65, 1898.35 },
	{ 7.6, 0.10, 2324.95 },
	{ 6.3, 0.76, 210.38 },
	{ 6.6, 1.79, 12.53 },
	/* 246 terms retained, 393 terms dropped, error 2.1e-06 a.u.*T */

	/* saturn r, T^2 */
	{ 436902.5, 4.7867167, 213.2990954 },
	{ 71922.8, 2.500700, 206.185548 },
	{ 49766.8, 4.971682, 220.412642 },
	{ 43220.9, 3.869404, 426.598191 },
	{ 29645.6, 5.963103, 7.113547 },
	{ 4141.6, 4.10671, 433.71174 },
	{ 4720.9, 2.47528, 199.07200 },
	{ 3789.4, 3.09771, 639.89729 },
	{ 2964.0, 1.37206, 103.09277 },
	{ 2556.4, 2.85066, 419.48464 },
	{ 2208.5, 6.27589, 110.20632 },
	{ 2187.6, 5.85546, 14.22709 },
	{ 1956.9, 4.92449, 227.52619 },
	{ 2326.8, 0, 0 },
	{ 923.8, 5.4639, 323.5054 },
	{ 705.9, 2.9708, 95.9792 },
	{ 546.1, 4.1285, 412.3711 },
	{ 373.8, 5.8344, 117.3199 },
	{ 360.9, 3.2770, 647.0108 },
	{ 356.3, 3.1915, 210.1177 },
	{ 390.6, 4.4811, 216.4805 },
	{ 431.5, 5.1783, 522.5774 },
	{ 325.6, 2.2687, 853.1964 },
	{ 405.0, 4.1729, 209.3669 },
	{ 204.5, 0.0877, 202.2534 },
	{ 206.9, 4.0219, 735.8765 },
	{ 178.5, 4.0972, 440.8253 },
	{ 180.1, 3.5970, 632.7837 },
	{ 153.7, 3.1347, 625.6702 },
	{ 147.8, 0.1361, 302.1648 },
	{ 123.2, 4.1890, 88.8657 },
	{ 133.1, 2.5935, 191.9585 },
	{ 100.4, 5.4606, 3.1814 },
	{ 132.0, 5.9329, 309.2783 },
	{ 97.2, 4.018, 728.763 },
	{ 110.7, 4.7785, 838.9693 },
	{ 119.1, 5.5539, 224.3448 },
	{ 93.9, 4.384, 217.231 },
	{ 108.7, 5.2931, 515.4639 },
	{ 78.6, 5.725, 21.341 },
	{ 81.5, 5.109, 956.289 },
	{ 96.4, 6.259, 742.990 },
	{ 69.2, 4.049, 3.932 },
	{ 65.2, 3.777, 1052.268 },
	{ 64.1, 5.812, 529.691 },
	{ 62.5, 2.184, 195.140 },
	{ 57.0, 3.147, 203.004 },
	{ 56.0, 4.841, 234.640 },
	{ 52.9, 5.078, 330.619 },
	{ 50.6, 2.773, 942.062 },
	{ 41.6, 4.790, 63.736 },
	{ 44.9, 0.565, 269.921 },
	{ 41.4, 3.735, 316.392 },
	{ 52.8, 3.926, 949.176 },
	{ 38.4, 3.740, 1045.155 },
	{ 37.6, 4.189, 536.805 },
	{ 35.3, 2.908, 284.149 },
	{ 33.6, 3.805, 149.563 },
	{ 41.1, 4.579, 1155.361 },
	{ 30.4, 2.481, 860.310 },
	{ 31.4, 4.841, 1272.681 },
	{ 30.2, 4.352, 405.258 },
	{ 39.4, 3.509, 422.666 },
	{ 29.7, 1.589, 1066.495 },
	{ 35.2, 5.945, 1059.382 },
	{ 25.8, 3.549, 1368.660 },
	{ 26.3, 4.816, 124.433 },
	{ 30.0, 3.663, 429.780 },
	{ 33.0, 4.969, 831.856 },
	{ 24.3, 5.311, 10.295 },
	{ 26.3, 4.453, 223.594 },
	{ 22.1, 2.761, 415.552 },
	{ 27.2, 1.663, 277.035 },
	{ 21.6, 1.038, 11.046 },
	{ 19.7, 2.522, 1258.454 },
	{ 17.1, 3.277, 654.124 },
	{ 17.3, 3.494, 1361.547 },
	{ 16.1, 1.734, 490.334 },
	{ 21.1, 3.621, 1265.567 },
	{ 17.7, 4.311, 1471.753 },
	{ 13.5, 0.323, 295.051 },
	{ 12.6, 3.138, 74.782 },
	{ 12.0, 2.329, 210.851 },
	{ 15.1, 3.596, 265.989 },
	{ 13.0, 4.624, 1589.073 },
	{ 15.4, 5.013, 127.472 },
	{ 11.2, 4.550, 81.752 },
	{ 13.4, 4.887, 437.644 },
	{ 10.7, 5.052, 191.208 },
	{ 14.0, 3.050, 423.417 },
	{ 10.6, 5.028, 137.033 },
	{ 14.4, 4.687, 1148.248 },
	{ 13.5, 1.903, 408.439 },
	{ 10.1, 5.204, 340.771 },
	{ 10.3, 3.345, 1685.052 },
	{ 9.6, 3.17, 351.82 },
	{ 11.3, 5.478, 1375.774 },
	{ 8.6, 2.81, 99.91 },
	{ 8.5, 3.23, 1677.94 },
	{ 7.9, 2.36, 1574.85 },
	{ 7.6, 6.08, 231.46 },
	{ 9.2, 3.40, 1581.96 },
	{ 7.3, 2.00, 131.40 },
	{ 8.2, 4.04, 1788.14 },
	{ 7.6, 3.68, 846.08 },
	{ 6.7, 4.37, 145.63 },
	{ 7.5, 3.29, 750.10 },
	{ 6.4, 4.00, 447.94 },
	{ 6.2, 4.56, 106.27 },
	{ 6.5, 1.34, 215.75 },
	{ 6.5, 3.78, 313.21 },
	{ 6.0, 0.55, 18.16 },
	{ 6.2, 2.85, 138.52 },
	{ 6.8, 4.83, 319.57 },
	{ 6.7, 5.43, 508.35 },
	{ 7.2, 4.38, 1464.64 },
	{ 5.8, 4.14, 543.92 },
	{ 5.7, 4.35, 1905.46 },
	{ 5.1, 2.64, 288.08 },
	{ 5.3, 3.63, 6076.89 },
	{ 5.5, 4.20, 721.65 },
	{ 5.1, 5.05, 10007.10 },
	{ 5.5, 1.13, 56.62 },
	{ 4.8, 3.30, 76.27 },
	{ 4.9, 6.18, 483.22 },
	{ 5.0, 2.45, 628.85 },
	{ 4.5, 1.20, 200.77 },
	{ 4.8, 3.12, 2001.44 },
	{ 4.7, 1.27, 6062.66 },
	{ 4.8, 5.78, 184.84 },
	{ 4.8, 0.76, 333.66 },
	{ 4.5, 0.95, 343.22 },
	{ 4.5, 2.69, 9992.87 },
	{ 4.4, 0.80, 222.86 },
	{ 4.9, 5.92, 618.56 },
	{ 4.1, 1.92, 497.45 },
	{ 5.1, 4.50, 416.30 },
	{ 4.1, 1.98, 347.88 },
	{ 4.0, 2.88, 38.13 },
	{ 4.1, 2.90, 107.02 },
	{ 4.0, 2.93, 1994.33 },
	{ 4.9, 3.12, 1898.35 },
	{ 3.7, 3.25, 362.86 },
	{ 3.8, 0.88, 703.63 },
	{ 3.6, 3.48, 388.47 },
	{ 3.6, 4.08, 430.53 },
	{ 3.6, 0.05, 32.24 },
	{ 3.6, 5.46, 6283.08 },
	{ 3.5, 1.82, 70.85 },
	{ 3.8, 3.12, 635.97 },
	{ 3.4, 0.55, 10213.29 },
	{ 3.4, 3.52, 629.60 },
	{ 3.4, 3.28, 357.45 },
	{ 3.3, 1.98, 203.74 },
	{ 3.1, 2.18, 1891.24 },
	{ 3.2, 1.26, 134.59 },
	{ 4.0, 5.45, 1692.17 },
	{ 3.2, 2.46, 867.42 },
	{ 3.4, 4.21, 337.73 },
	{ 3.0, 2.19, 217.96 },
	{ 3.6, 5.55, 113.39 },
	{ 3.7, 3.79, 2104.54 },
	{ 3.1, 4.09, 1478.87 },
	{ 2.9, 3.91, 312.20 },
	{ 3.2, 3.92, 1038.04 },
	{ 4.0, 5.18, 404.51 },
	{ 3.9, 4.12, 1781.03 },
	{ 3.1, 1.61, 1073.61 },
	{ 3.1, 5.01, 312.46 },
	{ 3.0, 5.46, 258.88 },
	{ 2.9, 2.38, 181.06 },
	{ 3.0, 0.89, 1279.79 },
	{ 2.7, 0.01, 195.89 },
	{ 3.1, 5.60, 216.22 },
	{ 2.6, 6.13, 273.10 },
	{ 2.7, 2.32, 565.12 },
	{ 3.2, 3.88, 85.83 },
	{ 2.7, 5.74, 160.61 },
	{ 2.9, 4.75, 213.25 },
	{ 2.5, 5.30, 444.76 },
	{ 2.8, 5.09, 1169.59 },
	{ 2.9, 1.67, 213.35 },
	{ 2.9, 4.21, 650.94 },
	{ 3.0, 2.55, 6069.78 },
	{ 3.1, 2.67, 52.69 },
	{ 2.4, 0.90, 121.25 },
	{ 3.0, 3.97, 9999.99 },
	{ 3.1, 0.41, 561.18 },
	{ 2.4, 4.74, 218.72 },
	{ 2.6, 1.13, 344.70 },
	{ 2.3, 4.08, 131.55 },
	{ 2.2, 3.38, 22.09 },
	{ 2.1, 3.32, 358.93 },
	{ 2.7, 1.69, 208.63 },
	{ 2.6, 5.10, 824.74 },
	{ 2.2, 2.60, 305.35 },
	{ 2.1, 3.37, 320.32 },
	{ 2.7, 3.62, 436.89 },
	{ 2.5, 2.96, 2214.74 },
	{ 2.7, 2.88, 643.08 },
	{ 2.1, 1.61, 218.93 },
	{ 2.0, 4.63, 188.03 },
	{ 2.4, 3.46, 6275.96 },
	{ 2.0, 2.29, 2627.11 },
	{ 1.9, 5.67, 28.45 },
	{ 1.9, 4.26, 546.96 },
	{ 2.5, 3.58, 2420.93 },
	{ 1.9, 1.31, 212.34 },
	{ 1.9, 1.59, 424.15 },
	{ 1.9, 3.58, 329.73 },
	{ 2.1, 3.95, 1795.26 },
	{ 2.2, 4.22, 2221.86 },
	{ 1.9, 1.69, 350.33 },
	{ 1.8, 2.07, 144.15 },
	{ 1.9, 4.61, 182.28 },
	{ 2.2, 5.18, 99.16 },
	{ 1.8, 2.73, 291.26 },
	{ 2.2, 5.43, 207.88 },
	{ 1.8, 2.24, 168.05 },
	{ 1.7, 1.32, 219.45 },
	{ 1.7, 5.56, 92.80 },
	{ 1.7, 1.95, 129.92 },
	{ 2.1, 4.85, 1141.13 },
	{ 1.8, 5.05, 214.26 },
	{ 1.8, 2.86, 636.72 },
	{ 1.9, 2.90, 2310.72 },
	{ 1.8, 5.35, 45.58 },
	{ 1.7, 6.14, 554.07 },
	{ 1.6, 4.51, 210.38 },
	{ 1.7, 3.55, 1354.43 },
	{ 1.9, 3.01, 2317.84 },
	{ 1.6, 1.16, 235.39 },
	{ 1.9, 4.13, 225.83 },
	{ 1.6, 3.30, 1670.83 },
	{ 1.9, 0.18, 12.53 },
	{ 1.6, 5.73, 1485.98 },
	{ 1.7, 3.44, 2428.04 },
	{ 1.8, 2.70, 12.74 },
	{ 1.7, 4.98, 2008.56 },
	/* 239 terms retained, 103 terms dropped, error 5.2e-07 a.u.*T^2 */

	/* saturn r, T^3 */
	{ 20315.0, 3.021866, 213.299095 },
	{ 8923.6, 3.19144, 220.41264 },
	{ 6908.7, 4.35175, 206.18555 },
	{ 4087.1, 4.22407, 7.11355 },
	{ 3879.0, 2.01056, 426.59819 },
	{ 1070.8, 4.20360, 199.07200 },
	{ 907.3, 2.2834, 433.7117 },
	{ 606.1, 3.1746, 227.5262 },
	{ 596.6, 4.1346, 14.2271 },
	{ 483.2, 1.1735, 639.8973 },
	{ 393.2, 0, 0 },
	{ 229.5, 4.6984, 419.4846 },
	{ 188.2, 4.5900, 110.2063 },
	{ 149.5, 3.2020, 103.0928 },
	{ 121.4, 3.7683, 323.5054 },
	{ 101.2, 5.8188, 412.3711 },
	{ 102.1, 4.7097, 95.9792 },
	{ 93.1, 1.435, 647.011 },
	{ 72.6, 4.154, 117.320 },
	{ 84.3, 2.635, 216.480 },
	{ 62.2, 2.312, 440.825 },
	{ 45.1, 4.373, 191.958 },
	{ 49.5, 2.389, 209.367 },
	{ 54.8, 0.305, 853.196 },
	{ 40.5, 1.838, 302.165 },
	{ 38.1, 5.945, 88.866 },
	{ 32.2, 4.011, 21.341 },
	{ 40.7, 0.688, 522.577 },
	{ 28.2, 5.772, 210.118 },
	{ 25.0, 3.062, 234.640 },
	{ 20.8, 4.926, 625.670 },
	{ 25.1, 0.731, 515.464 },
	{ 17.5, 5.731, 728.763 },
	{ 18.0, 1.456, 309.278 },
	{ 16.9, 3.528, 3.181 },
	{ 13.4, 3.365, 330.619 },
	{ 11.1, 3.372, 224.345 },
	{ 11.1, 3.417, 956.289 },
	{ 10.0, 1.588, 202.253 },
	{ 11.6, 5.991, 735.877 },
	{ 10.5, 6.069, 405.258 },
	{ 9.1, 2.94, 124.43 },
	{ 8.7, 4.65, 632.78 },
	{ 10.0, 0.582, 860.310 },
	{ 7.5, 4.51, 942.06 },
	{ 10.1, 0.283, 838.969 },
	{ 9.2, 2.57, 223.59 },
	{ 8.7, 1.76, 429.78 },
	{ 7.6, 1.46, 654.12 },
	{ 7.1, 5.47, 1045.15 },
	{ 7.0, 1.52, 422.67 },
	{ 8.1, 4.48, 742.99 },
	{ 6.8, 4.83, 316.39 },
	{ 7.7, 0.44, 831.86 },
	{ 7.9, 4.20, 195.14 },
	{ 6.1, 2.34, 269.92 },
	{ 5.6, 1.15, 284.15 },
	{ 5.6, 4.18, 529.69 },
	{ 5.0, 2.12, 295.05 },
	{ 6.6, 3.42, 10.29 },
	{ 5.5, 2.47, 536.80 },
	{ 6.2, 6.01, 1066.50 },
	{ 5.6, 0.83, 217.23 },
	{ 4.3, 3.23, 1272.68 },
	{ 4.5, 0.92, 203.00 },
	{ 3.3, 4.33, 1258.45 },
	{ 3.7, 0.06, 81.75 },
	{ 4.0, 0.11, 1155.36 },
	{ 3.8, 6.01, 1052.27 },
	{ 2.9, 5.64, 3.93 },
	{ 3.0, 2.19, 447.94 },
	{ 3.0, 1.89, 149.56 },
	{ 3.1, 0.19, 1148.25 },
	{ 2.8, 0.92, 508.35 },
	{ 2.8, 4.97, 1677.94 },
	{ 2.6, 3.00, 1589.07 },
	{ 2.9, 5.41, 1361.55 },
	{ 2.3, 1.30, 184.84 },
	{ 2.5, 3.71, 408.44 },
	{ 2.5, 3.22, 319.57 },
	{ 2.6, 2.31, 543.92 },
	{ 2.3, 5.88, 721.65 },
	{ 2.0, 0.52, 416.30 },
	{ 2.5, 4.24, 1059.38 },
	{ 1.9, 2.41, 337.73 },
	{ 1.9, 0.54, 635.97 },
	{ 1.9, 5.62, 11.05 },
	{ 2.4, 5.73, 313.21 },
	{ 1.9, 2.41, 131.55 },
	{ 1.7, 4.58, 1994.33 },
	{ 1.9, 5.17, 2854.64 },
	{ 1.9, 6.23, 1471.75 },
	{ 2.0, 6.18, 1464.64 },
	{ 1.8, 5.59, 1038.04 },
	{ 1.5, 0.61, 210.85 },
	{ 1.6, 1.75, 195.89 },
	{ 1.6, 0.56, 2324.95 },
	{ 1.5, 0.27, 497.45 },
	{ 1.7, 2.58, 2090.31 },
	{ 1.8, 1.82, 436.89 },
	{ 1.6, 6.15, 490.33 },
	{ 1.8, 6.12, 1073.61 },
	{ 1.5, 0.85, 415.55 },
	{ 1.6, 2.95, 437.64 },
	{ 1.4, 4.12, 1574.85 },
	{ 1.6, 5.97, 1781.03 },
	{ 1.5, 3.85, 1251.34 },
	{ 1.4, 5.33, 2538.25 },
	{ 1.8, 1.51, 750.10 },
	{ 1.5, 3.29, 1884.12 },
	{ 1.5, 0.99, 643.08 },
	{ 1.3, 3.79, 1567.73 },
	{ 1.7, 0.03, 423.42 },
	{ 1.5, 5.35, 1354.43 },
	{ 1.4, 0.70, 867.42 },
	{ 1.1, 1.80, 618.56 },
	{ 1.1, 4.70, 113.39 },
	{ 1.1, 3.96, 1891.24 },
	{ 1.5, 1.50, 430.53 },
	{ 1.1, 5.13, 25.27 },
	{ 1.2, 2.97, 241.75 },
	{ 1.3, 2.29, 2420.93 },
	{ 1.1, 0.05, 63.74 },
	{ 1.4, 5.58, 1382.89 },
	{ 1.1, 3.11, 2200.52 },
	{ 1.1, 0.79, 127.47 },
	{ 1.0, 5.85, 215.75 },
	{ 1.1, 3.73, 131.40 },
	{ 1.2, 0.48, 824.74 },
	{ 1.1, 3.78, 1375.77 },
	{ 1.0, 5.91, 265.99 },
	{ 1.2, 1.41, 2634.23 },
	{ 1.1, 4.80, 1987.22 },
	{ 0.9, 6.26, 2015.67 },
	{ 1.0, 1.09, 362.86 },
	{ 1.1, 5.42, 1279.79 },
	{ 0.9, 1.92, 483.22 },
	{ 0.9, 2.97, 934.95 },
	{ 0.9, 2.66, 145.63 },
	{ 0.9, 6.26, 2.45 },
	{ 1.1, 4.48, 2214.74 },
	{ 1.0, 0.74, 16.67 },
	{ 1.0, 4.06, 231.46 },
	{ 0.9, 0.09, 628.85 },
	{ 0.9, 5.99, 2524.02 },
	{ 0.9, 3.16, 2207.63 },
	{ 0.8, 1.24, 74.78 },
	{ 0.8, 2.90, 2008.56 },
	{ 0.8, 2.28, 1478.87 },
	{ 1.0, 5.33, 2428.04 },
	{ 0.8, 2.38, 2228.97 },
	{ 0.8, 4.70, 1670.83 },
	{ 1.0, 4.23, 1802.37 },
	{ 0.8, 5.87, 1368.66 },
	{ 0.7, 5.92, 1685.05 },
	{ 0.8, 1.16, 3053.71 },
	{ 0.7, 3.13, 56.62 },
	/* 157 terms retained, 0 terms dropped, error 1.7e-07 a.u.*T^3 */

	/* saturn r, T^4 */
	{ 1202.0, 1.41499, 220.41264 },
	{ 707.8, 1.1615, 213.2991 },
	{ 516.1, 6.2397, 206.1855 },
	{ 426.7, 2.4692, 7.1135 },
	{ 267.7, 0.1866, 426.5982 },
	{ 170.2, 5.9593, 199.0720 },
	{ 145.1, 1.4421, 227.5262 },
	{ 150.3, 0.4797, 433.7117 },
	{ 121.0, 2.4053, 14.2271 },
	{ 47.3, 5.569, 639.897 },
	{ 15.7, 2.901, 110.206 },
	{ 16.7, 0.529, 440.825 },
	{ 19.0, 5.856, 647.011 },
	{ 14.1, 1.303, 412.371 },
	{ 12.7, 2.093, 323.505 },
	{ 14.7, 0.299, 419.485 },
	{ 11.1, 2.463, 117.320 },
	{ 11.3, 0.218, 95.979 },
	{ 9.2, 2.28, 21.34 },
	{ 9.2, 1.56, 88.87 },
	{ 9.0, 0.68, 216.48 },
	{ 7.7, 3.59, 302.16 },
	{ 7.8, 4.49, 853.20 },
	{ 8.4, 1.27, 234.64 },
	{ 9.6, 3.14, 0 },
	{ 4.8, 2.59, 515.46 },
	{ 6.1, 5.17, 103.09 },
	{ 4.4, 0.02, 191.96 },
	{ 4.4, 1.60, 330.62 },
	{ 3.7, 3.30, 210.12 },
	{ 4.4, 5.97, 654.12 },
	{ 4.4, 4.97, 860.31 },
	{ 3.2, 2.73, 522.58 },
	{ 4.0, 1.60, 405.26 },
	{ 3.1, 0.75, 209.37 },
	{ 2.5, 1.19, 124.43 },
	{ 3.1, 1.32, 728.76 },
	{ 2.2, 3.28, 203.00 },
	{ 2.1, 6.15, 429.78 },
	{ 2.1, 0.75, 295.05 },
	{ 2.0, 3.89, 1066.50 },
	{ 2.2, 0.49, 447.94 },
	{ 2.2, 0.73, 625.67 },
	{ 1.8, 0.09, 942.06 },
	{ 1.7, 1.40, 224.34 },
	{ 1.6, 3.02, 184.84 },
	{ 1.8, 0.82, 223.59 },
	{ 1.9, 2.00, 831.86 },
	{ 1.6, 5.41, 824.74 },
	{ 1.5, 5.96, 422.67 },
	{ 1.1, 1.12, 838.97 },
	{ 1.2, 1.90, 956.29 },
	{ 1.5, 2.12, 529.69 },
	{ 1.4, 0.72, 536.80 },
	{ 1.1, 0.89, 721.65 },
	{ 1.3, 1.65, 17.41 },
	{ 1.2, 5.97, 195.14 },
	{ 1.0, 5.36, 316.39 },
	{ 1.0, 3.06, 1574.85 },
	{ 1.1, 1.59, 735.88 },
	{ 0.8, 4.93, 56.62 },
	{ 0.8, 2.72, 508.35 },
	{ 1.0, 1.01, 1045.15 },
	{ 0.7, 1.11, 1169.59 },
	/* 64 terms retained, 0 terms dropped, error 1.2e-07 a.u.*T^4 */

	/* saturn r, T^5 */
	{ 128.6, 5.9128, 220.4126 },
	{ 32.3, 0.693, 7.114 },
	{ 26.7, 5.914, 227.526 },
	{ 19.9, 0.674, 14.227 },
	{ 20.2, 4.951, 433.712 },
	{ 13.5, 1.457, 199.072 },
	{ 14.1, 2.671, 206.186 },
	{ 13.4, 4.588, 426.598 },
	{ 7.3, 4.63, 213.30 },
	{ 4.9, 3.61, 639.90 },
	{ 3.1, 4.66, 191.96 },
	{ 2.9, 0.49, 323.51 },
	{ 3.8, 4.90, 440.83 },
	{ 3.3, 4.07, 647.01 },
	{ 2.9, 3.18, 419.48 },
	{ 2.3, 3.70, 88.87 },
	{ 1.9, 5.33, 302.16 },
	{ 2.1, 3.32, 95.98 },
	{ 1.6, 2.67, 853.20 },
	{ 2.0, 0.56, 117.32 },
	{ 1.6, 0.86, 515.46 },
	{ 1.7, 0, 0 },
	{ 1.1, 5.98, 3.18 },
	{ 1.3, 5.83, 234.64 },
	{ 0.9, 5.23, 216.48 },
	{ 1.1, 0.16, 412.37 },
	{ 0.8, 0.37, 28.45 },
	{ 0.8, 5.05, 124.43 },
	/* 28 terms retained, 0 terms dropped, error 9e-08 a.u.*T^5 */
	/* end saturn */
};

int vn_saturn[][3] = {
	/* addresses for saturn l, b, r  */
	/* T^0 */ { 0, 592, 811, },
	/* T^1 */ { 165, 645, 1099, },
	/* T^2 */ { 303, 698, 1345, },
	/* T^3 */ { 418, 744, 1584, },
	/* T^4 */ { 500, 777, 1741, },
	/* T^5 */ { 566, 803, 1805, },
	/* end */ { 592, 811, 1833, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_uranus[][3] = {
	/* uranus l, T^0 */
	{ 548129294.3, 0, 0 },
	{ 9260408.3, 0.89106422, 74.78159857 },
	{ 1504247.8, 3.62719262, 1.48447271 },
	{ 365981.7, 1.8996219, 73.2971259 },
	{ 272328.1, 3.3582371, 149.5631971 },
	{ 70328.5, 5.392544, 63.735898 },
	{ 68892.6, 6.092925, 76.266071 },
	{ 61998.6, 2.269520, 2.968945 },
	{ 61950.7, 2.850989, 11.045700 },
	{ 26468.9, 3.141521, 71.812653 },
	{ 25710.5, 6.113798, 454.909367 },
	{ 21078.9, 4.360595, 148.078724 },
	{ 17818.7, 1.744370, 36.648563 },
	{ 14613.5, 4.737320, 3.932153 },
	{ 11162.5, 5.826820, 224.344796 },
	{ 10997.9, 0.488655, 138.517497 },
	{ 9527.5, 2.95517, 35.16409 },
	{ 7545.5, 5.23626, 109.94569 },
	{ 4220.2, 3.23329, 70.84945 },
	{ 4051.9, 2.27754, 151.04767 },
	{ 3354.6, 1.06549, 4.45342 },
	{ 2926.7, 4.62904, 9.56123 },
	{ 3490.4, 5.48306, 146.59425 },
	{ 3144.1, 4.75199, 77.75054 },
	{ 2922.4, 5.35237, 85.82730 },
	{ 2272.8, 4.36601, 70.32818 },
	{ 2051.2, 1.51774, 0.11187 },
	{ 2148.6, 0.60746, 38.13304 },
	{ 1991.7, 4.92437, 277.03499 },
	{ 1376.2, 2.04281, 65.22037 },
	{ 1666.9, 3.62745, 380.12777 },
	{ 1284.2, 3.11346, 202.25340 },
	{ 1150.4, 0.93344, 3.18139 },
	{ 1533.2, 2.58593, 52.69020 },
	{ 1281.6, 0.54270, 222.86032 },
	{ 1372.1, 4.19642, 111.43016 },
	{ 1221.0, 0.19901, 108.46122 },
	{ 946.2, 1.1925, 127.4718 },
	{ 1151.0, 4.17898, 33.67962 },
	{ 1244.3, 0.91613, 2.44768 },
	{ 1072.0, 0.23565, 62.25143 },
	{ 1090.5, 1.77502, 12.53017 },
	{ 707.9, 5.1829, 213.2991 },
	{ 653.4, 0.9659, 78.7138 },
	{ 627.6, 0.1821, 984.6003 },
	{ 524.5, 2.0128, 299.1264 },
	{ 559.4, 3.3578, 0.5213 },
	{ 606.8, 5.4321, 529.6910 },
	{ 404.9, 5.9869, 8.0768 },
	{ 467.2, 0.4148, 145.1098 },
	{ 471.3, 1.4066, 184.7273 },
	{ 483.2, 2.1055, 0.9632 },
	{ 395.6, 5.8704, 351.8166 },
	{ 433.5, 5.5214, 183.2428 },
	{ 309.9, 5.8330, 145.6310 },
	{ 378.6, 2.3498, 56.6224 },
	{ 399.0, 0.3381, 415.5525 },
	{ 300.4, 5.6435, 22.0914 },
	{ 249.2, 4.7462, 225.8293 },
	{ 239.3, 2.3505, 137.0330 },
	{ 294.2, 5.8392, 39.6175 },
	{ 216.5, 4.7785, 340.7709 },
	{ 251.8, 1.6370, 221.3759 },
	{ 219.6, 1.9221, 67.6681 },
	{ 202.0, 1.2969, 0.0482 },
	{ 224.1, 0.5157, 84.3428 },
	{ 216.5, 6.1421, 5.9379 },
	{ 222.6, 2.8431, 0.2606 },
	{ 207.8, 5.5802, 68.8437 },
	{ 187.5, 1.3192, 0.1601 },
	{ 158.0, 0.7381, 54.1747 },
	{ 199.1, 0.9563, 152.5321 },
	{ 168.6, 5.8787, 18.1592 },
	{ 170.3, 3.6772, 5.4166 },
	{ 193.7, 1.8880, 456.3938 },
	{ 193.0, 0.9162, 453.4249 },
	{ 181.9, 3.5362, 79.2350 },
	{ 173.1, 1.5386, 160.6089 },
	{ 164.6, 1.4238, 106.9767 },
	{ 172.0, 5.6795, 219.8914 },
	{ 162.8, 3.0503, 112.9146 },
	{ 146.7, 1.2630, 59.8037 },
	{ 139.5, 5.3860, 32.1951 },
	{ 138.6, 4.2599, 909.8187 },
	{ 143.1, 1.3000, 35.4247 },
	{ 123.8, 1.3736, 7.1135 },
	{ 104.4, 5.0282, 0.7508 },
	{ 103.3, 0.6810, 14.9779 },
	{ 94.7, 0.907, 74.670 },
	{ 83.0, 2.928, 265.989 },
	{ 110.2, 2.0269, 554.0700 },
	{ 94.2, 3.943, 74.893 },
	{ 79.9, 1.014, 6.592 },
	{ 109.4, 5.7058, 77.9630 },
	{ 85.9, 1.706, 82.858 },
	{ 103.6, 1.4577, 24.3790 },
	{ 74.7, 4.632, 69.365 },
	{ 79.9, 3.010, 297.642 },
	{ 84.5, 0.369, 186.212 },
	{ 88.8, 0.525, 181.758 },
	{ 70.3, 1.190, 66.705 },
	{ 70.0, 0.875, 305.346 },
	{ 69.9, 3.761, 131.404 },
	{ 84.6, 5.887, 256.540 },
	{ 74.3, 6.243, 447.796 },
	{ 62.3, 0.169, 479.288 },
	{ 72.7, 2.849, 462.023 },
	{ 69.1, 4.439, 39.357 },
	{ 76.6, 4.587, 6.220 },
	{ 73.4, 4.276, 87.312 },
	{ 55.3, 1.496, 71.600 },
	{ 57.3, 1.630, 143.625 },
	{ 61.7, 3.186, 77.229 },
	{ 57.6, 3.672, 51.206 },
	{ 50.3, 1.123, 20.607 },
	{ 53.7, 5.519, 128.956 },
	{ 57.9, 2.669, 381.612 },
	{ 58.1, 1.586, 60.767 },
	{ 45.4, 0.481, 14.015 },
	{ 37.6, 6.068, 211.815 },
	{ 38.6, 3.436, 153.495 },
	{ 46.1, 4.362, 75.745 },
	{ 40.1, 4.573, 46.210 },
	{ 34.2, 2.940, 140.002 },
	{ 38.7, 5.589, 99.161 },
	{ 34.8, 1.028, 203.738 },
	{ 40.0, 0.699, 218.407 },
	{ 32.5, 4.216, 200.769 },
	{ 31.9, 5.510, 72.334 },
	{ 41.7, 3.824, 81.001 },
	{ 34.8, 0.394, 1.373 },
	{ 39.8, 6.056, 293.189 },
	{ 27.6, 2.183, 125.987 },
	{ 36.3, 1.666, 258.024 },
	{ 35.4, 1.967, 835.037 },
	{ 35.4, 3.723, 692.587 },
	{ 27.3, 2.102, 209.367 },
	{ 26.5, 4.483, 373.908 },
	{ 34.5, 1.079, 191.208 },
	{ 29.9, 3.874, 259.509 },
	{ 26.2, 3.632, 490.334 },
	{ 25.8, 0.545, 41.644 },
	{ 27.0, 6.277, 28.572 },
	{ 26.4, 5.811, 75.303 },
	{ 34.2, 6.056, 275.551 },
	{ 29.9, 1.888, 269.921 },
	{ 26.2, 6.201, 134.585 },
	{ 25.2, 5.425, 116.426 },
	{ 26.5, 4.772, 284.149 },
	{ 27.0, 4.753, 41.102 },
	{ 28.9, 0.171, 528.206 },
	{ 25.8, 0.746, 278.519 },
	/* 152 terms retained, 795 terms dropped, error 1.3" */

	/* uranus l, T^1 */
	{ 7502543121.6, 0, 0 },
	{ 154458.2, 5.2420166, 74.7815986 },
	{ 24456.4, 1.712557, 1.484473 },
	{ 9257.8, 0.42845, 11.04570 },
	{ 8266.0, 1.50220, 63.73590 },
	{ 7841.7, 1.31984, 149.56320 },
	{ 3899.1, 0.46484, 3.93215 },
	{ 2283.8, 4.17368, 76.26607 },
	{ 1926.6, 0.53013, 2.96895 },
	{ 1232.7, 1.58634, 70.84945 },
	{ 791.2, 5.4364, 3.1814 },
	{ 767.0, 1.9956, 73.2971 },
	{ 481.7, 2.9840, 85.8273 },
	{ 449.8, 4.1383, 138.5175 },
	{ 445.6, 3.7230, 224.3448 },
	{ 426.6, 4.7313, 71.8127 },
	{ 347.7, 2.4537, 9.5612 },
	{ 353.8, 2.5832, 148.0787 },
	{ 317.1, 5.5786, 52.6902 },
	{ 179.9, 5.6837, 12.5302 },
	{ 171.1, 3.0006, 78.7138 },
	{ 205.6, 2.3626, 2.4477 },
	{ 158.0, 2.9093, 0.9632 },
	{ 189.1, 4.2024, 56.6224 },
	{ 154.7, 5.5908, 4.4534 },
	{ 183.8, 0.2837, 151.0477 },
	{ 143.5, 2.5905, 62.2514 },
	{ 152.0, 2.9422, 77.7505 },
	{ 153.5, 4.6519, 35.1641 },
	{ 121.5, 4.1484, 127.4718 },
	{ 115.5, 3.7322, 65.2204 },
	{ 102.0, 4.1875, 145.6310 },
	{ 101.7, 6.0339, 0.1119 },
	{ 88.2, 3.990, 18.159 },
	{ 87.5, 6.155, 202.253 },
	{ 80.5, 2.641, 22.091 },
	{ 72.0, 6.045, 70.328 },
	{ 68.6, 4.051, 77.963 },
	{ 59.2, 3.704, 67.668 },
	{ 47.3, 3.543, 351.817 },
	{ 42.5, 5.724, 5.417 },
	{ 44.3, 5.909, 7.114 },
	{ 35.6, 3.292, 8.077 },
	{ 35.5, 3.328, 71.600 },
	{ 36.1, 5.900, 33.680 },
	{ 30.6, 5.464, 160.609 },
	{ 31.5, 5.620, 984.600 },
	{ 38.5, 4.915, 222.860 },
	{ 35.0, 5.080, 38.133 },
	{ 30.8, 5.496, 59.804 },
	{ 28.9, 4.519, 84.343 },
	{ 26.6, 5.541, 131.404 },
	{ 29.9, 1.660, 447.796 },
	{ 29.2, 1.147, 462.023 },
	{ 25.8, 4.994, 137.033 },
	{ 25.4, 5.736, 380.128 },
	{ 21.7, 2.806, 69.365 },
	{ 26.6, 6.146, 299.126 },
	{ 23.0, 2.249, 111.430 },
	{ 19.2, 3.556, 54.175 },
	{ 21.8, 0.933, 213.299 },
	{ 19.3, 1.862, 108.461 },
	{ 16.2, 3.102, 14.978 },
	{ 13.1, 1.954, 87.312 },
	{ 13.9, 1.541, 340.771 },
	{ 13.5, 4.385, 5.938 },
	{ 13.1, 5.883, 6.220 },
	{ 11.8, 0.326, 35.425 },
	{ 11.0, 1.692, 45.577 },
	{ 12.4, 0.328, 51.206 },
	{ 10.9, 5.971, 265.989 },
	{ 11.4, 3.378, 72.334 },
	{ 12.0, 3.604, 269.921 },
	{ 11.7, 1.745, 79.235 },
	{ 13.8, 2.690, 225.829 },
	{ 12.0, 5.344, 152.532 },
	{ 9.9, 5.50, 153.50 },
	{ 10.4, 4.169, 24.379 },
	{ 10.6, 3.069, 284.149 },
	{ 9.6, 0.50, 209.37 },
	{ 9.3, 3.54, 41.64 },
	{ 9.5, 5.60, 82.86 },
	{ 9.7, 1.01, 68.84 },
	{ 9.2, 4.49, 20.61 },
	{ 10.2, 3.518, 529.691 },
	{ 8.6, 3.89, 60.77 },
	{ 10.0, 4.648, 77.229 },
	{ 8.7, 1.97, 195.14 },
	{ 8.4, 4.41, 134.59 },
	{ 9.3, 3.93, 39.62 },
	{ 7.8, 5.36, 75.74 },
	{ 7.7, 5.77, 73.82 },
	{ 7.7, 4.44, 14.01 },
	{ 8.4, 2.44, 146.59 },
	{ 8.0, 5.73, 184.73 },
	{ 7.5, 2.19, 145.11 },
	{ 6.4, 0.85, 32.20 },
	{ 6.3, 2.17, 74.89 },
	{ 7.9, 0.17, 120.36 },
	{ 7.0, 4.12, 191.21 },
	{ 6.9, 2.13, 116.43 },
	/* 101 terms retained, 325 terms dropped, error 0.29"*T */

	/* uranus l, T^2 */
	{ 53033.3, 0, 0 },
	{ 2357.6, 2.26015, 74.78160 },
	{ 769.1, 4.5256, 11.0457 },
	{ 551.5, 3.2581, 63.7359 },
	{ 541.5, 2.2757, 3.9322 },
	{ 529.5, 4.9235, 1.4845 },
	{ 257.5, 3.6906, 3.1814 },
	{ 238.8, 5.8581, 149.5632 },
	{ 181.9, 6.2176, 70.8494 },
	{ 49.4, 6.031, 56.622 },
	{ 53.5, 1.442, 76.266 },
	{ 38.2, 1.785, 52.690 },
	{ 44.8, 3.909, 2.448 },
	{ 44.5, 0.812, 85.827 },
	{ 37.4, 4.462, 2.969 },
	{ 33.0, 0.864, 9.561 },
	{ 24.3, 2.107, 18.159 },
	{ 29.4, 5.098, 73.297 },
	{ 22.1, 4.817, 78.714 },
	{ 22.5, 5.993, 138.517 },
	{ 17.2, 2.535, 145.631 },
	{ 21.4, 2.399, 77.963 },
	{ 20.6, 2.169, 224.345 },
	{ 16.8, 3.466, 12.530 },
	{ 12.0, 0.019, 22.091 },
	{ 10.5, 4.456, 62.251 },
	{ 11.0, 0.085, 127.472 },
	{ 8.7, 4.26, 7.11 },
	{ 10.5, 5.165, 71.600 },
	{ 7.2, 1.25, 5.42 },
	{ 8.4, 5.50, 67.67 },
	{ 6.1, 5.45, 65.22 },
	{ 6.0, 4.52, 151.05 },
	{ 5.7, 1.83, 202.25 },
	{ 6.1, 3.36, 447.80 },
	{ 6.0, 5.73, 462.02 },
	{ 5.1, 3.52, 59.80 },
	{ 5.2, 1.06, 131.40 },
	{ 6.0, 5.61, 148.08 },
	{ 5.1, 3.36, 4.45 },
	{ 4.8, 1.20, 71.81 },
	{ 4.0, 0.68, 77.75 },
	{ 3.7, 1.76, 351.82 },
	{ 3.1, 3.84, 45.58 },
	{ 3.0, 3.32, 160.61 },
	{ 3.0, 6.15, 77.23 },
	{ 3.6, 4.57, 454.91 },
	{ 2.7, 5.36, 269.92 },
	{ 2.5, 1.05, 69.36 },
	{ 2.3, 2.69, 84.34 },
	{ 2.2, 5.08, 14.98 },
	{ 2.2, 1.39, 284.15 },
	{ 2.1, 4.35, 984.60 },
	{ 2.1, 2.32, 120.36 },
	{ 1.9, 5.70, 54.17 },
	{ 2.0, 3.87, 195.14 },
	{ 1.6, 5.08, 209.37 },
	{ 1.6, 0.49, 137.03 },
	{ 1.6, 2.91, 51.21 },
	{ 1.7, 6.26, 41.64 },
	{ 2.1, 1.24, 35.16 },
	{ 1.7, 6.28, 277.03 },
	/* 62 terms retained, 89 terms dropped, error 0.055"*T^2 */

	/* uranus l, T^3 */
	{ 120.9, 0.0242, 74.7816 },
	{ 68.1, 4.121, 3.932 },
	{ 52.8, 2.390, 11.046 },
	{ 43.8, 2.960, 1.484 },
	{ 45.3, 2.044, 3.181 },
	{ 45.8, 0, 0 },
	{ 25.0, 4.887, 63.736 },
	{ 21.1, 4.545, 70.849 },
	{ 19.9, 2.313, 149.563 },
	{ 8.9, 1.58, 56.62 },
	{ 4.3, 0.23, 18.16 },
	{ 3.6, 5.39, 76.27 },
	{ 3.5, 4.98, 85.83 },
	{ 3.5, 4.13, 52.69 },
	{ 3.6, 0.95, 77.96 },
	{ 2.3, 0.86, 145.63 },
	{ 2.7, 0.37, 78.71 },
	{ 1.9, 2.68, 7.11 },
	{ 2.2, 5.66, 9.56 },
	{ 1.4, 4.87, 224.34 },
	{ 1.3, 1.25, 12.53 },
	{ 1.6, 0.49, 71.60 },
	{ 1.5, 5.20, 73.30 },
	{ 1.2, 3.93, 22.09 },
	{ 0.9, 2.19, 127.47 },
	{ 0.8, 3.98, 462.02 },
	{ 0.8, 5.06, 447.80 },
	{ 0.7, 0.35, 5.63 },
	{ 0.7, 1.06, 138.52 },
	{ 0.7, 2.94, 131.40 },
	{ 0.5, 1.59, 151.05 },
	{ 0.4, 4.33, 120.36 },
	/* 32 terms retained, 14 terms dropped, error 0.0098"*T^3 */

	/* uranus l, T^4 */
	{ 113.9, 3.1416, 0 },
	{ 5.6, 4.58, 74.78 },
	{ 3.2, 0.35, 11.05 },
	{ 1.2, 3.42, 56.62 },
	{ 0.6, 4.66, 18.16 },
	{ 0.2, 3.80, 149.56 },
	{ 0.1, 4.36, 63.74 },
	/* 7 terms retained, 0 terms dropped, error 0.0016"*T^4 */

	/* uranus l, T^5 */
	{ 0.9, 3.14, 0 },
	/* 1 terms retained, 0 terms dropped, error 0.0051"*T^5 */
	/* end uranus l */

	/* uranus b, T^0 */
	{ 1346277.6, 2.61877811, 74.78159857 },
	{ 62341.4, 5.081112, 149.563197 },
	{ 61601.2, 3.141593, 0 },
	{ 9963.7, 1.61604, 76.26607 },
	{ 9926.2, 0.57630, 73.29713 },
	{ 3259.5, 1.26119, 224.34480 },
	{ 2972.3, 2.24367, 1.48447 },
	{ 2010.3, 6.05550, 148.07872 },
	{ 1522.2, 0.27960, 63.73590 },
	{ 924.1, 4.0382, 151.0477 },
	{ 760.6, 6.1400, 71.8127 },
	{ 420.3, 5.2128, 11.0457 },
	{ 430.7, 3.5545, 213.2991 },
	{ 436.8, 3.3808, 529.6910 },
	{ 522.3, 3.3209, 138.5175 },
	{ 434.6, 0.3407, 77.7505 },
	{ 462.6, 0.7426, 85.8273 },
	{ 232.6, 2.2572, 222.8603 },
	{ 215.8, 1.5912, 38.1330 },
	{ 244.7, 0.7880, 2.9689 },
	{ 179.9, 3.7249, 299.1264 },
	{ 174.9, 1.2355, 146.5943 },
	{ 173.7, 1.9365, 380.1278 },
	{ 160.4, 5.3364, 111.4302 },
	{ 144.1, 5.9624, 35.1641 },
	{ 102.0, 2.6188, 78.7138 },
	{ 116.4, 5.7388, 70.8494 },
	{ 106.4, 0.9410, 70.3282 },
	{ 86.2, 0.703, 39.618 },
	{ 72.6, 0.206, 225.829 },
	{ 71.2, 0.833, 109.946 },
	{ 57.5, 2.670, 108.461 },
	{ 54.3, 3.352, 184.727 },
	{ 44.5, 2.744, 152.532 },
	{ 38.6, 5.174, 202.253 },
	{ 39.2, 2.171, 351.817 },
	{ 41.3, 3.221, 160.609 },
	{ 35.1, 4.001, 112.915 },
	{ 33.1, 3.614, 221.376 },
	{ 31.3, 2.720, 145.110 },
	{ 37.3, 4.021, 52.690 },
	{ 32.0, 1.292, 145.631 },
	{ 27.6, 3.701, 36.649 },
	/* 43 terms retained, 240 terms dropped, error 0.75" */

	/* uranus b, T^1 */
	{ 206366.2, 4.1239431, 74.7815986 },
	{ 8563.2, 0.33820, 149.56320 },
	{ 1725.7, 2.12193, 73.29713 },
	{ 1368.9, 3.06862, 76.26607 },
	{ 1374.4, 0, 0 },
	{ 399.8, 2.8477, 224.3448 },
	{ 450.6, 3.7766, 1.4845 },
	{ 307.2, 1.2546, 148.0787 },
	{ 154.3, 3.7858, 63.7359 },
	{ 110.9, 5.3289, 138.5175 },
	{ 112.4, 5.5730, 151.0477 },
	{ 83.5, 3.592, 71.813 },
	{ 55.6, 3.401, 85.827 },
	{ 41.4, 4.455, 78.714 },
	{ 53.7, 1.705, 77.751 },
	{ 41.9, 1.215, 11.046 },
	{ 32.0, 3.774, 222.860 },
	{ 30.3, 2.564, 2.969 },
	{ 27.0, 5.337, 213.299 },
	{ 26.2, 0.416, 380.128 },
	{ 20.1, 5.931, 529.691 },
	{ 23.0, 2.489, 146.594 },
	{ 19.6, 5.372, 299.126 },
	{ 20.4, 3.702, 70.849 },
	{ 19.1, 1.092, 111.430 },
	{ 19.4, 3.830, 38.133 },
	{ 10.8, 2.663, 3.932 },
	{ 10.2, 2.313, 109.946 },
	{ 9.4, 2.77, 39.62 },
	{ 7.7, 1.81, 225.83 },
	{ 8.1, 4.69, 184.73 },
	{ 6.6, 5.50, 35.16 },
	{ 7.4, 1.18, 65.22 },
	{ 6.5, 4.98, 71.60 },
	/* 34 terms retained, 120 terms dropped, error 0.16"*T */

	/* uranus b, T^2 */
	{ 9211.7, 5.80044, 74.78160 },
	{ 556.9, 0, 0 },
	{ 286.3, 2.1773, 149.5632 },
	{ 95.0, 3.842, 73.297 },
	{ 45.4, 4.878, 76.266 },
	{ 20.1, 5.463, 1.484 },
	{ 14.8, 0.880, 138.517 },
	{ 14.0, 5.072, 63.736 },
	{ 14.3, 2.845, 148.079 },
	{ 10.1, 5.003, 224.345 },
	{ 8.3, 6.27, 78.71 },
	{ 4.7, 5.16, 71.81 },
	{ 3.8, 6.28, 85.83 },
	{ 3.5, 3.53, 11.05 },
	{ 2.6, 1.44, 151.05 },
	{ 2.4, 4.23, 3.93 },
	{ 2.6, 0.41, 71.60 },
	/* 17 terms retained, 43 terms dropped, error 0.045"*T^2 */

	/* uranus b, T^3 */
	{ 267.8, 1.2510, 74.7816 },
	{ 11.0, 3.142, 0 },
	{ 6.2, 4.01, 149.56 },
	{ 3.4, 5.78, 73.30 },
	{ 1.6, 1.06, 63.74 },
	{ 1.3, 1.67, 78.71 },
	{ 1.2, 2.59, 138.52 },
	{ 1.1, 0.29, 76.27 },
	{ 0.6, 1.87, 71.60 },
	{ 0.6, 0.80, 1.48 },
	{ 0.5, 4.43, 148.08 },
	/* 11 terms retained, 5 terms dropped, error 0.0067"*T^3 */

	/* uranus b, T^4 */
	{ 5.7, 2.85, 74.78 },
	{ 0.3, 3.14, 0 },
	/* 2 terms retained, 0 terms dropped, error 0.0021"*T^4 */
	/* end uranus b */

	/* uranus r, T^0 */
	{ 1921264847.9, 0, 0 },
	{ 88784984.1, 5.603775270, 74.781598567 },
	{ 3440835.5, 0.32836099, 73.29712586 },
	{ 2055653.5, 1.78295170, 149.56319713 },
	{ 649321.9, 4.5224730, 76.2660713 },
	{ 602248.1, 3.8600382, 63.7358983 },
	{ 496404.2, 1.4013993, 454.9093665 },
	{ 338525.5, 1.5800268, 138.5174969 },
	{ 243508.2, 1.5708660, 71.8126532 },
	{ 190521.9, 1.9980936, 1.4844727 },
	{ 161858.3, 2.7913786, 148.0787244 },
	{ 143705.9, 1.3836857, 11.0457003 },
	{ 93192.4, 0.174372, 36.648563 },
	{ 71424.3, 4.245093, 224.344796 },
	{ 89805.8, 3.661054, 109.945689 },
	{ 39009.6, 1.669711, 70.849445 },
	{ 46677.3, 1.399766, 35.164090 },
	{ 39025.7, 3.362347, 277.034994 },
	{ 36755.2, 3.886489, 146.594252 },
	{ 30348.9, 0.701004, 151.047670 },
	{ 29156.3, 3.180562, 77.750544 },
	{ 20471.6, 1.555890, 202.253395 },
	{ 25620.4, 5.256563, 380.127768 },
	{ 25785.8, 3.785377, 85.827299 },
	{ 22637.2, 0.725191, 529.690965 },
	{ 20473.2, 2.796398, 70.328180 },
	{ 17900.6, 0.554555, 2.968945 },
	{ 12328.2, 5.960392, 127.471797 },
	{ 14701.6, 4.904344, 108.461216 },
	{ 11494.7, 0.437740, 65.220371 },
	{ 15502.8, 5.354050, 38.133036 },
	{ 10792.7, 1.421049, 213.299095 },
	{ 11696.1, 3.298256, 3.932153 },
	{ 11959.4, 1.750441, 984.600332 },
	{ 12896.5, 2.621540, 111.430161 },
	{ 11853.0, 0.993428, 52.690198 },
	{ 9111.4, 4.99639, 62.25143 },
	{ 8420.6, 5.25351, 222.86032 },
	{ 7449.1, 0.79492, 351.81659 },
	{ 8402.1, 5.03878, 415.55249 },
	{ 6046.4, 5.67961, 78.71375 },
	{ 5524.1, 3.11499, 9.56123 },
	{ 7329.5, 3.97278, 183.24281 },
	{ 5444.9, 5.10576, 145.10978 },
	{ 5238.1, 2.62960, 33.67962 },
	{ 4079.2, 3.22065, 340.77089 },
	{ 3801.6, 6.10986, 184.72729 },
	{ 3919.5, 4.25015, 39.61751 },
	{ 2940.5, 2.14637, 137.03302 },
	{ 3781.2, 3.45840, 456.39384 },
	{ 2942.2, 0.42394, 299.12639 },
	{ 3686.8, 2.48718, 453.42489 },
	{ 3101.7, 4.14031, 219.89138 },
	{ 2962.6, 0.82978, 56.62235 },
	{ 2937.8, 3.67657, 140.00197 },
	{ 2865.1, 0.30997, 12.53017 },
	{ 2538.0, 4.85458, 131.40395 },
	{ 1962.5, 5.24342, 84.34283 },
	{ 2363.6, 0.44253, 554.06999 },
	{ 1979.4, 6.12836, 106.97674 },
	{ 2182.6, 2.94040, 305.34617 },
	{ 1963.0, 0.04115, 221.37585 },
	{ 1829.6, 4.01106, 68.84371 },
	{ 1642.9, 0.35564, 67.66805 },
	{ 1584.8, 3.16267, 225.82927 },
	{ 1848.7, 2.91112, 909.81873 },
	{ 1632.4, 4.23062, 22.09140 },
	{ 1401.4, 1.39084, 265.98929 },
	{ 1403.7, 5.63564, 4.45342 },
	{ 1655.9, 1.96431, 79.23502 },
	{ 1249.0, 5.44027, 54.17467 },
	{ 1563.4, 1.47918, 112.91463 },
	{ 1248.1, 4.88984, 479.28839 },
	{ 1197.4, 2.52186, 145.63104 },
	{ 1507.0, 5.24186, 181.75834 },
	{ 1481.7, 5.66203, 152.53214 },
	{ 1438.8, 1.53046, 447.79582 },
	{ 1408.5, 4.41922, 462.02291 },
	{ 1477.1, 4.32215, 256.53994 },
	{ 1228.3, 5.97703, 59.80375 },
	{ 1250.0, 6.24485, 160.60890 },
	{ 906.5, 5.6203, 74.6697 },
	{ 1090.7, 4.15394, 77.96299 },
	{ 844.9, 0.1294, 82.8584 },
	{ 900.4, 2.3732, 74.8935 },
	{ 1072.0, 1.74287, 528.20649 },
	{ 689.7, 3.0810, 69.3650 },
	{ 593.8, 4.5007, 8.0768 },
	{ 718.6, 4.0005, 128.9563 },
	{ 699.6, 0.0399, 143.6253 },
	{ 575.7, 5.8955, 66.7048 },
	{ 759.0, 2.1370, 692.5875 },
	{ 710.4, 5.4161, 218.4069 },
	{ 548.7, 5.6281, 3.1814 },
	{ 651.6, 4.4234, 18.1592 },
	{ 539.8, 6.2079, 71.6002 },
	{ 544.5, 5.6938, 203.7379 },
	{ 710.3, 4.2197, 381.6122 },
	{ 593.8, 3.8381, 32.1951 },
	{ 710.1, 4.4897, 293.1885 },
	{ 705.5, 0.4552, 835.0371 },
	{ 588.0, 5.0825, 186.2118 },
	{ 598.2, 0.3582, 269.9214 },
	{ 641.9, 2.7113, 87.3118 },
	{ 495.6, 2.6509, 200.7689 },
	{ 630.3, 4.4615, 275.5505 },
	{ 575.2, 5.5786, 2.4477 },
	{ 569.9, 1.6393, 77.2293 },
	{ 556.7, 1.0723, 1059.3819 },
	{ 449.4, 0.2798, 617.8059 },
	{ 463.6, 1.4345, 297.6419 },
	{ 436.5, 0.5280, 209.3669 },
	{ 463.9, 2.3544, 211.8146 },
	{ 435.9, 2.1008, 1514.2913 },
	{ 515.5, 3.2327, 284.1485 },
	{ 454.9, 4.0836, 99.1606 },
	{ 477.4, 2.8940, 39.3569 },
	{ 542.3, 5.3948, 278.5195 },
	{ 410.1, 3.0497, 404.5068 },
	{ 367.8, 0.7116, 125.9873 },
	{ 503.1, 5.8393, 191.2077 },
	{ 487.5, 0.0640, 60.7670 },
	{ 455.0, 2.5932, 490.3341 },
	{ 436.3, 2.0818, 51.2057 },
	{ 435.8, 2.7945, 75.7448 },
	{ 323.5, 4.8290, 195.1398 },
	{ 359.4, 0.0087, 35.4247 },
	{ 429.3, 3.0803, 41.1020 },
	{ 320.0, 5.4863, 14.9779 },
	{ 414.3, 0.0901, 258.0244 },
	{ 379.7, 0.0583, 378.6433 },
	{ 420.1, 2.2539, 81.0014 },
	{ 357.7, 4.7141, 173.9422 },
	{ 358.9, 0.3521, 426.5982 },
	{ 405.4, 6.1226, 24.3790 },
	{ 365.2, 5.5948, 255.0555 },
	{ 308.1, 3.9236, 116.4261 },
	{ 325.7, 4.7200, 134.5853 },
	{ 292.8, 3.9952, 72.3339 },
	{ 386.5, 0.6862, 230.5646 },
	{ 305.7, 3.7611, 344.7030 },
	{ 287.0, 1.8499, 153.4954 },
	{ 353.6, 4.6572, 329.8371 },
	{ 302.1, 0.1319, 565.1157 },
	{ 241.1, 1.6045, 81.3739 },
	{ 249.8, 4.2421, 75.3029 },
	{ 245.1, 5.9491, 20.6069 },
	{ 248.3, 1.0628, 105.4923 },
	{ 305.4, 2.5553, 6208.2943 },
	{ 296.3, 4.2110, 1364.7281 },
	{ 219.9, 2.9612, 120.3582 },
	{ 233.6, 2.9707, 46.2098 },
	{ 262.4, 3.8365, 831.1050 },
	{ 233.5, 4.4812, 628.8516 },
	{ 187.4, 3.0353, 135.5486 },
	{ 216.8, 3.4291, 241.6103 },
	{ 255.8, 1.1671, 177.8744 },
	{ 220.5, 0.1963, 180.2739 },
	{ 224.5, 0.4068, 114.3991 },
	{ 205.4, 2.3038, 259.5089 },
	{ 211.1, 4.9308, 103.0928 },
	{ 175.8, 5.5082, 7.1135 },
	{ 188.5, 2.2359, 5.4166 },
	{ 171.7, 5.2173, 41.6445 },
	{ 176.1, 1.9596, 756.3234 },
	{ 170.4, 4.9498, 206.1855 },
	{ 169.5, 4.0432, 55.6591 },
	{ 219.0, 0.2479, 294.6730 },
	{ 187.8, 2.0454, 408.4389 },
	{ 182.3, 0.7073, 391.1735 },
	{ 192.1, 5.7672, 291.7040 },
	{ 153.7, 4.7066, 543.0243 },
	{ 170.0, 4.5100, 288.0807 },
	{ 164.1, 5.2253, 67.3592 },
	{ 194.3, 6.1169, 414.0680 },
	{ 168.0, 5.2581, 518.6453 },
	{ 156.6, 0.6630, 220.4126 },
	{ 182.3, 0.7838, 417.0370 },
	{ 167.5, 4.9224, 422.6660 },
	{ 170.8, 2.3093, 98.9000 },
	{ 161.7, 3.2726, 443.8637 },
	{ 132.8, 2.8888, 373.9080 },
	{ 161.1, 3.8234, 451.9404 },
	{ 179.3, 4.8241, 366.4856 },
	{ 178.2, 3.9803, 10138.5039 },
	{ 141.9, 1.2697, 159.1244 },
	{ 153.8, 4.2785, 45.5767 },
	{ 161.5, 4.9955, 73.8184 },
	{ 146.3, 2.6566, 465.9551 },
	{ 124.9, 4.3047, 339.2864 },
	{ 154.6, 4.3205, 760.2555 },
	{ 142.9, 2.0777, 457.8783 },
	{ 152.4, 4.6474, 155.7830 },
	{ 116.4, 4.4351, 5.9379 },
	{ 113.4, 4.6535, 80.1982 },
	{ 107.6, 3.7729, 142.4497 },
	{ 133.7, 5.3089, 14.0146 },
	{ 116.1, 2.5118, 296.1574 },
	{ 129.1, 0.3628, 96.8730 },
	{ 122.8, 2.3834, 141.4864 },
	{ 101.4, 1.0574, 92.3077 },
	{ 114.7, 6.2486, 767.3691 },
	{ 113.3, 0.8305, 100.3845 },
	{ 107.2, 2.3937, 347.8844 },
	{ 95.4, 0.801, 342.255 },
	{ 110.8, 0.3865, 216.9224 },
	{ 127.0, 0.4236, 331.3215 },
	{ 112.6, 0.0811, 558.0021 },
	{ 103.2, 0.6979, 358.9301 },
	{ 111.5, 0.7502, 80.7195 },
	{ 90.9, 5.165, 144.147 },
	{ 90.7, 0.220, 333.657 },
	{ 98.6, 4.332, 74.521 },
	{ 89.3, 2.189, 74.830 },
	{ 117.2, 3.9497, 74.2603 },
	{ 89.1, 5.878, 74.733 },
	{ 97.3, 0.694, 977.487 },
	{ 116.6, 1.8368, 1289.9465 },
	{ 85.4, 5.803, 6.592 },
	{ 86.8, 5.620, 300.611 },
	{ 105.2, 5.9451, 328.3526 },
	{ 112.1, 1.2117, 329.7252 },
	{ 83.0, 2.208, 74.942 },
	{ 94.3, 4.539, 28.572 },
	{ 106.8, 1.8207, 306.8306 },
	{ 103.6, 2.9937, 6.2198 },
	{ 106.4, 0.8158, 1087.6931 },
	{ 77.7, 2.734, 110.206 },
	{ 98.4, 3.735, 75.042 },
	{ 86.2, 2.833, 983.116 },
	{ 89.0, 4.738, 604.473 },
	{ 83.0, 1.883, 387.241 },
	{ 90.2, 3.804, 986.085 },
	{ 84.6, 1.258, 142.141 },
	{ 74.7, 1.351, 350.332 },
	{ 95.8, 5.548, 969.622 },
	{ 90.3, 0.368, 0.963 },
	{ 82.7, 5.856, 74.622 },
	{ 75.8, 2.780, 88.115 },
	{ 83.8, 1.844, 227.314 },
	{ 70.7, 4.656, 44.725 },
	{ 71.3, 3.650, 894.841 },
	{ 94.1, 4.988, 403.134 },
	{ 89.0, 4.439, 154.017 },
	{ 79.4, 5.667, 267.474 },
	{ 75.6, 5.410, 50.403 },
	{ 68.6, 4.767, 991.714 },
	{ 65.3, 0.693, 152.745 },
	{ 63.0, 2.899, 79.889 },
	{ 63.9, 0.098, 681.542 },
	{ 80.1, 2.975, 526.722 },
	{ 69.7, 3.953, 187.696 },
	{ 59.5, 3.596, 58.107 },
	{ 59.3, 0.509, 28.311 },
	{ 68.6, 2.419, 235.390 },
	{ 66.0, 5.046, 30.711 },
	{ 70.2, 3.736, 546.956 },
	{ 66.8, 0.855, 522.577 },
	{ 63.0, 0.293, 119.507 },
	{ 62.0, 2.316, 74.031 },
	{ 71.4, 3.170, 23.576 },
	{ 74.8, 5.368, 373.014 },
	{ 64.2, 2.368, 157.640 },
	{ 70.7, 0.558, 92.941 },
	{ 55.8, 5.270, 874.394 },
	{ 75.6, 4.663, 101.869 },
	{ 73.7, 6.206, 312.460 },
	{ 72.9, 0.584, 367.970 },
	{ 53.2, 2.247, 17.526 },
	{ 63.1, 4.596, 67.880 },
	{ 60.5, 0.576, 253.571 },
	{ 52.9, 2.459, 264.505 },
	{ 70.2, 1.519, 552.586 },
	{ 68.6, 2.445, 555.554 },
	{ 62.8, 0.338, 561.184 },
	{ 49.0, 1.092, 19.122 },
	{ 64.6, 5.275, 68.189 },
	{ 63.0, 5.359, 92.047 },
	{ 47.7, 3.909, 192.692 },
	{ 65.3, 4.236, 771.301 },
	{ 65.2, 3.739, 536.805 },
	{ 59.5, 6.106, 365.001 },
	{ 52.2, 1.717, 905.887 },
	{ 46.0, 3.871, 210.330 },
	{ 46.4, 5.974, 477.804 },
	{ 62.1, 2.675, 130.441 },
	{ 46.0, 3.894, 48.758 },
	{ 42.7, 3.815, 61.288 },
	{ 53.9, 2.865, 353.301 },
	{ 46.9, 1.000, 166.829 },
	{ 42.2, 2.617, 90.823 },
	{ 43.3, 4.158, 173.682 },
	{ 41.3, 1.799, 149.451 },
	{ 45.0, 1.766, 0.521 },
	{ 51.9, 2.978, 383.097 },
	{ 42.9, 1.574, 120.991 },
	{ 49.6, 4.034, 303.862 },
	{ 45.3, 3.584, 97.416 },
	{ 38.7, 2.394, 31.493 },
	{ 38.1, 5.795, 75.532 },
	{ 50.1, 4.764, 911.303 },
	{ 50.9, 5.155, 439.783 },
	{ 43.1, 0.850, 58.319 },
	{ 42.7, 5.173, 162.093 },
	{ 50.3, 5.816, 66.917 },
	{ 35.6, 1.874, 472.175 },
	{ 50.0, 1.889, 42.586 },
	{ 40.0, 1.743, 89.759 },
	{ 45.3, 1.925, 55.138 },
	{ 44.9, 1.484, 450.977 },
	{ 34.3, 5.203, 316.392 },
	{ 46.4, 0.339, 273.103 },
	{ 37.2, 2.038, 117.911 },
	{ 46.1, 5.623, 1819.637 },
	{ 39.4, 4.194, 486.402 },
	{ 41.0, 4.830, 149.675 },
	{ 45.0, 0.727, 3265.831 },
	{ 43.6, 0.753, 404.619 },
	{ 31.8, 3.848, 20.447 },
	{ 44.2, 4.368, 418.261 },
	{ 37.9, 3.029, 167.089 },
	{ 43.7, 1.573, 491.558 },
	{ 34.0, 1.263, 260.993 },
	{ 31.3, 4.161, 13.333 },
	{ 40.0, 2.866, 468.243 },
	{ 36.5, 2.588, 68.562 },
	{ 32.4, 3.116, 103.353 },
	{ 33.9, 0.156, 24.118 },
	{ 35.9, 1.368, 59.282 },
	{ 33.6, 0.755, 290.220 },
	{ 29.8, 5.332, 1033.358 },
	{ 32.0, 4.675, 205.222 },
	{ 31.0, 4.628, 258.876 },
	{ 35.3, 1.007, 1108.140 },
	{ 33.4, 3.407, 43.129 },
	{ 32.6, 5.255, 114.138 },
	{ 29.8, 5.642, 254.944 },
	{ 31.6, 3.782, 152.011 },
	{ 31.0, 2.267, 104.008 },
	{ 34.6, 5.173, 25.603 },
	{ 28.4, 1.769, 820.059 },
	{ 28.0, 3.925, 199.284 },
	{ 29.0, 2.582, 76.479 },
	{ 33.8, 5.794, 274.066 },
	{ 29.4, 5.936, 280.967 },
	{ 31.1, 1.394, 178.789 },
	{ 30.1, 0.444, 27.087 },
	{ 33.8, 6.262, 401.650 },
	{ 27.5, 2.152, 480.773 },
	{ 26.9, 2.513, 123.540 },
	{ 26.1, 0.220, 286.596 },
	{ 26.5, 3.882, 372.424 },
	{ 34.0, 1.446, 88.796 },
	{ 30.1, 0.827, 100.645 },
	{ 27.7, 4.648, 198.321 },
	{ 33.7, 1.143, 82.486 },
	{ 26.5, 1.979, 95.389 },
	{ 26.6, 0.399, 106.014 },
	{ 27.0, 2.102, 1057.897 },
	{ 31.0, 5.340, 476.431 },
	{ 27.0, 0.713, 248.724 },
	{ 29.1, 3.992, 908.334 },
	{ 28.0, 3.465, 1439.510 },
	{ 27.8, 4.124, 694.072 },
	{ 25.5, 5.496, 115.884 },
	{ 27.2, 5.761, 1215.165 },
	{ 26.3, 2.775, 490.073 },
	{ 26.4, 3.371, 49.721 },
	{ 26.9, 3.260, 691.103 },
	{ 25.0, 3.650, 73.409 },
	/* 370 terms retained, 754 terms dropped, error 9.6e-06 a.u. */

	/* uranus r, T^1 */
	{ 1479896.4, 3.67205705, 74.78159857 },
	{ 71212.1, 6.226010, 63.735898 },
	{ 68627.0, 6.134113, 149.563197 },
	{ 20857.3, 5.246255, 11.045700 },
	{ 21468.2, 2.601767, 76.266071 },
	{ 24059.6, 3.141593, 0 },
	{ 11405.3, 0.018485, 70.849445 },
	{ 7496.8, 0.42360, 73.29713 },
	{ 4243.8, 1.41692, 85.82730 },
	{ 3505.9, 2.58354, 138.51750 },
	{ 3228.8, 5.25500, 3.93215 },
	{ 3926.7, 3.15514, 71.81265 },
	{ 3060.0, 0.15322, 1.48447 },
	{ 3578.4, 2.31161, 224.34480 },
	{ 2564.3, 0.98077, 148.07872 },
	{ 2429.4, 3.99440, 52.69020 },
	{ 1644.7, 2.65349, 127.47180 },
	{ 1583.8, 1.43046, 78.71375 },
	{ 1413.1, 4.57462, 202.25340 },
	{ 1489.5, 2.67559, 56.62235 },
	{ 1403.2, 1.36985, 77.75054 },
	{ 1228.2, 1.04704, 62.25143 },
	{ 1508.0, 5.05996, 151.04767 },
	{ 992.1, 2.1717, 65.2204 },
	{ 1032.7, 0.26459, 131.40395 },
	{ 861.9, 5.0553, 351.8166 },
	{ 744.4, 3.0764, 35.1641 },
	{ 604.4, 0.9072, 984.6003 },
	{ 646.9, 4.4729, 70.3282 },
	{ 574.7, 3.2307, 447.7958 },
	{ 687.5, 2.4991, 77.9630 },
	{ 623.6, 0.8625, 9.5612 },
	{ 527.8, 5.1514, 2.9689 },
	{ 561.8, 2.7178, 462.0229 },
	{ 530.4, 5.9166, 213.2991 },
	{ 460.1, 4.2230, 12.5302 },
	{ 494.3, 0.4629, 145.6310 },
	{ 487.3, 0.7061, 380.1278 },
	{ 380.9, 3.8509, 3.1814 },
	{ 444.4, 2.1556, 67.6681 },
	{ 338.8, 2.5382, 18.1592 },
	{ 372.9, 5.0514, 529.6910 },
	{ 348.3, 1.7487, 71.6002 },
	{ 405.9, 1.2296, 22.0914 },
	{ 268.9, 6.2407, 340.7709 },
	{ 255.6, 2.9570, 84.3428 },
	{ 259.5, 3.9205, 59.8037 },
	{ 224.7, 3.9096, 160.6089 },
	{ 221.7, 3.6473, 137.0330 },
	{ 254.6, 3.5041, 38.1330 },
	{ 238.3, 2.0488, 269.9214 },
	{ 272.4, 3.3836, 222.8603 },
	{ 200.6, 1.2486, 69.3650 },
	{ 234.2, 0.2783, 108.4612 },
	{ 188.5, 4.4131, 265.9893 },
	{ 211.7, 0.6803, 111.4302 },
	{ 205.9, 1.5338, 284.1485 },
	{ 196.2, 4.7715, 299.1264 },
	{ 153.1, 5.2176, 209.3669 },
	{ 162.6, 4.3405, 33.6796 },
	{ 150.6, 1.9897, 54.1747 },
	{ 137.0, 0.4032, 195.1398 },
	{ 117.2, 0.3965, 87.3118 },
	{ 127.9, 2.4033, 39.6175 },
	{ 104.2, 2.9215, 134.5853 },
	{ 103.9, 1.8162, 72.3339 },
	{ 105.7, 0.1707, 79.2350 },
	{ 106.4, 0.6980, 2.4477 },
	{ 95.3, 4.029, 82.858 },
	{ 104.8, 4.4362, 305.3462 },
	{ 93.8, 5.018, 51.206 },
	{ 103.7, 2.5755, 191.2077 },
	{ 106.7, 1.2300, 225.8293 },
	{ 93.5, 3.093, 77.229 },
	{ 97.4, 3.814, 152.532 },
	{ 84.6, 5.725, 68.844 },
	{ 77.4, 0.083, 45.577 },
	{ 76.2, 4.204, 73.818 },
	{ 86.2, 0.531, 145.110 },
	{ 75.8, 3.786, 75.745 },
	{ 77.6, 1.636, 479.288 },
	{ 84.6, 0.617, 116.426 },
	{ 100.2, 4.9408, 120.3582 },
	{ 72.1, 4.305, 565.116 },
	{ 70.7, 2.385, 60.767 },
	{ 71.6, 3.939, 153.495 },
	{ 84.6, 5.560, 344.703 },
	{ 63.6, 1.937, 41.644 },
	{ 71.6, 3.712, 408.439 },
	{ 61.6, 3.900, 4.453 },
	{ 65.0, 1.558, 106.977 },
	{ 59.9, 0.601, 74.893 },
	{ 62.0, 4.394, 453.425 },
	{ 63.4, 4.192, 184.727 },
	{ 62.3, 3.238, 422.666 },
	{ 54.4, 3.725, 7.114 },
	{ 52.5, 6.086, 404.507 },
	{ 59.1, 1.556, 456.394 },
	{ 52.6, 3.505, 125.987 },
	{ 52.8, 5.201, 358.930 },
	{ 58.1, 5.335, 220.413 },
	{ 52.9, 4.448, 426.598 },
	{ 50.9, 0.526, 490.334 },
	{ 55.0, 1.601, 14.978 },
	{ 49.5, 4.255, 5.417 },
	{ 51.3, 0.368, 206.186 },
	{ 51.8, 1.758, 8.077 },
	{ 57.0, 0.841, 146.594 },
	{ 49.1, 0.941, 99.161 },
	{ 46.4, 5.351, 152.745 },
	{ 48.0, 1.972, 288.081 },
	{ 43.8, 3.037, 20.607 },
	{ 49.5, 5.846, 112.915 },
	{ 42.0, 0.046, 128.956 },
	{ 48.6, 3.628, 81.001 },
	{ 41.5, 2.337, 277.035 },
	{ 40.0, 5.095, 35.425 },
	{ 41.9, 2.511, 24.379 },
	{ 38.3, 3.619, 173.942 },
	{ 38.4, 2.060, 333.657 },
	{ 42.6, 1.261, 1514.291 },
	{ 38.9, 0.742, 347.884 },
	{ 38.5, 4.951, 92.941 },
	{ 33.2, 1.384, 74.670 },
	{ 33.8, 3.684, 66.917 },
	{ 39.0, 5.492, 200.769 },
	{ 31.9, 0.540, 203.738 },
	{ 33.3, 6.260, 1059.382 },
	{ 30.8, 2.538, 977.487 },
	{ 29.2, 5.431, 58.107 },
	{ 30.1, 0.195, 387.241 },
	{ 29.0, 3.105, 991.714 },
	{ 35.6, 3.729, 96.873 },
	{ 27.6, 0.371, 80.198 },
	{ 32.5, 4.384, 221.376 },
	{ 27.0, 1.356, 0.963 },
	{ 31.3, 0.796, 373.014 },
	{ 31.1, 2.054, 230.565 },
	{ 25.9, 3.468, 144.147 },
	{ 30.2, 0.714, 109.946 },
	{ 24.7, 3.042, 14.015 },
	{ 27.9, 4.766, 415.552 },
	{ 25.1, 5.124, 81.374 },
	{ 25.6, 2.569, 522.577 },
	{ 24.4, 2.203, 628.852 },
	{ 25.5, 1.795, 143.625 },
	{ 24.2, 5.672, 443.864 },
	{ 25.7, 5.432, 546.956 },
	{ 24.2, 5.600, 32.195 },
	{ 24.4, 3.303, 617.806 },
	{ 23.5, 0.658, 46.210 },
	{ 22.4, 4.821, 135.549 },
	{ 27.2, 2.027, 536.805 },
	{ 22.2, 4.617, 391.173 },
	{ 22.0, 4.592, 241.610 },
	{ 20.8, 0.244, 465.955 },
	{ 27.3, 2.152, 140.002 },
	{ 21.4, 5.272, 159.124 },
	{ 23.6, 4.950, 561.184 },
	{ 24.9, 0.546, 181.758 },
	{ 23.0, 3.806, 55.138 },
	{ 19.8, 1.303, 518.645 },
	{ 19.3, 1.314, 543.024 },
	{ 19.7, 4.909, 909.819 },
	{ 20.8, 0.912, 76.479 },
	{ 19.9, 0.665, 66.705 },
	{ 19.0, 4.680, 98.900 },
	{ 25.9, 4.529, 454.909 },
	{ 21.9, 1.234, 41.102 },
	{ 18.7, 6.096, 103.093 },
	{ 18.2, 0.973, 55.659 },
	{ 21.2, 4.194, 329.725 },
	{ 19.4, 4.315, 6.220 },
	{ 18.5, 5.786, 142.450 },
	{ 22.6, 5.846, 297.642 },
	{ 16.8, 6.091, 211.815 },
	{ 16.4, 2.500, 61.288 },
	{ 20.4, 3.161, 186.212 },
	{ 16.0, 2.983, 81.895 },
	{ 19.0, 6.012, 155.783 },
	{ 17.7, 4.826, 273.103 },
	{ 15.1, 3.656, 472.175 },
	{ 18.4, 3.476, 36.649 },
	{ 16.3, 0.131, 554.070 },
	{ 18.6, 0.239, 23.576 },
	{ 14.4, 2.694, 70.116 },
	{ 15.2, 2.438, 486.402 },
	{ 14.0, 5.124, 29.205 },
	{ 15.8, 4.249, 146.382 },
	{ 14.1, 1.557, 110.206 },
	{ 17.5, 1.945, 835.037 },
	{ 13.7, 1.638, 92.047 },
	{ 13.8, 0.137, 235.390 },
	{ 13.6, 2.854, 49.509 },
	{ 12.6, 3.209, 100.384 },
	{ 12.4, 2.886, 60.555 },
	{ 15.0, 0.326, 259.509 },
	{ 12.9, 2.776, 105.492 },
	{ 12.3, 3.364, 440.682 },
	{ 15.2, 0.256, 258.876 },
	{ 12.1, 0.109, 157.640 },
	{ 12.9, 0.307, 124.290 },
	{ 10.9, 3.429, 33.137 },
	{ 11.2, 4.988, 604.473 },
	{ 10.8, 3.863, 767.369 },
	{ 11.6, 2.605, 166.829 },
	{ 10.2, 5.278, 264.505 },
	{ 10.9, 0.641, 558.002 },
	{ 12.3, 4.340, 16.675 },
	{ 9.9, 0.67, 31.49 },
	{ 12.6, 4.832, 114.399 },
	{ 10.5, 0.204, 275.551 },
	{ 11.3, 0.961, 373.908 },
	{ 12.1, 1.917, 378.643 },
	{ 12.2, 0.705, 218.407 },
	{ 10.8, 5.745, 88.115 },
	{ 9.5, 0.66, 353.30 },
	{ 11.0, 2.630, 154.017 },
	{ 9.1, 2.99, 681.54 },
	{ 10.4, 2.331, 132.888 },
	{ 9.2, 4.79, 216.48 },
	{ 9.3, 0.76, 129.92 },
	{ 8.9, 0.78, 67.36 },
	{ 8.8, 6.13, 150.53 },
	{ 9.6, 2.89, 67.88 },
	{ 10.5, 0.369, 699.701 },
	{ 9.3, 1.50, 19.64 },
	{ 9.4, 5.26, 80.72 },
	{ 10.1, 3.565, 278.519 },
	{ 9.5, 3.06, 149.68 },
	{ 9.2, 3.03, 162.09 },
	{ 8.4, 2.18, 342.26 },
	{ 9.2, 5.33, 152.01 },
	{ 9.8, 2.44, 75.30 },
	{ 10.0, 0.819, 339.286 },
	{ 9.4, 1.94, 147.12 },
	{ 7.9, 4.72, 106.01 },
	{ 8.8, 0.02, 42.59 },
	{ 7.8, 0.61, 135.34 },
	{ 8.2, 2.60, 469.14 },
	{ 10.1, 2.586, 50.403 },
	{ 8.6, 5.69, 760.26 },
	{ 7.5, 2.65, 5.94 },
	{ 8.7, 0.54, 66.18 },
	{ 8.0, 1.94, 180.27 },
	{ 7.5, 5.95, 97.42 },
	{ 7.6, 5.80, 450.98 },
	{ 8.7, 3.70, 300.61 },
	{ 7.7, 1.47, 32.24 },
	{ 8.2, 2.31, 254.94 },
	{ 8.5, 1.28, 39.36 },
	{ 7.0, 0.68, 874.39 },
	{ 8.9, 0.16, 43.13 },
	{ 7.2, 4.98, 117.91 },
	{ 7.4, 4.09, 92.31 },
	{ 7.3, 5.04, 756.32 },
	{ 8.5, 1.22, 79.45 },
	{ 6.9, 6.04, 350.33 },
	{ 8.8, 1.33, 48.76 },
	{ 7.3, 3.33, 68.19 },
	{ 6.8, 4.78, 142.66 },
	{ 6.8, 3.90, 480.77 },
	{ 7.1, 1.28, 68.56 },
	{ 7.9, 4.30, 624.92 },
	{ 6.7, 5.43, 610.69 },
	{ 6.5, 5.44, 88.80 },
	{ 7.6, 4.81, 312.46 },
	{ 7.2, 3.18, 268.44 },
	{ 8.1, 1.99, 692.59 },
	{ 6.5, 1.05, 685.47 },
	{ 6.6, 1.38, 291.26 },
	{ 6.9, 2.59, 282.66 },
	{ 7.1, 5.80, 468.24 },
	{ 6.3, 2.58, 458.09 },
	{ 7.6, 0.49, 296.16 },
	{ 8.5, 0.01, 227.31 },
	{ 6.5, 3.99, 42.54 },
	{ 6.4, 1.04, 365.90 },
	{ 8.2, 1.13, 69.15 },
	{ 6.4, 0.16, 228.28 },
	{ 8.0, 4.04, 183.24 },
	{ 6.3, 3.52, 285.63 },
	{ 6.9, 3.32, 306.83 },
	{ 6.9, 1.34, 7.86 },
	{ 6.5, 0.46, 106.27 },
	{ 6.6, 5.25, 58.32 },
	{ 6.4, 0.35, 411.62 },
	{ 6.4, 5.19, 120.99 },
	{ 7.0, 4.86, 419.48 },
	{ 6.4, 2.78, 198.32 },
	/* 290 terms retained, 224 terms dropped, error 2.2e-06 a.u.*T */

	/* uranus r, T^2 */
	{ 22439.9, 0.699531, 74.781599 },
	{ 4727.0, 1.69902, 63.73590 },
	{ 1681.9, 4.64834, 70.84945 },
	{ 1433.8, 3.52120, 149.56320 },
	{ 1649.6, 3.09660, 11.04570 },
	{ 770.2, 0, 0 },
	{ 461.0, 0.7668, 3.9322 },
	{ 500.4, 6.1723, 76.2661 },
	{ 390.4, 4.4961, 56.6224 },
	{ 389.9, 5.5267, 85.8273 },
	{ 292.1, 0.2039, 52.6902 },
	{ 272.9, 3.8471, 138.5175 },
	{ 286.6, 3.5336, 73.2971 },
	{ 205.4, 3.2476, 78.7138 },
	{ 219.7, 1.9642, 131.4039 },
	{ 215.8, 0.8481, 77.9630 },
	{ 128.8, 2.0815, 3.1814 },
	{ 148.6, 4.8984, 127.4718 },
	{ 117.5, 4.9341, 447.7958 },
	{ 112.7, 1.0136, 462.0229 },
	{ 98.9, 6.158, 224.345 },
	{ 91.4, 0.680, 18.159 },
	{ 89.2, 0.234, 202.253 },
	{ 88.2, 2.931, 62.251 },
	{ 114.1, 4.7874, 145.6310 },
	{ 103.9, 3.5856, 71.6002 },
	{ 61.8, 3.300, 351.817 },
	{ 57.8, 4.907, 22.091 },
	{ 64.4, 3.390, 1.484 },
	{ 71.1, 6.105, 454.909 },
	{ 51.0, 3.867, 65.220 },
	{ 63.5, 3.962, 67.668 },
	{ 59.0, 5.555, 9.561 },
	{ 48.7, 3.747, 269.921 },
	{ 43.6, 1.926, 59.804 },
	{ 42.2, 2.617, 151.048 },
	{ 42.4, 6.136, 284.149 },
	{ 44.3, 5.900, 71.813 },
	{ 37.3, 5.913, 984.600 },
	{ 36.2, 5.403, 77.751 },
	{ 42.0, 2.091, 12.530 },
	{ 31.4, 4.592, 148.079 },
	{ 31.3, 2.267, 195.140 },
	{ 27.2, 3.532, 209.367 },
	{ 28.2, 4.578, 77.229 },
	{ 26.1, 0.660, 120.358 },
	{ 24.4, 5.867, 69.365 },
	{ 23.0, 1.038, 84.343 },
	{ 22.7, 1.714, 160.609 },
	{ 27.7, 4.915, 277.035 },
	{ 20.8, 2.196, 45.577 },
	{ 20.0, 2.321, 2.448 },
	{ 16.6, 4.775, 213.299 },
	{ 16.6, 1.856, 340.771 },
	{ 17.2, 4.369, 54.175 },
	{ 16.1, 3.646, 152.745 },
	{ 14.8, 5.438, 408.439 },
	{ 13.9, 3.385, 358.930 },
	{ 13.3, 5.252, 137.033 },
	{ 13.3, 1.263, 134.585 },
	{ 12.9, 3.033, 92.941 },
	{ 12.5, 1.332, 51.206 },
	{ 13.4, 1.532, 422.666 },
	{ 16.4, 0.402, 265.989 },
	{ 12.0, 5.104, 191.208 },
	{ 12.9, 4.432, 87.312 },
	{ 11.4, 2.026, 7.114 },
	{ 11.8, 4.656, 41.644 },
	{ 12.0, 3.239, 116.426 },
	{ 11.7, 3.733, 220.413 },
	{ 11.6, 4.165, 60.555 },
	{ 10.2, 0.329, 70.328 },
	{ 11.3, 1.076, 72.334 },
	{ 9.7, 3.06, 2.97 },
	{ 9.3, 2.44, 565.12 },
	{ 9.0, 5.19, 225.83 },
	{ 10.3, 1.186, 344.703 },
	{ 8.8, 6.01, 5.42 },
	{ 8.5, 5.25, 347.88 },
	{ 8.3, 3.72, 14.98 },
	{ 8.3, 2.27, 299.13 },
	{ 8.1, 5.72, 55.14 },
	{ 7.8, 0.90, 222.86 },
	{ 8.3, 4.49, 70.12 },
	{ 8.8, 5.82, 153.50 },
	{ 8.5, 3.91, 333.66 },
	{ 9.9, 5.97, 35.16 },
	{ 9.6, 0.39, 415.55 },
	{ 7.1, 1.51, 991.71 },
	{ 6.6, 1.18, 96.87 },
	{ 8.1, 2.26, 206.19 },
	{ 6.5, 2.99, 380.13 },
	{ 9.0, 6.05, 146.38 },
	{ 6.1, 0.06, 99.16 },
	{ 5.8, 0.82, 142.45 },
	{ 5.8, 4.63, 49.51 },
	{ 5.6, 0.66, 58.11 },
	{ 6.0, 2.49, 373.01 },
	{ 5.7, 2.24, 80.20 },
	{ 5.3, 5.07, 440.68 },
	{ 5.2, 4.36, 977.49 },
	{ 5.4, 0.85, 546.96 },
	{ 5.8, 0.34, 536.80 },
	{ 5.9, 5.48, 76.48 },
	{ 5.3, 3.73, 23.58 },
	{ 5.2, 4.14, 132.89 },
	{ 5.3, 6.14, 39.62 },
	{ 5.8, 3.40, 458.09 },
	{ 5.0, 4.26, 522.58 },
	{ 5.0, 4.79, 387.24 },
	{ 5.2, 3.26, 561.18 },
	{ 4.6, 1.69, 152.53 },
	{ 5.3, 1.84, 124.29 },
	{ 5.0, 0.37, 60.77 },
	{ 4.5, 2.30, 312.46 },
	{ 4.5, 0.46, 33.14 },
	{ 5.7, 0.90, 81.90 },
	{ 5.8, 0.92, 20.61 },
	{ 5.7, 0.66, 38.13 },
	{ 4.3, 3.55, 479.29 },
	{ 4.2, 4.38, 79.24 },
	{ 4.2, 1.65, 128.96 },
	{ 5.1, 1.41, 144.15 },
	{ 4.0, 6.07, 19.64 },
	{ 4.0, 5.77, 288.08 },
	{ 5.0, 3.00, 29.20 },
	{ 3.8, 2.60, 426.60 },
	{ 3.9, 3.20, 159.12 },
	{ 3.9, 4.44, 141.70 },
	{ 5.3, 4.08, 111.43 },
	{ 4.6, 0.01, 298.23 },
	{ 3.7, 5.28, 353.30 },
	{ 3.9, 5.27, 521.09 },
	{ 3.7, 5.15, 490.33 },
	{ 4.0, 0.61, 152.01 },
	{ 3.9, 1.34, 535.32 },
	{ 4.4, 0.62, 827.17 },
	{ 3.6, 4.72, 6.90 },
	{ 3.6, 3.25, 230.56 },
	{ 3.5, 0.79, 983.12 },
	{ 4.5, 2.87, 129.92 },
	{ 3.6, 5.59, 774.48 },
	{ 3.5, 4.50, 376.20 },
	{ 3.4, 2.56, 258.88 },
	{ 4.4, 2.10, 404.51 },
	{ 3.3, 0.90, 469.14 },
	{ 3.3, 3.86, 42.54 },
	{ 3.2, 2.76, 248.72 },
	{ 3.2, 0.08, 1514.29 },
	{ 3.8, 5.30, 369.08 },
	{ 3.3, 2.25, 73.82 },
	{ 3.1, 2.60, 433.71 },
	{ 3.1, 4.55, 980.67 },
	{ 3.1, 1.27, 200.77 },
	{ 3.1, 1.71, 639.90 },
	{ 3.1, 3.63, 16.67 },
	{ 3.5, 4.94, 411.62 },
	{ 3.5, 4.49, 881.51 },
	{ 3.3, 5.59, 472.17 },
	{ 3.0, 6.03, 291.26 },
	{ 3.5, 2.17, 554.07 },
	{ 3.1, 0.52, 1094.81 },
	{ 3.3, 2.49, 451.73 },
	{ 2.9, 0.50, 305.35 },
	{ 3.1, 4.20, 146.59 },
	{ 2.9, 2.45, 135.34 },
	{ 3.0, 0.39, 25.27 },
	{ 2.8, 2.53, 867.28 },
	{ 2.7, 5.29, 125.99 },
	{ 2.9, 4.71, 218.93 },
	{ 2.8, 4.28, 350.33 },
	{ 2.7, 1.99, 82.86 },
	{ 2.9, 3.09, 216.48 },
	{ 3.4, 3.68, 661.09 },
	{ 2.9, 1.44, 381.61 },
	{ 2.8, 0.39, 33.68 },
	{ 2.8, 4.63, 1357.61 },
	{ 3.4, 2.13, 685.47 },
	{ 2.6, 5.93, 89.76 },
	{ 2.7, 0.76, 486.40 },
	{ 2.7, 4.16, 235.39 },
	{ 2.6, 3.82, 550.89 },
	{ 3.4, 3.17, 108.46 },
	{ 2.6, 5.68, 24.38 },
	{ 2.7, 1.87, 529.69 },
	{ 2.6, 4.37, 1080.58 },
	{ 2.4, 3.07, 391.17 },
	{ 2.4, 5.74, 535.91 },
	{ 2.3, 5.19, 1059.38 },
	{ 2.6, 1.10, 913.00 },
	{ 2.2, 6.10, 140.00 },
	{ 3.1, 5.35, 681.54 },
	/* 192 terms retained, 0 terms dropped, error 8.5e-07 a.u.*T^2 */

	/* uranus r, T^3 */
	{ 1164.4, 4.73453, 74.78160 },
	{ 212.4, 3.3426, 63.7359 },
	{ 196.4, 2.9800, 70.8494 },
	{ 104.5, 0.9581, 11.0457 },
	{ 71.7, 0.025, 56.622 },
	{ 72.5, 0.997, 149.563 },
	{ 54.9, 2.594, 3.932 },
	{ 34.0, 3.816, 76.266 },
	{ 32.1, 3.598, 131.404 },
	{ 29.6, 3.441, 85.827 },
	{ 36.4, 5.650, 77.963 },
	{ 27.7, 0.428, 3.181 },
	{ 27.5, 2.551, 52.690 },
	{ 24.6, 5.140, 78.714 },
	{ 19.4, 5.135, 18.159 },
	{ 15.8, 0.371, 447.796 },
	{ 15.4, 5.573, 462.023 },
	{ 15.2, 3.860, 73.297 },
	{ 15.5, 2.975, 145.631 },
	{ 18.0, 0, 0 },
	{ 16.0, 5.199, 71.600 },
	{ 11.1, 6.032, 138.517 },
	{ 10.5, 3.583, 224.345 },
	{ 7.6, 1.45, 1.48 },
	{ 8.1, 2.62, 22.09 },
	{ 7.1, 5.44, 269.92 },
	{ 6.5, 4.37, 284.15 },
	{ 6.8, 0.01, 151.05 },
	{ 8.1, 0.30, 127.47 },
	{ 5.8, 4.23, 373.01 },
	{ 5.0, 1.84, 202.25 },
	{ 4.7, 2.78, 120.36 },
	{ 5.1, 0.78, 62.25 },
	{ 4.2, 1.84, 72.33 },
	{ 3.9, 1.89, 209.37 },
	{ 5.2, 4.16, 195.14 },
	{ 3.6, 2.00, 65.22 },
	{ 3.6, 3.93, 124.29 },
	{ 3.8, 1.05, 92.94 },
	{ 4.2, 3.96, 9.56 },
	{ 3.5, 1.54, 148.08 },
	{ 3.2, 2.99, 387.24 },
	{ 4.0, 1.86, 152.74 },
	{ 3.3, 1.41, 351.82 },
	{ 3.6, 1.17, 153.50 },
	{ 2.9, 6.04, 12.53 },
	{ 2.7, 5.65, 134.59 },
	{ 2.8, 0.79, 572.23 },
	{ 3.1, 5.84, 160.61 },
	{ 2.7, 1.99, 450.98 },
	{ 2.7, 2.77, 213.30 },
	{ 2.3, 1.68, 358.93 },
	{ 2.3, 5.77, 84.34 },
	{ 2.3, 4.81, 536.80 },
	{ 2.2, 2.20, 465.96 },
	/* 55 terms retained, 0 terms dropped, error 3.3e-07 a.u.*T^3 */

	/* uranus r, T^4 */
	{ 53.0, 3.008, 74.782 },
	{ 9.9, 1.91, 56.62 },
	{ 7.0, 5.09, 11.05 },
	{ 6.7, 5.43, 149.56 },
	{ 3.7, 5.23, 131.40 },
	{ 3.4, 1.30, 85.83 },
	{ 2.7, 0.44, 63.74 },
	{ 2.3, 0.92, 145.63 },
	{ 2.4, 6.21, 358.93 },
	{ 2.3, 2.23, 440.68 },
	{ 3.1, 3.14, 0 },
	/* 11 terms retained, 0 terms dropped, error 2.1e-07 a.u.*T^4 */
	/* end uranus */
};

int vn_uranus[][3] = {
	/* addresses for uranus l, b, r  */
	/* T^0 */ { 0, 355, 462, },
	/* T^1 */ { 152, 398, 832, },
	/* T^2 */ { 253, 432, 1122, },
	/* T^3 */ { 315, 449, 1314, },
	/* T^4 */ { 347, 460, 1369, },
	/* T^5 */ { 354, 462, 1380, },
	/* end */ { 355, 0, 0, },
	/* termination */ { 0, }
};

/*  version d4 (lbr)       
 *  heliocentric dynamical ecliptic and equinox of the date
 */

double vx_venus[][3] = {
	/* venus l, T^0 */
	{ 317614666.8, 0, 0 },
	{ 1353968.4, 5.59313320, 10213.28554621 },
	{ 89891.6, 5.306500, 20426.571092 },
	{ 5477.2, 4.41631, 7860.41939 },
	{ 3455.7, 2.69964, 11790.62909 },
	{ 2372.1, 2.99378, 3930.20970 },
	{ 1317.1, 5.18668, 26.29832 },
	{ 1664.1, 4.25019, 1577.34354 },
	{ 1438.3, 4.15745, 9683.59458 },
	{ 1200.5, 6.15357, 30639.85664 },
	{ 761.4, 1.9501, 529.6910 },
	{ 707.7, 1.0647, 775.5226 },
	{ 584.8, 3.9984, 191.4483 },
	{ 769.3, 0.8163, 9437.7629 },
	{ 499.9, 4.1234, 15720.8388 },
	{ 326.2, 4.5906, 10404.7338 },
	{ 429.5, 3.5864, 19367.1892 },
	{ 327.0, 5.6774, 5507.5532 },
	{ 231.9, 3.1625, 9153.9036 },
	{ 179.7, 4.6534, 1109.3786 },
	{ 128.3, 4.2260, 20.7754 },
	{ 155.5, 5.5704, 19651.0485 },
	{ 127.9, 0.9621, 5661.3320 },
	{ 105.5, 1.5372, 801.8209 },
	{ 85.7, 0.356, 3154.687 },
	{ 99.1, 0.833, 213.299 },
	{ 98.8, 5.394, 13367.973 },
	{ 82.1, 3.216, 18837.498 },
	{ 88.0, 3.889, 9999.986 },
	{ 71.6, 0.111, 11015.106 },
	{ 56.1, 4.240, 7.114 },
	{ 70.2, 0.675, 23581.258 },
	{ 50.8, 0.245, 11322.664 },
	{ 46.1, 5.316, 18073.705 },
	{ 44.6, 6.063, 40853.142 },
	{ 42.6, 5.329, 2352.866 },
	{ 42.6, 1.800, 7084.897 },
	{ 41.2, 0.362, 382.897 },
	{ 35.7, 2.704, 10206.172 },
	{ 33.9, 2.023, 6283.076 },
	{ 29.1, 3.592, 22003.915 },
	{ 28.5, 2.224, 1059.382 },
	{ 29.8, 4.022, 10239.584 },
	{ 33.3, 2.100, 27511.468 },
	{ 30.2, 4.942, 13745.346 },
	{ 29.3, 3.514, 283.859 },
	{ 26.3, 0.541, 17298.182 },
	/* 47 terms retained, 320 terms dropped, error 0.75" */

	/* venus l, T^1 */
	{ 1021352943052.9, 0, 0 },
	{ 95707.7, 2.464244, 10213.285546 },
	{ 14445.0, 0.516246, 20426.571092 },
	{ 213.4, 1.7955, 30639.8566 },
	{ 151.7, 6.1064, 1577.3435 },
	{ 173.9, 2.6554, 26.2983 },
	{ 82.2, 5.702, 191.448 },
	{ 69.7, 2.681, 9437.763 },
	{ 52.4, 3.600, 775.523 },
	{ 38.3, 1.034, 529.691 },
	{ 29.6, 1.251, 5507.553 },
	{ 25.1, 6.107, 10404.734 },
	{ 17.8, 6.194, 1109.379 },
	{ 16.5, 2.643, 7.114 },
	{ 14.2, 5.451, 9153.904 },
	{ 12.6, 1.245, 40853.142 },
	{ 11.6, 4.976, 213.299 },
	{ 12.6, 1.881, 382.897 },
	{ 8.9, 0.95, 13367.97 },
	{ 7.4, 4.39, 10206.17 },
	{ 6.6, 2.28, 2352.87 },
	{ 6.3, 4.08, 3154.69 },
	{ 6.7, 5.06, 801.82 },
	/* 23 terms retained, 192 terms dropped, error 0.14"*T */

	/* venus l, T^2 */
	{ 54127.1, 0, 0 },
	{ 3891.5, 0.34514, 10213.28555 },
	{ 1337.9, 2.02011, 20426.57109 },
	{ 23.8, 2.046, 26.298 },
	{ 19.3, 3.535, 30639.857 },
	{ 10.0, 3.971, 775.523 },
	{ 7.0, 1.52, 1577.34 },
	{ 6.0, 1.00, 191.45 },
	{ 3.2, 4.36, 9437.76 },
	{ 2.1, 2.66, 40853.14 },
	{ 1.9, 3.39, 382.90 },
	/* 11 terms retained, 59 terms dropped, error 0.028"*T^2 */

	/* venus l, T^3 */
	{ 135.7, 4.8039, 10213.2855 },
	{ 77.8, 3.669, 20426.571 },
	{ 26.0, 0, 0 },
	{ 1.2, 5.32, 30639.86 },
	/* 4 terms retained, 5 terms dropped, error 0.011"*T^3 */

	/* venus l, T^4 */
	{ 114.0, 3.1416, 0 },
	{ 3.2, 5.21, 20426.57 },
	{ 1.7, 2.51, 10213.29 },
	/* 3 terms retained, 2 terms dropped, error 0.014"*T^4 */

	/* venus l, T^5 */
	{ 0.9, 3.14, 0 },
	{ 0.1, 0.55, 20426.57 },
	{ 0.1, 1.91, 10213.29 },
	/* 3 terms retained, 2 terms dropped, error 0.00097"*T^5 */
	/* end venus l */

	/* venus b, T^0 */
	{ 5923638.5, 0.26702776, 10213.28554621 },
	{ 40108.0, 1.147372, 20426.571092 },
	{ 32814.9, 3.141593, 0 },
	{ 1011.4, 1.08946, 30639.85664 },
	{ 149.5, 6.2539, 18073.7049 },
	{ 137.8, 0.8602, 1577.3435 },
	{ 130.0, 3.6715, 9437.7629 },
	{ 119.5, 3.7047, 2352.8662 },
	{ 108.0, 4.5390, 22003.9146 },
	{ 92.0, 1.540, 9153.904 },
	{ 53.0, 2.281, 5507.553 },
	{ 45.6, 0.723, 10239.584 },
	{ 38.9, 2.934, 10186.987 },
	{ 43.5, 6.140, 11790.629 },
	{ 41.7, 5.991, 19896.880 },
	{ 39.6, 3.868, 8635.942 },
	{ 39.2, 3.950, 529.691 },
	{ 33.3, 4.832, 14143.495 },
	/* 18 terms retained, 192 terms dropped, error 0.6" */

	/* venus b, T^1 */
	{ 513347.6, 1.8036431, 10213.2855462 },
	{ 4380.1, 3.38616, 20426.57109 },
	{ 196.6, 2.5300, 30639.8566 },
	{ 199.2, 0, 0 },
	{ 14.0, 2.271, 9437.763 },
	{ 13.0, 1.507, 18073.705 },
	{ 11.9, 5.605, 1577.344 },
	{ 10.3, 5.242, 2352.866 },
	{ 9.3, 6.08, 22003.91 },
	{ 7.4, 1.50, 11790.63 },
	{ 8.0, 0.29, 9153.90 },
	{ 7.5, 5.08, 10186.99 },
	/* 12 terms retained, 121 terms dropped, error 0.11"*T */

	/* venus b, T^2 */
	{ 22377.7, 3.385091, 10213.285546 },
	{ 281.7, 0, 0 },
	{ 173.2, 5.2556, 20426.5711 },
	{ 26.9, 3.870, 30639.857 },
	/* 4 terms retained, 55 terms dropped, error 0.25"*T^2 */

	/* venus b, T^3 */
	{ 646.7, 4.9917, 10213.2855 },
	{ 20.0, 3.142, 0 },
	{ 5.5, 0.77, 20426.57 },
	{ 2.5, 5.44, 30639.86 },
	/* 4 terms retained, 11 terms dropped, error 0.023"*T^3 */

	/* venus b, T^4 */
	{ 14.1, 0.315, 10213.286 },
	{ 0.2, 2.35, 20426.57 },
	{ 0.2, 0.74, 30639.86 },
	{ 0.2, 3.14, 0 },
	/* 4 terms retained, 1 terms dropped, error 0.002"*T^4 */

	/* venus b, T^5 */
	{ 0.2, 2.05, 10213.29 },
	/* 1 terms retained, 3 terms dropped, error 0.0014"*T^5 */
	/* end venus b */

	/* venus r, T^0 */
	{ 72334820.9, 0, 0 },
	{ 489824.2, 4.0215183, 10213.2855462 },
	{ 1658.1, 4.90207, 20426.57109 },
	{ 1632.1, 2.84549, 7860.41939 },
	{ 1378.0, 1.12847, 11790.62909 },
	{ 498.4, 2.5868, 9683.5946 },
	{ 374.0, 1.4231, 3930.2097 },
	{ 263.6, 5.5294, 9437.7629 },
	{ 237.5, 2.5514, 15720.8388 },
	{ 222.0, 2.0135, 19367.1892 },
	{ 119.5, 3.0198, 10404.7338 },
	{ 125.9, 2.7277, 1577.3435 },
	{ 76.2, 1.596, 9153.904 },
	{ 85.3, 3.986, 19651.048 },
	{ 74.3, 4.120, 5507.553 },
	{ 41.9, 1.643, 18837.498 },
	{ 42.5, 3.819, 13367.973 },
	{ 39.4, 5.390, 23581.258 },
	{ 29.0, 5.677, 5661.332 },
	{ 27.6, 5.724, 775.523 },
	{ 27.3, 4.822, 11015.106 },
	{ 31.3, 2.318, 9999.986 },
	/* 22 terms retained, 308 terms dropped, error 3e-06 a.u. */

	/* venus r, T^1 */
	{ 34551.0, 0.891987, 10213.285546 },
	{ 234.2, 1.7722, 20426.5711 },
	{ 234.0, 3.1416, 0 },
	{ 23.9, 1.113, 9437.763 },
	{ 10.6, 4.592, 1577.344 },
	{ 9.1, 4.54, 10404.73 },
	{ 6.6, 5.98, 5507.55 },
	/* 7 terms retained, 173 terms dropped, error 3.7e-07 a.u.*T */

	/* venus r, T^2 */
	{ 1406.6, 5.06366, 10213.28555 },
	{ 15.5, 5.473, 20426.571 },
	{ 13.1, 0, 0 },
	/* 3 terms retained, 60 terms dropped, error 5.2e-07 a.u.*T^2 */

	/* venus r, T^3 */
	{ 49.6, 3.223, 10213.286 },
	{ 0.8, 3.21, 20426.57 },
	/* 2 terms retained, 5 terms dropped, error 2.9e-08 a.u.*T^3 */

	/* venus r, T^4 */
	{ 0.6, 0.92, 10213.29 },
	/* 1 terms retained, 2 terms dropped, error 1.6e-08 a.u.*T^4 */

	/* venus r, T^5 */
	/* 0 terms retained, 2 terms dropped, error 9e-10 a.u.*T^5 */
	/* end venus */
};

int vn_venus[][3] = {
	/* addresses for venus l, b, r  */
	/* T^0 */ { 0, 91, 134, },
	/* T^1 */ { 47, 109, 156, },
	/* T^2 */ { 70, 121, 163, },
	/* T^3 */ { 81, 125, 166, },
	/* T^4 */ { 85, 129, 168, },
	/* T^5 */ { 88, 133, 169, },
	/* end */ { 91, 134, 0, },
	/* termination */ { 0, }
};


/* For RCS Only -- Do Not Edit */
static char *rcsid[2] = {(char *)rcsid, "@(#) $RCSfile: vsop87_data.c,v $ $Date: 2009-07-16 10:34:39 $ $Revision: 1.8 $ $Name: not supported by cvs2svn $"};
