#include <stdlib.h>
#include <string.h>
#include "minifits.h"

// #include <iostream>

//////////////////////////////////////////////////////////////////////
///     Classe  MiniFITSException
//////////////////////////////////////////////////////////////////////


/* --Methode-- */
MiniFITSException::MiniFITSException(const char * m)   throw()
{
  if (m!=NULL) { 
    strncpy(msg_, m, MFEX_MAXMSGLEN-1);
    msg_[MFEX_MAXMSGLEN-1] = '\0';
  }
  else msg_[0] = '\0';
}

/* --Methode-- */
MiniFITSException::MiniFITSException(const string& m)   throw()
{
  strncpy(msg_, m.c_str(), MFEX_MAXMSGLEN-1);
  msg_[MFEX_MAXMSGLEN-1] = '\0';
}

/* --Methode-- */
MiniFITSException::~MiniFITSException()  throw()
{
}

/* --Methode-- */
const char* MiniFITSException::what() const throw()
{
  return msg_;
}

/* --Methode-- */
string const MiniFITSException::Msg() const 
{
  return (string(msg_));
}

//////////////////////////////////////////////////////////////////////
///     Classe  MiniFITSFile
//////////////////////////////////////////////////////////////////////

#define MFITSHLEN 2880

/* --Methode-- */
MiniFITSFile::MiniFITSFile()
{
  Init();
}

/* --Methode-- */
MiniFITSFile::MiniFITSFile(string const & nom, MiniFITS_Mode rwm)
{
  Init();
  Open(nom, rwm);
}

/* --Methode-- */
MiniFITSFile::MiniFITSFile(const char* nom, MiniFITS_Mode rwm)
{
  Init();
  Open(nom, rwm);
}


/* --Methode-- */
MiniFITSFile::~MiniFITSFile()
{
  Close();
  delete[] header;
}

/* --Methode-- */
void MiniFITSFile::Init()
{
  fip = NULL;
  rwmode = MF_Read;
  dtype = MF_Byte;
  nax1 = 1;
  nax2 = 1; 
  totwsz = 0;
  header = new char[MFITSHLEN];
  for(int i=0; i<MFITSHLEN; i++)  header[i]=' ';
  nkeya_ = 0;
}

/* --Methode-- */
void MiniFITSFile::Open(const char* nom, MiniFITS_Mode rwm)
{
  if (fip != NULL) throw MiniFITSException("MiniFITSFile::Open() - fip != NULL");
  if (rwm == MF_Write) {
    FillHeader();
    fip = fopen(nom, "w");
    if (fip == NULL) 
      throw MiniFITSException("MiniFITSFile::Open()/ failed fopen() for write");
    fwrite(header, 1, MFITSHLEN, fip);
    rwmode = MF_Write;
  }
  else {
    fip = fopen(nom, "r");
    if (fip == NULL) 
      throw MiniFITSException("MiniFITSFile::Open()/ failed fopen() for read");
    fread(header, 1, MFITSHLEN, fip);
    DecodeHeader();
    rwmode = MF_Read;
  }
  return;
}

/* --Methode-- */
void MiniFITSFile::Close()
{
  if (fip) { 
  	if (rwmode == MF_Write)  {  
  	  // on remplit avec des zeros pour avoir une longueur multiple de 2880	
  	  size_t padsz = MFITSHLEN-(totwsz%MFITSHLEN);
          char zeros[160];
  	  for(size_t k=0; k<160; k++) zeros[k]=0;
	  while(padsz>160) {
	    fwrite(zeros, 1, 160, fip);
	    padsz-=160;
	  }
	  if (padsz>0)  fwrite(zeros, 1, padsz, fip);
  	  // On reecrit l'entete 
  	  FillHeader();
  	  fseek(fip, 0, SEEK_SET);
  	  fwrite(header, 1, MFITSHLEN, fip);
  	}	
  	fclose(fip);
  }
  fip = NULL;
  return;
}

/* --Methode-- */
void MiniFITSFile::setDTypeNaxis(MiniFITS_DT dt, size_t na1, size_t na2)
{
  // Interdit si fichier ouvert en lecture ...
  if ((fip!=NULL)&&(rwmode == MF_Read))  
     throw MiniFITSException("MiniFITSFile::setDTypeNaxis()/Error ReadOnly file");

  dtype = dt;
  nax1 = na1; 
  nax2 = na2;
}

/* --Methode-- */
string MiniFITSFile::DataTypeToString()
{
  if (dtype == MF_Byte) return "MF_Byte";
  else if (dtype == MF_Int16) return "MF_Int16";
  else if (dtype == MF_Float32) return "MF_Float32";
  else return "Unknown??";
}

/* --Methode-- */
int MiniFITSFile::Write(void* data, size_t sz)
{
  fwrite(data, 1, sz, fip);
  totwsz += sz;
  return 0;
}

/* --Methode-- */
int MiniFITSFile::Read(void* data, size_t sz, size_t offset)
{
  fseek(fip, offset+MFITSHLEN, SEEK_SET);
  fread(data, 1, sz, fip);
  return 0;
}

/* --Methode-- */
void MiniFITSFile::FillHeader()
{
  strcpy(header, "SIMPLE  =                    T / file does conform to FITS standard");
  header[strlen(header)] = ' ';
  int bpix = 8;
  if (dtype == MF_Byte) bpix = 8;
  else if (dtype == MF_Int16) bpix = 16;
  else if (dtype == MF_Float32) bpix = -32;
  char * buff = header+80;
  sprintf(buff, "BITPIX  = %20d /   number of bits per data pixel", bpix);
  buff[strlen(buff)] = ' ';
  buff = header+160;
  strcpy(buff, "NAXIS   =                    2 / number of data axes");
  buff[strlen(buff)] = ' ';
  buff = header+240;
  sprintf(buff, "NAXIS1  = %20ld /   number of bits per data pixel", (long)nax1);
  buff[strlen(buff)] = ' ';
  buff = header+320;
  sprintf(buff, "NAXIS2  = %20ld /   number of bits per data pixel", (long)nax2);
  buff[strlen(buff)] = ' ';
  buff = header+400+nkeya_*80;
  strcpy(buff,"COMMENT  BAO-Radio / MiniFITSFile ");
  buff[strlen(buff)] = ' ';
  buff = header+480+nkeya_*80;
  strcpy(buff,"END");
  buff[strlen(buff)] = ' ';

  return;
}

/* --Methode-- */
int MiniFITSFile::AddKeyI(const char* key, long val, const char* comm)
{
  if (nkeya_ >= 29) return 0;
  char cle[10];
  strncpy(cle,key,8);
  cle[8]='=';
  for(int i=0;i<8;i++) 
    if (cle[i]=='\0') cle[i]=' ';
  cle[9]='\0';
  char* buff=header+400+nkeya_*80;
  if (comm!=NULL) {
    char tcom[50];
    strncpy(tcom,comm,48);  
    tcom[48]='\0';
    sprintf(buff,"%s %20ld / %s", cle, val, tcom);
  }
  else  sprintf(buff,"%s %20ld / ", cle, val);
  buff[strlen(buff)]=' ';
  nkeya_++;
  return nkeya_;
}

/* --Methode-- */
int MiniFITSFile::AddKeyD(const char* key, double val, const char* comm)
{
  if (nkeya_ >= 29) return 0;
  char cle[10];
  strncpy(cle,key,8);
  cle[8]='=';
  for(int i=0;i<8;i++) 
    if (cle[i]=='\0') cle[i]=' ';
  cle[9]='\0';
  char* buff=header+400+nkeya_*80;
  if (comm!=NULL) {
    char tcom[50];
    strncpy(tcom,comm,48);  
    tcom[48]='\0';
    sprintf(buff,"%s %20lg / %s", cle, val, tcom);
  }
  else  sprintf(buff,"%s %20ld / ", cle, val);
  buff[strlen(buff)] = ' ';
  nkeya_++;
  return nkeya_;
}

/* --Methode-- */
int MiniFITSFile::AddKeyS(const char* key, const char* val, const char* comm)
{
  if (nkeya_ >= 29) return 0;
  char cle[10];
  strncpy(cle,key,8);
  cle[8]='=';
  for(int i=0;i<8;i++) 
    if (cle[i]=='\0') cle[i]=' ';
  cle[9]='\0';
  char tcom[72];
  tcom[0]='\'';
  strncpy(tcom+1,val,65);
  int l=strlen(tcom);
  strcpy(tcom+l,"' / ");
  l+=4;
  if ((l<70)&&(comm!=NULL)) strncpy(tcom+l,comm,70-l);
  tcom[70]='\0';
  char* buff=header+400+nkeya_*80;
  sprintf(buff,"%s %s", cle, tcom);
  buff[strlen(buff)] = ' ';
  nkeya_++;
  return nkeya_;
}

/* --Methode-- */
void MiniFITSFile::DecodeHeader()
{
  // AMELIORER le decodage de l'entete, remplissage dtype, nax1, nax2
  char * buff = header;
  if (strncmp(buff, "SIMPLE  =", 9) != 0) 
     throw MiniFITSException("MiniFITSFile::DecodeHeader()/Error - NO SIMPLE keyword");
  bool fgokt=false;
  bool fgok1=false;
  bool fgok2=false;
  for(int kh=80; kh<2800; kh+=80) {
  	buff = header+kh;
  	if (strncmp(buff, "NAXIS1  =", 9) == 0)  {
  	  nax1 = atol(buff+10);
  	  fgok1 = true;
//  	  cout << " FOUND : NAXIS1= " << nax1 << endl;
  	} 
  	else if (strncmp(buff, "NAXIS2  =", 9) == 0)  {
  	  nax2 = atol(buff+10);
  	  fgok2 = true;
//  	  cout << " FOUND : NAXIS2= " << nax2 << endl;  	  
  	} 
  	else if (strncmp(buff, "BITPIX  =", 9) == 0)  {
  	  int bpix = atoi(buff+10);
  	  fgokt = true;
  	  if (bpix == 8)  dtype = MF_Byte;
  	  else if (bpix == 16)  dtype = MF_Int16;
  	  else if (bpix == -32)  dtype = MF_Float32;
  	  else fgokt = false;
//  	  cout << " FOUND : bpix= " << bpix << endl;  	  	  
  	} 
  }
  if (!(fgok1&&fgok2&&fgokt))  
     throw MiniFITSException("MiniFITSFile::DecodeHeader()/Error- Missing/wrong NAXIS1/2,BITPIX");
  return;
}

