// Classe d'initialisation du module TArray (template Arrays)
#include "sopnamsp.h"
#include "machdefs.h"
#include "tarrinit.h"

#include "fioarr.h"

/*!
   \defgroup TArray TArray module
   This module contains template arrays, matrices and vectors.
*/

/*!
  \class SOPHYA::TArrayInitiator
  \ingroup TArray
  Array Matrices and Vector initiator
*/

int TArrayInitiator::FgInit = 0;

// Module version number - 2.0 , Jul 2006
//   V= 2.04 , Jan/Fev 2007: Ajout TArray::ZeroSize() , RenewObjId() et methodes de cast (arrctcast.h)
//   V= 2.1 , Avr/Jul 2007: Constr.copie/extrac sous-tableaux thread-safe
#define MOD_VERS   2.1

TArrayInitiator::TArrayInitiator()
  : SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules TArray
  

  PPRegister(FIO_TArray<uint_1>);
  DObjRegister(FIO_TArray<uint_1>, TArray<uint_1>);
  DObjRegister(FIO_TArray<uint_1>, TMatrix<uint_1>);
  DObjRegister(FIO_TArray<uint_1>, TVector<uint_1>);

  PPRegister(FIO_TArray<int_1>);
  DObjRegister(FIO_TArray<int_1>, TArray<int_1>);
  DObjRegister(FIO_TArray<int_1>, TMatrix<int_1>);
  DObjRegister(FIO_TArray<int_1>, TVector<int_1>);

  PPRegister(FIO_TArray<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TArray<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TMatrix<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TVector<uint_2>);

  PPRegister(FIO_TArray<int_2>);
  DObjRegister(FIO_TArray<int_2>, TArray<int_2>);
  DObjRegister(FIO_TArray<int_2>, TMatrix<int_2>);
  DObjRegister(FIO_TArray<int_2>, TVector<int_2>);

  PPRegister(FIO_TArray<uint_4>);
  DObjRegister(FIO_TArray<uint_4>, TArray<uint_4>);
  DObjRegister(FIO_TArray<uint_4>, TMatrix<uint_4>);
  DObjRegister(FIO_TArray<uint_4>, TVector<uint_4>);

  PPRegister(FIO_TArray<int_4>);
  DObjRegister(FIO_TArray<int_4>, TArray<int_4>);
  DObjRegister(FIO_TArray<int_4>, TMatrix<int_4>);
  DObjRegister(FIO_TArray<int_4>, TVector<int_4>);

  PPRegister(FIO_TArray<uint_8>);
  DObjRegister(FIO_TArray<uint_8>, TArray<uint_8>);
  DObjRegister(FIO_TArray<uint_8>, TMatrix<uint_8>);
  DObjRegister(FIO_TArray<uint_8>, TVector<uint_8>);

  PPRegister(FIO_TArray<int_8>);
  DObjRegister(FIO_TArray<int_8>, TArray<int_8>);
  DObjRegister(FIO_TArray<int_8>, TMatrix<int_8>);
  DObjRegister(FIO_TArray<int_8>, TVector<int_8>);

  PPRegister(FIO_TArray<r_4>);
  DObjRegister(FIO_TArray<r_4>, TArray<r_4>);
  DObjRegister(FIO_TArray<r_4>, TMatrix<r_4>);
  DObjRegister(FIO_TArray<r_4>, TVector<r_4>);

  PPRegister(FIO_TArray<r_8>);
  DObjRegister(FIO_TArray<r_8>, TArray<r_8>);
  DObjRegister(FIO_TArray<r_8>, TMatrix<r_8>);
  DObjRegister(FIO_TArray<r_8>, TVector<r_8>);

  PPRegister(FIO_TArray< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TArray< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TMatrix< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TVector< complex<r_4> >);

  PPRegister(FIO_TArray< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TArray< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TMatrix< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TVector< complex<r_8> >);

  SophyaInitiator::RegisterModule("TArray", MOD_VERS);  // Module name and version number registration
}

TArrayInitiator::~TArrayInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static TArrayInitiator tarrayinit;

