#include "sopnamsp.h"
#include "machdefs.h"
#include "piinit.h"
#include "nobjmgr.h"
#include "servnobjm.h"

#include "nomdvladapter.h"
#include "nomhistadapter.h"
#include "nomherradapter.h"
#include "nomgfdadapter.h"
#include "nomimagadapter.h"

#include <complex>
#include "nomtmatvecadapter.h"
#include "nomtarradapter.h"

#include "datatable.h"
#include "swppfdtable.h"

#include "nomskymapadapter.h"
#include "spherethetaphi.h"
#include "spherehealpix.h"
#include "localmap.h"
#include "sphereecp.h"

#include "specrespvector.h"
#include "gaussfilt.h"
#include "nomspecrespadapter.h"

#include "piaversion.h"


int PIAppInitiator::FgInit = 0;

PIAppInitiator::PIAppInitiator(PIStdImgApp * app)
 : SambaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

  Services2NObjMgr* serv = app->ObjMgr()->GetServiceObj();

  serv->RegisterClass(new DVList, new NOMAdapter_DVList );
  serv->RegisterClass(new Histo, new NOMAdapter_Histo );
  serv->RegisterClass(new HProf, new NOMAdapter_Histo );
  serv->RegisterClass(new Histo2D, new NOMAdapter_Histo2D );

  serv->RegisterClass(new HistoErr, new NOMAdapter_HistoErr );
  serv->RegisterClass(new Histo2DErr, new NOMAdapter_Histo2DErr );

  serv->RegisterClass(new NTuple, new NOMAdapter_NTuple );

  serv->RegisterClass(new DataTable, new NOMAdapter_DataTable );
  serv->RegisterClass(new SwPPFDataTable, new NOMAdapter_DataTable );

  serv->RegisterClass(new GeneralFitData, new NOMAdapter_GeneralFitData );

//  Octobre 2008 : prise en charge tableaux/matrice/vecteurs en uint_4 uint_8 
  serv->RegisterClass(new TArray<uint_1>, new NOMAdapter_TArray<uint_1> );
  serv->RegisterClass(new TArray<uint_2>, new NOMAdapter_TArray<uint_2> );
  serv->RegisterClass(new TArray<uint_4>, new NOMAdapter_TArray<uint_4> );
  serv->RegisterClass(new TArray<uint_8>, new NOMAdapter_TArray<uint_8> );
  serv->RegisterClass(new TArray<int_1>, new NOMAdapter_TArray<int_1> );
  serv->RegisterClass(new TArray<int_2>, new NOMAdapter_TArray<int_2> );
  serv->RegisterClass(new TArray<int_4>, new NOMAdapter_TArray<int_4> );
  serv->RegisterClass(new TArray<int_8>, new NOMAdapter_TArray<int_8> );
  serv->RegisterClass(new TArray<r_4>, new NOMAdapter_TArray<r_4> );
  serv->RegisterClass(new TArray<r_8>, new NOMAdapter_TArray<r_8> );
  serv->RegisterClass(new TArray<complex<r_4> >, new NOMAdapter_TArray<complex<r_4> > );
  serv->RegisterClass(new TArray<complex<r_8> >, new NOMAdapter_TArray<complex<r_8> > );

  serv->RegisterClass(new TVector<uint_1>, new NOMAdapter_TMatrix<uint_1> );
  serv->RegisterClass(new TMatrix<uint_1>, new NOMAdapter_TMatrix<uint_1> );
  serv->RegisterClass(new TVector<uint_2>, new NOMAdapter_TMatrix<uint_2> );
  serv->RegisterClass(new TMatrix<uint_2>, new NOMAdapter_TMatrix<uint_2> );
  serv->RegisterClass(new TVector<uint_4>, new NOMAdapter_TMatrix<uint_4> );
  serv->RegisterClass(new TMatrix<uint_4>, new NOMAdapter_TMatrix<uint_4> );
  serv->RegisterClass(new TVector<uint_8>, new NOMAdapter_TMatrix<uint_8> );
  serv->RegisterClass(new TMatrix<uint_8>, new NOMAdapter_TMatrix<uint_8> );
  serv->RegisterClass(new TVector<int_1>, new NOMAdapter_TMatrix<int_1> );
  serv->RegisterClass(new TMatrix<int_1>, new NOMAdapter_TMatrix<int_1> );
  serv->RegisterClass(new TVector<int_2>, new NOMAdapter_TMatrix<int_2> );
  serv->RegisterClass(new TMatrix<int_2>, new NOMAdapter_TMatrix<int_2> );
  serv->RegisterClass(new TVector<int_4>, new NOMAdapter_TMatrix<int_4> );
  serv->RegisterClass(new TMatrix<int_4>, new NOMAdapter_TMatrix<int_4> );
  serv->RegisterClass(new TVector<int_8>, new NOMAdapter_TMatrix<int_8> );
  serv->RegisterClass(new TMatrix<int_8>, new NOMAdapter_TMatrix<int_8> );
  serv->RegisterClass(new TVector<r_4>, new NOMAdapter_TMatrix<r_4> );
  serv->RegisterClass(new TMatrix<r_4>, new NOMAdapter_TMatrix<r_4> );
  serv->RegisterClass(new TVector<r_8>, new NOMAdapter_TMatrix<r_8> );
  serv->RegisterClass(new TMatrix<r_8>, new NOMAdapter_TMatrix<r_8> );
  serv->RegisterClass(new TVector<complex<r_4> >, new NOMAdapter_TMatrix<complex<r_4> > );
  serv->RegisterClass(new TMatrix<complex<r_4> >, new NOMAdapter_TMatrix<complex<r_4> > );
  serv->RegisterClass(new TVector<complex<r_8> >, new NOMAdapter_TMatrix<complex<r_8> > );
  serv->RegisterClass(new TMatrix<complex<r_8> >, new NOMAdapter_TMatrix<complex<r_8> > );

  /*  Avril 2007 : Prise en charge des images par NOMAdapter_TMatrix  au lieu de
      NOMAdapter_Image<T> , deplace ci-dessous dans SANS_EVOLPLANCK */
  serv->RegisterClass(new Image<uint_2>, new NOMAdapter_TMatrix<uint_2> );
  serv->RegisterClass(new Image<uint_4>, new NOMAdapter_TMatrix<uint_4> );
  serv->RegisterClass(new Image<uint_8>, new NOMAdapter_TMatrix<uint_8> );
  serv->RegisterClass(new Image<int_2>, new NOMAdapter_TMatrix<int_2> );
  serv->RegisterClass(new Image<int_4>, new NOMAdapter_TMatrix<int_4> );
  serv->RegisterClass(new Image<int_8>, new NOMAdapter_TMatrix<int_8> );
  serv->RegisterClass(new Image<r_4>, new NOMAdapter_TMatrix<r_4> );
  serv->RegisterClass(new Image<r_8>, new NOMAdapter_TMatrix<r_8> );
  serv->RegisterClass(new Image<complex<r_4> >, new NOMAdapter_TMatrix<complex<r_4> > );
  serv->RegisterClass(new Image<complex<r_8> >, new NOMAdapter_TMatrix<complex<r_8> > );

  serv->RegisterClass(new LocalMap<int_4>, new NOMAdapter_PixelMap<int_4> );
  serv->RegisterClass(new SphereThetaPhi<int_4>, new NOMAdapter_PixelMap<int_4> );
  serv->RegisterClass(new SphereHEALPix<int_4>, new NOMAdapter_PixelMap<int_4> );
  serv->RegisterClass(new SphereECP<int_4>, new NOMAdapter_PixelMap<int_4> );
  serv->RegisterClass(new LocalMap<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new SphereThetaPhi<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new SphereHEALPix<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new SphereECP<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new LocalMap<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new SphereThetaPhi<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new SphereHEALPix<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new SphereECP<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new LocalMap<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new SphereThetaPhi<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new SphereHEALPix<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new SphereECP<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new LocalMap<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );
  serv->RegisterClass(new SphereThetaPhi<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );
  serv->RegisterClass(new SphereHEALPix<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );
  serv->RegisterClass(new SphereECP<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );

  serv->RegisterClass(new GaussianFilter, new NOMAdapter_SpectralResponse );
  serv->RegisterClass(new SpecRespVec, new NOMAdapter_SpectralResponse );

  SophyaInitiator::RegisterModule("PIext/piapp", PIAPP_VERSIONNUMBER);
}

PIAppInitiator::~PIAppInitiator()
{
  FgInit--;
/*  if (FgInit == 0)
    {
    }  */
}

