//  Adaptateurs pour TMatrix TVector du package Sophya
//                             R. Ansari  1/99
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "pitvmaad.h"
#include <math.h>

/* --Methode-- */
template <class T> 
POTVectorAdapter<T>::POTVectorAdapter(TVector<T>* v, bool ad)
        : P1DArrayAdapter(v->NElts())
{
aDel = ad; 
mVec = v; 
}
/* --Methode-- */
template <class T> 
POTVectorAdapter<T>::~POTVectorAdapter()
{
if (aDel) delete mVec;
}

/* --Methode-- */
template <class T> 
double POTVectorAdapter<T>::Value(int i)
{
return((*mVec)(i));
}

/* --Methode-- */
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
double POTVectorAdapter< complex<float> >::Value(int i)
{
double re,im;
re = (*mVec)(i).real();
im = (*mVec)(i).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
double POTVectorAdapter< complex<double> >::Value(int i)
{
double re,im;
re = (*mVec)(i).real();
im = (*mVec)(i).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
template <class T> 
POTMatrixAdapter<T>::POTMatrixAdapter(TMatrix<T>* mtx, bool ad)
        : P2DArrayAdapter(mtx->NCols(), mtx->NRows())
{
aDel = ad; 
mMtx = mtx;
}
/* --Methode-- */
template <class T> 
POTMatrixAdapter<T>::~POTMatrixAdapter()
{
if (aDel)  delete mMtx;
}
/* --Methode-- */
template <class T> 
double POTMatrixAdapter<T>::Value(int ix, int iy)
{
return((double)(*mMtx)(iy, ix));
}

/* --Methode-- */
template <class T> 
double POTMatrixAdapter<T>::MeanVal(int ix1, int ix2, int jy1, int jy2)
{
int ec;
if (ix1>ix2) { ec=ix1; ix1=ix2; ix2=ec; }
if (jy1>jy2) { ec=jy1; jy1=jy2; jy2=ec; }    
double ss = 0.;
for(int j=jy1; j<=jy2; j++) 
  for(int i=ix1; i<=ix2; i++)  ss += (double)((*mMtx)(j, i));
ss /= (double)((jy2-jy1+1)*(ix2-ix1+1));
return ss;  
}   


/* --Methode-- */
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
double POTMatrixAdapter< complex<float> >::Value(int ix, int iy)
{
double re,im;
re = (*mMtx)(iy, ix).real();
im = (*mMtx)(iy, ix).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
double POTMatrixAdapter< complex<double> >::Value(int ix, int iy)
{
double re,im;
re = (*mMtx)(iy, ix).real();
im = (*mMtx)(iy, ix).imag();
return(sqrt(re*re+im*im));
}

/* --Methode-- */
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
double POTMatrixAdapter< complex<float> >::MeanVal(int ix1, int ix2, int jy1, int jy2)
{
int ec;
if (ix1>ix2) { ec=ix1; ix1=ix2; ix2=ec; }
if (jy1>jy2) { ec=jy1; jy1=jy2; jy2=ec; }    
complex<float> ss = 0.;
for(int j=jy1; j<=jy2; j++) 
  for(int i=ix1; i<=ix2; i++)  ss += (*mMtx)(j, i);
ss /= (double)((jy2-jy1+1)*(ix2-ix1+1));
return sqrt(ss.real()*ss.real()+ss.imag()*ss.imag());  
}   

/* --Methode-- */
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
double POTMatrixAdapter< complex<double> >::MeanVal(int ix1, int ix2, int jy1, int jy2)
{
int ec;
if (ix1>ix2) { ec=ix1; ix1=ix2; ix2=ec; }
if (jy1>jy2) { ec=jy1; jy1=jy2; jy2=ec; }    
complex<double> ss = 0.;
for(int j=jy1; j<=jy2; j++) 
  for(int i=ix1; i<=ix2; i++)  ss += (*mMtx)(j, i);
ss /= (double)((jy2-jy1+1)*(ix2-ix1+1));
return sqrt(ss.real()*ss.real()+ss.imag()*ss.imag());  
}   

#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template POTVectorAdapter< uint_1 >
#pragma define_template POTVectorAdapter< uint_2 >
#pragma define_template POTVectorAdapter< uint_4 >
#pragma define_template POTVectorAdapter< uint_8 >
#pragma define_template POTVectorAdapter< int_1 >
#pragma define_template POTVectorAdapter< int_2 >
#pragma define_template POTVectorAdapter< int_4 >
#pragma define_template POTVectorAdapter< int_8 >
#pragma define_template POTVectorAdapter< float >
#pragma define_template POTVectorAdapter< double >
#pragma define_template POTVectorAdapter< complex<float> > 
#pragma define_template POTVectorAdapter< complex<double> > 

#pragma define_template POTMatrixAdapter< uint_1 >
#pragma define_template POTMatrixAdapter< uint_2 >
#pragma define_template POTMatrixAdapter< uint_4 >
#pragma define_template POTMatrixAdapter< uint_8 >
#pragma define_template POTMatrixAdapter< int_1 >
#pragma define_template POTMatrixAdapter< int_2 >
#pragma define_template POTMatrixAdapter< int_4 >
#pragma define_template POTMatrixAdapter< int_8 >
#pragma define_template POTMatrixAdapter< float >
#pragma define_template POTMatrixAdapter< double >
#pragma define_template POTMatrixAdapter< complex<float> > 
#pragma define_template POTMatrixAdapter< complex<double> > 
#endif

#if defined(ANSI_TEMPLATES)
template class POTVectorAdapter< uint_1 >;
template class POTVectorAdapter< uint_2 >;
template class POTVectorAdapter< uint_4 >;
template class POTVectorAdapter< uint_8 >;
template class POTVectorAdapter< int_1 >;
template class POTVectorAdapter< int_2 >;
template class POTVectorAdapter< int_4 >;
template class POTVectorAdapter< int_8 >;
template class POTVectorAdapter< float >;
template class POTVectorAdapter< double >;
template class POTVectorAdapter< complex<float> >;
template class POTVectorAdapter< complex<double> >;

template class POTMatrixAdapter< uint_1 >;
template class POTMatrixAdapter< uint_2 >;
template class POTMatrixAdapter< uint_4 >;
template class POTMatrixAdapter< uint_8 >;
template class POTMatrixAdapter< int_1 >;
template class POTMatrixAdapter< int_2 >;
template class POTMatrixAdapter< int_4 >;
template class POTMatrixAdapter< int_8 >;
template class POTMatrixAdapter< float >;
template class POTMatrixAdapter< double >;
template class POTMatrixAdapter< complex<float> >;
template class POTMatrixAdapter< complex<double> >;
#endif
