#include "brparam.h"
#include "strutilxx.h"
#include "bracqvers.h"

/* --Methode-- */
ADCBoardDesc::ADCBoardDesc(int id, string sbid, string cyc_firmw, string str1_firmw, string str2_firmw)
  : id_(id), sbid_(sbid), cyclone_firmware_(cyc_firmw), stratix1_firmware_(str1_firmw), stratix2_firmware_(str2_firmw)
{
  
}

/* --Methode-- */
ADCBoardDesc::ADCBoardDesc(ADCBoardDesc const& bdes)
  : id_(bdes.id_), sbid_(bdes.sbid_), cyclone_firmware_(bdes.cyclone_firmware_), 
    stratix1_firmware_(bdes.stratix1_firmware_), stratix2_firmware_(bdes.stratix2_firmware_)
{
}

/* --Methode-- */
ADCBoardDesc& ADCBoardDesc::Set(ADCBoardDesc const & bdes)
{
  id_ = bdes.id_;
  sbid_ = bdes.sbid_;
  cyclone_firmware_ = bdes.cyclone_firmware_;
  stratix1_firmware_ = bdes.stratix1_firmware_;
  stratix2_firmware_ = bdes.stratix2_firmware_;
  return(*this);
}

/* --Methode-- */
ostream& ADCBoardDesc::Print(ostream& os)
{
  os << "ADCBoard#" << id_ << "(" << sbid_ << ") Cyclone:" << cyclone_firmware_ 
     << " Stratix1: " << stratix1_firmware_ << " Stratix2: " << stratix2_firmware_ << endl;
  return os;
}

/* --Methode-- */
BRConfList::BRConfList()
  : basedir_("./")
{
}

/* --Methode-- */
BRConfList::BRConfList(string basedir)
  : basedir_(basedir)
{
}

/* --Methode-- */
BRConfList::BRConfList(string basedir, vector<ADCBoardDesc> boards)
  : basedir_(basedir), boards_(boards)
{
  size_t len = basedir_.length();
  if ((len>1)&&(basedir_[len-1]!='/')) basedir_ += '/';
}

/* --Methode-- */
BRConfList::BRConfList(BRConfList const & cf)
  : basedir_(cf.basedir_), boards_(cf.boards_)
{
}

/* --Methode-- */
void BRConfList::Set(BRConfList const & cf)
{
  basedir_=cf.basedir_;
  boards_=cf.boards_;
}

/* --Methode-- */
ostream& BRConfList::Print(ostream& os)
{
  os << " ----- BRConfList:: BaseDir:" << basedir_ << " NBoards= " << boards_.size() << endl;
  for(size_t k=0; k<boards_.size(); k++)  boards_[k].Print(os);
  return os;
}

/* --Methode-- */
void BRConfList::ReadDCFile(string file)
{
  //  A FAIRE 
}

// Classe qui memorise tous les parametres importants de l'acquisition

/* --Methode-- */
BRParList::BRParList(string fibres,unsigned int paqsz ,unsigned int nframeDMA, 
		     int nfiles, string acqmod,int nblocfile,int nmxproc ,
		     string outpath, uint_4 nzon , uint_4 npaqzon, bool fgcntlc)
{
  FiberListS=fibres;
  NbFibers=0;
  for (int fib=0; fib<PMAXNBFIBRES;fib++)  FiberNum[fib]=0;
  PaqSize=paqsz;
  nbFrameDMA=nframeDMA;
  NbFiles=nfiles;
  AcqMode=acqmod;
  NBlocPerFile=nblocfile;
  NMaxProc=nmxproc;
  OutPathName=outpath;
  nZones=nzon;
  nPaqZone=npaqzon;
  swapall=BR_Copy;
  savesigfits=true;
  fgnulldev4fits=false;
  fg_hard_ctrlc=fgcntlc;
  fgreducpsize=false;
  redpqsize=PaqSize;
  reducoffset=0;

  monothr=false;
  activate_pattern=false;

  Decode();    // On decode et on complete les parametres 
}

/* --Methode-- */
BRParList::BRParList(BRParList const & p)
{
  Set(p);
}

/* --Methode-- */
void BRParList::Set(BRParList const & p)
{
  FiberListS=p.FiberListS;
  NbFibers=p.NbFibers;
  for (int fib=0; fib<PMAXNBFIBRES;fib++)  FiberNum[fib]=p.FiberNum[fib];
  PaqSize=p.PaqSize;
  nbFrameDMA=p.nbFrameDMA;
  NbFiles=p.NbFiles;
  AcqMode=p.AcqMode;
  NBlocPerFile=p.NBlocPerFile;
  NMaxProc=p.NMaxProc;
  OutPathName=p.OutPathName;
  nZones=p.nZones;
  nPaqZone=p.nPaqZone;
  swapall=p.swapall;
  savesigfits=p.savesigfits;
  fgnulldev4fits=p.fgnulldev4fits;
  fg_hard_ctrlc=p.fg_hard_ctrlc;
  fgnulldev4fits=p.fgnulldev4fits;

  fgreducpsize=p.fgreducpsize;
  redpqsize=p.redpqsize;
  reducoffset=p.reducoffset;

  monothr=p.monothr;
  activate_pattern=p.activate_pattern;
  return;
}

/* --Methode-- */
void BRParList::ReadDCFile(string file)
{
  DataCards conf(file);
  FiberListS= conf.SParam("Fibres",0,"1");
  PaqSize=(unsigned int)conf.IParam("PaqSZ",0,16424);
  nbFrameDMA =(unsigned int) conf.IParam("nbFrameDma",0,32);
  NbFiles=conf.IParam("NbFiles",0,1);
  NBlocPerFile=conf.IParam("NBlocPerFile",0,10);
  NMaxProc=conf.IParam("NMaxProc",0,0);
  OutPathName= conf.SParam("OutPathName",0,"TstAcq");
  AcqMode =conf.SParam("acqmode",0,"std");
  nZones=(unsigned int)conf.IParam("nZones",0,4);
  nPaqZone=(uint_4)conf.IParam("nPaqZone",0,128);
  fg_hard_ctrlc=conf.HasKey("fg_hard_ctrlc");

  Decode();
}

/* --Methode-- */
void BRParList::Decode() 
{
  vector<string> fiblist;
  FillVStringFrString(FiberListS, fiblist, ',');
  NbFibers=fiblist.size();
  for (int fib=0; fib<fiblist.size(); fib++) {
    FiberNum[fib]=atoi(fiblist[fib].c_str()); 
  }
  if (OutPathName == "/dev/null") { 
    fgnulldev4fits=true;
  }
  else { 
    size_t len = OutPathName.length();
    if ((len>1)&&(OutPathName[len-1]!='/')) OutPathName+='/';
    fgnulldev4fits=false;
  }
  string acqmode = AcqMode;
  if (acqmode == "std")  swapall = BR_Copy ;
  if (acqmode == "nosw")   swapall = BR_Copy ;
  if (acqmode == "nof")  { swapall = BR_Copy ; savesigfits = false; }
  if (acqmode == "fft1c")  swapall = BR_FFTOneChan;
  if (acqmode == "fft2c")  swapall = BR_FFTTwoChan;
  if (acqmode == "fft1cnof")  { swapall = BR_FFTOneChan;  savesigfits = false; }
  if (acqmode == "fft2cnof")  { swapall = BR_FFTTwoChan;  savesigfits = false; }
  if (acqmode == "mono")  { monothr = true;   swapall = BR_Copy; }
  if (acqmode == "monodirect")  { monothr = true;  swapall =  BR_CopyHDR;}
  if (acqmode == "patmonodirect")  { monothr = true;  swapall =  BR_CopyHDR; activate_pattern=true; }
  if (acqmode == "patmono")  { monothr = true;   swapall = BR_Copy; activate_pattern=true; }
  if (acqmode == "patnof")  { savesigfits = false; swapall = BR_Copy; activate_pattern=true; }
  if (acqmode == "pattern")  { savesigfits = true; swapall = BR_Copy; activate_pattern=true; }

  if (acqmode == "swapall")  swapall = BR_SwapAll;
  if (acqmode == "fft1csw")  swapall = BR_FFTOneChanSwapAll;
  if (acqmode == "fft2csw")  swapall = BR_FFTTwoChanSwapAll;
  if (acqmode == "fft1cswnof")  { swapall = BR_FFTOneChanSwapAll;  savesigfits = false; }
  if (acqmode == "fft2cswnof")  { swapall = BR_FFTTwoChanSwapAll;  savesigfits = false; }
  if ((acqmode == "swh") || (acqmode == "mxs") || (acqmode == "monoswh") )  swapall = BR_SwapHDR;
  if ((acqmode == "swapallnof") || (acqmode == "mxs") )  savesigfits = false;
  if (acqmode == "monoswh")  { monothr = true;   swapall = BR_SwapHDR;; }
  if (acqmode == "monosw")  { monothr = true;   swapall = BR_SwapAll; }

  if (acqmode == "swap32")   swapall = BR_Swap32 ;
  if (acqmode == "nof32")   { swapall = BR_Swap32 ; savesigfits = false; }
  if (acqmode == "fft1c32")  swapall = BR_FFTOneChanSwap32;
  if (acqmode == "fft2c32")  swapall = BR_FFTTwoChanSwap32;
  if (acqmode == "fft1cnof32")  { swapall = BR_FFTOneChanSwap32;  savesigfits = false; }
  if (acqmode == "fft2cnof32")  { swapall = BR_FFTTwoChanSwap32;  savesigfits = false; }
}

/* --Methode-- */
ostream& BRParList::Print(ostream& os) 
{  
  os << " ------ BRParList::Print() ----- " << endl;
  os << " FiberListS=" << FiberListS ;
  os << " PaqSize=" <<PaqSize;
  os << " nbFrameDMA=" <<nbFrameDMA << endl;
  os << " AcqMode="<<AcqMode;
  os << " Type of acquisition :" << BRPaquet::FmtConvToString( swapall) << endl;
  os << " NbFiles="<<NbFiles;
  os << " NBlocPerFile="<<NBlocPerFile;
  os << " OutPathName="<<OutPathName << endl;
  os << " MemMgr: nZones="<<nZones;
  os << " nPaqZone="<<nPaqZone;
  os << " fg_hard_ctrlc=" << ((fg_hard_ctrlc)?"true":"false");
  os << " Save to fits " << ((savesigfits)?"true":"false") << endl;
  os << " monothr y(1)/n(0) " << ((monothr)?"true":"false"); 
  os << " ActivatePattern " << ((activate_pattern)?"true":"false") <<  endl;
  
  return os;
}


//-------------------- Classe BRAcqConfig -----------------------

BRParList* BRAcqConfig::param_=NULL;
BRConfList* BRAcqConfig::config_=NULL;

/* --Methode-- */
BRAcqConfig::BRAcqConfig()
{
  if (param_==NULL)  param_ = new BRParList;  
  if (config_==NULL) config_ = new BRConfList;
}

/* --Methode-- */
ostream& BRAcqConfig::Print(ostream& os)
{ 
  os << " ------------  BAORadio Acq Run/Configuration -------- " << endl;
  config_->Print(os);
  param_->Print(os); 
  os << " ----------------------------------------------------- " << endl;
}

/* --Methode-- */
int BRAcqConfig::CreateOutputDirectories()
{
  char cmd[1024];
  if (param_->fgnulldev4fits!=true) {
    sprintf(cmd,"mkdir %s%s",config_->BaseDirectory().c_str(), param_->OutPathName.c_str());
    if (system(cmd) < 0) {
      cout << "CreateOutputDirectories()/Error: Can not create subdirectory " 
	   << cmd << " -> stop" << endl;
      return 2;
    }
    cout << "CreateOutputDirectories() - Executed command " << cmd << endl;
    
    memset(cmd,0,1024); 
    for (int  i= 0; i< NFibers() ; i++)  {
      sprintf(cmd,"mkdir %s%s/Fiber%d",config_->BaseDirectory().c_str(), param_->OutPathName.c_str(),param_->FiberNum[i]);
      if (system(cmd) < 0) {
	cout << "CreateOutputDirectories()/Error: Can not create subdirectory " 
	     << cmd << " -> stop" << endl;
	return 3;
      }
      else cout << "CreateOutputDirectories() - Executed command " << cmd << endl;
    }
  }
  else {
    string ProcPathName = "./XZXZXZX/";
    cout << " Using " << ProcPathName << " for other processed files ... " << endl;
    char cmd[512];
    sprintf(cmd,"mkdir %s",ProcPathName.c_str());
    if (system(cmd) < 0) {
      cout << "CreateOutputDirectories()/Error: Can not create subdirectory ./XZXZXZX/" 
	   << "-> stop" << endl;
      return 3;
    }
    else cout << "CreateOutputDirectories() - Executed command " << cmd << endl;
  }
  return 0;
}

/* --Methode-- */
string BRAcqConfig::OutputDirectoryFib(int ifib)
{
  char buff[24];
  sprintf(buff,"Fiber%d/",param_->FiberNum[ifib]);
  return ( config_->BaseDirectory() + param_->OutPathName + buff );
}
