// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

// include standard c/c++
#include <math.h>
#include <stdio.h>

#include <iostream>
#include <string>

#include "pexceptions.h"  // les exceptions SOPHYA

// Include sophya des tableaux
#include "tvector.h" // Pour l'utilisation des classes TArray, TMatrix , TVector
#include "fioarr.h"  // Pour IO PPF TArray
#include "sopemtx.h"
#include "matharr.h"
#include "tarrinit.h" // Pour l'utilisation des classes TArray, TMatrix , TVecto
// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

// ---- ENTETE classe BRPaquet 
#include "brpaqu.h"

int main(int narg, char* arg[])
{
	/*
  cout << " sizeof(UInt32)= " << sizeof(UInt32) << endl;
    cout << " sizeof(UInt64)= " << sizeof(UInt64) << endl;
 UInt64 i1,i2,i3; 
 i1 = 0xFF000000; 
 i2 = i1*256; 
 i3 = 20000000000L;
 cout << " i1= " << i1 << " i2 = " << i2 << " 0x" << hex << i2 
      << dec << " i3=" << i3 << " 0x"<< hex << i3 << dec << endl;
      */
      
  if (narg < 3) {
    cout << "tbrpaq.cc/Erreur arg: tbrpaq paqsz paqredsz [neltsprint=8] [OutPPFFileName]" << endl;
    return 1;
  }

  // Sophya modules initialization
  TArrayInitiator  _inia;
  //------- AU LIEU DE ------>  SophyaInit();

  InitTim();   // Initializing the CPU timer

  int paqsz = atoi(arg[1]);
  int redpsz = atoi(arg[2]);
  int nelt = 8;
  if (narg>3) nelt = atoi(arg[3]);

  cout << " tbrpaq :  PaqSize=" << paqsz << " RedPaqSize " << endl;
  Byte * src = new Byte[paqsz];
  Byte * dst = new Byte[paqsz];

  for(int kk=0; kk<paqsz; kk++) src[kk]=kk%256;
  cout << " tbrpaq : Creating BRPaquet(src,dst,paqsz) ... " << endl;

  BRPaquet paq(src, dst, paqsz);
  cout << " tbrpaq : Appel paq.Print(cout) ... " << endl;
  paq.Print(cout, nelt, true);

  int NN=100;
  Byte * rdst = new Byte[NN*redpsz];

  for(int n=0; n<NN; n++) {
    BRPaquet paqc(rdst+n*redpsz, redpsz);
    paqc.CopyFrom(paq, BR_TwoChanReduc, 0);
    if ((n==0)||(n==NN-1)) paqc.Print(cout, nelt, true);
  }

  // Cleanup
  delete[] src;
  delete[] dst;
  delete[] rdst;

  PrtTim("FIN tbrpaq.cc");
  cout << " ---------- FIN tbrpaq -----------" << endl;
  return 0;
}
