#include "mfacq.h"

//---------------------------------------------------------------
// Programme d'acquisition BAORadio multi-fibres/multi-threads 
//  LAL -   2009 - 2010
//     R. Ansari, M.Taurigna
//---------------------------------------------------------------

static RAcqMemZoneMgr* pMmgr=NULL;
static  PCIEMultiReader* pPcierThr=NULL;

void Stop(int s)
{ 
  if (s == 9765) cout << " Stop after exception ..." << endl;
  else printf("............. MAIN ... receive signal %d \n",s);
  if (pMmgr != NULL) pMmgr->Stop();
  if (pPcierThr !=NULL) pPcierThr->Stop();

}


//-----------------------------------------------------------------------
//-------------------- le programme principal ---------------------------
//-----------------------------------------------------------------------
int main(int narg, char* arg[])
{ 
  
  int rc = 0;
  cout << " ============= BAORadio / Acquisition : mfacq  =================" << endl;
  cout << " ===============================================================" << endl;
  cout << " =========  " <<BAOR_ACQ_VER_STR <<BAOR_ACQ_VER << " ===========" << endl;
  cout << " ===============================================================" << endl;
  
 
  InitTim();
 
  // Initialisation 
  TArrayInitiator _arri;
  FitsIOServerInitiator _fiosi;


  if ((narg < 2)||(strcmp(arg[1],"-h"))==0) {
    Usage(false);
    return 1;
  }
  
  string pardcfile=arg[1];
#ifndef NOPCIECARD  
  string basedir="/Raid";
#else 
  string basedir="./";
#endif 
  if (narg>2)  basedir=arg[2];
  try {
    // Creation/initialisation parametres Acq
    BRAcqConfig acpar;
    acpar.ReadParamFile(arg[1]);
    acpar.GetConfig().SetBaseDirectory(basedir); 
    // Creation des repertoires 
    if (acpar.CreateOutputDirectories()!=0)  return 9;
    acpar.Print(cout);
    struct sigaction act;  
    if (!acpar.GetParams().fg_hard_ctrlc) {
      act.sa_handler=Stop;
      sigaction(SIGINT,&act,NULL);        
    }
    rc = MultiFibreAcq();    
  }
  catch (MiniFITSException& exc) {
    cerr << " mfacq.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  } 
  catch (PCIEWException& exc) {
    cerr << " mfacq.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 75;
  }  
  catch (PThrowable& exc) {
    cerr << " mfacq.cc catched Exception " << exc.Msg() << endl;
    rc = 76;
  }  
  catch (std::exception& sex) {
    cerr << "\n mfacq.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << "  mfacq.cc : Catched ... exception " << endl;
    rc = 79;
  }
  cout << "mfacq[9] ----- END --- stopping acq program " << endl;
  return rc;
}


/* --Nouvelle-Fonction-- */
void Usage(bool fgshort) 
{
  if (fgshort) {
    cout << " Usage: mfacq DataCardFile [BaseDirectory] \n" << endl;
    cout << "   Parameters in DataCard : \n"
	 << "       fibres outpathname skysource paqsize dmasizekb nbfiles \n" 
	 << "       nblocperfile acqmode memmgr monitor reducpaqsz "<< endl;
    cout << "   BaseDirectory (default= /Raid ) " << endl;
    return;
  }
  return;
}
 
 
/* --Nouvelle-Fonction-- */
int MultiFibreAcq() 
{
  Timer tm("mfacq/MultiFibre");
  cout << " ---------- mfacq/ MultiFibreAcq()  ------------- " << endl;
  PCIEWrapperInterface* pciwp[4]={NULL,NULL,NULL,NULL};
    
  BRAcqConfig bpar;
  BRParList& acpar=bpar.GetParams();
  
  cout << " mfacq[1]/Info: Creating RAcqMemZoneMgr for" << acpar.NbFibers << " fibers , nZones=" 
       << acpar.nZones << " NbPaquet/Zone=" << acpar.nPaqZone 
       << " MmgrPaqSize=" << acpar.MMgrPaquetSize() << endl;
  RAcqMemZoneMgr mmgr(acpar.nZones, bpar.NFibers(), acpar.nPaqZone, acpar.MMgrPaquetSize());
  pMmgr=&mmgr;  
  if (acpar.fgdoProc && (acpar.stepProc>0)) {
    // Dans ce cas, toutes les zones doivent passer ds le thread de monitoring 
    // pour etre au moins marque comme traite - seul 1/acpar.stepProc sont effectivement traite 
    mmgr.SetFinalizedMask(((uint_4)MemZS_Saved) | ((uint_4)MemZS_Proc));
    cout << " mfacq[1.b]/Info: Mmgr.SetFinalizedMask( MemZS_Saved | MemZS_Proc )" << endl;
  }
  
#ifndef NOPCIECARD  
  for (int i=0 ;i <acpar.NFibers() ;i++) {
    UINT32 card=(acpar.FiberNum[i]-1)/2+1;
    UINT32 cardfiber=(acpar.FiberNum[i]-1)%2;
    cout <<"mfacq[2] CreatePCIEWrapperV6- indice " << i <<  "INIT card " << card 
	 << " fibre " << cardfiber << endl;
    pciwp[i] =  CreatePCIEWrapperV6(card,acpar.PatternSize(),acpar.dmasizekb,acpar.activate_pattern,cardfiber);
  }
#else 
  TestPCIWrapperNODMA pciw1(bpar.RecvPaquetSize(), acpar.nopciLossRate);
  TestPCIWrapperNODMA pciw2(bpar.RecvPaquetSize(), acpar.nopciLossRate);
  TestPCIWrapperNODMA pciw3(bpar.RecvPaquetSize(), acpar.nopciLossRate);
  TestPCIWrapperNODMA pciw4(bpar.RecvPaquetSize(), acpar.nopciLossRate);
  pciwp[0] = &pciw1;
  pciwp[1] = &pciw2;
  pciwp[2] = &pciw3;
  pciwp[3] = &pciw4;  
#endif 

  cout <<"mfacq[2] Creating MultiDataSaver and  MonitorProc thread objects ... " << endl;
  MultiDataSaver DsThr(mmgr);   //   Utilise les parametres globaux BRAcqConfig
  string ppath=bpar.OutputDirectory();
  MonitorProc PrThr(mmgr);
  vector<PCIEWrapperInterface*> vec_pciw;
  for  (int i=0 ;i<bpar.NFibers();i++)  vec_pciw.push_back( pciwp[i]);
  cout << "mfacq[3] Creating   PCIEMultiReader thread object     " << endl;
  PCIEMultiReader PcierThr(vec_pciw, mmgr, bpar.GetParams());
  //  usleep(200);  attente au cas ou ...
  pPcierThr=&PcierThr;
  tm.Split("Threads created");  
  if (acpar.fgdoProc>0) 
    cout << "mfacq[4] - starting three threads: PCIEMultiReader, MultiDataSaver, MonitorProc ... " << endl;
  else 
    cout << "mfacq[4] - starting two threads: PCIEMultiReader, MultiDataSaver  ... " << endl;

  PcierThr.start();
  DsThr.start();
  if (acpar.fgdoProc>0) { // On ne demarre que si au moins NMaxProc>0
    PrThr.start();
  }
  
  // On attend avant de declencher la terminaison des threads
  usleep(200000);
  
  cout << "mfacq[5] -  Waiting for threads to finish ... " << endl;  
  PcierThr.join();
  DsThr.join();
  mmgr.Stop();
  if (acpar.fgdoProc) { // On n'attend la fin que si le thread a ete demarre (NMaxProc>0)
    PrThr.join();
  }
  pMmgr=NULL;  
  cout << "mfacq[6] ---------- threads finished ---------------- " << endl;
  tm.Split("Threads Finished");  
 
  mmgr.Print(cout);
#ifndef NOPCIECARD
  for (int i=0 ;i <acpar.NbFibers ;i++) {
    UINT32 card=(acpar.FiberNum[i]-1)/2+1;
    UINT32 cardfiber=(acpar.FiberNum[i]-1)%2;
    DeletePCIEWrapperV6(card,cardfiber);
  }
#endif    
return 0;

}
