#ifndef  MINIFITS_H_SEEN
#define  MINIFITS_H_SEEN

#include <stdio.h>
#include <exception>
#include <string>

#include "brtypes.h"

/* 
   Classe d'I/O simplifie FITS pour ACQ BAO-radio  
   R. Ansari, C. Magneville -      Fev 2008
*/

using namespace std;

#define MFEX_MAXMSGLEN 160

class MiniFITSException : public std::exception {
  public:
  explicit MiniFITSException(const char * m) throw() ; 
  explicit MiniFITSException(const string& m) throw() ;
  virtual ~MiniFITSException() throw() ; 
    //! Implementation of std::exception what() method, returning the exception message
  virtual const char* what() const throw();
  virtual string const Msg() const ; 
 private:
  char msg_[MFEX_MAXMSGLEN];
};


enum MiniFITS_DT { MF_Byte, MF_Int16, MF_Float32 };
enum MiniFITS_Mode { MF_Read, MF_Write };

class MiniFITSFile {
 public:
  MiniFITSFile();
  MiniFITSFile(string const & nom, MiniFITS_Mode rwm);
  MiniFITSFile(const char* nom, MiniFITS_Mode rwm);

  ~MiniFITSFile();

  void Open(const char* nom, MiniFITS_Mode rwm);
  inline void Open(string const & nom, MiniFITS_Mode rwm)
    { return Open(nom.c_str(), rwm); }

  void Close();

  inline bool IsOpen() { return (fip!=NULL) ; }
  inline MiniFITS_DT DataType() { return dtype; }
  string DataTypeToString();  

  size_t NAxis1() { return nax1; }
  size_t NAxis2() { return nax2; }

  void setDTypeNaxis(MiniFITS_DT dt, size_t na1, size_t na2);

  // Lecture avec indication de la taille (nb d'elements) et offset 
  int Read(void* data, size_t sz, size_t offset=0);
  inline int ReadB(Byte* data, size_t nel, size_t offsel=0)
    { return ( Read((void *)data, nel, offsel) ); }
  inline int ReadI(Int16* data, size_t nel, size_t offsel=0)
    { return ( Read((void *)data, nel*sizeof(Int16), offsel*sizeof(Int16)) ); }
  inline int ReadF(Float32* data, size_t nel, size_t offsel=0)
    { return ( Read((void *)data, nel*sizeof(Float32), offsel*sizeof(Float32)) ); }

  // Ecriture en mode append (fin de fichier) 
  int Write(void* data, size_t sz);
  inline int WriteB(Byte* data, size_t nel) 
    { return ( Write((void *)data, nel) ); }
  inline int WriteI(Int16* data, size_t nel) 
    { return ( Write((void *)data, nel*sizeof(Int16)) ); }
  inline int WriteF(Float32* data, size_t nel) 
    { return ( Write((void *)data, nel*sizeof(Float32)) ); }

  // Ajout de mots-cle a l'entete FITS
  int AddKeyI(const char* key, long val, const char* comm=NULL);
  inline int AddKeyI(string const& key, long val) 
    { return AddKeyI(key.c_str(), val); }
  inline int AddKeyI(string const& key, long val, string const& comm) 
    { return AddKeyI(key.c_str(), val, comm.c_str()); }
  int AddKeyD(const char* key, double val, const char* comm=NULL);
  inline int AddKeyD(string const& key, double val) 
    { return AddKeyD(key.c_str(), val); }
  inline int AddKeyD(string const& key, double val, string const& comm) 
    { return AddKeyD(key.c_str(), val, comm.c_str()); }
  int AddKeyS(const char* key, const char* val, const char* comm=NULL);
  inline int AddKeyS(string const& key, string const& val) 
    { return AddKeyS(key.c_str(), val.c_str()); }
  inline int AddKeyS(string const& key, string const& val, string const& comm) 
    { return AddKeyS(key.c_str(), val.c_str(), comm.c_str()); }

  //  string getKey(string& key);
 protected:
  void FillHeader();
  void DecodeHeader();
  void Init();
  
  FILE* fip;
  MiniFITS_Mode rwmode;
  MiniFITS_DT dtype;
  size_t nax1, nax2;
  size_t totwsz;  // total bytes ecrits
  char* header; //  entete FITS
  int nkeya_; // 
};

#endif
