#ifndef  BRBASEPROC_H_SEEN
#define  BRBASEPROC_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads de traitememt donnees BAORadio 
//----------------------------------------------------------------


#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>

#include "brpaqu.h"

using namespace std;

//---------------------------------------------------------------------
// Classe de base pour l'analyse donnees (paquets acquisition) BAORadio 
// Les classes de traitement des paquets BAORadio peuvent heriter de 
// cette classe de base BRBaseProcessor en redefinissant la methode Process()
//---------------------------------------------------------------------
class BRBaseProcessor : public SOPHYA::ZThread {
public:	
  BRBaseProcessor(RAcqMemZoneMgr& memgr);
  virtual void run();
  // Methode devant etre redefinie pour effectuer le traitement 
  virtual int Process();  // renvoie 0 si OK, sinon, arret traitement 
  inline void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr_;
  bool stop_;  
  vector<BRPaquet> vpaq_;   // Vecteur de BRPaquet pour chaque fibre
  vector<uint_8> vfgok_;    // Vecteur de flag si paquet OK pour chaque fibre
  vector<uint_8> curfc_;    // Vecteur de numero de FrameCounter pour chaque fibre
  bool fgokallfibers_;      // true -> paquets for all fibers OK
  vector<BRPaqChecker> vpchk_;
  uint_8 totprocnpaq_; 
};



#endif
