#include "branap.h"
#include "minifits.h"
#include "strutilxx.h"
#include "sopnamsp.h"

//--------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classe de gestion des parametres programmes d'analyse 
//--------------------------------------------------------------

/* --Methode-- */
BRAnaParam::BRAnaParam(uint_4 nmean, uint_4 nzon, uint_4 npaqz)
{
  outpath_="./";
  nmean_=nmean;
  imin_=imax_=0;
  istep_=1;
  paqsize_=16424;
  nzones_=nzon;
  npaqinzone_=npaqz;
}

/* --Methode-- */
int BRAnaParam::DecodeArgs(int narg, char* arg[])
{
  if ((narg>1)&&(strcmp(arg[1],"-h")==0))  return Usage(false);
  if (narg<5) return Usage(true);

  bool okarg=false;
  int ka=1;
  while (ka<(narg-1)) {
    if (strcmp(arg[ka],"-act")==0) {
      action_=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-out")==0) {
      outpath_=arg[ka+1];
      ka+=2;
    }
    else if (strcmp(arg[ka],"-nmean")==0) {
      nmean_=atoi(arg[ka+1]);
      ka+=2;
    }
    else if (strcmp(arg[ka],"-zones")==0) {
      int nzon=4;
      int npaqz=128;
      sscanf(arg[ka+1],"%d,%d",&nzon,&npaqz);
      nzones_=nzon;  npaqinzone_=npaqz;
      ka+=2;
    }
    else if (strcmp(arg[ka],"-in")==0) {
      if ((narg-ka)<4)  {
	cout << " BRAnaParam::DecodeArgs() / Argument error " << endl;
	return Usage(true);
      }
      sscanf(arg[ka+1],"%d,%d,%d",&imin_,&imax_,&istep_);  ka+=2;
      while(ka<(narg-3)) {
	string inpath = arg[ka]; 
	if (inpath.size()<1)  inpath="./";
	if (inpath[inpath.size()-1]!='/')  inpath[inpath.size()-1]='/';
	vector<string> fiblist;
	string sa1 = arg[ka+1]; 
	FillVStringFrString(sa1, fiblist, ',');
	char dbuff[32];
	for(size_t i=0; i<fiblist.size(); i++) {
	  sprintf(dbuff,"Fiber%d/",(int)atoi(fiblist[i].c_str()));
	  dirlist_.push_back(inpath+dbuff);
	}
	ka += 2;
      }
      okarg=true;
    }
  }
  if (!okarg) {
    cout << " BRAnaParam::DecodeArgs() / Argument error " << endl;
    return Usage(true);
  }
  return 0;
}

/* --Methode-- */
int BRAnaParam::Usage(bool fgshort)
{
  cout << " --- BRAnaParam : Reading/Processing BAORadio FITS files parameters " << endl;
  cout << " Usage:  prgname [-act ACT] [-out OutPath] [-nmean NMean] [-zones NZones,nPaqinZone] \n" 
       << "         -in Imin,Imax,Istep InPath FiberList [InPath2 FiberList2 InPath3 FiberList3 ...] \n" << endl; 
  if (fgshort) {
    cout << " prgname -h for detailed instructions" << endl;
    return 5;
  }
  cout << " -act Action: Not YET used  \n"
       << " -out OutPath: Output directory name \n"
       << " -nmean NMean: Number of packet used for spectra/visibility computation \n"
       << " -zones NZones,NbPaqinZone : Number of Zones and number of paquets in one zone \n" 
       << " -in : input files/directory definition : \n"
       << "       Imin,Imax,Istep: fits files signalII.fits Imin<=II<=Imax Istep=increment \n" 
       << "       InPath: Input directerory fits files in InPath/FiberJJ directory \n"
       << "       FiberList: List of fiber numbers (JJ - Ex: 2,1,4 )  \n" << endl;
  return 1;
}

/* --Fonction-- */
int BRAnaParam::PaqSizeFromFits()
{
  uint_4 paqsz, npaqf;
  char flnm[1024];
  sprintf(flnm,"%s/signal%d.fits",dirlist_[0].c_str(),imin_);
  return DecodeMiniFitsHeader(flnm,paqsize_, npaqf); 
}

/* --Fonction-- */
ostream& BRAnaParam::Print(ostream& os)
{
  os << " BRAnaParam::Print() dirlist_.size()=" << dirlist_.size() << " Input directories: " << endl;
  for(size_t k=0; k< dirlist_.size(); k++) 
    cout << k+1 << " :  " << dirlist_[k] << endl;
  cout << " IMin= " << imin_ << " IMax= " << imax_ << " IStep= " << istep_ << endl;
  cout << " OutPath= " << outpath_ << endl;
  cout << "  NMean=" << nmean_ << " PaqSize=" << paqsize_ << "  -  NZones=" << nzones_ 
       << " NPaqZone=" << npaqinzone_ << endl;
  return os;
}

/* --Fonction-- */
int BRAnaParam::DecodeMiniFitsHeader(const char* filename, uint_4& paqsz, uint_4& npaq) 
{
  cout << " DecodeMiniFitsHeader - Opening file: " << filename << endl;
  MiniFITSFile mff(filename, MF_Read);
  cout << "DecodeMiniFitsHeader()... Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
       << " NAxis2=" << mff.NAxis2() << endl;
  paqsz = mff.NAxis1();
  npaq = mff.NAxis2();
  return 0;
}

