#include "brdiskw.h"
#include <exception>
#include "timestamp.h"
#include "ctimer.h"

using namespace SOPHYA;
//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads ecriture de donnees traitees BAORadio
//----------------------------------------------------------------

//----------------------------------------------------------------
// ---- Classe FitsCubeWriter : 
// Ecriture de fichier FITS BAORadio 3D (plusieurs fibres dans un fichier)
//----------------------------------------------------------------

/* --Methode-- */
FitsCubeWriter::FitsCubeWriter(RAcqMemZoneMgr& mmgr, string outpath, uint_4 nblocperfile)
  :  memgr_(mmgr), outpath_(outpath), nblocperfile_(nblocperfile)
{
  stop_ = false;
  numfile_=0;
  totnbyteswrt_=0;
}

/* --Methode-- */
void FitsCubeWriter::run()
{
  try {
    TimeStamp ts; 
    Timer tm("FitsCubeWriter", false);

    uint_4 paqsz = memgr_.PaqSize();
    cout << " FitsCubeWriter::run() - Starting   NBloc/File=" << nblocperfile_ << " PaqSz=" << paqsz << endl;	
    vector<Byte*> fbuff;
    for(size_t fib=0; fib<(size_t)memgr_.NbFibres(); fib++)  fbuff.push_back(NULL);

    size_t npaqperfile = memgr_.NbPaquets()*nblocperfile_;  // Nombre de paquets ecrits dans un fichier 

    bool fgrun=true;
    MiniFITSFile mff;
    uint_4 numblk=0;
    char fname[1024];
    while (fgrun) {
      if (stop_) break;
      if (memgr_.GetRunState() == MemZR_Stopped) break;
      int mid = memgr_.FindMemZoneId(MemZA_Save);
      Byte* buffg = memgr_.GetMemZone(mid);
      if (buffg == NULL) {
	cout << "FitsCubeWriter::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
	setRC(7);      fgrun=false;		
	break;	
      }
      if (numblk%nblocperfile_ == 0) {
	if (mff.IsOpen()) { 
	  mff.Close();
	  cout << " FitsCubeWriter::run() " << numfile_ << " End write file" << fname << endl;
	} 
	sprintf(fname,"%ssig3d%d.fits",outpath_.c_str(),(int)numfile_);
	mff.Open(fname, MF_Write);
	mff.setDTypeNaxis(MF_Byte, paqsz, memgr_.NbFibres(), npaqperfile);
	numfile_++;
      } 
      for(size_t fib=0; fib<(size_t)memgr_.NbFibres(); fib++) {
	fbuff[fib] = memgr_.GetMemZone(mid,fib);
	if (fbuff[fib] == NULL) { // cela ne devrait pas arriver 
	  cout << "FitsCubeWriter::run()/ERROR memgr.GetMemZone(" << mid << "," << fib << ") -> NULL" << endl;
	  setRC(9);	  fgrun=false;		
	  break;
	}
	for(size_t jp=0; jp<memgr_.NbPaquets(); jp++) {
	  mff.WriteB(fbuff[fib],paqsz); // ecriture 
	  totnbyteswrt_+=paqsz;
	}
      } // Fin de la boucle sur les fibres 
      memgr_.FreeMemZone(mid, MemZS_Saved);
      numblk++;
    } // Fin de boucle sur les zones a traiter 
    //------------------------------------
    cout << " ------------------  FitsCubeWriter::run() END ----------------- " << endl;
    //    ts.SetNow();
    tm.SplitQ();
    //    cout << "  END writing : " << ts ;
    cout << "  TotalDiskWrite= " << totnbyteswrt_/(1024*1024) << " MBytes Disk-Write rate= " 
         << (double)(totnbyteswrt_)/1024./tm.PartialElapsedTimems() << " MB/s" << endl;    
    //    cout << " FitsCubeWriter::run()/Timing: \n";   tm.Print();
    cout << " --------------------------------------------------------------- " << endl;
  }
  catch (MiniFITSException& exc) {
    cout << " FitsCubeWriter::run()/catched MiniFITSException " << exc.Msg() << endl;
    setRC(5);	
    return; 
  }
  catch (std::exception& exc) {
    cout << " FitsCubeWriter::run()/catched std::exception :  " << exc.what() << endl;
    setRC(5);	
    return; 
  }
  catch(...) {
    cout << " FitsCubeWriter::run()/catched unknown ... exception " << endl;
    setRC(5);	
    return; 
  }

}
