#ifndef  BRDISKW_H_SEEN
#define  BRDISKW_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads ecriture de donnees traitees BAORadio
//----------------------------------------------------------------

#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>

#include "brpaqu.h"
#include "minifits.h"

using namespace std;


// ---- Classe FitsCubeWriter : ecriture de fichier FITS BAORadio 3D (plusieurs fibres dans un fichier)
class FitsCubeWriter : public SOPHYA::ZThread {
public:	
  FitsCubeWriter(RAcqMemZoneMgr& mmgr, string outpath, uint_4 nblocperfile);

  virtual void run(); 
  inline void Stop() { stop_ = true; }	
  inline void STOP() { stop_ = true; }	
protected:

  RAcqMemZoneMgr& memgr_;
  string outpath_;
  uint_4 numfile_;  // numero de fichier courant 
  uint_4 nblocperfile_;  // Nombre de bloc (zone memoire) mis dans un fichier
  size_t totnbyteswrt_;

  bool stop_;    
};


#endif
