#include<stdio.h>

#include "pilistmac.h"




/* --Methode-- */
PIListMac::PIListMac(PIContainerGen* par, char* nom,
                 int sx, int sy, int px, int py)
: PIListGen(par, nom, sx, sy, px, py)
{
  delete mPane;
  mPane = mPIPPList = new PIPPList(mPaneInfo, mViewInfo, this);
  Manage();
}

/* --Methode-- */
PIListMac::~PIListMac()
{
}


/* --Methode-- */
void PIListMac::AppendItem(const char * item, PIMessage msg)
{
  mPIPPList->AppendItem(item, msg);
}

/* --Methode-- */
void PIListMac::DeleteItem(const char * item)
{
  mPIPPList->DeleteItem(item);
}

/* --Methode-- */
void PIListMac::DeleteItemMsg(PIMessage msg)
{
  mPIPPList->DeleteItem(msg);
}


/* --Methode-- */
void PIListMac::SetMultipleSelect(bool ms)
{
  mPIPPList->SetMultipleSelect(ms);
}

/* --Methode-- */
int PIListMac::GetNbSelection()
{
  return mPIPPList->GetNbSel();
}

/* --Methode-- */
PIMessage PIListMac::GetSelection(int num)
{
  return mPIPPList->GetSelMsg(num);
}

/* --Methode-- */
string PIListMac::GetSelectionStr(int num)
{
  return mPIPPList->GetSelStr(num);
}

/* --Methode-- */
void PIListMac::SelectItem(const char * item)
{
  mPIPPList->SelectItem(item);
}

/* --Methode-- */
void PIListMac::SelectItemMsg(PIMessage msg)
{
  mPIPPList->SelectItem(msg);
}


/* --Methode-- */
void PIListMac::ClearSelItem(const char * item)
{
  mPIPPList->ClearSelItem(item);
}

/* --Methode-- */
void PIListMac::ClearSelItemMsg(PIMessage msg)
{
  mPIPPList->ClearSelItem(msg);
}


