#include "pistdwdgmac.h"
#include <LString.h>
#include <PP_Messages.h>

/************* PILabelMac ************/
#include <LCaption.h>

PILabelMac::PILabelMac(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LCaption(mPaneInfo, titre, 130);
}

PILabelMac::~PILabelMac()
{}


/************* PIButtonMac ************/
#include <LStdControl.h>

PIButtonMac::PIButtonMac(PIContainerGen *par, char *nom, PIMessage msg,
                         int sx, int sy, int px, int py)
: PIButtonGen(par, nom, msg, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdButton(mPaneInfo, msg_Click, 130, titre);
  ((LStdButton*)mPane)->AddListener(this);
}

PIButtonMac::~PIButtonMac()
{}

void
PIButtonMac::SetLabel(string const& str)
{
  LStr255 sstr(str.c_str());
  ((LStdButton*)mPane)->SetDescriptor(sstr);
}


void
PIButtonMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_Click)
    Send(myMsg, PIMsg_Press);
}


/************* PITextMac ************/
#include <LEditField.h>

PITextMac::PITextMac(PIContainerGen *par, const char *nom,
                         int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LEditField(mPaneInfo, titre, 130, 255, true, true, NULL, LCommander::GetTopCommander());
}

PITextMac::PITextMac(PIContainerGen *par, const char *nom,
                     bool vsb, bool hsb,
                     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LEditField(mPaneInfo, titre, 130, 255, true, true, NULL, LCommander::GetTopCommander());
}


PITextMac::~PITextMac()
{}

void
PITextMac::SetText(string const& s)
{
  SetLabel(s);
}

string
PITextMac::GetText() const
{
  Str255 desc;
  mPane->GetDescriptor(desc);
  p2cstr(desc);
  return (char*) desc;
}

/* --Methode-- */
void PITextMac::SetMutiLineMode(bool /*mlm*/)
{
return;
}

/* --Methode-- */
void PITextMac::SetTextEditable(bool te)
{
if (te)
  { mPane->Enable(); }
else
  { mPane->Disable(); }
return;
}

/************* PIScaleMac ************/
static ControlActionUPP	sSBarAction = nil;


PIScaleMac::PIScaleMac(PIContainerGen* par, char* nom, PIMessage msg,
                       bool horiz, int sx, int sy, int px, int py)
: PIScaleGen(par, nom, msg, horiz, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdControl(mPaneInfo, msg_Click, 1, 1, 10,
						  scrollBarProc, 130, titre, (Int32) this);
  ((LStdControl*)mPane)->AddListener(this);
  
  if (sSBarAction == nil) {	// Allocate UPP if necessary
	sSBarAction = NewControlActionProc((ProcPtr) SBarAction);
  }
  ((LStdControl*)mPane)->SetActionProc(sSBarAction);
}

PIScaleMac::~PIScaleMac()
{}

void
PIScaleMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_ThumbDragged)
    Send(myMsg, PIMsg_DataChanged);
}

void
PIScaleMac::SetMinMax(int min, int max)
{
  ((LStdControl*)mPane)->SetMinValue(min);
  ((LStdControl*)mPane)->SetMaxValue(max);
}

void
PIScaleMac::GetMinMax(int &min, int &max)
{
  min = ((LStdControl*)mPane)->GetMinValue();
  max = ((LStdControl*)mPane)->GetMaxValue();
}

void
PIScaleMac::SetValue(int val)
{
  StopListening();
  ((LStdControl*)mPane)->SetValue(val);
  StartListening();
}

int
PIScaleMac::GetValue()
{
  return ((LStdControl*)mPane)->GetValue();
}

pascal void
PIScaleMac::SBarAction(
	ControlHandle	inMacControl,
	Int16			inPart)
{
	PIScaleMac		*theScroller =
							(PIScaleMac *) GetControlReference(inMacControl);
	theScroller->HandleScroll(inPart);
}

void
PIScaleMac::HandleScroll(
	const Int16		inPart)
{
    int delta;
	switch (inPart) {				// Determine how much to scroll
	
		case kControlUpButtonPart:	// Scroll left one unit
			delta = -1;
			break;
			
		case kControlDownButtonPart:	// Scroll right one unit
			delta = 1;
			break;
			
		case kControlPageUpPart:		// Scroll left by Frame width
										//   less one unit of overlap
			delta = -10;
			break;
			
		case kControlPageDownPart:		// Scroll right by Frame width
										//   less one unit of overlap
			delta = 10;
			break;
	}
	
	if (delta != 0) {
	    SetValue(GetValue()+delta);
	}
}

/************* PIScrollBarMac ************/
static ControlActionUPP	sSBarAction2 = nil;


PIScrollBarMac::PIScrollBarMac(PIContainerGen* par, char* nom, PIMessage msg,
                       bool vert, int sx, int sy, int px, int py)
: PIScrollBarGen(par, nom, msg, vert, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdControl(mPaneInfo, msg_Click, 1, 1, 10,
						  scrollBarProc, 130, titre, (Int32) this);
  ((LStdControl*)mPane)->AddListener(this);
  
  if (sSBarAction2 == nil) {	// Allocate UPP if necessary
	sSBarAction2 = NewControlActionProc((ProcPtr) SBarAction);
  }
  ((LStdControl*)mPane)->SetActionProc(sSBarAction2);
}

PIScrollBarMac::~PIScrollBarMac()
{}

void
PIScrollBarMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_ThumbDragged)
    Send(myMsg, PIMsg_DataChanged);
}

void
PIScrollBarMac::SetMinMax(int min, int max)
{
  ((LStdControl*)mPane)->SetMinValue(min);
  ((LStdControl*)mPane)->SetMaxValue(max);
}

void
PIScrollBarMac::GetMinMax(int &min, int &max)
{
  min = ((LStdControl*)mPane)->GetMinValue();
  max = ((LStdControl*)mPane)->GetMaxValue();
}


void
PIScrollBarMac::SetValue(int val)
{
  StopListening();
  ((LStdControl*)mPane)->SetValue(val);
  StartListening();
}

int
PIScrollBarMac::GetValue()
{
  return ((LStdControl*)mPane)->GetValue();
}

pascal void
PIScrollBarMac::SBarAction(
	ControlHandle	inMacControl,
	Int16			inPart)
{
	PIScrollBarMac		*theScroller =
							(PIScrollBarMac *) GetControlReference(inMacControl);
	theScroller->HandleScroll(inPart);
}

void
PIScrollBarMac::HandleScroll(
	const Int16		inPart)
{
    int delta;
	switch (inPart) {				// Determine how much to scroll
	
		case kControlUpButtonPart:	// Scroll left one unit
			delta = -1;
			break;
			
		case kControlDownButtonPart:	// Scroll right one unit
			delta = 1;
			break;
			
		case kControlPageUpPart:		// Scroll left by Frame width
										//   less one unit of overlap
			delta = -10;
			break;
			
		case kControlPageDownPart:		// Scroll right by Frame width
										//   less one unit of overlap
			delta = 10;
			break;
	}
	
	if (delta != 0) {
	    SetValue(GetValue()+delta);
	}
}

/************* PICheckBoxMac ************/
#include <LStdControl.h>

PICheckBoxMac::PICheckBoxMac(PIContainerGen *par, char *nom, PIMessage msg,
                         int sx, int sy, int px, int py)
: PICheckBoxGen(par, nom, msg, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdCheckBox(mPaneInfo, msg_Click, 0, 130, titre);
  ((LStdCheckBox*)mPane)->AddListener(this);
}

PICheckBoxMac::~PICheckBoxMac()
{}

void
PICheckBoxMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_Click)
    Send(myMsg, PIMsg_DataChanged);
}

void
PICheckBoxMac::SetState(bool st)
{
  StopListening();
  ((LStdCheckBox*)mPane)->SetValue(st ? 1 : 0);
  StartListening();
}
 
bool
PICheckBoxMac::GetState()
{
  return ((LStdCheckBox*)mPane)->GetValue();
}
