#include "pippviewadapter.h"
#include "piupdattachment.h"


PIPPViewAdapter::PIPPViewAdapter()	
:LView()
{
	::SetRect(&piBindings, 0, 0, 0, 0);
}

PIPPViewAdapter::PIPPViewAdapter(	
	const PIPPViewAdapter& inOriginal)
:LView(inOriginal)
{
	::SetRect(&piBindings, 0, 0, 0, 0);
}
PIPPViewAdapter::PIPPViewAdapter(
	const SPaneInfo		&inPaneInfo,
	const SViewInfo		&inViewInfo)
:LView(inPaneInfo, inViewInfo)
{
	::SetRect(&piBindings, 0, 0, 0, 0);
}

void PIPPViewAdapter::SetBinding(PIBindingKind left, PIBindingKind top, 
                                  PIBindingKind right, PIBindingKind bottom)
{
  piBindings.left   = left;
  piBindings.right  = right;
  piBindings.top    = top;
  piBindings.bottom = bottom;
}

bool PIPPViewAdapter::GetBinding(PIBindingKind& left, PIBindingKind& top, 
                                  PIBindingKind& right, PIBindingKind& bottom)
{
  left   = (PIBindingKind)piBindings.left;
  right  = (PIBindingKind)piBindings.right;
  top    = (PIBindingKind)piBindings.top;
  bottom = (PIBindingKind)piBindings.bottom;
  
  return false;
}


void PIPPViewAdapter::AdaptToSuperFrameSize(
	Int32				inSurrWidthDelta,
	Int32				inSurrHeightDelta,
	Boolean				inRefresh)
{
  SDimension16 parSize;
  GetSuperView()->GetFrameSize(parSize);
  
  SDimension16 oldParSize = parSize;
  oldParSize.width -= inSurrWidthDelta;
  oldParSize.height -= inSurrHeightDelta;
  
  SPoint32 myLoc;
  GetFrameLocation(myLoc);
  SPoint32	superImageLoc = {0, 0};
	
  if (mSuperView != nil) {
    mSuperView->GetImageLocation(superImageLoc);
  }
  myLoc.h -= superImageLoc.h;
  myLoc.v -= superImageLoc.v;
  
  SDimension16 mySize;
  GetFrameSize(mySize);
    
  SPoint32 myXLoc = myLoc;
  myXLoc.h += mySize.width;
  myXLoc.v += mySize.height;
  
  if (piBindings.left == PIBK_elastic) {
     myLoc.h = parSize.width * ((float)myLoc.h / (float)oldParSize.width);
  }
 
  if (piBindings.top == PIBK_elastic) {
     myLoc.v = parSize.height * ((float)myLoc.v / (float)oldParSize.height);
  }
  
  if (piBindings.right == PIBK_fixed) {
     myXLoc.h += inSurrWidthDelta;
  } else
  if (piBindings.right == PIBK_elastic) {
     myXLoc.h = parSize.width * ((float)myXLoc.h / (float)oldParSize.width);
  }  
 
  if (piBindings.bottom == PIBK_fixed) {
     myXLoc.v += inSurrHeightDelta;
  } else
  if (piBindings.bottom == PIBK_elastic) {
     myXLoc.v = parSize.height * ((float)myXLoc.v / (float)oldParSize.height);
  }
  
  
  if (piBindings.left == PIBK_free) {
    myLoc.h = myXLoc.h - mySize.width;
  }   
  if (piBindings.top == PIBK_free) {
    myLoc.v = myXLoc.v - mySize.height;
  }   
  if (piBindings.right == PIBK_free) {
    myXLoc.h = myLoc.h + mySize.width;
  }   
  if (piBindings.bottom == PIBK_free) {
    myXLoc.v = myLoc.v + mySize.height;
  }
  
  mySize.width = myXLoc.h - myLoc.h;
  mySize.height = myXLoc.v - myLoc.v;
  
  ResizeFrameTo(mySize.width, mySize.height, inRefresh);
  ResizeFrameTo(mySize.width, mySize.height, inRefresh);
  PlaceInSuperImageAt(myLoc.h, myLoc.v, inRefresh);
}

void
PIPPViewAdapter::ResizeFrameBy(
	Int16		inWidthDelta,
	Int16		inHeightDelta,
	Boolean		inRefresh)
{
  LView::ResizeFrameBy(inWidthDelta,inHeightDelta,inRefresh);
  ExecuteAttachments(msg_Resize, NULL);
}

