#ifndef  BRPROC_H_SEEN
#define  BRPROC_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads de traitememt donnees BAORadio 
//----------------------------------------------------------------


#include <string>
#include <vector>
#include <iostream>

#include "racqumem.h"
#include "brbaseproc.h"
#include "sopnamsp.h"
#include "tvector.h"
#include "ntuple.h"
#include "datatable.h"

using namespace std;


//---------------------------------------------------------------------
// Classe de traitement - calcul de visibilite pour n fibres 
//---------------------------------------------------------------------
class BRVisibilityCalculator : public BRBaseProcessor {
public:	
  BRVisibilityCalculator(RAcqMemZoneMgr& memgr, string outpath, uint_4 nmean=1000, 
			 uint_4 freq1=0, uint_4 freq2=0, uint_4 nbfreq=1);
  virtual ~BRVisibilityCalculator(); // Fait le nettoyage final , sauvegarde des objets ...

  virtual int Process(); 
  virtual int FillVisibTable(double fcm, double ttm); 

protected:
  uint_4 nmean_;  // Nombre de spectres pour le calcul des moyennes 
  string outpath_;  // directory pour fichiers de sortie
  uint_4 numfreq1_,numfreq2_,nbinfreq_;
  uint_4 jf1_,jf2_,djf_;

  vector<TwoByteComplex*> vpdata_;

  double moyfc_, moytt_;
  TMatrix< complex<r_4> > vismtx_; 
  TVector< uint_4 > chanum_;
  //  FitsInOutFile dtfos_;
  DataTable visdt_;

  uint_4 numfile_;
  uint_4 totnbpaq_;
  double* xnt_;
};


//-------------------------------------------------------------------------
//    **** OBSOLETE : BRProcA2C et BRProcB4C
//   Anciennes classes de traitement (Avant Nov2009) utilises par mcrd.cc
//-------------------------------------------------------------------------
//---------------------------------------------------------------------
// Classe thread de traitement avec 2 voies par frame (donnees raw/FFT
//---------------------------------------------------------------------

/*-- Arguments du constructeur : 
  o mem : gestionnaire zones memoires avec contenant les "frames" avec 2 voies/frame
  o path : Chemin et nom des fichiers PPF produits (on ajoute _numero.ppf )
  o nmean : Nombre de frame (paquets) moyennes
  o nmax : Nombre maxi de frames traites 
  o fghist = true -> fait aussi l'histo des valeurs des echantillons temps
  o nfsmap>0 : fabrication de cartes (image 2D) des spectres, 
     avec nfsmap=nombre de frequences sommes  
  o fgnotrl = true -> fichiers fits / paquets sans trailer 
  o card : numero de carte , juste pour les impressions 
*/
class BRProcA2C : public ZThread {
public:	
  BRProcA2C(RAcqMemZoneMgr& mem, string& path, bool fgraw, 
	    uint_4 nmean=10, uint_4 nmax=100, bool fgtshist=false, 
	    uint_4 nfsmap=0, bool fgnotrl=false, int card=1);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  bool stop_;  
  bool fgraw_;   // true -> raw data 
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 nmean_;  // Nombre de spectres pour le calcul des moyennes 
  uint_4 nfsmap_;  // Binning en frequence pour les cartes 2D temps-freq
  string path_;  
  bool fghist_;   // if true, fill and save histogram with time sample values
  bool fgnotrl_;   // if true, don't check packet trailer - when using pre-june fits files
  int card_;   // Numeros de voies 2*card_-1, 2*card_
};

//---------------------------------------------------------------------
// Classe thread de traitement 2 x 2 voies/paquet (Apres BRProcA2C)
//---------------------------------------------------------------------
/*-- Arguments du constructeur : 
  o mem1,mem2 : gestionnairea zones memoires avec contenant les donnees des 4 voies (2 voies/frame)
  o path : Chemin et nom des fichiers PPF produits (on ajoute _numero.ppf )
  o nmean : Nombre de frame (paquets) moyennes
  o nmax : Nombre maxi de frames traites 
  o fgnotrl = true -> fichiers fits / paquets sans trailer 
  o card : numero de carte , juste pour les impressions 
*/

class BRProcB4C : public ZThread {
public:	
  BRProcB4C(RAcqMemZoneMgr& mem1, RAcqMemZoneMgr& mem2, string& path, 
	    bool fgraw, uint_4 nmean=10, uint_4 nmax=100, bool fgnotrl=false);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr1;
  RAcqMemZoneMgr& memgr2;
  bool stop_;  
  bool fgraw_;   // true -> raw data 
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
  bool fgnotrl_;   // if true, don't check packet trailer - when using pre-june fits files
};



#endif
