#ifndef PISTLIST_H
#define PISTLIST_H


#include "piscdrawwdg.h"
#include "stlist.h"

class PIStarList : public PIScDrawer {
public:
                     PIStarList(StarList* stl, bool ayud=true);
  virtual           ~PIStarList();
  
  virtual void       Draw();
  virtual void       Refresh();  // Recalcule les limites, et reaffiche
  
  inline  void       SetAutoDelStList(bool ad=false)   { mAdelStl = ad; }
  void               SetFluxLimits(float min=1., float max=-1., int nl=5, 
                                   int msz0=0, bool refr=false);
  void               SetXYLimits(float xmin=1., float xmax=-1., float ymin=1., float ymax=-1., 
                                 bool dfv=false, bool refr=false);              

  inline StarList*   StList()  { return(mStL); }  
  inline float       XMin()    { return(mXMin); }       
  inline float       XMax()    { return(mXMax); }       
  inline float       YMin()    { return(mYMin); }       
  inline float       YMax()    { return(mYMax); }       
  inline float       FluxMin() { return(mFmin); }       
  inline float       FluxMax() { return(mFmax); }
       
protected:
  StarList* mStL;
  bool   mAdelStl;
  float mFmin, mFmax;
  int mNLev, mMSz0;
  double mF0, mDLgF;
  float mXMin, mXMax;
  float mYMin, mYMax;
  bool mDspFV;
  bool mAYdir;

  virtual void       AttachTo(PIScDrawWdg*);
  virtual void       UpdateSize();
};

#endif
