#include <stdio.h>
#include "pihisto.h"

PIHisto::PIHisto(Histo* histo)
: PIScDrawer(), mHisto(histo)
{
  ahisup = false;     // Flag pour suppression automatique de mHisto
}

PIHisto::~PIHisto()
{
  if (ahisup)
    delete mHisto;
}


void
PIHisto::AttachTo(PIScDrawWdg* wdg)
{
  PIScDrawer::AttachTo(wdg);
  UpdateSize();
}


void
PIHisto::UpdateSize()
{
  if (!mDrawWdg) return;
  if (mDrawWdg->LimitsFixed()) return;
  // Commencer par trouver nos limites
  
  double xmin = mHisto->XMin();
  double xmax = (mHisto->XMax());

  double ymax = mHisto->VMax()*1.2;
  double ymin = mHisto->VMin();
  
  mDrawWdg->SetLimits(xmin, xmax, ymin, ymax);
  mDrawWdg->SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


void
PIHisto::Draw()
{
  if (!mDrawWdg) return;
  for (int i=0; i<mHisto->NBins(); i++) {
		double left   = mHisto->BinLowEdge(i);
		double width  = mHisto->BinWidth();
		double bottom = 0;
		double height = (*mHisto)(i);
		mDrawWdg->ScDrawFBox(left,bottom,width,height);
		mDrawWdg->ScDrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
	}
  DrawStats();
}

void
PIHisto::DrawStats()
{
  // Une boite dans le coin superieur droit
  if (!mDrawWdg) return;
  double cellHeight = (mDrawWdg->YMax() - mDrawWdg->YMin()) * 0.05;
  double cellWidth  = (mDrawWdg->XMax() - mDrawWdg->XMin()) * 0.23;
  mDrawWdg->ScDrawLine(mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax(),
                       mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax() - cellHeight);
  mDrawWdg->ScDrawLine(mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax() - cellHeight,
                       mDrawWdg->XMax()            , mDrawWdg->YMax() - cellHeight);
  char label[50];
  sprintf(label, "N = %.6g", mHisto->NData());
  mDrawWdg->ScSelFontSz((mDrawWdg->YMax() - mDrawWdg->YMin())/30);
  mDrawWdg->ScDrawString(mDrawWdg->XMax() - cellWidth*0.9, mDrawWdg->YMax() - cellHeight*0.8, label);
                       
}

void
PIHisto::Refresh()
{
  if (!mDrawWdg) return;
  mDrawWdg->FreeLimits();
  UpdateSize();
  mDrawWdg->Refresh();
}
