#include <stdlib.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Core.h>
#include <X11/CoreP.h>

#include <Xm/Xm.h>       // A cause des container XmForm 
#include <Xm/Form.h>     // Idem 


#include "piwdgx.h"
#include "picontainerx.h"


// #define DEBUG_PIWdgX

static SysDWdg  top = NULL;
static Display * dpy = NULL;
static char appname[64];
static char appclass[64];
/* Nouvelle-Fonction */
SysDWdg   PIXtTopWdg()
{
return (top);
}

/* Nouvelle-Fonction */
Display * PIXDisplay()
{
return(dpy);
}

/* Nouvelle-Fonction */
void PIBeep()
{
XBell(dpy, 0);
return;
}

/* Nouvelle-Fonction */
int CStrFrXmStr(XmString xms, char* buff, int nmx)
/*  Pour recuperer le contenu d'un string Motif  */
{
int n,l,m;
XmStringContext cntx;
char *txs;
XmStringDirection dir;
XmStringCharSet cset;
Boolean sep;

if (nmx < 2)  return(0);
n = 0;  m = nmx-1;  buff[0] = buff[m] = '\0';
XmStringInitContext (&cntx, xms);
while (m > 0)
  {
  if (XmStringGetNextSegment( cntx, &txs, &cset, &dir, &sep) )
    {
    l = strlen(txs);
    if (m < l)  txs[m] = '\0';
    strcpy(buff+n, txs);
    n += l;   m -= l;
    if (sep)  m = -2;
    XtFree(txs);
    }
  else m = -1;
  }

return(n);
} 


/* --Methode-- */
PIWdgX::PIWdgX(int narg, char *arg[])
:PIWdgGen(NULL, "PITopLevel")  
{
if (top == NULL)  InitXt(narg, arg);
sdw = top;
wmis =  k_wmi_appshell;
stmng = 0;
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::PIWdgX(int , char * [])  this=%lx  top=%lx \n", (long)this, (long)sdw);
#endif
}



/* --Methode-- */
PIWdgX::PIWdgX(PIContainerGen *par, char *nom, 
               int sx, int sy, int px, int py)
:PIWdgGen(par, nom, sx, sy, px, py) 
{
sdw = NULL;
wmis = k_wmi_unknown;
}

/* --Methode-- */
int PIWdgX::CreateXtWdg(char *nom, SysDWdgClass wdgcl, SysDWdg pwdg,
                        int sx, int sy, int px, int py)
{
Arg  wargs[5];
int n=0;

if (pwdg == NULL)
  {
  if (parent == NULL)
    {
    if (top == NULL)  InitXt();
    pwdg = top;
    }
  else pwdg = ((PIContainerX *)parent)->sdw;
  }

n=0;
if ((sx >= 0) && (sy >= 0))
  {
  XtSetArg(wargs[n],XtNwidth,sx);  n++;
  XtSetArg(wargs[n],XtNheight,sy);  n++;
  }
XtSetArg(wargs[n],XtNx,px);  n++;
XtSetArg(wargs[n],XtNy,py);  n++;

if (wdgcl == NULL)  wdgcl = coreWidgetClass;

if ( (wdgcl == topLevelShellWidgetClass) || 
     (wdgcl == transientShellWidgetClass) ||
     (wdgcl == overrideShellWidgetClass) )
  {
  sdw = XtCreatePopupShell(nom, wdgcl, pwdg, wargs, n);
  }
else
  {
  sdw = XtCreateWidget(nom, wdgcl, pwdg, wargs, n);
  }

if (wdgcl == topLevelShellWidgetClass)  wmis = k_wmi_toplevel;
else if (wdgcl == transientShellWidgetClass)  wmis = k_wmi_transient;
else if (wdgcl == overrideShellWidgetClass)  wmis = k_wmi_override;
else wmis == k_wmi_normal ;

stmng = 0;
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::CreateXtWdg(%s) this=%lx sdw=%lx pere=%lx wmis=%d\n", nom, 
       (long)this, (long)sdw, (long)pwdg, wmis);
#endif

SetBinding(PIBK_free, PIBK_free, PIBK_free, PIBK_free);
return(0);
}


/* --Methode-- */
PIWdgX::~PIWdgX()
{
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::~PIWdgX()  %lx %lx \n", (long)this, (long)sdw);
#endif
if (!sdw)  XtDestroyWidget(sdw);
}


/* --Methode-- */
void PIWdgX::FinishCreate()
{
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::FinishCreate() ne fait rien ! \n");
#endif
return;
}


/* --Methode-- */
void PIWdgX::Manage()
{
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::Manage  this=%lx  sdw=%lx \n", (long)this, (long)sdw);
#endif
if (!sdw)  return;
if (wmis != k_wmi_appshell)  XtManageChild(sdw);
else if (!XtIsRealized(sdw))  XtRealizeWidget(sdw);  
stmng = 1;
return;
}

/* --Methode-- */
void PIWdgX::Unmanage()
{
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::Unmanage  this=%lx sdw=%lx \n", (long)this, (long)sdw);
#endif
if (!sdw)  return;
if (wmis != k_wmi_appshell) 
  XtUnmanageChild(sdw);
stmng = 0;
return;
}

/* --Methode-- */
int PIWdgX::IfManaged()
{
return(stmng);
}


/* --Methode-- */
void PIWdgX::SetSize(int sx, int sy)
{
#ifdef DEBUG_PIWdgX
printf("Debug_PIWdgX::SetSize  this=%lx  sdw=%lx \n", (long)this, (long)sdw);
#endif

if (!sdw)  return;
/*
Arg  wargs[2];
XtSetArg(wargs[0],XtNwidth,sx); 
XtSetArg(wargs[1],XtNheight,sy); 
XtSetValues(this->sdw, wargs, 2);
*/
XtResizeWidget(sdw, sx, sy, BorderWidth());

return;
} 

/* --Methode-- */
void PIWdgX::SetPos(int px, int py)
{
if (!sdw)  return;
/*
Arg  wargs[2];
XtSetArg(wargs[0],XtNx,px);  
XtSetArg(wargs[1],XtNy,py);  
XtSetValues(this->sdw, wargs, 2);
*/
XtMoveWidget(sdw, px, py);

return;
} 

/* --Methode-- */
void PIWdgX::SetBinding(PIBindingKind left, PIBindingKind top, 
                        PIBindingKind right, PIBindingKind bottom)
{
Arg  wargs[3];
int n=0;
if (!sdw)  return;
if (!parent)  return;

/*
n = 0;
XtSetArg(wargs[n],XmNfractionBase, 500);  n++;
XtSetValues(this->sdw, wargs, n);
*/
switch (left)
  {
  case PIBK_free : 
    n = 0;
    XtSetArg(wargs[n],XmNleftAttachment, XmATTACH_NONE);  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_fixed :
    n = 0;
    XtSetArg(wargs[n],XmNleftAttachment, XmATTACH_FORM);  n++;
    XtSetArg(wargs[n],XmNleftOffset, XPos() );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_elastic :
    n = 0;
    XtSetArg(wargs[n],XmNleftAttachment, XmATTACH_POSITION);  n++;
    XtSetArg(wargs[n],XmNleftPosition, (XPos()*100/parent->XSize()) );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  }

switch (top)
  {
  case PIBK_free : 
    n = 0;
    XtSetArg(wargs[n],XmNtopAttachment, XmATTACH_NONE);  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_fixed :
    n = 0;
    XtSetArg(wargs[n],XmNtopAttachment, XmATTACH_FORM);  n++;
    XtSetArg(wargs[n],XmNtopOffset, YPos() );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_elastic :
    n = 0;
    XtSetArg(wargs[n],XmNtopAttachment, XmATTACH_POSITION);  n++;
    XtSetArg(wargs[n],XmNtopPosition, (YPos()*100/parent->YSize()) );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  }
  
switch (right) 
  {
  case PIBK_free : 
    n = 0;
    XtSetArg(wargs[n],XmNrightAttachment, XmATTACH_NONE);  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_fixed :
    n = 0;
    XtSetArg(wargs[n],XmNrightAttachment, XmATTACH_FORM);  n++;
    XtSetArg(wargs[n],XmNrightOffset, parent->XSize()-(XSize()+XPos()) );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_elastic :
    n = 0;
    XtSetArg(wargs[n],XmNrightAttachment, XmATTACH_POSITION);  n++;
    XtSetArg(wargs[n],XmNrightPosition, ((XPos()+XSize())*100/parent->XSize()) );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  }

switch (bottom) 
  {
  case PIBK_free : 
    n = 0;
    XtSetArg(wargs[n],XmNbottomAttachment, XmATTACH_NONE);  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_fixed :
    n = 0;
    XtSetArg(wargs[n],XmNbottomAttachment, XmATTACH_FORM);  n++;
    XtSetArg(wargs[n],XmNbottomOffset, parent->YSize()-(YSize()+YPos()) );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  case PIBK_elastic :
    n = 0;
    XtSetArg(wargs[n],XmNbottomAttachment, XmATTACH_POSITION);  n++;
    XtSetArg(wargs[n],XmNbottomPosition, ((YPos()+YSize())*100/parent->YSize()) );  n++;
    XtSetValues(this->sdw, wargs, n);
    break;
  }

return;
}


/* --Methode-- */
void PIWdgX::SetBorderWidth(int bw)
{
if (!sdw)  return;

Arg  wargs[2];
int n=0;

XtSetArg(wargs[n],XtNborderWidth,bw);  n++;
XtSetValues(this->sdw, wargs, n);
return;
}

/* --Methode-- */
void PIWdgX::SetLabel(string const& lab)
{
XmString xmstr;
xmstr = XmStringLtoRCreate((char *)lab.c_str(), XmSTRING_DEFAULT_CHARSET);
int n=0;
Arg warg[2];

XtSetArg(warg[n], XmNlabelString, xmstr); n++;
XtSetValues(XtWdg(), warg, n);
XmStringFree(xmstr);
return;
}



/* --Methode-- */
int PIWdgX::XSize()
{
if (!sdw)  return(-1);
else return((int)this->sdw->core.width);
}

/* --Methode-- */
int PIWdgX::YSize()
{
if (!sdw)  return(-1);
else return((int)this->sdw->core.height);
}

/* --Methode-- */
int PIWdgX::XPos()
{
if (!sdw)  return(-1);
else return((int)this->sdw->core.x);
}

/* --Methode-- */
int PIWdgX::YPos()
{
if (!sdw)  return(-1);
else return((int)this->sdw->core.y);
}


/* --Methode-- */
int PIWdgX::BorderWidth()
{
if (!sdw)  return(-1);
Arg  wargs[2];
int bw;
XtSetArg(wargs[0],XtNborderWidth, &bw);  
XtGetValues(this->sdw, wargs, 1);
return(bw);
}

/* --Methode-- */
string PIWdgX::Nom()
{
return(XtName(this->sdw));
}

/* --Methode-- */
void PIWdgX::GetScreenPos(int & spx, int & spy)
{
PIWdgX * wc;
Display *mdsp;
Window w, rw, pw, *cw;
unsigned int ncw;
Status st;
int x,y;
unsigned int bw, l, h, d;

spx = 0;  spy = 0;
wc = this;

while (wc)
  { spx += wc->XPos();
  spy += wc->YPos();  wc = (PIWdgX *)wc->Parent();
  }

mdsp = XtDisplay(XtWdg());
w = XtWindow(XtWdg());
ncw = 0;
st = XQueryTree(mdsp, w, &rw, &pw, &cw, &ncw);
if (st) 
  { XFree(cw);
  if (pw == rw)  return; }

while (st && (pw != rw))  
  {
  w = pw;
  st = XQueryTree(mdsp, w, &rw, &pw, &cw, &ncw); 
  if (st)   XFree(cw);
  XGetGeometry(mdsp, w, &rw, &x, &y, &l, &h, &bw, &d);  
  spy += y;  spx += x;
  }  
return;
}



/* --Methode-- */
int PIWdgX::InitXt(int narg, char *arg[])
{
if (top == NULL)   // Initialisation ...  
  {
  int n;
  char *pc = "PIWdgX";
  char **ppc;
  if (narg > 0)  { n = narg, ppc = arg; }
  else { ppc = &pc; n = 1; }
  strncpy(appname, ppc[0], 63); appname[63] = '\0';
  strncpy(appclass,"PeidaInt",63);  appclass[63] = '\0';     
  top = XtInitialize(appname, appclass, NULL, 0, &n, ppc);
  dpy = XtDisplay(top);
  }
return(0);
}
