// This may look like C code, but it is really -*- C++ -*-
//  Adaptateurs pour TMatrix TVector du package Sophya
//                             R. Ansari  1/99
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PITVMAAD_H_SEEN
#define PITVMAAD_H_SEEN

#include "machdefs.h"
#include "parradapter.h"

#include "tmatrix.h"
#include "tvector.h"

// Definition d'enum pour choix de la quantite affichee pour les tableaux de complexes.
enum PICmplxDispOption { PICDO_Module, PICDO_Real, PICDO_Imag, PICDO_Phase, PICDO_Module2 };
// Decode la presence d'une chaine opt contenant cdreal , cdimag , cdphase , cdmod , cdmod2
PICmplxDispOption StringToCmplxDispOption( string & opt );

// Adaptateur de vecteurs SOPHYA a P1DArrayAdapter
template <class T> 
class POTVectorAdapter : public P1DArrayAdapter {
public :
  POTVectorAdapter(TVector<T>* v, bool ad=false, PICmplxDispOption dopt=PICDO_Module); 
  virtual         ~POTVectorAdapter();
  virtual double  Value(int i);

protected:
  PICmplxDispOption dOpt;
  bool aDel;
  TVector<T>* mVec;
};

typedef POTVectorAdapter<r_8> POVectorAdapter;


// Adaptateur de matrice SOPHYA a P2DArrayAdapter
// Attention MatrixAdapter(X=Colonne, Y= Row) = Matrix(row, col)  
template <class T> 
class POTMatrixAdapter :  public P2DArrayAdapter {
public :
  POTMatrixAdapter(TMatrix<T>* mtx, bool ad=false, PICmplxDispOption dopt=PICDO_Module);
  virtual         ~POTMatrixAdapter();
  virtual double  Value(int ix, int iy);
  virtual double  MeanVal(int ix1, int ix2, int jy1, int jy2);

protected:
  PICmplxDispOption dOpt;
  bool aDel;
  TMatrix<T>* mMtx;
};

typedef POTMatrixAdapter<r_8> POMatrixAdapter;

#endif
