#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <typeinfo>
#include <iostream.h>
#include <string>
#include <list>
#include <map>
#if defined(__KCC__)
using std::string ;
#include <list.h>
#include <map.h>
#endif

#include "strutil.h"
#include "datatypes.h"

#include "nobjmgr.h"
#include "servnobjm.h"
#include "nomgadapter.h"
#include "pistdimgapp.h"


// EVOL-PLANCK
#ifdef SANS_EVOLPLANCK
#include "fitsimage.h"  
#endif

#include "pisurfdr.h"
#include "pipodrw.h"

#include "pintuple.h"
#include "pintup3d.h"
#include "pigfd1.h"
#include "pigfd2.h"


//++
// Class	NamedObjMgr
// Lib		PI
// include	nobjmgr.h
//
//	Cette classe fournit les services ncssaires  la gestion des objets
//	(l'ensemble des objets PPersist de PEIDA++) au sein du programme
//	d'analyse interactive *piapp* . Elle constitue en outre l'interface
//	entre les fonctions utilisateur et l'application graphique.
//--
//++
// Links	Voir aussi
// PIStdImgApp
// Services2NObjMgr
// PIACmd
//--


// ..................................................................
// ......  Gestion des objets nommes, variables globales ............
struct nobj_diritem {
  int id;                 // Directory Id
  int nobj;               // Number of objects in directory
  bool lock;              // True -> directory locked, No Add, del or rename
  bool keepold;           // True -> When duplicate object name, old object moved to /old
};

typedef map<string, nobj_diritem, less<string> > NObjDirList;

struct nobj_item {
  AnyDataObj* obj;             // Object pointer
  NObjMgrAdapter* obja;        // Object adapter pointer
  int oid;                     // object Id
  int dirid;                   // Directory Id
  list<int> wrsid;             // List of Window Resource Id (Drawer, PIBaseWdg, ...) 
                               // (for PIStdImgApp)
  bool operator==(nobj_item const& b) const
    { return (this->obj ==  b.obj); }
};

typedef map<string, nobj_item, less<string> > NObjList;

static NObjDirList* myDirs = NULL;
static NObjList* myObjs = NULL;
static int fgOInit = 0;
static int myNObj = 0;
static int myDirId = 0;
static string* currDir;

static PIStdImgApp* myImgApp=NULL;
static Services2NObjMgr* servnobjm=NULL;

static string* TmpDir;  // Repertoire pour les compilations / link dynamique

static bool BeQuiet = false;  // Moins de messages ...

// Pour completer le nom de l'objet avec le nom du repertoire
static void RemoveSpacesFromName(string & nom);
static bool CheckDirName(string & nom);
static int  ParseObjectName(string & nom, string & nomrep, string & nomobj);
// ..................................................................

//++
// Titre	Constructeurs
//--
//++
// NamedObjMgr()
//	Constructeur. Les diffrents instantiation de la classe "NamedObjMgr" 
//	dans une mme application crent des objets qui travaillent sur la mme
//	liste d'objets. Les objets de cette classe ne possedent en effet pas
//	de variables membres. 
//--

/* --Methode-- */
NamedObjMgr::NamedObjMgr()
{
if (fgOInit == 0) { 
  myNObj = 0;
  myDirId = 0;
  myDirs = new NObjDirList;
  myObjs = new NObjList;  
  currDir = new string("home");
  string dirn = "home";
  CreateDir(dirn);
  SetKeepOldDirAtt(dirn, true);
  dirn = "tmp";
  CreateDir(dirn);
  SetKeepOldDirAtt(dirn, false);
  dirn = "func";
  CreateDir(dirn);
  SetKeepOldDirAtt(dirn, false);
  dirn = "old";
  CreateDir(dirn);
  SetKeepOldDirAtt(dirn, false);
  dirn = "home";
  SetCurrentDir(dirn);
  myDirId = 50;
  char* varenv;
  TmpDir = new string("");
  if ( (varenv=getenv("PEIDA_TMP")) != NULL )  (*TmpDir) = varenv; 
  else if ( (varenv=getenv("TMPDIR")) != NULL )  (*TmpDir) = varenv; 
  int l = (*TmpDir).length();
  if ( (l>0) && ((*TmpDir)[l-1] != '/') )  (*TmpDir) += '/';
  servnobjm = new Services2NObjMgr(this, (*TmpDir));
  }
fgOInit++;
}

  
/* --Methode-- */
NamedObjMgr::~NamedObjMgr()
{
fgOInit--;
if (fgOInit == 0)  delete myObjs;
}

//++
// Titre	Mthodes
//--
//++
// void SetImgApp(PIStdImgApp* app)
//	Spcifie l'objet "PIStdImgApp" associ.
// PIStdImgApp* GetImgApp()
//	Accs  l'objet "PIStdImgApp" associ.
//--

/* --Methode-- */
void NamedObjMgr::SetImgApp(PIStdImgApp* app)
{
myImgApp = app;
servnobjm->SetImgApp(app);

NObjDirList::iterator it;
string cn;
for(it= myDirs->begin(); it != myDirs->end(); it++) {
  cn = '/' + (*it).first;
  (myImgApp->ObjMgrW())->AddDirectory(cn.c_str(), (*it).second.id);
  }
}

/* --Methode-- */
PIStdImgApp* NamedObjMgr::GetImgApp()
{
return(myImgApp);
}

/* --Methode-- */
Services2NObjMgr* NamedObjMgr::GetServiceObj()
{
return(servnobjm);
}

/* --Methode-- */
bool NamedObjMgr::CreateDir(string & dirname)
{
if ( !CheckDirName(dirname) ) {
  cout << "NamedObjMgr::CreateDir( " << dirname << ") Error - Invalid name !" << endl;
  return(false); 
  }
NObjDirList::iterator it = myDirs->find(dirname);
if (it != myDirs->end()) {
  cout << "NamedObjMgr::CreateDir( " << dirname << ") Error - Existing directory !" << endl;
  return(false);
  }
myDirId++;
nobj_diritem di;
di.id = myDirId;
di.nobj = 0;
di.lock = false;
di.keepold = false;
(*myDirs)[dirname] = di;
if (myImgApp)  { 
  string str = '/' + dirname;
  (myImgApp->ObjMgrW())->AddDirectory(str.c_str(), myDirId);
  }
cout << "NamedObjMgr::CreateDir() " << dirname << " Created " << endl;
return(true);
}

/* --Methode-- */
bool NamedObjMgr::DeleteDir(string & dirname)
{
if ( !CheckDirName(dirname) ) {
  cout << "NamedObjMgr::DeleteDir( " << dirname << ") Error - Invalid name !" << endl;
  return(false); 
  }
NObjDirList::iterator it = myDirs->find(dirname);
if (it == myDirs->end()) {
  cout << "NamedObjMgr::DeleteDir( " << dirname << ") Error - No such directory !" << endl;
  return(false);
  }
if ((*it).second.nobj > 0) {
  cout << "NamedObjMgr::DeleteDir() " << dirname << " not empty ! " << endl;
  return(false);
  }
if ((*it).second.lock ) {
  cout << "NamedObjMgr::DeleteDir() " << dirname << " locked ! " << endl;
  return(false);
  }
if ((*it).second.id < 50) {
  cout << "NamedObjMgr::DeleteDir() " << dirname << " cannot be deleted ! " << endl;
  return(false);
  }

if (myImgApp)  
  (myImgApp->ObjMgrW())->DelDirectory((*it).second.id);
myDirs->erase(it);
cout << "NamedObjMgr::DeleteDir() " << dirname << " deleted " << endl;  
return(true);
}

/* --Methode-- */
void NamedObjMgr::LockDir(string & dirname)
{
if ( !CheckDirName(dirname) ) return;
NObjDirList::iterator it = myDirs->find(dirname);
if (it == myDirs->end()) return;
(*it).second.lock = true;
cout << "NamedObjMgr::LockDir() " << dirname << " Locked " << endl;
return;
}

/* --Methode-- */
void NamedObjMgr::UnlockDir(string & dirname)
{
if ( !CheckDirName(dirname) ) return;
NObjDirList::iterator it = myDirs->find(dirname);
if (it == myDirs->end()) return;
(*it).second.lock = true;
cout << "NamedObjMgr::UnlockDir() " << dirname << " Unlocked " << endl;
return;
}

/* --Methode-- */
void NamedObjMgr::SetKeepOldDirAtt(string & dirname, bool keepold)
{
if ( !CheckDirName(dirname) ) return;
NObjDirList::iterator it = myDirs->find(dirname);
if (it == myDirs->end()) return;
(*it).second.keepold = keepold;
cout << "NamedObjMgr::SetKeepOldDirAtt() " << dirname << "  ->  ";
if ( keepold ) cout << " True " << endl;
else cout << " False " << endl;
return;
}


/* --Methode-- */
bool NamedObjMgr::SetCurrentDir(string & dirname)
{
if ( !CheckDirName(dirname) ) {
  cout << "NamedObjMgr::SetCurrentDir( " << dirname << ") Error - Invalid name !" << endl;
  return(false); 
  }
NObjDirList::iterator it = myDirs->find(dirname);
if (it == myDirs->end()) {
  cout << "NamedObjMgr::SetCurrentDir( " << dirname << ") Error - No such directory !" << endl;
  return(false);
  }
*currDir = dirname;
cout << "NamedObjMgr::SetCurrentDir() -> " << dirname << endl;
return(true);
}

/* --Methode-- */
void NamedObjMgr::GetCurrentDir(string & dirname)
{
dirname = *currDir;
}

/* --Methode-- */
void NamedObjMgr::ListDirs(string & patt)
{
NObjDirList::iterator it;
string cn;
cout << "NamedObjMgr::ListDirs( " << patt << " ) " << endl;
int k = 0;
for(it= myDirs->begin(); it != myDirs->end(); it++) {
  cn = (*it).first;
  if (csh_parse(cn.c_str(), patt.c_str()) == 0) continue;
  k++;
  cout << k << "- " << (*it).first;
  if ( (*it).second.lock )  cout << "  Locked " ;
  if ( (*it).second.keepold )   cout << "  KeepOld " ;
  cout << "  (Id= " << (*it).second.id << " NbObj= " << (*it).second.nobj << ")" << endl;
   
  }
}

/* --Methode-- */
void NamedObjMgr::GetDirList(string & patt, vector<string>& lstd)
{
NObjDirList::iterator it;
string cn;
for(it= myDirs->begin(); it != myDirs->end(); it++) {
  cn = (*it).first;
  if (csh_parse(cn.c_str(), patt.c_str()) == 0) continue;
  lstd.push_back(cn);
  }
}

/* --Methode-- */
void NamedObjMgr::CleanDir(string & dirname)
{
if ( !CheckDirName(dirname) ) {
  cout << "NamedObjMgr::CleanDir( " << dirname << ") Error - Invalid name !" << endl;
  }
NObjDirList::iterator itr = myDirs->find(dirname);
if (itr == myDirs->end()) {
  cout << "NamedObjMgr::CleanDir( " << dirname << ") Error - No such directory !" << endl;
  }

int did = (*itr).second.id;
NObjList::iterator it;  
list<int>::iterator iwr;
bool nodisp = true;
list<string> odel;
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  if ((*it).second.dirid != did) continue;
  nodisp = true;
  if (myImgApp) 
    for(iwr=(*it).second.wrsid.begin(); iwr != (*it).second.wrsid.end(); iwr++) 
      if (myImgApp->CheckWRsId(*iwr)) { nodisp = false; break; }
  if (nodisp) odel.push_back((*it).first);
  }
list<string>::iterator ii;
for(ii=odel.begin(); ii != odel.end(); ii++)  DelObj(*ii,true);
}



//++
// Titre	Gestion de la liste des objets
//--
//++
// void AddObj(AnyDataObj* obj, string& nom)
//	Ajoute l'objet "obj"  la liste, identifi par "nom".
//	Si un objet de mme nom existe, l'ancien objet est renomm en concatnant 
//	un numro  son nom.
// void DelObj(string const& nom, bool fgd=true)
//	Supprime l'objet "nom" de la liste. L'objet est dtruit si "fgd==true"	("delete obj")
// void DelObjects(string const& patt, bool fgd=true)
//	Supprime l'ensemble des objets dont le nom correspond au patron "patt".
//	Le patron peut contenir les caractres "*" et "?" . Les objets sont dtruits si "fgd==true"
// AnyDataObj*  GetObj(string const& nom) 
//	Retourne l'objet identifi par "nom" dans la liste. Retourne "NULL" si "nom" n'est 
//	pas dans la liste.
// void  RenameObj(string const& nom, string& nomnew)
//	Change le nom d'un objet dans la liste.
//--


/* --Methode-- */
bool NamedObjMgr::AddObj(AnyDataObj* obj, string & nom, bool crd)
{

if (obj == NULL)  return(false);
// On verifie si l'objet est deja dans la liste 
NObjList::iterator it;
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  if ((*it).second.obj == obj) {
    cout << "NamedObjMgr::AddObj() Object already present with name " << (*it).first << endl;
    return(false);
    }
  }
string nobj;
string nrep;
char buff[32];
int did = ParseObjectName(nom, nrep, nobj);
if (did == 0) {
  if (!crd) {
    cout << "NamedObjMgr::AddObj() No " << nrep << " Directory " << endl;
    return(false);
    }
  else { CreateDir(nrep);  did =  myDirId; }
  }

// Si c'est le repertoire /func, on nettoie
if (nrep == "func")  {
  BeQuiet = true;   
  CleanDir(nrep);
  BeQuiet = false;
  }

myNObj++;
if (nobj.length() < 1) { 
  sprintf(buff,"O%d", myNObj);
  nobj = buff;
  }

nom = '/' + nrep + '/' + nobj;  
NObjDirList::iterator itr = myDirs->find(nrep);
if ((*itr).second.lock) {
  cout << "NamedObjMgr::AddObj() " << nrep << " Locked Directory " << endl;
  return(false);
  }
it = myObjs->find(nom);
if (it != myObjs->end()) { // l'objet existe deja
  if (nrep == "func") {  // Dans /func , on garde les objets affiches, donc del. par Clean
    sprintf(buff, "%d", (*it).second.oid); 
    string nomnew = "/func/" + nobj + buff;
    RenameObj(nom, nomnew);
    }                              
  else if ( (*itr).second.keepold ) { // On met l'ancien objet dans /old
    string on,od;
//    ParseObjectName((*it).first, od, on); 
    sprintf(buff, "%d", (*it).second.oid);
    string nomnew = "/old/" + nobj + buff;
    RenameObj(nom, nomnew);
    }
  else {  // Sinon, on remplace l'objet
    cout << "NamedObjMgr::AddObj() - Replacing " << nom << endl;
    DelObj(nom);
    }
  }

nobj_item no;
no.obj = obj;
no.obja = servnobjm->GetAdapter(obj);  // L'adaptateur
no.oid =  myNObj;
no.dirid = did;
(*myObjs)[nom] = no;

(*itr).second.nobj++;

cout << "NamedObjMgr::AddObj()  Object " << nom << " ( "  
     << typeid(*obj).name() << " ) added (Total= " << myObjs->size() << ")" << endl;  
return(true);
}

/* --Methode-- */
bool NamedObjMgr::RenameObj(string & nom, string& nomnew)
{
string n1,r1,n2,r2;
int dids = ParseObjectName(nom, r1, n1);
NObjDirList::iterator itr1 = myDirs->find(r1);
int did = ParseObjectName(nomnew, r2, n2);
NObjDirList::iterator itr2 = myDirs->find(r2);

if (did == 0) {
  cout << "NamedObjMgr::RenameObj() Error - No " << r2 << " directory !" << endl;
  return(false);
  }
nom = '/' + r1 + '/' + n1;
nomnew = '/' + r2 + '/' + n2;
NObjList::iterator it1 = myObjs->find(nom);
if (it1 == myObjs->end()) {
  cout << "NamedObjMgr::RenameObj() Error -  No " << nom << " object !" << endl;
  return(false);
  }
NObjList::iterator it2 = myObjs->find(nomnew);
if (it2 != myObjs->end()) {
  cout << "NamedObjMgr::RenameObj() Error -  Object " << nomnew << " exist !" << endl;
  return(false);
  }

if ( (*itr1).second.lock || (*itr2).second.lock ) {
  cout << "NamedObjMgr::RenameObj() Error - Source or destination directory locked !" 
       << endl;
  return(false);  
  }


nobj_item no = (*it1).second;
no.dirid = did;
myObjs->erase(it1);
NObjDirList::iterator itr = myDirs->find(r1);
(*itr).second.nobj--;
(*myObjs)[nomnew] = no;
itr = myDirs->find(r2);
(*itr).second.nobj++;
cout << "NamedObjMgr::RenameObj() - Object " << nom << " renamed to " << nomnew << endl;
return(true);
}

/* --Methode-- */
bool NamedObjMgr::DelObj(string & nom, bool fgd)
{
string n1,r1;
ParseObjectName(nom, r1, n1);
nom = '/' + r1 + '/' + n1;
NObjList::iterator it = myObjs->find(nom);
if (it == myObjs->end()) return(false); 
NObjDirList::iterator itr = myDirs->find(r1);
if ( (*itr).second.lock  ) {
  cout << "NamedObjMgr::DelObj() Error - Locked directory " << r1 << endl;
  return(false);
  }
list<int>::iterator ii;
if (myImgApp) {
//DBG  cerr << " *DBG* NamedObjMgr::DelObj Sz= " << (*it).second.wrsid.size() << endl; 
  for(ii=(*it).second.wrsid.begin(); ii != (*it).second.wrsid.end(); ii++) 
      myImgApp->DelWRsId((*ii));
}
delete (*it).second.obja;  // destruction de l'adaptateur 
if (fgd) delete (*it).second.obj;

myObjs->erase(it);
(*itr).second.nobj--;

if (BeQuiet) return(true);  
if (fgd) cout << "NamedObjMgr::DelObj()  Object " << nom << " deleted (Total= " << myObjs->size() << ")" << endl;
else  cout << "NamedObjMgr::DelObj()  Object " << nom << " removed (Total= " << myObjs->size() << ")" << endl;
return(true);  
}

/* --Methode-- */
bool NamedObjMgr::DelObj_Id(int oid)
{
NObjList::iterator it;
string nom;
bool of = false;
for(it = myObjs->begin(); it != myObjs->end(); it++) 
  if ( (*it).second.oid == oid ) { 
    of = true;  nom = (*it).first;
    break;
  }
if (of) return(DelObj(nom, true));
else return(false);
}

/* --Methode-- */
void NamedObjMgr::DelObjects(string & patt, bool fgd)
{
string n1,r1;
ParseObjectName(patt, r1, n1);
patt = '/' + r1 + '/' + n1;
NObjList::iterator it;  
list<string> odel;
string cn;
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  cn = (*it).first;
  if (csh_parse(cn.c_str(), patt.c_str()) != 0)  odel.push_back(cn);
  }
list<string>::iterator ii;
for(ii=odel.begin(); ii != odel.end(); ii++)  DelObj(*ii, fgd);
}

/* --Methode-- */
AnyDataObj* NamedObjMgr::GetObj(string & nom)
{
string n1,r1;
ParseObjectName(nom, r1, n1);
nom = '/' + r1 + '/' + n1;
NObjList::iterator it = myObjs->find(nom);
if (it == myObjs->end()) return(NULL); 
return((*it).second.obj);
}

/* --Methode-- */
NObjMgrAdapter* NamedObjMgr::GetObjAdapter(string & nom)
{
string n1,r1;
ParseObjectName(nom, r1, n1);
nom = '/' + r1 + '/' + n1;
NObjList::iterator it = myObjs->find(nom);
if (it == myObjs->end()) return(NULL); 
return((*it).second.obja);
}

/* --Methode-- */
void NamedObjMgr::ListObjs(string & patt)
{
int k;
AnyDataObj* obj=NULL;
string ctyp;
char strg[256];

string n1,r1;
ParseObjectName(patt, r1, n1);
patt = '/' + r1 + '/' + n1;
 cout << "NamedObjMgr::ListObjs( " << patt << " ) TotNObjs= " << myObjs->size() << "\n" ;
NObjList::iterator it;  k = 0;
string cn;
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  cn = (*it).first;
  if (csh_parse(cn.c_str(), patt.c_str()) == 0)  continue;
  obj = (*it).second.obj;
  ctyp = typeid(*obj).name();
  sprintf(strg, "%2d/ %16s : %s", k, typeid(*obj).name(), ((*it).first).c_str()); 
  ctyp = strg;
  cout << ctyp << "\n" ;
  k++;
}
cout << endl;
return;
}

/* --Methode-- */
void NamedObjMgr::GetObjList(string & patt, vector<string> &lst)
{
string n1,r1;
if (patt.length() < 1)  return;
bool fgr = (patt[0] == '/') ? true : false;
ParseObjectName(patt, r1, n1);
patt = '/' + r1 + '/' + n1;
NObjList::iterator it;
string cn;
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  cn = (*it).first;
  if (csh_parse(cn.c_str(), patt.c_str()) == 0)  continue;
  if (fgr) lst.push_back(cn);
  else {
    ParseObjectName(cn, r1, n1);
    lst.push_back(n1);
    }
  }
}

//++
// Titre	Entres-Sorties (I/O) sur les objets
//--
//++
// void  ReadObj(PInPersist& s, int num=-1)
//	Lit l'objet  partir avec le tag numro "num" dans le flot "PInPersist s"
//	et l'ajoute  la liste. Si "num" est ngatif, tous les objets prsents
//	sur le flot "s" sont crs et ajouts  la liste.
// void  ReadObj(string const & nomppf, string nobj="")
//	Lit le premier objet  partir du fichier PPF "nomppf". L'objet est ajout
//	 la liste avec le nom "nobj". Si "nobj" est une chane vide, un nom est 
//	compos  partir du nom de fichier. 
//--

/* --Methode-- */
void NamedObjMgr::ReadObj(string const & flnm, string & nobj)
{
PPersist* obj=NULL;
bool ok = true;

TRY{
  PInPersist pis(flnm);
  obj = PPersistMgr::ReadObject(pis);
  if (obj == NULL) ok = false;
}  CATCH(merr) 
  { printf("NamedObjMgr::ReadObj()/Error Exception= %ld (%s) \n", 
    (long)merr, PeidaExc(merr));  ok = false; } ENDTRY;

if (!ok)  return;
if (nobj.length()<1)  nobj = servnobjm->FileName2Name(flnm);
AddObj(obj->DataObj(), nobj, true);
return;
}

/* --Methode-- */
void NamedObjMgr::ReadObj(PInPersist& s, int num)
{
int i, cid, key, ln;
int n0, n1;
bool ok = true;
PPersist* obj=NULL;
string nom;

if ( (s.NbTags() < 1) || (num >= s.NbTags()) ) {
  if (num >= 0) { 
    printf("NamedObjMgr::ReadObj(PInPersist, %d) Error! NbTags = %d \n", num, s.NbTags());
    return;
  }
  TRY {
    obj = PPersistMgr::ReadObject(s);
    if (obj == NULL)  ok = false;
  }  CATCH(merr) { 
    printf("NamedObjMgr::ReadObj()/Error Exception= %ld (%s) \n", (long)merr, PeidaExc(merr)); 
    ok = false; 
  } ENDTRY;
  if (!ok)  return;
  nom = "";
  AddObj(obj->DataObj(), nom);
}
 
if (num < 0) { n0 = 0; n1 = s.NbTags(); } 
else { n0 = num; n1 = num+1; }
for(i=n0; i<n1; i++) {
  key = s.TagKey(i, cid, ln); 
  if (ln <= 0)  nom = "";
  else nom = s.TagName(i);
  s.GotoTag(i);
  TRY {
    obj = PPersistMgr::ReadObject(s);
    if (obj == NULL)  ok = false;
  }  CATCH(merr) { 
    printf("NamedObjMgr::ReadObj()/Error Exception= %ld (%s) \n", (long)merr, PeidaExc(merr)); 
    ok = false; 
  } ENDTRY;
  if (ok)  AddObj(obj->DataObj(), nom, true);  
}

return;
}
/* --Methode-- */
void NamedObjMgr::ReadAll(string const & flnm)
{
bool ok = true;
PPersist* obj=NULL;

PInPersist* ppin;
TRY{
  ppin = new PInPersist(flnm);
  if (ppin->NbTags() < 1)  obj = PPersistMgr::ReadObject((*ppin));
  else obj = NULL;
}  CATCH(merr) 
  { printf("NamedObjMgr::ReadAll()/Error Exception= %ld (%s) \n", 
    (long)merr, PeidaExc(merr));  ok = false; } ENDTRY;

if (!ok)  return;
if (obj) {
  string nom = servnobjm->FileName2Name(flnm);
  AddObj(obj->DataObj(), nom);
  }
else ReadObj((*ppin), -1);
delete ppin;
return;
}

/* --Methode-- */
void NamedObjMgr::ReadFits(string const & flnm, string & nobj)
{
bool ok = true;
RzImage* obj;

TRY{
//  obj = RzReadFits((char*)flnm.c_str(), ImgOffX, ImgOffY, ImgSizX, ImgSizY, ImgBitSgn);
#ifdef SANS_EVOLPLANCK 
  obj = RzReadFits((char*)flnm.c_str());
#else
  printf("NamedObjMgr::ReadFITS( NON-Disponible EVOL-PLANCK) \n"); 
  obj = NULL;
#endif
  if (obj == NULL)   ok = false;
}  CATCH(merr) { 
  printf("NamedObjMgr::ReadFITS(_Error Exception= %ld (%s) \n", (long)merr, PeidaExc(merr)); 
  ok = false; 
} ENDTRY;
if (ok) { 
  if (nobj.length()<1)  nobj = servnobjm->FileName2Name(flnm);
  AddObj((AnyDataObj*)obj, nobj);
}
return;
}


static int key_for_write = 5000;
/* --Methode-- */
void NamedObjMgr::SaveObj(string & nom, POutPersist& s, bool keeppath)
{
if (nom.length() < 1) return;
string nob,rep;
ParseObjectName(nom, rep, nob);
nom = '/' + rep + '/' + nob;
NObjMgrAdapter* obja=NULL;
string nomf = (keeppath) ? nom : nob;
obja = GetObjAdapter(nom);
if (obja == NULL)  return;
printf("NamedObjMgr::SaveObj(%s, )  (Type=%s) \n",  
       nom.c_str(), typeid(*(obja->GetDataObj())).name());
obja->SavePPF(s, nomf);
return; 
}

/* --Methode-- */
void NamedObjMgr::SaveObjects(string & patt, string const& flnm)
{
string n1,r1;
if (patt.length() < 1)  return;
bool keeppath = (patt[0] == '/') ? true : false;
ParseObjectName(patt, r1, n1);
patt = '/' + r1 + '/' + n1;

bool ok = true;
POutPersist* pout;
TRY{
  pout = new POutPersist(flnm);
}  CATCH(merr) 
  { printf("NamedObjMgr::SaveObjects()/Error Exception= %ld (%s) \n", 
    (long)merr, PeidaExc(merr));  ok = false; } ENDTRY;
if (!ok)  return;
NObjList::iterator it;
string cn; 
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  cn = (*it).first;
  if (csh_parse(cn.c_str(), patt.c_str()) == 0)  continue;
  SaveObj(cn, (*pout), keeppath);
  }
delete pout;
return;
}

/* --Methode-- */
void NamedObjMgr::SaveAll(string const& flnm)
{
bool ok = true;

POutPersist* pout;
TRY{
  pout = new POutPersist(flnm);
}  CATCH(merr) 
  { printf("NamedObjMgr::SaveAll()/Error Exception= %ld (%s) \n", 
    (long)merr, PeidaExc(merr));  ok = false; } ENDTRY;
if (!ok)  return;
NObjList::iterator it;
string no; 
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  no = (*it).first;
  SaveObj(no, (*pout), true);
  }
delete pout;
return;
}

/* --Methode-- */
void NamedObjMgr::SaveFits(string& nom, string const & flnm)
{
NObjMgrAdapter* obja=NULL;
obja = GetObjAdapter(nom);
if (obja == NULL)  return;
obja->SaveFits(flnm);
return;
}



/* --Methode-- */
void NamedObjMgr::PrintObj(string& nom)
{
NObjMgrAdapter* obja=NULL;
obja = GetObjAdapter(nom);
if (obja == NULL)  return;

string ctyp = typeid(*obja->GetDataObj()).name();
cout << "NamedObjMgr::PrintObj(" << nom << ") Type: " << ctyp << endl;
obja->Print(cout);

return;
}

/* --Methode-- */
void NamedObjMgr::DisplayObj(string& nom, string dopt) 
{
NObjMgrAdapter* obja=NULL;
obja = GetObjAdapter(nom);
if (obja == NULL) {
  cout << "NamedObjMgr::DisplayObj() Error , Pas d'objet de nom " << nom << endl; 
  return;
}
if (!myImgApp)  return;
 
PIDrawer * dr = NULL;
P2DArrayAdapter* arr = NULL;
dr = obja->GetDrawer(dopt);
if (!dr) arr = obja->Get2DArray(dopt);

if (!dr && !arr) { 
  string ctyp = typeid(*(obja->GetDataObj())).name();
  cout << "NamedObjMgr::DisplayObj() Error , Pas de display pour " << ctyp << endl; 
  return;
  }

int wrsid = 0;
bool fgsr = true;
int opt = servnobjm->DecodeDispOption(dopt, fgsr);

string n1,r1;
ParseObjectName(nom, r1, n1);

if (dr) { 
  PIDrawer3D * dr3 = dynamic_cast<PIDrawer3D *>(dr);
  if(dr3)  wrsid = myImgApp->Disp3DDrawer(dr3, n1, opt);
  else wrsid = myImgApp->DispScDrawer( dr, n1, opt); 
  }
else if (arr) wrsid = myImgApp->DispImage(arr, n1, opt);

if(wrsid != 0) {
  NObjList::iterator it = myObjs->find(nom);
  if (it == myObjs->end()) return; 
  (*it).second.wrsid.push_back(wrsid);
  }
if (fgsr) myImgApp->RestoreGraphicAtt(); 
return;
}

/* --Methode-- */
void NamedObjMgr::DisplayImage(string& nom, string dopt)
{
NObjMgrAdapter* obja=NULL;
obja = GetObjAdapter(nom);
if (obja == NULL) {
  cout << "NamedObjMgr::DisplayImage() Error , Pas d'objet de nom " << nom << endl; 
  return;
}
if (!myImgApp)  return;
 
P2DArrayAdapter* arr = obja->Get2DArray(dopt);

if (!arr) { 
  string ctyp = typeid(*(obja->GetDataObj())).name();
  cout << "NamedObjMgr::DisplayImage() Error , Non supporte pour " << ctyp << endl; 
  return;
  }

string n1,r1;
ParseObjectName(nom, r1, n1);

int wrsid = 0;
bool fgsr = true;
int opt = servnobjm->DecodeDispOption(dopt, fgsr);
wrsid = myImgApp->DispImage(arr, n1, opt);

if(wrsid != 0) {
  NObjList::iterator it = myObjs->find(nom);
  if (it == myObjs->end()) return; 
  (*it).second.wrsid.push_back(wrsid);
  }
if (fgsr) myImgApp->RestoreGraphicAtt(); 
return;
}
/* --Methode-- */
void NamedObjMgr::DisplaySurf3D(string& nom, string dopt)
{
NObjMgrAdapter* obja=NULL;
obja = GetObjAdapter(nom);
if (obja == NULL) {
  cout << "NamedObjMgr::DisplayImage() Error , Pas d'objet de nom " << nom << endl; 
  return;
}
if (!myImgApp)  return;
 
P2DArrayAdapter* arr = obja->Get2DArray(dopt);

if (!arr) { 
  string ctyp = typeid(*(obja->GetDataObj())).name();
  cout << "NamedObjMgr::DisplaySurf3D() Error , Non supporte pour " << ctyp << endl; 
  return;
  }

if ((arr->XSize() > 250) || (arr->YSize() > 250)) {
  cout << "NamedObjMgr::DisplaySurf3D() Error , 2D-Array(" <<  arr->XSize() 
       << "x" << arr->YSize() << ") trop grand (max=250x250)" << endl; 
  delete arr;
  return;
  }

string n1,r1;
ParseObjectName(nom, r1, n1);

int wrsid = 0;
bool fgsr = true;
int opt = servnobjm->DecodeDispOption(dopt, fgsr);
PISurfaceDrawer* sdr = new PISurfaceDrawer(arr, true, true, true);
wrsid = myImgApp->Disp3DDrawer(sdr, n1, opt);
if(wrsid >= 0) {
  NObjList::iterator it = myObjs->find(nom);
  if (it == myObjs->end()) return; 
  (*it).second.wrsid.push_back(wrsid);
  }

if (fgsr) myImgApp->RestoreGraphicAtt();  
return; 
}

/* --Methode-- */
void NamedObjMgr::DisplayNT(string& nom, string& nmx, string& nmy, string& nmz,
                            string& erx, string& ery, string& erz, string dopt, bool fg3d)
{
AnyDataObj* obj=GetObj(nom);
if (obj == NULL) {
  cout << "NamedObjMgr::DisplayNT() Error , Pas d'objet de nom " << nom << endl; 
  return;
}
if (!myImgApp)  return; 

NTupleInterface * nt = dynamic_cast<NTupleInterface *>(obj);
if (nt == NULL) {
// if (typeid(*obj) != typeid(NTupleInterface)) { 
  string ctyp = typeid(*obj).name();
  cout << "NamedObjMgr::DisplayNT() Error , Objet n'est pas un NTuple " << ctyp << endl; 
  return;
  }

int wrsid = 0;
bool fgsr = true;
dopt = "defline," + dopt;
int opt = servnobjm->DecodeDispOption(dopt, fgsr);

string n1,r1;
ParseObjectName(nom, r1, n1);

if ( fg3d && (nmz.length()>0) )  { // Display 3D
  PINTuple3D* pin = new PINTuple3D(nt, false);
  pin->SelectXYZ(nmx.c_str(), nmy.c_str(), nmz.c_str());
  pin->SelectErrBar(erx.c_str(), ery.c_str(), erz.c_str());
  string titre = nmz + "%" + nmy + "%" + nmz;
  wrsid = myImgApp->Disp3DDrawer(pin, n1, opt, titre);  
}
else {
  PINTuple* pin = new PINTuple(nt, false);
  pin->SelectXY(nmx.c_str(), nmy.c_str());
  pin->SelectErrBar(erx.c_str(), ery.c_str());
  if ( nmz.length()>0 ) pin->SelectWt(nmz.c_str());
  string titre = nmy + "%" + nmx;
  wrsid = myImgApp->DispScDrawer( (PIDrawer*)pin, n1, opt, titre);
  }

if(wrsid >= 0) {
  NObjList::iterator it = myObjs->find(nom);
  if (it == myObjs->end()) return; 
  (*it).second.wrsid.push_back(wrsid);
  }

if (fgsr) myImgApp->RestoreGraphicAtt(); 
return;
}

/* --Methode-- cmv 13/10/98 : Obsolete mais ne pas virer SVP */
void NamedObjMgr::DisplayGFD(string& nom, string& numvarx, string& numvary, string& err, string dopt)
//	Pour le display 2D ou 3D d'un ``GeneralFitData''.
//|  nom = nom de l'objet GeneralFitData a representer.
//|  numvarx = numero (nombre entier) de la 1ere variable d'abscisse.
//|  numvary = numero (nombre entier) de la 2sd variable d'abscisse (3D).
//|            Pour le display 2D, numvary="" string vide.
//|  err = qu'elles erreurs faut il representer ?
//|      - 2D : x y xy   (display y=f(x))
//|      - 3D : x y z xy xz yz xzy   (display z=f(x,y))
//|      Ceci n'est suivi que si on a PI_NotDefLineAtt, sinon toutes
//|      les barres d'erreurs sont representees.
//|  opt = options generales pour le display.
{
AnyDataObj* obj=GetObj(nom);
if(obj == NULL)
  {cout << "NamedObjMgr::DisplayGFD() Error , Pas d'objet de nom " << nom << endl; 
   return;}
if(!myImgApp) return; 
if(typeid(*obj) != typeid(GeneralFitData))
  {string ctyp = typeid(*obj).name();
   cout<<"NamedObjMgr::DisplayGFD() Error , Objet n'est pas un GeneralFitData "<<ctyp<<endl; 
   return;}

// Decodage des options classiques
bool fgsr = true;
int opt = servnobjm->DecodeDispOption(dopt, fgsr);
// Decodage des erreurs a representer
bool errx=false, erry=false, errz=false;
if(err.length()>0) {
  for(int i=0;i<err.length();i++)
    if     (err[i]=='x' || err[i]=='X') errx = true;
    else if(err[i]=='y' || err[i]=='Y') erry = true;
    else if(err[i]=='z' || err[i]=='Z') errz = true;
}
// Decodage des numeros de variables en abscisse
 int numvx=-1, numvy=-1;
 if(numvarx.length()>0) numvx = atoi(numvarx.c_str());
 if(numvary.length()>0) numvy = atoi(numvary.c_str());
 
 string n1,r1;
 ParseObjectName(nom, r1, n1);

 int wrsid = 0;
 if(numvy>=0) {              // display 3D
  PIGenFitDat3D* pigfd = new PIGenFitDat3D(((GeneralFitData*)obj),false);
  pigfd->SelectXY(numvx,numvy);
  pigfd->SelectErrBar(errx,erry,errz);
  wrsid = myImgApp->Disp3DDrawer(pigfd,n1,opt);  
} else {                   // display 2D
  PIGenFitDat* pigfd = new PIGenFitDat(((GeneralFitData*)obj),false);
  pigfd->SelectX(numvx);
  pigfd->SelectErrBar(errx,erry);
  wrsid = myImgApp->DispScDrawer((PIDrawer*)pigfd,n1,opt);
}

if(wrsid >= 0) {
  NObjList::iterator it = myObjs->find(nom);
  if (it == myObjs->end()) return; 
  (*it).second.wrsid.push_back(wrsid);
}
if (fgsr) myImgApp->RestoreGraphicAtt(); 
return;
}

/* --Methode-- 
void NamedObjMgr::DisplayImage(string& nom, string dopt)
{
  cout << "NamedObjMgr::DisplayImage() a faire ! " << endl;
}
*/




/* --Methode-- */
void NamedObjMgr::SetGraphicAttributes(string gratt)
{
bool fg = false;
servnobjm->DecodeDispOption(gratt, fg);
}

/* --Methode-- */
void NamedObjMgr::SetGraphicWinZone(int nzx, int nzy, bool fcr)
{
if (!myImgApp)  return; 
if (fcr)  myImgApp->CreateGraphWin(nzx, nzy);
else myImgApp->SetZone(nzx, nzy);
}

/* --Methode-- */
void NamedObjMgr::AddWRsId(string & nom, int wrsid)
{
if(wrsid != 0) {
  NObjList::iterator it = myObjs->find(nom);
  if (it == myObjs->end()) return; 
  (*it).second.wrsid.push_back(wrsid);
  }
return;
}

/* --Methode-- */
void NamedObjMgr::UpdateObjMgrWindow(int did)
{
if (!myImgApp)  return;
(myImgApp->ObjMgrW())->ClearHelpList();

NObjList::iterator it;  
string cn;
for(it = myObjs->begin(); it != myObjs->end(); it++) {
  if ((*it).second.dirid != did) continue;
  cn = (*it).first.substr(1);
  cn = cn.substr(cn.find('/')+1) + "  (T= " + typeid(*((*it).second.obj)).name() + ")" ;
  (myImgApp->ObjMgrW())->AddObj(cn.c_str());
  }
}


/* Nouvelle-Fonction */
void RemoveSpacesFromName(string & nom)
{
// on supprime les blancs de debut et de fin 
size_t p = nom.find_first_not_of(" ");
if(p>nom.length()) { nom = ""; return; }
nom = nom.substr(p);
p = nom.find(' ');
if(p>nom.length()) p=nom.length();
nom = nom.substr(0, p);
}

/* Nouvelle-Fonction */
bool CheckDirName(string & nom)
{
RemoveSpacesFromName(nom);
if (nom.length() < 1)  return(false); 
if (nom[0] == '/') nom = nom.substr(1) ;
size_t p = nom.find('/');
if (p < nom.length()) nom = nom.substr(0,p);
if (nom.length() < 1)  return(false); 
return(true);
}

/* Nouvelle-Fonction */
int ParseObjectName(string & nom, string & nomrep, string & nomobj)
{
RemoveSpacesFromName(nom);
// Si le nom ne commence pas par un slash, c'est le repertoire courant 
if (nom[0] != '/') { nomrep = *currDir;  nomobj = nom; }
else {
  string xx = nom.substr(1);
  size_t p = xx.find('/');
  if (p < xx.length())  { 
    nomrep = xx.substr(0,p); 
    nomobj = xx.substr(p+1);
    }
  else {
    nomrep = xx;
    nomobj = "";
    }
  }
int rc = 0;
NObjDirList::iterator it = myDirs->find(nomrep);
if (it != myDirs->end())  rc = (*it).second.id;
return(rc);
}

