/*
 *  PIMenuQuartz.h
 *  PI
 *
 *  Created by Bruno MANSOUX on Fri May 28 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */
#ifndef PIMENUQUARTZ_H_SEEN
#define PIMENUQUARTZ_H_SEEN

#include <Carbon/Carbon.h>
#include "pimenugen.h"

class PIMenuQuartz;

struct _pimqit_
{
    MenuCommand itemId;
    PIMenuQuartz *pim;
    PIMessage msg;
    CFStringRef	itemString;
    int itemIndex;
};

class PIMenuQuartz : public PIMenuGen {
public:
	          PIMenuQuartz(PIWdg* par, const char* nom, PIMenuType pdpu=k_UTMenu);
	          ~PIMenuQuartz();
				   
  virtual void	  AppendItem(const char* nom, PIMessage msg, char* sc=NULL);
  virtual void	  AppendCheckItem(const char* nom, PIMessage msg, char* sc=NULL);
  virtual void	  AppendPDMenu(PIMenuGen* pdm, char* sc=NULL);
  virtual void    AppendCascadeMenu(PIMenuQuartz* cascadeMenu, PIMessage msg);
  virtual void	  AppendSeparator();

  virtual void    DeleteItem(const char *nom);
  virtual void    DeleteItemMsg(PIMessage msg);
  virtual void    DeleteItemNum(int n);

  virtual void    SetSensitivity(const char *nom, bool sens=true); 
  virtual void    SetSensitivityMsg(PIMessage msg, bool sens=true); 
  virtual void    SetSensitivityNum(int n, bool sens=true);

  virtual bool    IsSensitive(const char *nom);
  virtual bool    IsSensitiveMsg(PIMessage msg);
  virtual bool    IsSensitiveNum(int n);

  virtual void    SetState(const char *nom, bool st=false); 
  virtual void    SetStateMsg(PIMessage msg, bool st=false); 
  virtual void    SetStateNum(int n, bool st=false);
 
  virtual bool    GetState(const char *nom); 
  virtual bool    GetStateMsg(PIMessage msg); 
  virtual bool    GetStateNum(int n); 

  virtual void    Show();
  virtual void    Show(PIWdg *w, int px, int py);

  PIMessage	GetMsgItem(int ItemID);
  int		GetNumItem(const char *nom);
  int		GetNumItemMsg(PIMessage msg);
  char*		ItemName(int n);

  MenuRef	GetMenuRef ();
  MenuID	GetMenuID ();
  PIWdg*	GetParent ();
    
  protected:
	PIWdg* parent;
    MenuRef mMenu;
    int     mMenuID;
    _pimqit_ * mItems;
    int mNItem;
	int mNItemMax;
};


typedef PIMenuQuartz        PIMenu;

#endif
