/*
 *  PIWindowQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Tue Apr 13 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "PIWindowQuartz.h"

PIWindowQuartz::PIWindowQuartz(PIMsgHandler *par, const char *nom, PIWindowKind k, int sx, int sy, int px, int py)
:PIWindowGen(par, nom, k, sx, sy, px, py) 
{
    OSStatus err = 0;
    WindowAttributes windowAttributes;
    
	/*
	wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
	*/
	
    SetRect(&wdgRect,px,py,px+sx,py+sy);
	windowAttributes = kWindowStandardDocumentAttributes | kWindowCompositingAttribute ;
	
	err = CreateNewWindow (kDocumentWindowClass,windowAttributes,&wdgRect,&wRef);

    if (err)
        printf ("PIWindowQuartz Create Err = %d \n",err);
    fflush (stdout);
    
    err = SetWindowTitleWithCFString (wRef, title);

	viewH = HIViewGetRoot(wRef);
    InstallStandardEventHandler(GetWindowEventTarget(wRef)); /* installs the default */
}

PIWindowQuartz::~PIWindowQuartz()
{

}

void PIWindowQuartz::SetSize(int sx, int sy)
{
    SizeWindow (wRef, sx, sy, true);
    return;
}

void PIWindowQuartz::SetPos(int px, int py)
{
    MoveWindow (wRef, px, py, false);
    return;
}

void PIWindowQuartz::Manage()
{
    return;	
}

void PIWindowQuartz::UnManage()
{
	HideWindow(wRef);
    return;
}

bool PIWindowQuartz::IfManaged()
{
    return true;
}
 
bool PIWindowQuartz::IsVisible()
{
    return (IsWindowVisible(wRef));
}

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
void PIWindowQuartz::Refresh()
{
    SetPortWindowPort(wRef);
    BeginUpdate(wRef);
	EraseRect(GetWindowPortBounds(wRef, &wdgRect));
    DrawControls(wRef);
    DrawGrowIcon(wRef);
    EndUpdate(wRef);
    ShowWindow (wRef);
    return ;
}

void PIWindowQuartz::Show()
{
	Refresh();
}

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
void PIWindowQuartz::SetSensitive()
{
    ActivateWindow (wRef, true);
    return;
}

void PIWindowQuartz::SetUnSensitive()
{
    ActivateWindow (wRef, false);
    return;
}

bool PIWindowQuartz::IfSensitive()
{
    return (IsWindowActive(wRef));
}

//  Gestion des EventHandler
void PIWindowQuartz::AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad)
{
/*
    InstallWindowEventHandler (contH, 
                                NewEventHandlerUPP (evh),
                                GetEventTypeCount(evtmask),
                                evtmask,
                                contH,
                                NULL);
                                
*/
    return;
}

void PIWindowQuartz::RemoveEventHandler(PIEventHandler* evh)
{
    RemoveEventHandler(evh);
    return;
}

// En public, pour permettre l'acces depuis call-back Xt
void PIWindowQuartz::CallDrawHandlers(int x0, int y0, int dx, int dy)
{
    return;
}

void PIWindowQuartz::CallEventHandlers(unsigned long evt, int px, int py,
                                    int k, int km, unsigned long tm)
{
    return;
}

