/*
 *  pistdwdgmosx.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on 24/08/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#include "pistdwdgquartz.h"

vector<PIWdg*> vpiwdg;

static void CommonControlActionCallback (ControlRef theControl, ControlPartCode partCode);

static void CommonControlActionCallback (ControlRef theControl, ControlPartCode partCode)
{
	vector<PIWdg*>::iterator it;
	for(it = vpiwdg.begin(); it != vpiwdg.end(); it++)
        {
			printf ("click : %d \n",(int)(*it)->Msg());
            if (((*it)->GetHIViewRef()) == theControl)
            {
				printf ("Valid : %d \n",(int)(*it)->Msg());
				(*it)->Send((*it)->Msg(), PIMsg_Click, NULL);
                break;
            }
        }
	return;
}

/* ========== PILabelQuartz ========== */

/* --Methode-- */
PILabelQuartz::PILabelQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	WindowRef wParent;
	
	string sNom(nom);
	wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,nom,kCFStringEncodingMacRoman);
	err = CreateStaticTextControl (wParent, &wdgRect, cfsrLabel, NULL, &viewH);
}

/* --Methode-- */
PILabelQuartz::~PILabelQuartz()
{
}

/* --Methode-- */
void PILabelQuartz::SetLabel(string const& sLabel)
{
	OSStatus err;
	
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,sLabel.c_str(),kCFStringEncodingMacRoman);
	// SetPortWindowPort(wParent);

	err = SetControlData (viewH,0,kControlEditTextCFStringTag,sizeof(cfsrLabel),(Ptr)&cfsrLabel);

	return;
}


/* ========== PITextQuartz ========== */

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
    SetRect(&wdgRect,px,py,px+sx,py+sy);
}

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PITextQuartz::~PITextQuartz()
{
}

/* --Methode-- */
void PITextQuartz::SetText(string const& s)
{	
	OSStatus err;
	WindowRef wParent = ((PIContainer *)Parent())->GetWindowRef();

	unicodeText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);
	err = CreateEditUnicodeTextControl (wParent,&wdgRect,unicodeText,false,NULL,&viewH);

	return;
}

/* --Methode-- */
string PITextQuartz::GetText() const
{
	CFStringRef str;
	char* cText;

	GetControlData(viewH, kControlEditTextPart, kControlEditTextCFStringTag, sizeof(str),&str,NULL);
	
	cText = (char *)CFStringGetCStringPtr(str,kCFStringEncodingMacRoman);	
	string sText(cText);	
	return (sText);
}

/* --Methode-- */
void PITextQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PITextQuartz::SetTextEditable(bool te)
{
	if (te == false)
		DeactivateControl (viewH);

	return;
}

/* --Methode-- */
void PITextQuartz::SetMsg(PIMessage msg)
{
}


/* ========== PIHITextViewQuartz ========== */

/* --Methode-- */
PIHITextViewQuartz::PIHITextViewQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	HIRect	hiRect; // = { { 0, 0 }, { 100, 100 } };
	int ox,oy,fx,fy;
	int mx,my;
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	mx = sx/50;
	my = sy/50; 
	ox = px+mx;
	oy = py+my;
	fx = px+sx-mx;
	fy = py+sy-my;
    SetRect(&wdgRect,px,py,px+sx,py+sy);

	SetRect(&userPaneRect,ox,oy,fx,fy);
	hiRect.origin.x = ox;
	hiRect.origin.y = oy;
	hiRect.size.width = fx-ox;
	hiRect.size.height = fy-oy;
	err = HITextViewCreate (&hiRect,0,0,&outTextView);
	err = CreateUserPaneControl (wParent, &userPaneRect,kControlSupportsEmbedding,&fUserPane);
	err = SetControlVisibility(fUserPane, true, true );
}

/* --Methode-- */
PIHITextViewQuartz::PIHITextViewQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PIHITextViewQuartz::~PIHITextViewQuartz()
{
}


/* --Methode-- */
void PIHITextViewQuartz::SetText(string const& s)
{	
	OSStatus err;
	CFStringRef cfsrText;
	
	cfsrText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);

	TXNObject txn = HITextViewGetTXNObject(outTextView);
	textLength = CFStringGetLength(cfsrText);
	uniChars = (UniChar*) malloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(cfsrText, CFRangeMake( 0, textLength ), uniChars );
	err = TXNSetData(txn,kTXNUnicodeTextData, uniChars, textLength * sizeof( UniChar ), 0, 0 );
	err = HIViewAddSubview (fUserPane, outTextView);
	HIViewPlaceInSuperviewAt (outTextView,10,10);
	ShowControl (fUserPane);
	err = HIViewSetVisible (outTextView, true);

	return;
}

/* --Methode-- */
string PIHITextViewQuartz::GetText() const
{
	CFStringRef str;
	char* cText;

	GetControlData(outTextView, kControlEditTextPart, kControlEditTextCFStringTag, sizeof(str),&str,NULL);
	cText = (char *)CFStringGetCStringPtr(str,kCFStringEncodingMacRoman);
	/*
	textLength = CFStringGetLength(str);
	uniChars = (UniChar*) realloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(str, CFRangeMake( 0, textLength ), uniChars );
	*/
	
	string sText(cText);	
	return (sText);
}


/* --Methode-- */
void PIHITextViewQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PIHITextViewQuartz::SetTextEditable(bool te)
{
	return;
}


/* --Methode-- */
void PIHITextViewQuartz::SetMsg(PIMessage msg)
{

}

/* ========== PIButtonQuartz ========== */

EventTypeSpec controlEvents[] = {{kEventClassControl, kEventControlHit}};

PIButtonQuartz::PIButtonQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIButtonGen(par,nom,msg,sx,sy,px,py)
{
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);

    CreatePushButtonControl (par->GetWindowRef(),&wdgRect,title,&viewH);
    SetControlTitleWithCFString (viewH, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (viewH, _actionProc);
	vpiwdg.push_back(this);
}


PIButtonQuartz::~PIButtonQuartz()
{
}

void PIButtonQuartz::ActivatePress(bool acp)
{
	return;
}	

void PIButtonQuartz::SetLabel(string const& sText)
{
    title = CFStringCreateWithCString (NULL, sText.c_str(), kCFStringEncodingMacRoman);
	SetControlTitleWithCFString(viewH,title);
	return;
}



/* ========== PICheckBoxQuartz ========== */

PICheckBoxQuartz::PICheckBoxQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg, int sx, int sy, int px, int py)
:PICheckBoxGen(par,nom,msg,sx,sy,px,py)
{
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    CreateCheckBoxControl (par->GetWindowRef(),&wdgRect,title,0,TRUE,&viewH);
    SetControlTitleWithCFString (viewH, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (viewH, _actionProc);
	_state = GetControl32BitValue (viewH);

	vpiwdg.push_back(this);
}


PICheckBoxQuartz::~PICheckBoxQuartz()
{
}

void PICheckBoxQuartz::SetState(bool acp)
{
	_state = acp;
	return;
}

bool PICheckBoxQuartz::GetState()
{
	_state = GetControl32BitValue (viewH);
	printf("GetState : %d ",_state);
	return _state;
}

/* ========== PIRadioQuartz ========== */

PIRadioQuartz::PIRadioQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py,
							int initialValue)
:PIWdg(par,nom,sx,sy,px,py)
{
	SetMsg(msg);
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    CreateRadioButtonControl (par->GetWindowRef(),&wdgRect,title,initialValue,FALSE,&viewH);
    SetControlTitleWithCFString (viewH, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (viewH, _actionProc);
	vpiwdg.push_back(this);
}

PIRadioQuartz::~PIRadioQuartz()
{
}

/* ========== PIRadioGroupQuartz ========== */

PIRadioGroupQuartz::PIRadioGroupQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIWdg(par,nom,sx,sy,px,py)
{
	SetMsg(msg);
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    OSErr error;
	error = CreateRadioGroupControl (par->GetWindowRef(),&wdgRect,&viewH);
	_state = 0;
}

void PIRadioGroupQuartz::AddRadioButton(PIRadio* piRadio)
{
	OSErr error;
	error = EmbedControl(piRadio->GetHIViewRef(),viewH);
		
	return;
}

PIRadioGroupQuartz::~PIRadioGroupQuartz()
{
}

