// Module PI : Peida Interactive     PIGraphicQuartz
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/IRFU (Saclay) / CEA

#include <stdio.h>
#include <math.h>

#include "sopnamsp.h"
#include "pigraphquartz.h"

/*  Variables globales pour modifier les GC  */
#define NMAXCOL  32
static  PIQuartzColor colpix[NMAXCOL];
static const EventTypeSpec  gqHIViewSpec[] = {kEventClassControl,kEventControlDraw };

OSStatus MyDrawEventHandler (EventHandlerCallRef myHandler,EventRef event, void *userData);

/* --Methode-- */
PIGraphicQuartz::PIGraphicQuartz(PIWdg* wdg)
: PIGraphicGen(wdg)
{
	OSStatus err;
	HIViewRef rootView;
    HIRect      bounds;
		
	rootView = wdg->GetHIViewRef();
	err = HIViewFindByID(rootView, kHIViewWindowContentID,&hiViewRef);
	HIViewGetBounds (rootView, &bounds);
	
	printf("View Bounds (%g %g) [%g %g] \n",bounds.origin.x,bounds.origin.y,
											bounds.size.width,bounds.size.height);

	err = InstallEventHandler (GetControlEventTarget (hiViewRef),
                            NewEventHandlerUPP (MyDrawEventHandler),
                            GetEventTypeCount (gqHIViewSpec),
                            (const EventTypeSpec*)&gqHIViewSpec,
                            (void *) cgContext,
                            NULL);
	cgWindow =  HIViewGetWindow(rootView);
	ShowWindow(cgWindow);
	SetPortWindowPort(cgWindow);
	QDBeginCGContext (GetWindowPort (cgWindow), &cgContext);
	CGContextFlush(cgContext);
}

/* --Methode-- */
PIGraphicQuartz::PIGraphicQuartz(PIScreenBuffer* grb)
: PIGraphicGen(grb)
{

}


/* --Methode-- */
PIGraphicQuartz::~PIGraphicQuartz()
{
	QDEndCGContext (GetWindowPort(cgWindow), &cgContext);
}

/* --Methode-- */
int PIGraphicQuartz::kind()
{
if (myWdg != NULL) return (PI_ScrWindowGraphics);
else if (myGrb != NULL) return (PI_ScrBufferGraphics);
else return(PI_UnknownGraphics);
}

/* --Methode-- */
void PIGraphicQuartz::TerminateInit()
{
// if (MyWdg() == NULL)  { fprintf(stderr, "BUG/PIGraphicQuartz::TerminateInit() for NULL Wdg \n"); return; }
}

/* --Methode-- */
void PIGraphicQuartz::Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
	CGPoint pt;
	CGSize sz;
	CGRect cgRect;
	pt.x = x0; 	pt.y = y0;
	sz.width = (int)dx ; sz.height = (int)dy ;
	cgRect.origin = pt;
	cgRect.size = sz;
	CGContextClearRect(cgContext, cgRect);
	CGContextFlush(cgContext);
	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos)
{
	CGPoint cgPt;
	int dx, dy, xi, yi;
	float xpos, ypos;
	xi = x;  yi = y;
	xpos = x; ypos = y;
	bool fgcsps = CalcStringPositionShift(s, pos, dx, dy);
	unsigned long txtdir = pos&PI_TextDirection;
	if (txtdir == PI_TextDirectionHorizontal) 
	{
	if (fgcsps) { xi -= dx;  yi -= dy; }
//  XDrawString (mDisp, mWId, DefGC(), xi, yi, s, strlen(s));
	}
	else 
	{ 
		if (txtdir == PI_TextDirectionVerticalDown) 
		{ xi += dy; yi -= dx; }
		else 
		{ xi -= dy; yi += dx; }
  //DrawVerticalString(xi, yi, s, txtdir, false);
	}

    CGAffineTransform myTextTransform;
	CGContextSelectFont(cgContext, "Times-Bold", 10.0, kCGEncodingMacRoman);
	CGContextSetCharacterSpacing (cgContext, 2);
	CGContextSetTextDrawingMode (cgContext, kCGTextFill);

    CGContextSetRGBFillColor (cgContext, 0, 1, 0, .5);// 6
    CGContextSetRGBStrokeColor (cgContext, 0, 0, 1, 1);//
	myTextTransform =  CGAffineTransformMakeRotation  (0.);// 8
    CGContextSetTextMatrix (cgContext, myTextTransform);

	CGContextShowTextAtPoint (cgContext, xpos, ypos, s, strlen(s));
	cgPt = CGContextGetTextPosition (cgContext);
	CGContextFlush(cgContext);

	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos)
{
int dx, dy, xi, yi;
xi = x;  yi = y;
bool fgcsps = CalcStringPositionShift(s, pos, dx, dy);
unsigned long txtdir = pos&PI_TextDirection;
if (txtdir == PI_TextDirectionHorizontal) {
  if (fgcsps) { xi -= dx;  yi -= dy; }
//  XDrawImageString (mDisp, mWId, DefGC(), xi, yi, s, strlen(s));
}
else { 
  if (txtdir == PI_TextDirectionVerticalDown) { xi += dy; yi -= dx; }
  else {   xi -= dy; yi += dx; }
  // DrawVerticalString(xi, yi, s, txtdir, true);
}
return;
}

 
/* --Methode-- */
void PIGraphicQuartz::DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
{
	float xf, yf;

	CGContextBeginPath(cgContext);
	xf = x1; yf = y1;
	CGContextMoveToPoint (cgContext, xf, yf);
	xf = x2; yf = y2;	
	CGContextAddLineToPoint (cgContext, xf, yf);
	CGContextSetLineWidth (cgContext, 2);
	CGContextStrokePath (cgContext);
	CGContextClosePath (cgContext);
	CGContextFlush(cgContext);

	return;
}


/* --Methode-- */
void PIGraphicQuartz::DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
	int ix0 = x0;
	int iy0 = y0;
	int idx = dx;
	int idy = dy;
	if (idx < 0)  { ix0 += idx;  idx = -idx; }
	if (idy < 0)  { iy0 += idy;  idy = -idy; }
	CGContextAddRect (cgContext, CGRectMake (ix0, iy0, idx, idy));
	CGContextFlush(cgContext);

	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
	int ix0 = x0;
	int iy0 = y0;
	int idx = dx;
	int idy = dy;
	if (idx < 0)  { ix0 += idx;  idx = -idx; }
	if (idy < 0)  { iy0 += idy;  idy = -idy; }
	CGContextFillRect (cgContext, CGRectMake (ix0, iy0, idx, idy));
	CGContextFlush(cgContext);

	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)
{
	DrawArc(x0, y0, r, r, 0, 360);
	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)
{
	DrawFArc(x0, y0, r, r, 0, 360);
	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
/*
XDrawArc(mDisp, mWId, DefGC(),
         (int)x0-(int)dx, (int)y0-(int)dy, (int)dx*2, (int)dy*2, 0, 360*64);
		 */
return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
/*
XFillArc(mDisp, mWId, DefGC(),
         (int)x0-(int)dx, (int)y0-(int)dy, (int)dx*2, (int)dy*2, 0, 360*64);
		 */
return;
}

// Pour les fonctions de trace avec un plusieurs coordonnees
#define NMXXPOINTS  128 

/* --Methode-- */
void PIGraphicQuartz::DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc)
{
	int i;
	CGPoint* points;

	if (n <= 0)  return;
	points = new CGPoint[n];
	for (i = 0; i < n ; i++)
	{
		points[i].x = x[i];
		points[i].y = y[i];
	}
	CGContextBeginPath (cgContext);
	CGContextAddLines(cgContext, points, n);
	
	CGContextClosePath(cgContext);
	CGContextStrokePath(cgContext);
	CGContextFlush(cgContext);

	delete[] points;
	return;
}


/* --Methode-- */
void PIGraphicQuartz::DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc)
{
	int i;
	CGPoint* points;

	if (n <= 0)  return;
	points = new CGPoint[n];
	for (i = 0; i < n ; i++)
	{
		points[i].x = x[i];
		points[i].y = y[i];
	}
	CGContextBeginPath (cgContext);
	CGContextAddLines(cgContext, points, n);
	
	CGContextClosePath(cgContext);
	CGContextFillPath(cgContext);
	CGContextFlush(cgContext);

	delete[] points;
	return;
}


/* --Methode-- */
void PIGraphicQuartz::DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                         double degdeb, double deltadeg)
{
	float xd, yd, xf, yf, radius, startAngle, endAngle;
	xd = (int)x0;
	yd = (int)y0;
	xf = (int)x0 + (int)dx;
	yf = (int)y0 + (int)dy;
	radius = sqrtf((int)dx*(int)dx + (int)dy*(int)dy);
	startAngle = 2 * 3.14 * degdeb / (360.);
	endAngle = startAngle + 2 * 3.14 * deltadeg / (360.);

	CGContextMoveToPoint (cgContext, xd, yd);
	CGContextBeginPath(cgContext);
	CGContextAddArc (cgContext, xf, yf, radius, startAngle, endAngle, 0);
	CGContextStrokePath(cgContext);
	CGContextClosePath(cgContext);
	CGContextFlush(cgContext);

	return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                         double degdeb, double deltadeg)
{
	float xd, yd, xf, yf, radius, startAngle, endAngle;
	xd = (int)x0;
	yd = (int)y0;
	xf = (int)x0 + (int)dx;
	yf = (int)y0 + (int)dy;
	radius = sqrtf((int)dx*(int)dx + (int)dy*(int)dy);
	startAngle = 2 * 3.14 * degdeb / (360.);
	endAngle = startAngle + 2 * 3.14 * deltadeg / (360.);

	CGContextBeginPath(cgContext);
	CGContextMoveToPoint (cgContext, xd, yd);
	CGContextAddArc (cgContext, xf, yf, radius, startAngle, endAngle, 0);
	CGContextClosePath(cgContext);
	CGContextFillPath(cgContext);
	CGContextFlush(cgContext);
	return;
}

// Coordonnees pour tracer une etoile a 5 branches 
// static float starcoordx[10], starcoordy[10];

/* --Methode-- */
void PIGraphicQuartz::DrawMarker(PIGrCoord x0, PIGrCoord y0)
{

/*
if (mMrk == PI_DotMarker) {
  XDrawPoint(mDisp, mWId, DefGC(), (int)x0, (int)y0);
  return;
}
else  {
  int x1,x2,y1,y2,r;
  float hmsz = mMrkSz/2;
  float dmsz = mMrkSz-hmsz;
  XPoint pxp[12];
  int k;
  bool fgcgc = SetupMrkGC();
  switch (mMrk) {
    case  PI_PlusMarker :
      x1 = (float)x0-hmsz;   y1 = y0;
      x2 = (float)x0+dmsz;   y2 = y1;
      XDrawLine(mDisp, mWId, mMrkGC, x1, y1, x2, y2);
      x1 = x0;  y1 = (float)y0-hmsz;
      x2 = x1;  y2 = (float)y0+dmsz;
      XDrawLine(mDisp, mWId, mMrkGC, x1, y1, x2, y2);
      break;
    case  PI_CrossMarker :
      x1 = (float)x0-hmsz;   y1 = (float)y0-hmsz;
      x2 = (float)x0+dmsz;   y2 = (float)y0+dmsz;
      XDrawLine(mDisp, mWId, mMrkGC, x1, y1, x2, y2);
      XDrawLine(mDisp, mWId, mMrkGC, x1, y2, x2, y1);
      break;  
    case PI_CircleMarker :
    case PI_FCircleMarker :
      r = hmsz;
      x1 = (int)x0-r;  y1 = (int)y0-r;
      if (mMrk == PI_CircleMarker) 
	XDrawArc(mDisp, mWId, mMrkGC, x1, y1, 2*r, 2*r, 0, 360*64);
      else XFillArc(mDisp, mWId, mMrkGC, x1, y1, 2*r, 2*r, 0, 360*64);
      break;
    case PI_BoxMarker :
    case PI_FBoxMarker :
      pxp[0].x = (int)x0-hmsz;  pxp[0].y = (int)y0-hmsz;
      pxp[1].x = (int)x0+hmsz;  pxp[1].y = (int)y0-hmsz;
      pxp[2].x = (int)x0+hmsz;  pxp[2].y = (int)y0+hmsz;
      pxp[3].x = (int)x0-hmsz;  pxp[3].y = (int)y0+hmsz;
      pxp[4].x = (int)x0-hmsz;  pxp[4].y = (int)y0-hmsz;
      if (mMrk == PI_BoxMarker) MrkDrawPolygon(pxp, 5, false);
      else MrkDrawFPolygon(pxp, 5, false);
      break;
    case  PI_TriangleMarker :
    case  PI_FTriangleMarker :
      pxp[1].x = mMrkSz; pxp[1].y = 0; pxp[2].x = -hmsz; pxp[2].y = -mMrkSz;
      pxp[3].x = -dmsz;  pxp[3].y = +mMrkSz; pxp[0].x = (float)x0-hmsz; pxp[0].y = (float)y0+hmsz;
      if (mMrk == PI_TriangleMarker) MrkDrawPolygon(pxp, 4, true);
      else MrkDrawFPolygon(pxp, 4, true);
      break;
    case  PI_StarMarker :
    case  PI_FStarMarker :
      for(k=0; k<10; k++) {
        pxp[k].x = (int)(starcoordx[k]*hmsz+(float)x0+0.5);
        pxp[k].y = (int)(starcoordy[k]*hmsz+(float)y0+0.5);
        }
      pxp[10].x = pxp[0].x;   pxp[10].y = pxp[0].y;
      if (mMrk == PI_StarMarker)   MrkDrawPolygon(pxp, 11, false);
      else  MrkDrawFPolygon(pxp, 11, false);
      break;
    default :
      XDrawPoint(mDisp, mWId, DefGC(), x0, y0);
      break;
    }
  if (fgcgc) mFgMrkGCOK = false;
  }
*/
return;
}

/* --Methode-- */
void PIGraphicQuartz::DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)
{
/*
int i;
if (n <= 0)  return;

if (mMrk == PI_DotMarker)
  {
  XPoint multipoint[NMXXPOINTS];
  XPoint *pxp;
  if (n > NMXXPOINTS)  pxp = new XPoint[n];
  else pxp = multipoint;
  for(i=0; i<n; i++)  { pxp[i].x = x[i];  pxp[i].y = y[i]; } 
  XDrawPoints(mDisp, mWId, DefGC(), pxp, n, CoordModeOrigin);
  if (n > NMXXPOINTS)  delete[] pxp;  
  }
else { 
  SetupMrkGC();
  for(i=0; i<n; i++) DrawMarker(x[i], y[i]);
  mFgMrkGCOK = false;
}
*/
return;
}


/* --Methode-- */
void PIGraphicQuartz::DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                            int sx, int sy, PIColorMap* cmap)
{
/*
Window xw;
Display * mdsp;
int scr;
int depth;
int pad;
int i,j;
XImage * ximg;

if ( (sx < 1) || (sy < 1) )  return;
if ((pix == NULL) || (cmap == NULL)) return; 

  
xw = mWId;
mdsp = PIXDisplay();
scr = PIXScreen();

depth = DefaultDepth(mdsp,scr);
pad = (depth > 8) ? 32 : 8;
ximg = XCreateImage (mdsp,DefaultVisual(mdsp,scr),
                     depth,ZPixmap,0,NULL, sx, sy, pad,0);
if (ximg == NULL)  return;
ximg->data = new char [sy*ximg->bytes_per_line];
if (ximg->data == NULL)  
  { XFree(ximg); return; }

for(j=0; j<sy; j++)
  for(i=0; i<sx; i++)
    { XPutPixel(ximg, i, j, cmap->Color(*pix) );  pix++; }

XPutImage(mdsp, xw, DefGC(), ximg, 0, 0, (int)x, (int)y, sx, sy);

delete[] ximg->data;
XFree(ximg);
*/
return;
}

/* --Methode-- */
/*
bool PIGraphicQuartz::SetupMrkGC()
{
if (mFgMrkGCOK) return(false);

XCopyGC(mDisp, DefGC(), GCFunction|GCForeground|GCBackground|GCPlaneMask, mMrkGC); 
XSetLineAttributes(mDisp, mMrkGC, 1, LineSolid, CapButt, JoinMiter);

mFgMrkGCOK = true;
return true;
}
*/

/* --Methode-- */
/*
void PIGraphicQuartz::MrkDrawPolygon(XPoint *pxp, int n, bool cinc)
{

if (n <= 0)  return;
int mode = CoordModeOrigin;
if (cinc) mode =  CoordModePrevious;
XDrawLines(mDisp, mWId, mMrkGC, pxp, n, mode);

return;
}
*/

/* --Methode-- */
/*
void PIGraphicQuartz::MrkDrawFPolygon(XPoint *pxp, int n, bool cinc)
{
int mode = CoordModeOrigin;
if (cinc) mode =  CoordModePrevious;
XFillPolygon(mDisp, mWId, mMrkGC, pxp, n, 
                        Complex, mode);
return;
}
*/


/* --Methode-- */
void PIGraphicQuartz::DrawVerticalString(int x, int y, const char* s, unsigned long pos, bool imgs)
{
/*
  int fh, fasc, fdes;
  fh = GetFont().GetFontHeight(fasc, fdes); 
  int sw = GetFont().GetStringWidth(s);

  Display * dsx = mDisp;
  Window rw = DefaultRootWindow(dsx);
  Pixmap pxm = XCreatePixmap(dsx, rw, sw, fh, 1 );

  XGCValues  xgv;
  xgv.function = GXcopy;
  xgv.plane_mask = ~0;
  GC gcbm = XCreateGC (dsx, pxm, GCFunction | GCPlaneMask, &xgv);
  XSetForeground(dsx, gcbm, ~0); 
  XSetBackground(dsx, gcbm, 0);
  XSetFont(mDisp, gcbm, myFont.GetXFontId());
  
  XDrawImageString (dsx, pxm, gcbm, 0, fasc, s, strlen(s));
  XImage* ximg = XGetImage(dsx, pxm, 0, 0, sw, fh, 0xFFFFFFFF, ZPixmap);

  Pixmap pxm2 = XCreatePixmap(dsx, rw, fh, sw, 1 );
  XImage* ximg2 =  XGetImage(dsx, pxm2, 0, 0, fh, sw, 0xFFFFFFFF, ZPixmap);
  //  On recopie de ximg -> ximg2 en echangeant x,y
  int i,j;
  bool fgdown = ((pos&PI_TextDirection) == PI_TextDirectionVerticalDown);
  if (fgdown) {
    for(i=0; i<sw; i++)
      for(j=0; j<fh; j++)
	XPutPixel(ximg2, fh-j-1, i, XGetPixel(ximg, i, j));
  }
  else {
    for(i=0; i<sw; i++)
      for(j=0; j<fh; j++)
	XPutPixel(ximg2, j, sw-i-1, XGetPixel(ximg, i, j));
  }
  XPutImage(dsx, pxm2, gcbm, ximg2, 0, 0, 0, 0, fh, sw);
  GC gcvis;
  GC gcvs = XCreateGC (dsx, mWId, GCFunction | GCPlaneMask, &xgv);
  XCopyGC(dsx, DefGC(), ~0, gcvs); 
  XSetStipple(dsx, gcvs, pxm2);
  XSetFillStyle(dsx, gcvs, FillStippled);
  if (imgs) {
    gcvis = XCreateGC (dsx, mWId, GCFunction | GCPlaneMask, &xgv);
    XCopyGC(dsx, DefGC(), ~0, gcvis); 
    if (mBCol == PI_ColorFromMap)  XSetForeground(mDisp, gcvis, mBCfMap);
    else  XSetForeground(mDisp, gcvis, colpix[mBCol]); 
  }
  if (fgdown) {
    XSetTSOrigin(dsx, gcvs, x-fdes, y);
    if (imgs)  XFillRectangle(dsx, mWId, gcvis, x-fdes, y, fh, sw);
    XFillRectangle(dsx, mWId, gcvs, x-fdes, y, fh, sw);
  }
  else {
    XSetTSOrigin(dsx, gcvs, x-fasc, y-sw);
    if (imgs) XFillRectangle(dsx, mWId, gcvis, x-fasc, y-sw, fh, sw);
    XFillRectangle(dsx, mWId, gcvs, x-fasc, y-sw, fh, sw);
  }
  // Cleaning  
  XDestroyImage(ximg);
  XDestroyImage(ximg2);
  XFreeGC(dsx, gcbm);
  XFreeGC(dsx, gcvs);
  if (imgs) XFreeGC(dsx, gcvis);
  XFreePixmap(dsx, pxm);			     
  XFreePixmap(dsx, pxm2);			     
*/
}


/* --Methode-- */
void PIGraphicQuartz::SelForeground(PIColors col)
{
	if (myLockFCol)  return;
	if (col == mFCol)  return;
	if ( (col < 0) || (col >= NMAXCOL))  return;
	// XSetForeground(mDisp, DefGC(), colpix[col]);
	if (col == PI_Green)
	{
		CGContextSetRGBFillColor (cgContext, 0, 1, 0, 1);
		CGContextSetRGBStrokeColor (cgContext, 0, 1, 0, 1);
	}
	else if (col == PI_Blue)
	{
		CGContextSetRGBFillColor (cgContext, 0, 0, 1, 1);	
		CGContextSetRGBStrokeColor (cgContext, 0, 0, 1, 1);
	}
	else if (col == PI_Red)
	{
		CGContextSetRGBFillColor (cgContext, 1, 0, 0, 1);	
		CGContextSetRGBStrokeColor (cgContext, 1, 0, 0, 1);
	}
	else
	{
		CGContextSetRGBFillColor (cgContext, 0, 0, 0, 1);	
		CGContextSetRGBStrokeColor (cgContext, 0, 0, 0, 1);
	}

	mFCol = col;  
	return;
}

/* --Methode-- */
void PIGraphicQuartz::SelBackground(PIColors col)
{
if (col == mBCol)  return;
if ( (col < 0) || (col >= NMAXCOL))  return;
// XSetBackground(mDisp, DefGC(), colpix[col]); 
mBCol = col;  
return;
}

/* --Methode-- */
void PIGraphicQuartz::SelForeground(PIColorMap& cmap, int cid)
{
if (myLockFCol)  return;
// SelectFCol(cmap.Color(cid));
}

/* --Methode-- */
void PIGraphicQuartz::SelBackground(PIColorMap& cmap, int cid)
{
// SelectBCol(cmap.Color(cid));
}

/* --Methode-- */
void PIGraphicQuartz::SelGOMode(PIGOMode mod)
{
if (mod == mGOm)  return;
switch (mod)
  {
  case PI_GOCopy :
   // XSetFunction(mDisp, DefGC(), GXcopy);
    mGOm = mod;
    break;
  case PI_GOXOR :
    // XSetFunction(mDisp, DefGC(), GXxor);
    mGOm = mod;
    break;
  case PI_GOInvert :
    // XSetFunction(mDisp, DefGC(), GXinvert);
    mGOm = mod;
    break;
  }
return;
}


/* --Methode-- */
void PIGraphicQuartz::SelFont(PIFont & fnt)
{
if (myFont == fnt)  return;
myFont = fnt;
// XSetFont(mDisp, DefGC(), myFont.GetXFontId());
}

/* --Methode-- */
void PIGraphicQuartz::SelFont(PIFontSize sz, PIFontAtt att)
{
PIFont fnt(myFont.GetFontName());
fnt.SetFontAtt(att);
fnt.SetFontSz(sz);
SelFont(fnt);
}

/* --Methode-- */
void PIGraphicQuartz::SelFontSzPt(int npt, PIFontAtt att)
{
PIFont fnt(npt, myFont.GetFontName(), att);
SelFont(fnt);
}



/* --Methode-- */
void PIGraphicQuartz::SelLine(PILineAtt const& att)
{

if (att == mLAtt)  return;

/*
unsigned int lw = att.GetLineWidth();
int lstyle=LineSolid;
int dashlen = 2;
char dash[4]= {3,3,3,3};   

switch (att.GetLineDash()) {
  case PI_LineSolid :
    lstyle = LineSolid;
     break;
  case PI_LineDashed :
    lstyle = LineOnOffDash;
    dash[0] = dash[1] = 6;     
    dashlen = 2;
    break;
  case PI_LineDotted :
    lstyle = LineOnOffDash;
    dash[0] = 2; dash[1] = 6;  
    dashlen = 2;
    break;
  case PI_LineDashDotted :
    lstyle = LineOnOffDash;
    dash[0] = 2; dash[1] = 2;  
    dash[2] = 4; dash[3] = 6;  
    dashlen = 4;
    break;
  default :
    lstyle = LineSolid;
    break;
  }
if (lstyle != LineSolid) 
  XSetDashes( mDisp, DefGC(), 0, dash, dashlen);


int ljoin = JoinMiter;
switch (att.GetLineJoin()) {
 case PI_JoinMiter :
   ljoin = JoinMiter;
   break;
 case PI_JoinRound :
   ljoin = JoinRound;
   break;
 case PI_JoinBevel :
   ljoin = JoinBevel;
   break;
 default :
   ljoin = JoinMiter;
   break;
}

int lcap = CapButt;
switch (att.GetLineCap()) {
 case PI_CapButt :
   lcap = CapButt;
   break;
 case PI_CapRound :
   lcap = CapRound;
   break;
 case PI_CapProjecting :
   lcap = CapProjecting;
   break;
 default :
   lcap = CapButt;
   break;
}

XSetLineAttributes(mDisp, DefGC(), lw, lstyle, lcap, ljoin);
*/
mLAtt = att;
return;
}


/* --Methode-- */
void PIGraphicQuartz::SelMarker(int msz, PIMarker mrk)
{
if (msz > 1)  { mMrk = mrk;  mMrkSz = msz; }
else  { mMrk = PI_DotMarker;  mMrkSz = 1; }
return;
}


/* --Methode-- */
void PIGraphicQuartz::SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
	CGPoint pt;
	CGSize sz;
	CGRect cgRect;
	pt.x = x0; 	pt.y = y0;
	sz.width = (int)dx ; sz.height = (int)dy ;
	cgRect.origin = pt;
	cgRect.size = sz;
	CGContextBeginPath(cgContext);
	CGContextAddRect(cgContext, cgRect);

	CGContextClosePath (cgContext);
	CGContextClip(cgContext);
	CGContextFlush(cgContext);	
	return;
}

/* --Methode-- */
void PIGraphicQuartz::ClearClipRectangle()
{
/* 
XSetClipMask(mDisp, DefGC(), None);
XSetClipMask(mDisp, mMrkGC, None);
*/
return;
}

/* --Methode-- */
PIColors  PIGraphicQuartz::GetForeground() 
{
return (mFCol);
}

/* --Methode-- */
PIColors  PIGraphicQuartz::GetBackground() 
{
return (mBCol);
}


/* --Methode-- */
PIGOMode   PIGraphicQuartz::GetGOMode()
{
return (mGOm);
}

/* --Methode-- */
PIFontAtt  PIGraphicQuartz::GetFontAtt()
{
return (mFAtt);
}

/* --Methode-- */
int        PIGraphicQuartz::GetFontSize()
{
return (mFSize);
}

/* --Methode-- */
PILineAtt  PIGraphicQuartz::GetLineAtt()
{
return (mLAtt);
}

/* --Methode-- */
PIMarker   PIGraphicQuartz::GetMarker()
{
return (mMrk);
}

/* --Methode-- */
int        PIGraphicQuartz::GetMarkerSize()
{
return (mMrkSz);
}


/* --Methode-- */
void PIGraphicQuartz::SaveGraphicAtt()
{  
// Pour optimier l'implementation de PIBaseWdgGen
sFCol = mFCol;    sBCol = mBCol;
sGOm = mGOm;
sFont = myFont;   
sMrk = mMrk;   sMrkSz = mMrkSz;
sFCfMap = mFCfMap; sBCfMap = mBCfMap; 
return;
}

/* --Methode-- */
void PIGraphicQuartz::RestoreGraphicAtt()
{
/*
  if (sFCol != PI_ColorFromMap) SelForeground(sFCol);
  else SelectFCol(sFCfMap);
  if (sBCol != PI_ColorFromMap) SelBackground(sBCol);
  else SelectBCol(sBCfMap);
  */
  SelGOMode(sGOm);
  SelFont(sFont);
  SelLine(sLAtt);
  SelMarker(sMrkSz, sMrk);
  return;
}


/* --Methode-- */
unsigned long PIGraphicQuartz::GetPixelValueforColor(PIColors col)
{
if ( (col < 0) || (col >= NMAXCOL))  return(0);
// GlInit();
return(colpix[col]); 
}


/* Methode Generale */
OSStatus MyDrawEventHandler (EventHandlerCallRef myHandler, EventRef event, void *userData)
{
	OSStatus status = noErr;
 
    status = GetEventParameter (event, // 1
                            kEventParamCGContextRef,
                            typeCGContextRef,
                            NULL,
                            sizeof (CGContextRef),
                            NULL,
                            &userData);
    return status;
}
