/*
 *  PIMenuBarQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Fri May 28 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */
 
#include "PIMenuBarQuartz.h"
#include PIAPP_H

static PIMenubar* MainMenuBar;

PIMenuBarQuartz::PIMenuBarQuartz(PIApplicationGen* par, const char* nom)
: PIMenubarGen(par, nom)
{
    EventTypeSpec menuEvent = {kEventClassCommand, kEventCommandProcess};
    
    DrawMenuBar();
    InstallApplicationEventHandler(NewEventHandlerUPP(MenuEventHandler),1,&menuEvent,0,NULL);
    MainMenuBar = this;
	piApp = par;
}

PIMenuBarQuartz::~PIMenuBarQuartz()
{
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuBarQuartz::AppendMenu(PIMenu *pdm)
{
    InsertMenu (pdm->GetMenuRef(),0);
    vPIMenu.push_back(pdm);
    return;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuBarQuartz::AppendPopupMenu(PIMenu *pdm)
{
	InsertMenu (pdm->GetMenuRef(),kInsertHierarchicalMenu);
	vPIMenu.push_back(pdm);
	return;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuBarQuartz::RemoveMenu(PIMenu *pdm)
{
    vector<PIMenu*>::iterator it;

    for(it = vPIMenu.begin(); it != vPIMenu.end(); it++)
        {
            if ((*it)->GetMenuID()==(pdm->GetMenuID()))
            {
                vPIMenu.erase(it);
                break;
            }
        }
		
    DeleteMenu (pdm->GetMenuID());
    return;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuBarQuartz::SetSensitivity(PIMenu *pdm, bool sens)
{
    // Not relevant in Carbon/MACOSX
    return;
}

/* ----------------------------- Methode ------------------------------- */
bool PIMenuBarQuartz::IsSensitive(PIMenu *pdm)
{
    // Not relevant in Carbon/MACOSX
    return true;
}

/* ----------------------------- Methode ------------------------------- */
PIMessage PIMenuBarQuartz::GetMsg(HICommand commandStruct)
{
	MenuRef menuRef = commandStruct.menu.menuRef;
	UInt32 commandID = commandStruct.commandID;
	UInt16 itemIndex = commandStruct.menu.menuItemIndex;
	
    vector<PIMenu*>::iterator it;
    for(it = vPIMenu.begin(); it != vPIMenu.end(); it++)
        {
           if ((*it)->GetMenuRef() == menuRef)
            {
				if ((*it)->MType() == k_PopupMenu)
				{
					PIWdg* piWdg;
					ControlRef contH;
					piWdg = (*it)->GetParent();
					contH = piWdg->GetHIViewRef();
//					printf("PopValue : %d \n", GetControl32BitValue(contH));
					SetControl32BitValue(contH, itemIndex);
				}
                return (*it)->GetMsgItem(commandID);
            }
        }
	return 0;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuBarQuartz::Dispatch(HICommand commandStruct, void* userData)
{
	PIMessage msg;
	
	msg = GetMsg(commandStruct);
	Process(BuildMsg(msg,PIMsg_Click), piApp, userData);
		
	return;
}

/* ========== Common Handler for Menu Events ========== */
OSStatus MenuEventHandler (EventHandlerCallRef myHandler, EventRef event, void* userData)
{
    OSStatus result = eventNotHandledErr;
    HICommand commandStruct; 
    short itemHit;

    GetEventParameter (event, kEventParamDirectObject, 
                        typeHICommand, NULL, sizeof(HICommand), 
                        NULL, &commandStruct);
    
    if ((commandStruct.commandID) == kHICommandAbout)
    {
        /*        RunStandardAlert (aboutBox, NULL, &itemIndex);*/
        StandardAlert (kAlertStopAlert, 
                        "\pQuartz Test",
                        "\pPeida Interactive based",
                        NULL,
                        &itemHit);

        result = noErr;
    }
    else if ((commandStruct.commandID) == kHICommandQuit)
    {
        ExitToShell ();
        result = noErr;
    }
    else
    {
		printf("Menu Item selected %u \n", commandStruct.commandID);
		fflush (stdout);		
		MainMenuBar->Dispatch(commandStruct, userData);
		result = noErr;
    }
    return (result);
}

