/*
    QuartzAppTest.cpp
    BMX 14/06/06
    Test Program for PI4Mac validation    
*/

#include <PIApplQuartz.h>
#include <PIMenuBarQuartz.h>
#include <PIWindowQuartz.h>
#include <pioptmenuquartz.h>
#include <pistdwdgquartz.h>
#include <pigraphquartz.h>
#include <iostream>

#define NBCOTE 7

void FillDatas();

PIGraphicWin* pig;
PIGrCoord* tabx;
PIGrCoord* taby;

/* ============================== */
class QuartzApp : public PIApplication
{
public:
	QuartzApp();
	~QuartzApp();
	virtual void Process (PIMessage msg, PIMsgHandler* sender, void * data = NULL);
};

/* ============================== */
QuartzApp::QuartzApp()
: PIApplication()
{
}

/* ============================== */
QuartzApp::~QuartzApp()
{
}

/* ============================== */

void QuartzApp::Process (PIMessage msg, PIMsgHandler* sender, void * data)
{
  switch(UserMsg(msg))    
	{	
		case 777:
		std::cout << " Erase " << std::endl;
		pig->Erase(280,60,100,50);
		break;

		case 2001:
		std::cout << " Circle " << std::endl;
		pig->DrawCircle(360,100,30);
		break;
		
		case 2002:
		std::cout << " Polygone " << std::endl;
		pig->DrawPolygon(tabx, taby, NBCOTE, 0);
		break;
		
		case 3001:
		std::cout << " Pop 1 " << std::endl;
		break;
	
		case 3002:
		std::cout << " Pop 2 " << std::endl;
		break;
		
		default:
		std::cout << " msg : "<< UserMsg(msg) << std::endl;
		break;
	}

	return;
}


/* ============================== */
int main(int argc, char *argv[])
{
    QuartzApp* mainApp;
    PIMenu* firstMenu;
    PIMenu* underMenu;
	PIMenu* popMenu;
	PIMenu* figuresMenu;
	PIOptMenu* optMenu;  
    PIMenubar* mBar;
    PIWindow* windowFirst;	
	PILabel *piLabel;
    PIButton* piButton;
    vector<int> points;

    /* Creation of general graphical objects */

    mainApp = new QuartzApp();

    firstMenu = new PIMenu((PIWdg *)mainApp, (const char *)"File Menu");
    firstMenu->AppendItem("One from file", 1000);
    firstMenu->AppendSeparator();
    firstMenu->AppendItem("Two from file", 1001);
    firstMenu->AppendCheckItem("Check from file", 1002);
    firstMenu->AppendItem("Quitter ", 1003);
	
	underMenu = new PIMenu((PIWdg *)firstMenu,(const char *)"submenu");
    firstMenu->AppendCascadeMenu(underMenu,1001);
	underMenu->AppendItem("Sub 1 from 2",1010);
	underMenu->AppendItem("Sub 2 from 2",1011);

	figuresMenu = new PIMenu((PIWdg *)mainApp, (const char *)"Figures");
	figuresMenu->AppendItem("Circle",2001);
	figuresMenu->AppendItem("Polygone",2002);

	printf ("Menus created \n");
    fflush (stdout);
	
    mBar = mainApp->Menubar();
    mBar->AppendMenu(firstMenu);
    mBar->AppendMenu(figuresMenu);
	
    windowFirst = new PIWindow((PIMsgHandler *)mainApp, (const char *)"Window First",PIWK_normal,600,200,50,50);
	
	piLabel = new PILabel(windowFirst,(const char *)"Label",80,40,150,50);

	piButton = new PIButton(windowFirst, "Hello",777,60,20,80,80);
	
	optMenu = new PIOptMenu(windowFirst, "Opt Menu", 100,25,150,80);
	popMenu = new PIMenu((PIWdg *)optMenu, (const char *)"Pop Menu",k_PopupMenu);
	popMenu->AppendItem("pop 1",3001);
	popMenu->AppendItem("pop 2",3002);
	mBar->AppendPopupMenu(popMenu);

	optMenu->AppendPDMenu(popMenu);
	
	piLabel->SetLabel("Etiquette");

	windowFirst->Refresh();
	fflush (stdout);
	
	pig = new PIGraphicWin (windowFirst);
	// pig->SetClipRectangle(280,60,100,50);

	PIGrCoord px(300);
	PIGrCoord py(80);
	PIGrCoord len(150);
	PIGrCoord hei(50);
	pig->SelForeground(PI_Blue);
	pig->DrawFBox(px, py, len, hei);
	pig->DrawString (px, py, "Graphic Text", 1);

	PIGrCoord pxfin(450);
	PIGrCoord pyfin(130);
	pig->SelForeground(PI_Green);	
	pig->DrawLine (px, py, pxfin, pyfin);

	PIGrCoord deltax(60);
	PIGrCoord deltay(30);
	pig->SelForeground(PI_Red);	
	pig->DrawArc (px, py, deltax, deltay, 0., 90.);

	FillDatas();
	
    mainApp->Run(); // Main loop

    return 0;
}

/* ============================== */
void FillDatas()
{
	tabx = new PIGrCoord[NBCOTE];
	taby = new PIGrCoord[NBCOTE];
	
	tabx[0] = 80 ;	tabx[1] = 100; tabx[2] = 120;	tabx[3] = 140;	tabx[4] = 130;	tabx[5] = 110; tabx[6] = 90;
	taby[0] = 50;	taby[1] = 60; taby[2] = 70;	taby[3] = 80;	taby[4] = 60;	taby[5] = 40; taby[6] = 20;
	return;
}
