#ifndef MACHDEFS_SEEN
#define MACHDEFS_SEEN

/* -------------- List of flags (and description) ------------------- 
  - SO_ARCH64 : select 64 bits architecture (default 32 bits)
  - SO_NOFPIC  : disable fPIC flag (Position Independent Code) default fPIC enabled 
  - SO_SASIZET64 : select 64 bits size for array indices (default 32 bits)
  - SO_LDBLE128  : enable support for 128 bits floating point numbers (default NO 128 bits floats)
  - SO_BOUNDCHECKING : activate bound checking (in accessing array elements)
  - SOPHYA_DEBUG : debug flag ( --> if set, SO_BOUNDCHECKING is also set)
  ------------------------------------------------------------------  */

#ifdef SOPHYA_DEBUG
#define SO_BOUNDCHECKING
#endif

/***********************************************************************/
/* Find hardware, OS and compiler combination                          */
/***********************************************************************/

#if defined(OSF1) 
#define MACH_ALPHA
#endif

#if defined(_AIX) || defined(AIX)
#define MACH_IBMRS
#endif

#if defined(__hpux__) || defined(HPUX)
#define MACH_HP
#endif

#if defined(SunOS)  || defined ( sun )
#define MACH_SUN
#endif

#ifdef IRIX64
#define MACH_SGI
#endif

#ifdef __APPLE__
#ifdef __MACH__
#ifdef __POWERPC__
#define MACH_POWERPC
#else
#define MACH_INTEL
#endif
#endif
#endif

#if defined(Linux)  || defined(linux)
#if defined(__alpha__)
#define MACH_ALPHA
#elif defined(powerpc)
#define MACH_POWERPC
#elif defined(__i386__)    
#define MACH_INTEL
#else
#define MACH_AMD
/* $CHECK$ (Reza Avril 2007):  Il faut affiner ce test pour 
   determiner correctement le type de  processeur        */
#endif
#endif

/***********************************************************************/
/* Hardware/OS dependent stuff                                         */
/***********************************************************************/

/* --------------------------------------------------------------- */
/* 1/     typedefs for different size integers and floats          */
/* --------------------------------------------------------------- */

/* --- Avr2007: The following typdefs should be OK for most system */
/* and compilers:  OSF, Linux, AIX, SGI, MacOSX, Sun, HP           */

typedef signed char int_1;
typedef unsigned char uint_1;
typedef short int_2;
typedef unsigned short uint_2;
typedef int int_4;
typedef unsigned int uint_4;
typedef long long int_8;
typedef unsigned long long uint_8;
typedef float r_4;
typedef double r_8;
#ifdef SO_LDBLE128
/* 128 bits floating point numbers */
typedef long double r_16;
#endif

/* --------------------------------------------------------------- */
/* 2/     Endiannes (/ byteswap for different processors)          */
/* --------------------------------------------------------------- */
/*  
    ==> POWERPC, IBMRS, HP_UX, IRIX64, SunSPARC (?) : 
           BigEndian    ( SWAP=SWAPDEFAUT=0)
    ==> ALPHA, INTEL, AMD :
           LittleEndian ( SWAP=SWAPDEFAUT=1)        
*/                                      

#if defined(MACH_ALPHA) || defined(MACH_INTEL) || defined(MACH_AMD) 
#define IS_BIG_ENDIAN 0
#else 
#define IS_BIG_ENDIAN 1
#endif

/* ---- La taille des index des tableaux ---- */
#ifdef SO_SASIZET64 
typedef int_8 sa_size_t ;
#else
typedef int_4 sa_size_t ;
#endif


/***********************************************************************/
/* Find Compiler                                                       */
/***********************************************************************/

/*    __DECCXX     : DEC CXX, version >= 6 is required                 */
/*    __GNUG__     : GNU C++ 2.8.1, egcs ??                            */
/*    __aCC__      : aCC on HP                                         */
/*    __KCC__      : KCC, version >= 3.3 is required                   */
/*    __SGICC__    : SGI (IRIX64) CC compiler                          */
/*    __INTEL_COMPILER :   : INTEL compiler                            */
/*    __IBMCPP__   : AIX (IBM) xlC c++ compiler                        */

/***********************************************************************/
/* Compiler-specific stuff                                             */
/***********************************************************************/
  
/*   ANSI_TEMPLATES        : use ANSI syntax for explicit templates        */
/*   GNUG_TEMPLATES        : use GNU syntax for explicit templates         */
/*   PRAGMA_TEMPLATES      : use pragma template, a la cxx                 */
/*   COMPILER_EXCEPTIONS   : knows about exceptions  --- required ?        */ 
/*   STREAMPOS_IS_CLASS    : streampos is a real class                     */
/*   ITER_TAG              : use iter_tag for iterator qualifiers in STL   */
/*   NO_STRSTREAM          : does not have strstream                       */
/*   HAS_IOS_BIN                                                           */
/*   HAS_IOS_NOCREATE                                                      */
/*   HAS_VEC_NEW           : operator new[]                                */
/*   CC_HAS_RTTI_SUPPORT     has Run Time Type Identification support      */
/*   ANSI_IO               : rdbuf()->pubseekoff rather than seekg         */
/*   HAS_STR_NPOS          : has string::npos and not a global NPOS        */
/*   NO_IOS_COMPLEX        : does not have operator << defined for complex */
/*   DECL_TEMP_SPEC        : Template specialization declaration           */
/*   TSNMLUPG4             : Two stage name look-up scheme (g++>3.4)       */


/* (STREAMPOS_IS_CLASS non-active: ca compile sans sur gcc3.2 et cxx)
   rz+cmv 11/02/03 */

/* The following is true for most compilers */

#ifndef HAS_VEC_NEW
#define HAS_VEC_NEW
#endif

#ifndef COMPILER_EXCEPTIONS
#define COMPILER_EXCEPTIONS
#endif

#ifndef  CC_HAS_RTTI_SUPPORT 
#define  CC_HAS_RTTI_SUPPORT 
#endif


#ifndef DECL_TEMP_SPEC
#define DECL_TEMP_SPEC
#endif

/* Most compilers dot not implement two level name lookup for templates 
   introduced by gcc >= 3.4 
*/
#ifdef TSNMLUPG4
#undef TSNMLUPG4
#endif

/* now the specific things */

#ifdef __GNUC__
#define GCC_VERSION (__GNUC__ * 1000 \
                               + __GNUC_MINOR__ * 100 \
                               + __GNUC_PATCHLEVEL__)
#define ANSI_TEMPLATES
/*
if (__GNUC__ >= 3) 
define STREAMPOS_IS_CLASS
endif
*/
#define GNU_TEMPLATES
#define HAS_STR_NPOS
#define HAS_IOS_BIN
#define HAS_IOS_NOCREATE
#if ( GCC_VERSION >= 3000 ) 
#undef  DECL_TEMP_SPEC
#define DECL_TEMP_SPEC template <>
#endif
#if ( GCC_VERSION >= 3400 )
/* Two level name look-up scheme for templates introduced from gcc 3.4 */
#define TSNMLUPG4
#endif

#endif

#ifdef __DECCXX
#define HAS_STR_NPOS
#define ITER_TAG
#define __CXX_PRAGMA_TEMPLATES__
#define PRAGMA_TEMPLATES
#endif

#if defined (__aCC__)  
#ifndef ANSI_TEMPLATES
#define ANSI_TEMPLATES
#endif
#endif

#if defined(__KCC__)
/* KCC V 3.2 ne compile pas  i/ostream s ; long p = s.tellg();  OK en  V 3.3 */
#define HAS_STR_NPOS
#ifndef ANSI_TEMPLATES
#define ANSI_TEMPLATES
#endif
#endif

#if defined(__SGICC__)
#define HAS_STR_NPOS
#ifndef ANSI_TEMPLATES
#define ANSI_TEMPLATES
#endif
#undef  DECL_TEMP_SPEC
#define DECL_TEMP_SPEC template <>
#endif

#if defined(__IBMCPP__)
/* IBM xlC compiler support Added : dec 2005 */
#ifndef ANSI_TEMPLATES
#define ANSI_TEMPLATES
#endif
#undef  DECL_TEMP_SPEC
#define DECL_TEMP_SPEC template <>
#endif

/* Get things has homogeneous as possible between compilers */

#ifdef HAS_STR_NPOS
#define NPOS string::npos
#else
#define NPOS (size_t)-1
#endif

#ifndef __GNUG__
#define __PRETTY_FUNCTION__ __FILE__ " __LINE__ "
#ifndef __FUNCTION__
#define __FUNCTION__ __FILE__ " __LINE__ "
#endif
#ifndef __KCC__
#define __attribute__(_x_)
#endif
#endif


#ifdef HAS_IOS_BIN
#define IOS_BIN ios::binary
#else
#define IOS_BIN 0
#endif


#ifdef Darwin
#define NO_VALUES_H
#include "osx_values.h"
#endif


#ifdef __cplusplus
/* Standard C++ library classes are in the namespace std  */
namespace std { }
using namespace std;
/*******************************************/
/* SOPHYA classes are in namespace SOPHYA  */
/* namespace SOPHYA {}                     */
/* using namespace SOPHYA;                 */
/* Please use instead: sopnamsp.h          */
/*******************************************/
#endif

#endif
