/*    Projet BAORadio    
    (C) LAL / Univ. Paris Sud ,   IRFU   2007-2010 
    Programme de lecture des paquets Acquisition BAORadio 
*/

// include standard c/c++
#include <math.h>
#include <stdio.h>
#include <typeinfo>
#include <iostream>
#include <string>


// include mini-fits lib et manipulation de paquets AcqBAORadio 
#include "minifits.h"
#include "brpaqu.h"

int main(int narg, char* arg[])
{
  if (narg < 2) {
    cout << " Usage: tstrdfits file1.fits [file2.fits ...] " << endl;
    return 1;
  }
  cout << " ---------- tstrdfits.cc Start ------------- " << endl;
  int rc = 0;
  int maxprt = 7;
  try {
    int paqsz = 0;
    int nprt = 0;
    BRPaquet paq; 
    BRPaqChecker pcheck;
    Byte* data=NULL;
//---- Boucle sur les fichiers a lire ---- 
    for(int ifile=1; ifile<narg; ifile++) {
      string ffname = arg[ifile];
// -------------- Lecture de bytes      
      cout << ifile <<"-Ouverture/lecture fichier " << ffname << endl;
      MiniFITSFile mff(ffname, MF_Read);
      cout << "... Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
	   << " NAxis2=" << mff.NAxis2() << endl;
      if (mff.DataType() != MF_Byte) {
        cout << " PB : DataType!=MF_Byte --> skipping " << endl;
      }
     if (paqsz == 0)  {  // premier passage, on fixe la taille de paquet et on alloue le buffer
       paqsz = mff.NAxis1();
       cout << " tstrdfits/ Allocating data , PaqSz=" << paqsz << endl;
       data = new Byte[paqsz];
       for(int ib=0; ib<paqsz; ib++) data[ib]=0;
       paq.Set(data, paqsz); 
     }
     else {   // Sinon, on verifie que les differents fichiers ont la meme taille de paquet
       if (paqsz != mff.NAxis1()) {
	 cout << " PB : paqsz=" << paqsz << " != mff.NAxis1()" << " --> skipping " << endl;
	 continue;
       }
     }
  
     size_t sx = mff.NAxis1(); 
     size_t sy = mff.NAxis2();
     // On construit un paquet sur 
     // Boucle de lecture des paquets dans le fichier 
     for(int j=0; j<sy; j++) {
       mff.ReadB(data, sx, j*sx);    // Lecture du paquet 
       pcheck.Check(paq);            // Verification, comptage des paquets OK 
       if ((j%55==0)&&(nprt<maxprt)) {    // Impression optionnel du contenu du paquet 
	 paq.Print();    nprt++; 
       }
     }
     cout << "---- FIN lecture fichier " << ffname << endl;
    }
    cout << "-------- FIN boucle de lecture des fichiers ----------" << endl;
    cout << pcheck;
    cout << "------------------------------------------------------" << endl;
    delete[] data;
  }
  catch (MiniFITSException& exc) {
    cerr << " tstrdfits.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (std::exception& sex) {
    cerr << "\n tstrdfits.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " tstrdfits.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> tstrdfits.cc ------- FIN ----------- RC=" << rc << endl;
  return rc;

}
