#include "machdefs.h"
#include "piinit.h"
#include "nobjmgr.h"
#include "servnobjm.h"
#include "nomhistadapter.h"
#include "nomgfdadapter.h"
#include "nommatvecadapter.h"
#include "nomimagadapter.h"
#include "fitsimage.h"
#include "nomstladapter.h"

int PIAppInitiator::FgInit = 0;

PIAppInitiator::PIAppInitiator(PIStdImgApp * app)
 : PeidaOutilsInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

  Services2NObjMgr* serv = app->ObjMgr()->GetServiceObj();

  serv->RegisterClass(new Histo, new NOMAdapter_Histo );
  serv->RegisterClass(new Histo2D, new NOMAdapter_Histo2D );
  serv->RegisterClass(new NTuple, new NOMAdapter_NTuple );
  serv->RegisterClass(new XNTuple, new NOMAdapter_XNTuple );
  char* varenv=NULL;
  if ( (varenv=getenv("PEIDA_TMP")) == NULL )   varenv=getenv("TMPDIR") ;
  if (varenv)  XNTuple::SetSwapPath(varenv);

  serv->RegisterClass(new GeneralFitData, new NOMAdapter_GeneralFitData );

  serv->RegisterClass(new Vector, new NOMAdapter_Vector );
  serv->RegisterClass(new Matrix, new NOMAdapter_Matrix );

  serv->RegisterClass(new Image<uint_2>, new  NOMAdapter_Image<uint_2> );
  serv->RegisterClass(new Image<int_2>, new  NOMAdapter_Image<int_2> );
  serv->RegisterClass(new Image<int_4>, new  NOMAdapter_Image<int_4> );
  serv->RegisterClass(new Image<r_4>, new  NOMAdapter_Image<r_4> );
 
  serv->RegisterClass(new FitsImage<uint_2>, new  NOMAdapter_Image<uint_2> );
  serv->RegisterClass(new FitsImage<int_2>, new  NOMAdapter_Image<int_2> );
  serv->RegisterClass(new FitsImage<int_4>, new  NOMAdapter_Image<int_4> );
  serv->RegisterClass(new FitsImage<r_4>, new  NOMAdapter_Image<r_4> );

  serv->RegisterClass(new StarList, new NOMAdapter_StarList );

}

PIAppInitiator::~PIAppInitiator()
{
  FgInit--;
/*  if (FgInit == 0)
    {
    }  */
}

