#ifndef  RACQUPROC_H_SEEN
#define  RACQUPROC_H_SEEN

//----------------------------------------------------------------
// ---- classe de thread de traitememt  acquisition BAORadio -----
// LAL -      R. Ansari - 2008-2010
//  A/ Juin 2008 - Juin 2009 
//       Classes DataProc, DataProc2C, DataProcFFT2C avec des 
//       threads de traitement mono-fibre
//  B/ Novembre 2009 
//    MonitorProc : Classe de traitement pour monitoring multifibres
//----------------------------------------------------------------


#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>
#include "sopnamsp.h"
#include "zthread.h"
#include "tmatrix.h"

#include "brtypes.h"
#include "brparam.h"

using namespace std;

// Quelques definitions globales
// Nombre maximum de fibres geres par les classes MonitorProc
#ifndef MAXNBFIB
#define MAXNBFIB  32   
#endif

//---------------------------------------------------------------------
// Classe thread de traitement/monitoring multifibre Raw/FFT 
//---------------------------------------------------------------------
class MonitorProc : public ZThread {
public:	
  MonitorProc(RAcqMemZoneMgr& mem);
  virtual ~MonitorProc();
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  int procData2C(ofstream& logf);
  int procData1C(ofstream& logf);
  int CheckFrameCounters();

  RAcqMemZoneMgr& memgr;
  BRParList par_;
  bool stop_;  
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 step_;  // 1/step_ paquet traite ds chaque bloc
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;
  uint_4 nfiles_;
  TMatrix<r_4> spectre_;
  vector<uint_4> nzm_;
  uint_4 nblocproc_;         // nombre total de bloc MemMgr traites 
  uint_8 nprocpaq_;          // nombre de paquets traites entre deux mises a zero
  uint_8 npaqsamefc_;        // nombre de paquets avec meme framecounter  entre deux mises a zero
  uint_8 totnprocpaq_;       // nombre de paquets traites entre deux mises a zero
  uint_8 totnpaqsamefc_;     // nombre de paquets avec meme framecounter  entre deux mises a zero
  TMatrix<uint_8> curfc_;    // Numeros de FrameCounter dans le bloc
  TMatrix<uint_1> cpaqok_;   // Paquets OK ou pas dans le bloc
};


//-------------------------------------------------------------------
//--------  Premieres version - pour tmtacq.cc 
//-------------------------------------------------------------------
//-------------------------------------------------------------------
// Classe thread de traitement avec 1 voie par frame (donnees brutes)
//-------------------------------------------------------------------
class DataProc : public ZThread {
public:	
  DataProc(RAcqMemZoneMgr& mem, string& path, uint_4 nmean=1, uint_4 step=1, uint_4 nmax=100);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	

protected:
  RAcqMemZoneMgr& memgr;
  bool stop_;  
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 step_;  // 1/step_ frame traite ds chaque bloc
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
  struct sigaction act;	
};

//---------------------------------------------------------------------
// Classe thread de traitement avec 2 voies par frame (donnees brutes)
//---------------------------------------------------------------------
class DataProc2C : public ZThread {
public:	
  DataProc2C(RAcqMemZoneMgr& mem, string& path, uint_4 nmean=1, uint_4 step=1, uint_4 nmax=100);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  bool stop_;  
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 step_;  // 1/step_ frame traite ds chaque bloc
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
};

//---------------------------------------------------------------------
// Classe thread de traitement donnees FFT avec 2 voies par frame 
//---------------------------------------------------------------------
class DataProcFFT2C : public ZThread {
public:	
  DataProcFFT2C(RAcqMemZoneMgr& mem, string& path, uint_4 nmean=1, uint_4 step=1, uint_4 nmax=100);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  bool stop_;  
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 step_;  // 1/step_ frame traite ds chaque bloc
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
};

#endif
