#ifndef  BRPROC_H_SEEN
#define  BRPROC_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads de traitememt donnees BAORadio 
//----------------------------------------------------------------


#include <string>
#include <vector>
#include <iostream>

#include "racqumem.h"
#include "brbaseproc.h"
#include "parlex.h"
#include "sopnamsp.h"
#include "tvector.h"
#include "ntuple.h"
#include "datatable.h"

using namespace std;


//---------------------------------------------------------------------
// Classe de traitement - calcul de visibilite pour n fibres 
//---------------------------------------------------------------------
class BRVisibilityCalculator : public BRBaseProcessor, ParallelTaskInterface {
public:	
  BRVisibilityCalculator(RAcqMemZoneMgr& memgr, string outpath, uint_4 nmean=1000, size_t nthr=1);
  virtual ~BRVisibilityCalculator(); // Fait le nettoyage final , sauvegarde des objets ...

  // Pour definir le rang de l'objet lors d'un traitement avec plusieurs BRVisibilityCalculator en //
  void DefineRank(uint_4 nbc, uint_4 cid);

  // Pour limiter le calcul des visibilites a certaines fibres 
  uint_4 SelectPairs(uint_4 pair1=0, uint_4 nbpairs=99999999);
  // pour definir le binning en frequence pour la VisibDataTable 
  int SelectFreqBinning(uint_4 freq1=0, uint_4 freq2=0, uint_4 nbfreq=1);

  // Pour activer la verification des timetag
  // Creation / sauvegarde d'une matrice de TimeTag / FrameCounter avec NCols=maxnpaq (nb de paquets/trigger)  
  int ActivateTimeTagCheck(uint_8 maxnpaq);

  // Methode d'execution standard du thread (on redefinit la methode de BRBaseProcessor)
  virtual void run();  
  // Methode de la classe ParallelTaskInterface 
  virtual int    execute(int tid);

protected:
  virtual int Process(); 
  virtual int FillVisibTable(double fcm, double ttm); 
  virtual int CheckTimeTag(); 

  ParallelExecutor paralex_;  // Pour l'execution en parallele  
  size_t nparthr_;

  uint_4 nmean_;  // Nombre de spectres pour le calcul des moyennes 
  string outpath_;  // directory pour fichiers de sortie
  uint_4 nbcalc_, calcid_;  // Nombre total de threads/objets BRVisibilityCalculator parallles, l'identificateur de l'objet  

  uint_4 pairst_, nbpairs_;   // Numero de la premiere paire, nombre de paires 
  uint_4 jf1_,jf2_,djf_;  // binning en frequence pour la datatable

  vector<TwoByteComplex*> vpdata_;
  bool* fgallfibok;  

  double moyfc_, moytt_;
  TMatrix< complex<r_4> > vismtx_; 
  TVector< uint_4 > chanum_;
  //  FitsInOutFile dtfos_;
  DataTable visdt_;

  uint_4 numfile_;
  uint_8 totnbpaq_;

  // Variables/objets pour la verifications des timetag
  bool fgcktt_;  // true -> checktimetag 
  int_8 mindeltatt_;       // difference minimum de deux timetag successifs 
  TMatrix< uint_8 > fcmtx_; // matrices des framecounters
  TMatrix< uint_8 > ttmtx_; // matrices des timetag 
  vector< uint_8 > vlasttt_;  // dernieres valeurs de TimeTag / fibre
  vector< uint_8 > vbadtt_;  // Number of bad TimeTag paquets per fiber 
  vector< uint_8 > vnsamett_;  // Number of paquets having TimeTag <> TT_Fiber1 per fiber 
  vector< uint_8 > vndiff5tt_;  // Number of paquets having |TimeTag-TT_Fiber1|>5 per fiber 

};


//-------------------------------------------------------------------------------
// Classe Groupe (ensemble) de Calculateur de Visibilites, tourant en parallele
//-------------------------------------------------------------------------------

class BRVisCalcGroup {
public:	
  BRVisCalcGroup(size_t nbcalc, RAcqMemZoneMgr& memgr, string outpath, uint_4 nmean=1000, size_t nthr=1);
  ~BRVisCalcGroup();
  int SelectFreqBinning(uint_4 freq1=0, uint_4 freq2=0, uint_4 nbfreq=1);
  inline int ActivateTimeTagCheck(uint_8 maxnpaq)
  { return viscalcp_[0]->ActivateTimeTagCheck(maxnpaq); }

  void start();
  void join();
protected:
  vector<BRVisibilityCalculator *> viscalcp_; 
};
 
//---------------------------------------------------------------------
// Classe de traitement simple - calcul de spectres moyennes / voie
//---------------------------------------------------------------------
class BRMeanSpecCalculator : public BRBaseProcessor
{
public:
  BRMeanSpecCalculator(RAcqMemZoneMgr& memgr, string outpath, uint_4 nmean=1000);
  virtual ~BRMeanSpecCalculator(); // Fait le nettoyage final , sauvegarde des objets ...

protected:
  virtual int Process(); 

  uint_4 nmean_;  // Nombre de spectres pour le calcul des moyennes 
  string outpath_;  // directory pour fichiers de sortie
  uint_4 numfile_;

  uint_8 totnbpaq_;
  TMatrix< r_4 > mspecmtx_;    // Matrice des spectres moyennees 
}; 

//-------------------------------------------------------------------------
//    **** OBSOLETE : BRProcA2C et BRProcB4C
//   Anciennes classes de traitement (Avant Nov2009) utilises par mcrd.cc
//-------------------------------------------------------------------------
//---------------------------------------------------------------------
// Classe thread de traitement avec 2 voies par frame (donnees raw/FFT
//---------------------------------------------------------------------

/*-- Arguments du constructeur : 
  o mem : gestionnaire zones memoires avec contenant les "frames" avec 2 voies/frame
  o path : Chemin et nom des fichiers PPF produits (on ajoute _numero.ppf )
  o nmean : Nombre de frame (paquets) moyennes
  o nmax : Nombre maxi de frames traites 
  o fghist = true -> fait aussi l'histo des valeurs des echantillons temps
  o nfsmap>0 : fabrication de cartes (image 2D) des spectres, 
     avec nfsmap=nombre de frequences sommes  
  o fgnotrl = true -> fichiers fits / paquets sans trailer 
  o card : numero de carte , juste pour les impressions 
*/
class BRProcA2C : public ZThread {
public:	
  BRProcA2C(RAcqMemZoneMgr& mem, string& path, bool fgraw, 
	    uint_4 nmean=10, uint_4 nmax=100, bool fgtshist=false, 
	    uint_4 nfsmap=0, bool fgnotrl=false, int card=1);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  bool stop_;  
  bool fgraw_;   // true -> raw data 
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 nmean_;  // Nombre de spectres pour le calcul des moyennes 
  uint_4 nfsmap_;  // Binning en frequence pour les cartes 2D temps-freq
  string path_;  
  bool fghist_;   // if true, fill and save histogram with time sample values
  bool fgnotrl_;   // if true, don't check packet trailer - when using pre-june fits files
  int card_;   // Numeros de voies 2*card_-1, 2*card_
};

//---------------------------------------------------------------------
// Classe thread de traitement 2 x 2 voies/paquet (Apres BRProcA2C)
//---------------------------------------------------------------------
/*-- Arguments du constructeur : 
  o mem1,mem2 : gestionnairea zones memoires avec contenant les donnees des 4 voies (2 voies/frame)
  o path : Chemin et nom des fichiers PPF produits (on ajoute _numero.ppf )
  o nmean : Nombre de frame (paquets) moyennes
  o nmax : Nombre maxi de frames traites 
  o fgnotrl = true -> fichiers fits / paquets sans trailer 
  o card : numero de carte , juste pour les impressions 
*/

class BRProcB4C : public ZThread {
public:	
  BRProcB4C(RAcqMemZoneMgr& mem1, RAcqMemZoneMgr& mem2, string& path, 
	    bool fgraw, uint_4 nmean=10, uint_4 nmax=100, bool fgnotrl=false);
  virtual void run(); 
  void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr1;
  RAcqMemZoneMgr& memgr2;
  bool stop_;  
  bool fgraw_;   // true -> raw data 
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  uint_4 nmean_;  // Nombre de blocs pour le calcul des moyennes 
  string path_;  
  bool fgnotrl_;   // if true, don't check packet trailer - when using pre-june fits files
};



#endif
