#ifndef  BRANAPARAM 
#define  BRANAPARAM

//--------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classe de gestion des parametres programmes d'analyse 
//--------------------------------------------------------------

#include "machdefs.h"

#include <string>
#include <vector>
#include <iostream>

class BRAnaParam {  
public:
  BRAnaParam(uint_4 nmean=1000, uint_4 nzon=4, uint_4 npaqz=128);
  int DecodeArgs(int narg, char* arg[]);
  int Usage(bool fgshort);

  int PaqSizeFromFits();

  uint_8 TotalNPaquets() { return ((imax_-imin_+1)*npaqinfile_/istep_); }

  ostream& Print(ostream& os);

  static int DecodeMiniFitsHeader(const char* filename, uint_4& paqsz, uint_4& npaq);

  vector<string> dirlist_;
  string action_;
  string outpath_;
  uint_4 nmean_;
  uint_4 nbloc_;
  uint_4 imin_, imax_, istep_;
  uint_4 freqmin_, freqmax_, nbinfreq_;
  uint_4 paqsize_; 
  uint_4 nzones_, npaqinzone_;
  uint_4 npaqinfile_;    // nombre de paquets dans un fichier p
  int prtlevel_;
  uint_4 nbcalgrp_;    // Nb d'objets/threads dans BRVisCalcGroup 
  uint_4 nthreads_;  // Nb de threads pour l'execution parallele ds BRVisibilityCalculator
};

#endif
