#include "radutil.h"

double H21Conversions::SpeedOfLight_Cst = 2.99792458e8;  // metres/sec
double H21Conversions::Freq021cm_Cst = 1420.4;  // MHz 
double H21Conversions::k_Boltzman_Cst = 1.3806503e-23;  // Boltzman constant SI (J K^-1)

H21Conversions::H21Conversions(double freq, double opix)
{
  if (freq<1.e-6)  freq=Freq021cm_Cst;
  setFrequency(freq);
  setOmegaPix(opix);
}

void H21Conversions::setFrequency(double nu)
{
  freq_=nu;
  z_=Freq021cm_Cst/freq_-1.;
  lambda_=SpeedOfLight_Cst/freq_/1.e6;
}

double H21Conversions::toJansky(double temp)
{
  return 2.*k_Boltzman_Cst*temp/lambda_/lambda_ * omegapix_ * 1.e26;
}

double H21Conversions::toKelvin(double jy)
{
  return jy*1e-26 / omegapix_ * lambda_ * lambda_ / 2. / k_Boltzman_Cst ;
}
