//  Classes to compute simple quantities for radio / 21 cm 
//  R. Ansari - June 2010 

#ifndef RADUTIL_SEEN
#define RADUTIL_SEEN

#include "machdefs.h"      // SOPHYA .h  
#include "sopnamsp.h"      // SOPHYA .h  

#include "vector3d.h"      // conversion d'angle 

class H21Conversions {
public:
  // redshift nul, angle solide du pixel en steradian 
  H21Conversions(double freq=0., double opix=1.e-5); 

  double toJansky(double temp);  // Conversion d'une temperature (Kelvin) en jansky 
  double toKelvin(double jy);    // Conversion de Jansky en  temperature (Kelvin) 

  void setFrequency(double nu);  // on definit la frequence en MHz 
  inline void setRedshift(double z)    // on definit le redshift
  { setFrequency(Freq021cm_Cst/(1+z)); }
  inline void setLambda(double lam)    // on definit la longueur d'onde en m  
  { setFrequency(SpeedOfLight_Cst/lam); }

  inline void setOmegaPix(double opix)   // angle solide en steradian
  { omegapix_ = opix; }
  inline void setOmegaPixDeg2(double opix)  // angle solide en Deg^2
  { double cf=Angle(1.,Angle::Degree).ToRadian(); omegapix_ = opix*cf*cf; }
  inline void setOmegaPixArcmin2(double opix)  // angle solide en Arcmin^2
  { double cf=Angle(1.,Angle::ArcMin).ToRadian(); omegapix_ = opix*cf*cf; }

  inline double getRedshift() { return z_; }
  inline double getFrequency() { return freq_; }
  inline double getLambda() { return lambda_; } 

  inline double getOmegaPix()   // angle solide en steradian
  { return omegapix_; }
  inline double getOmegaPixArcmin2()  // angle solide en Arcmin^2
  { double cf=Angle(1.,Angle::ArcMin).ToRadian(); return omegapix_/cf/cf; }
  inline double getOmegaPixDeg2()  // angle solide en Deg^2
  { double cf=Angle(1.,Angle::Degree).ToRadian(); return omegapix_/cf/cf; }

  static double SpeedOfLight_Cst;       // Speed of light  m/sec
  static double Freq021cm_Cst;       // Speed of light  m/sec
  static double k_Boltzman_Cst;         // Boltzmann constant  (SI Units)

  double z_;
  double freq_;
  double lambda_;
  double omegapix_;
};

#endif
