//  Simple specific histo-like classes 
//  R. Ansari - Avril-Mai 2010 

#ifndef QHIST_SEEN
#define QHIST_SEEN

#include "histats.h"       // SOPHYA .h 

#include "machdefs.h"      // SOPHYA .h  
#include "sopnamsp.h"      // SOPHYA .h  
#include <iostream>

#include "histats.h"       // SOPHYA .h 

// -----------------------------------
// -- Classe ressemblant a un histo 1D 
class QHis1D {
  QHis1D();
  QHis1D(QHis1D const& a);
  QHis1D(r_8 xMin,r_8 xMax,int_4 nxBin);
  void Define(r_8 xMin,r_8 xMax,int_4 nxBin); 
  sa_size_t Add(r_8 x, r_8 w=1.);
  inline double WBinX() { return dxb_; }
  inline double NBinX() { return nx_; }

  Histo Convert();
  
  r_8 xmin_,xmax_;
  r_8 dxb_;
  sa_size_t nx_;
  TArray<r_8> aw_;
  sa_size_t nhis_, nunder_, nover_;
  r_8 swunder_, swover_ ; 
};

// -----------------------------------
// -- Classe ressemblant a un histo 2D 
class QHis2D {
public:
  QHis2D();
  QHis2D(r_8 xMin,r_8 xMax,int_4 nxBin,r_8 yMin,r_8 yMax,int_4 nyBin);
  void Define(r_8 xMin,r_8 xMax,int_4 nxBin,r_8 yMin,r_8 yMax,int_4 nyBin);
  double Add(r_8 x, r_8 y, r_8 w, bool fgfh);
  void SetZeroBin(r_8 x=0, r_8 y=0);
  inline double WBinX() { return dxb; }
  inline double WBinY() { return dyb; }
  Histo2D Convert();
  
  r_8 xmin,xmax,ymin,ymax;
  r_8 dxb,dyb;
  sa_size_t nx,ny;
  sa_size_t ixb0, jyb0;
  TArray<r_8> aw;
  double sumw0;
};


#endif
