
#include "lobe.h"
#include "radutil.h"
#include "randfmt.h"      
typedef FMTRandGen RandomGenerator ;


#include "fftwserver.h"    
#include "ctimer.h"    


/* --Methode-- */
BeamEffect::BeamEffect(Four2DResponse& resp)
  : fresp_(resp)
// resp doit avoir sa longueur d'onde de reference en metres
{
}

/* --Methode-- */
void BeamEffect::ApplyLobeK2D(TArray< complex<TF> >& fourAmp, double dkx, double dky, double lambda)
//  dx, dy en radians, lambda en metres 
{
  fresp_.setLambda(lambda);
  double kxx, kyy;
  for(sa_size_t ky=0; ky<fourAmp.SizeY(); ky++) {
    kyy =  (ky>fourAmp.SizeY()/2) ? -(double)(fourAmp.SizeY()-ky)*dky : (double)ky*dky; 
    for(sa_size_t kx=0; kx<fourAmp.SizeX(); kx++) {
      kxx=(double)kx*dkx;
      fourAmp(kx, ky) *= complex<TF>(fresp_(kxx, kyy), 0.);   	
    }
  }
  return;
}


/* --Methode-- */
void BeamEffect::ApplyLobe3D(TArray< TF >& a, double dx, double dy, double f0, double df)
// dx, dy en radioans, f0, df en MHz
{
  Timer tm("BeamEffect::ApplyLobe3D");
  FFTWServer ffts(true);                     
  ffts.setNormalize(true); 
  
  H21Conversions conv;
  
  TArray< complex<TF> > fourAmp;
  double dkx = DeuxPI/(double)a.SizeX()/dx;
  double dky = DeuxPI/(double)a.SizeY()/dy;
  
  for(sa_size_t kz=0; kz<a.SizeZ(); kz++) {
    TArray< TF > slice( a(Range::all(), Range::all(), kz) );
    ffts.FFTForward(slice, fourAmp);
    conv.setFrequency(f0+kz*df);
    ApplyLobeK2D(fourAmp, dkx, dky, conv.getLambda());
    ffts.FFTBackward(fourAmp, slice, true);
    if (kz%10==0)  cout << "BeamEffect::ApplyLobe3D() done kz=" << kz << " / a.SizeZ()=" << a.SizeZ() << endl; 
  }
  return;
}

/* --Methode-- */
TArray< TF > BeamEffect::ReSample(TArray< TF >& a, double xfac, double yfac, double zfac)
{
  Timer tm("BeamEffect::ReSample");

  sa_size_t szx = a.SizeX()*xfac;
  sa_size_t szy = a.SizeY()*yfac;
  sa_size_t szz = a.SizeZ()*zfac;

  TArray<TF> rsa(szx, szy, szz);
  for(sa_size_t kz=0; kz<rsa.SizeZ(); kz++) {
    sa_size_t kza=kz/zfac;
    if ((kza<0)||(kza>=a.SizeZ()))  continue;
    for(sa_size_t ky=0; ky<rsa.SizeY(); ky++) {
      sa_size_t kya=ky/yfac;
      if ((kya<0)||(kya>=a.SizeY()))  continue;
      for(sa_size_t kx=0; kx<rsa.SizeX(); kx++) {
	sa_size_t kxa=kx/xfac;
	if ((kxa<0)||(kxa>=a.SizeX()))  continue;
	rsa(kx,ky,kz)=a(kxa,kya,kza);
      }
    }
  }
  return rsa;
}


/* --Methode-- */
void BeamEffect::AddNoise(TArray< TF >& a, double pixsignoise, bool fgcmsig)
{
  cout << "BeamEffect::AddNoise() PixelSigmaNoise=" << pixsignoise << endl;
  RandomGenerator rg;
  for(sa_size_t kz=0; kz<a.SizeZ(); kz++) 
    for(sa_size_t ky=0; ky<a.SizeY(); ky++) 
      for(sa_size_t kx=0; kx<a.SizeX(); kx++) 
	a(kx,ky,kz) += rg.Gaussian(pixsignoise);
  if (fgcmsig) {
    double mean, sigma;
    MeanSigma(a, mean, sigma);
    cout << "BeamEffect::AddNoise()-done,  Mean=" << mean << " Sigma=" << sigma << endl;
  }
  return;
}
