/*  ------------------------ Projet BAORadio -------------------- 
    Calcul de l'effet de lobe sur Carte2D (angleX,angleY) et 
    cube 3D (angleX,angleY)
    R. Ansari , C. Magneville - Juin 2010 
---------------------------------------------------------------  */

#ifndef BEAMH_SEEN
#define BEAMH_SEEN

#include "machdefs.h"      // SOPHYA .h  
#include "sopnamsp.h"      // SOPHYA .h  
#include <math.h>
#include <iostream>
#include <vector>
#include <string> 

#include "tarray.h"
#include "vector3d.h"
#include "mdish.h"

#ifndef TF 
#define TF r_4 
#endif

class BeamEffect {
public:
  BeamEffect(Four2DResponse& resp);
  void ApplyLobeK2D(TArray< complex<TF> >& f2d, double dkx, double dky, double lambda=1.);
  void ApplyLobe3D(TArray< TF >& a, double dx, double dy, double f0, double df);  

  static TArray< TF > ReSample(TArray< TF >& a, double xfac, double yfac, double zfac);
  static void AddNoise(TArray< TF >& a, double pixsignoise, bool fgcmsig=true);

  Four2DResponse& fresp_;
};

#endif
