/*  ------------------------ Projet BAORadio -------------------- 
    Estimation et soustraction d'avant plan radio 
    R. Ansari , C. Magneville - Juin 2010 
---------------------------------------------------------------  */

#ifndef FGNDSUB_SEEN
#define FGNDSUB_SEEN

#include "machdefs.h"      // SOPHYA .h  
#include "sopnamsp.h"      // SOPHYA .h  
#include <math.h>
#include <iostream>
#include <vector>
#include <string> 

#include "tarray.h"
#include "vector3d.h"
#include "lobe.h"
#include "mdish.h"

#ifndef TF 
#define TF r_4 
#endif

class ForegroundCleaner {
public:
  ForegroundCleaner(Four2DResponse& arrep, Four2DResponse& tbeam, TArray< TF >& skycube);
  void BeamCorrections();
  int CleanPointSources(double nsigmas=5.);
  TArray< TF > extractLSSCube(TArray< TF >& synctemp, TArray< TF >& specidx);

  Four2DResponse& arrep_;   // Array/Instrument beam response
  Four2DResponse& tbeam_;    // Target beam to which would be corrected using BeamCorrections()
  TArray< TF > skycube_;
  double dx_, dy_;   // taille des pixels (radians) de skycube
  double freq0_, dfreq_;    // 1ere frequence et bin en frequence de skycube_;
  
};

#endif
