/*  ------------------------ Projet BAORadio -------------------- 
    Calcul de l'effet de lobe sur Carte2D (angleX,angleY) et 
    cube 3D (angleX,angleY, frquences)
    R. Ansari , C. Magneville - Juin 2010 
---------------------------------------------------------------  */

#ifndef BEAMH_SEEN
#define BEAMH_SEEN

#include "machdefs.h"      // SOPHYA .h  
#include "sopnamsp.h"      // SOPHYA .h  
#include <math.h>
#include <iostream>
#include <vector>
#include <string> 

#include "tarray.h"
#include "vector3d.h"
#include "mdish.h"

#ifndef TF 
#define TF r_4 
#endif

class BeamEffect {
public:
  // Definition de l'objet avec la reponse en frequence de l'instrument 
  BeamEffect(Four2DResponse& resp);
  // Applique l'effet de lobe au cube 3D (2 angles, frequence), pour chaque plan de frequence successivement  
  void ApplyLobe3D(TArray< TF >& a, double dx, double dy, double f0, double df);  

  // Corrige de l'effet de l'effet de lobe, pour chaque plan de frequence, pour tout ramener au lobe defini par "rep" 
  void Correct2RefLobe(Four2DResponse& rep, TArray< TF >& a, double dx, double dy, double f0, double df);

  // Applique l'effet de lobe "rep" dans le plan de Fourier  pour une frequence (longueur d'onde) fixee
  static void ApplyLobeK2D(Four2DResponse& rep, TArray< complex<TF> >& f2d, double dkx, double dky);

  // Re-echntillonnage du cube 3D en appliquant les facteurs xfac,yfac,zfac selon chaque direction 
  // fac = 2 ---> on double le nombre d'echantillon , fac=0.5 : un echantillon sur deux 
  static TArray< TF > ReSample(TArray< TF >& a, double xfac, double yfac, double zfac);

  // On ajoute du bruit gaussien au cube 3D - espace des positions 
  static void AddNoise(TArray< TF >& a, double pixsignoise, bool fgcmsig=true);

  Four2DResponse& fresp_;
};

#endif
