//  Definition de la carte synchrotron/radio sources ...
//  Projet BAORadio , Juin 2010 

#ifndef CUBEDEF_SEEN
#define CUBEDEF_SEEN

// Definition tailles et bornes du cube angles (X,Y), frequence (Z)

static sa_size_t NTheta=360;
static sa_size_t NPhi=360;
static sa_size_t NFreq = 200;

static double Theta0Degre = 75.;  // -> Delta = +30 deg
static double Phi0Degre = 135.;   // -> alpha = 9h00
static double ThetaSizeDegre = 30.;  // Taille de la carte en degre selon alpha (axe X)
static double PhiSizeDegre = 30.;    // Taille de la carte en degre selon delta (axe Y)

static double Freq0MHz = 840.;       // premiere frequence 
static double FreqSizeMHz = 100.;    // Taille de la carte en MHz (axe Z)


//---  Parametres des lois de puissance en frequence 
static double AmpPL1 = 1.;   // amp max PowerLaw 1 (synchrotron  
static double PLidx1 = -2.5;  // index de la loi de puissance synchrotron 
static double sigPLidx1 = 0.1;  // Sigma de la variation (gaussienne) de index1 
// Amplitude max de la 2eme composante en loi de puissance (tirage plat 0 ... AmpPL2)
static double AmpPL2 = 0.1;   // amp max PowerLaw 2 
static double PLidx2 = -3.2; 
static double sigPLidx2 = 0.15;

static double PLidxSrc = -2.2;  // index de la loi de puissance des sources  
static double sigPLidxSrc = 0.15;  // Sigma de la variation (gaussienne) de l'index  

// Parametres pour la reponse en Fourier de l'instrument :
static double InterfArrayDiametre = 64.;

/*
static sa_size_t NTheta=256;
static sa_size_t NPhi=256;
static sa_size_t NFreq = 128;

static double Theta0Degre = 60.;  // -> Delta = +30 deg
static double Phi0Degre = 120.;   // -> alpha = 8h00
static double ThetaSizeDegre = 60.;  // Taille de la carte en degre selon alpha (axe X)
static double PhiSizeDegre = 60.;    // Taille de la carte en degre selon delta (axe Y)
static double Freq0MHz = 840.;       // premiere frequence 
static double FreqSizeMHz = 100.;    // Taille de la carte en MHz (axe Z)
*/

#endif
