#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <fstream>
#include <iostream>
#include <string.h>
#include <unistd.h>

#include "skymap.h"


int main(int narg,char *arg[])
{
 int nside = 512;
 string ppfrn = "cmvgsm2sph";

 if(narg<=1) {
   cout<<"cmvgsm2sph liste_gsm.list [ppfroot_name]"<<endl;
   return -1;
 }

 ifstream flist(arg[1], ofstream::in);
 if(!flist)
   {cout<<"ERROR: open failed for "<<arg[1]<<endl; return -2;}
 if(narg>2) ppfrn = arg[2];

 int nfilrd = 0, nfrderr = 0;;
 while(1) {
   string fn; double f=-1.; int is = -1;
   flist>>is>>f>>fn;
   if(flist.eof()) break;
   cout<<nfilrd<<" : is="<<is<<" f="<<f<<" fn="<<fn<<endl;

   SphereHEALPix<r_4> sph(nside);
   int npix = sph.NbPixels();
   if(nfilrd==0) cout<<"Healpix sph nside="<<nside<<" npix="<<npix<<endl;

   ifstream fin(fn.c_str(), ofstream::in);
   if(!fin) {
     cout<<"ERROR: open failed for "<<fn<<endl;
     nfrderr++;
     continue;
   }

   int nread = 0;
   while(1) {
     double v = 0;
     fin>>v;
     if(fin.eof()) break;
     if(nread<npix) sph(nread) = v;
     nread++;
   }

   if(nread!=npix) {
     cout<<"ERROR: mismatch nread="<<nread<<" / "<<npix<<endl;
     nfrderr++;
   } else {
     char str[1024];
     sprintf(str,"%s_%d.ppf",ppfrn.c_str(),is);
     POutPersist pos(str);
     sph.Info()["ISeq"] = (int_4)is;
     sph.Info()["FMHz"] = (double)f;
     sph.Info()["FName"] = fn;
     pos<<PPFNameTag("sph")<<sph;
     nfilrd++;
   }
 }
 cout<<"\nread "<<nfilrd<<" files, with "<<nfrderr<<" echecs"<<endl;

 return 0;
}

