// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

/* ---------------------------------------------------------- 
   Programme de test de lecture multi-fibes et thread de traitement 
   BRBaseProcessor
   BAORadio -   LAL/IRFU      R. Ansari, C. Magneville
   Juin 2010
   ---------------------------------------------------------- */

// include standard c/c++
#include <iostream>
#include <string>
#include <exception>

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"
#include "timestamp.h"
#include "strutilxx.h"
#include "tarrinit.h"
#include "histinit.h"

#include "brpaqu.h"
#include "brfitsrd.h"
#include "brbaseproc.h"
#include "brdiskw.h"

#include "branap.h"



//----------------------------------------------------
//----------------------------------------------------
int main(int narg, char* arg[])
{

  TArrayInitiator  _inia;

  int rc = 0;
  try {
    cout << " ---------- treadmfib.cc Start   ------------- " << endl;
    // Decodage parametres 
    BRAnaParam par;
    rc = par.DecodeArgs(narg, arg);
    if (rc) return rc;
    rc = par.PaqSizeFromFits();
    if (rc) return rc;
    par.Print(cout);


    ResourceUsage resu;

    cout << " treadmfib: Creating MemZoneMgr/threads - PaqSz= " << par.paqsize_ << endl;

    RAcqMemZoneMgr mmgr(par.nzones_, par.dirlist_.size(), par.npaqinzone_, par.paqsize_);
    mmgr.SetFinalizedMask((uint_4)MemZS_ProcA);
    BRMultiFitsReader reader(mmgr, par.dirlist_, true, par.imin_, par.imax_, par.istep_);
    reader.SetPrintLevel(par.prtlevel_);
    BRBaseProcessor proc(mmgr);

    cout << " treadmfib: Starting threads (reader proc) ... " << endl;
    reader.start();
    proc.start();
    usleep(200000);
    cout << " treadmfib: Waiting for reader thread to finish ... " << endl;    
    reader.join();
    cout << " treadmfib: reader thread finished, waiting for processor thread to end ... " << endl;    
    proc.join();
    mmgr.Print(cout);
    cout << resu ; 
  }
  catch (std::exception& sex) {
    cerr << "\n treadmfib.cc std::exception :"  << (string)typeid(sex).name() 
	 << "\n msg= " << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " treadmfib.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> treadmfib.cc ------- END ----------- RC=" << rc << endl;
  return rc;

}


